/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingPropertyValueHandler {
    private static final Map<String, AutoType> AUTO_PROPS = new HashMap<String, AutoType>();
    private final List<Modification> changes;
    private final DateParser dateParser;
    private final ReferenceParser referenceParser;
    private final Calendar now = Calendar.getInstance();
    private static final int PROPERTY_TYPE_WEAKREFERENCE = 10;

    public SlingPropertyValueHandler(DateParser dateParser, ReferenceParser referenceParser, List<Modification> changes) {
        this.dateParser = dateParser;
        this.referenceParser = referenceParser;
        this.changes = changes;
    }

    static AutoType getAutoType(String propertyName) {
        return AUTO_PROPS.get(propertyName);
    }

    private PropertyDefinition searchPropertyDefinition(NodeType nodeType, String name) {
        if (nodeType.getPropertyDefinitions() != null) {
            for (PropertyDefinition pd : nodeType.getPropertyDefinitions()) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
        }
        return null;
    }

    private PropertyDefinition searchPropertyDefinition(Node node, String name) throws RepositoryException {
        PropertyDefinition result = this.searchPropertyDefinition(node.getPrimaryNodeType(), name);
        if (result == null && node.getMixinNodeTypes() != null) {
            for (NodeType mt : node.getMixinNodeTypes()) {
                result = this.searchPropertyDefinition(mt, name);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public void setProperty(Resource parent, RequestProperty prop) throws RepositoryException, PersistenceException {
        Modifiable mod = new Modifiable();
        mod.resource = parent;
        mod.node = (Node)parent.adaptTo(Node.class);
        mod.valueMap = (ModifiableValueMap)parent.adaptTo(ModifiableValueMap.class);
        if (mod.valueMap == null) {
            throw new PersistenceException("Resource at '" + parent.getPath() + "' is not modifiable.");
        }
        String name = prop.getName();
        if (prop.providesValue()) {
            this.setPropertyAsIs(mod, prop);
        } else if (AUTO_PROPS.containsKey(name)) {
            PropertyDefinition pd;
            if (mod.node != null && (pd = this.searchPropertyDefinition(mod.node, name)) != null && (mod.node.isNew() && pd.isAutoCreated() || pd.isProtected())) {
                return;
            }
            boolean isNew = mod.node != null ? mod.node.isNew() : true;
            switch (SlingPropertyValueHandler.getAutoType(name)) {
                case CREATED: {
                    if (!isNew) break;
                    this.setCurrentDate(mod, name);
                    break;
                }
                case CREATED_BY: {
                    if (!isNew) break;
                    this.setCurrentUser(mod, name);
                    break;
                }
                case MODIFIED: {
                    this.setCurrentDate(mod, name);
                    break;
                }
                case MODIFIED_BY: {
                    this.setCurrentUser(mod, name);
                }
            }
        } else {
            this.setPropertyAsIs(mod, prop);
        }
    }

    private void setCurrentDate(Modifiable parent, String name) throws RepositoryException, PersistenceException {
        this.removePropertyIfExists(parent, name);
        parent.valueMap.put((Object)name, (Object)this.now);
        this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
    }

    private void setCurrentUser(Modifiable parent, String name) throws RepositoryException, PersistenceException {
        this.removePropertyIfExists(parent, name);
        String user = parent.resource.getResourceResolver().getUserID();
        parent.valueMap.put((Object)name, (Object)user);
        this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
    }

    private String removePropertyIfExists(Modifiable parent, String name) throws RepositoryException, PersistenceException {
        if (parent.valueMap.containsKey((Object)name)) {
            if (parent.node != null) {
                Property prop = parent.node.getProperty(name);
                if (!prop.getDefinition().isMandatory()) {
                    String path = prop.getPath();
                    prop.remove();
                    return path;
                }
            } else {
                parent.valueMap.remove((Object)name);
                return parent.resource.getPath() + '/' + name;
            }
        }
        return null;
    }

    private void setPropertyAsIs(Modifiable parent, RequestProperty prop) throws RepositoryException, PersistenceException {
        String[] values = prop.getStringValues();
        if (values == null || values.length == 1 && values[0].length() == 0) {
            this.removeProperty(parent, prop);
        } else if (values.length == 0) {
            this.clearProperty(parent, prop);
        } else {
            Session s;
            if (prop.isPatch() && (values = this.patch(parent, prop.getName(), values)) == null) {
                return;
            }
            boolean multiValue = this.isMultiValue(parent, prop, values);
            int type = this.getType(parent, prop);
            if (multiValue) {
                this.removeIfSingleValueProperty(parent, prop);
            }
            if ((s = (Session)parent.resource.getResourceResolver().adaptTo(Session.class)) != null) {
                ValueFactory valFac = s.getValueFactory();
                if (type == 5 ? this.storeAsDate(parent, prop.getName(), values, multiValue, valFac) : this.isReferencePropertyType(type) && this.storeAsReference(parent, prop.getName(), values, type, multiValue, valFac)) {
                    return;
                }
            }
            this.store(parent, prop.getName(), values, type, multiValue);
        }
    }

    private String[] patch(Modifiable parent, String name, String[] values) throws RepositoryException, PersistenceException {
        ArrayList<String> oldValues = new ArrayList<String>();
        if (parent.valueMap.containsKey((Object)name)) {
            if (parent.node != null) {
                Property p = parent.node.getProperty(name);
                if (!p.getDefinition().isMultiple()) {
                    return null;
                }
                for (String string : p.getValues()) {
                    oldValues.add(string.getString());
                }
            } else {
                String[] setValues = (String[])parent.valueMap.get(name, String[].class);
                if (setValues != null) {
                    for (String string : setValues) {
                        oldValues.add(string);
                    }
                }
            }
        }
        boolean modified = false;
        for (String string : values) {
            if (string == null || string.length() <= 0) continue;
            char op = string.charAt(0);
            String val = string.substring(1);
            if (op == '+') {
                if (oldValues.contains(val)) continue;
                oldValues.add(val);
                modified = true;
                continue;
            }
            if (op != '-') continue;
            while (oldValues.remove(val)) {
                modified = true;
            }
        }
        if (modified) {
            return oldValues.toArray(new String[oldValues.size()]);
        }
        return null;
    }

    private boolean isReferencePropertyType(int propertyType) {
        return propertyType == 9 || propertyType == 10;
    }

    private boolean isWeakReference(int propertyType) {
        return propertyType == 10;
    }

    private int getType(Modifiable parent, RequestProperty prop) throws RepositoryException {
        int type = 0;
        if (prop.getTypeHint() != null) {
            try {
                type = PropertyType.valueFromName((String)prop.getTypeHint());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] values = prop.getStringValues();
        if (type == 0 && values != null && values.length > 0 && parent.node != null && parent.node.hasProperty(prop.getName())) {
            type = parent.node.getProperty(prop.getName()).getType();
        }
        return type;
    }

    private boolean isMultiValue(Modifiable parent, RequestProperty prop, String[] values) throws RepositoryException {
        if (values != null && values.length > 1) {
            return true;
        }
        if (prop.hasMultiValueTypeHint()) {
            return true;
        }
        if (prop.isPatch()) {
            return true;
        }
        if (parent.node != null) {
            if (parent.node.hasProperty(prop.getName())) {
                return parent.node.getProperty(prop.getName()).getDefinition().isMultiple();
            }
        } else {
            Object value = parent.valueMap.get((Object)prop.getName());
            if (value != null && value.getClass().isArray()) {
                return true;
            }
        }
        return false;
    }

    private void clearProperty(Modifiable parent, RequestProperty prop) throws RepositoryException, PersistenceException {
        if (parent.valueMap.containsKey((Object)prop.getName())) {
            if (parent.node != null) {
                if (parent.node.getProperty(prop.getName()).getDefinition().isMultiple()) {
                    String removePath = this.removePropertyIfExists(parent, prop.getName());
                    if (removePath != null) {
                        this.changes.add(Modification.onDeleted(removePath));
                    }
                } else {
                    this.changes.add(Modification.onModified(parent.node.setProperty(prop.getName(), "").getPath()));
                }
            } else {
                parent.valueMap.put((Object)prop.getName(), (Object)"");
                this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + prop.getName()));
            }
        }
    }

    private void removeProperty(Modifiable parent, RequestProperty prop) throws RepositoryException, PersistenceException {
        String removePath = this.removePropertyIfExists(parent, prop.getName());
        if (removePath != null) {
            this.changes.add(Modification.onDeleted(removePath));
        }
    }

    private void removeIfSingleValueProperty(Modifiable parent, RequestProperty prop) throws RepositoryException, PersistenceException {
        if (parent.valueMap.containsKey((Object)prop.getName())) {
            if (parent.node != null) {
                String removePath;
                if (!parent.node.getProperty(prop.getName()).getDefinition().isMultiple() && (removePath = this.removePropertyIfExists(parent, prop.getName())) != null) {
                    this.changes.add(Modification.onDeleted(removePath));
                }
            } else {
                String removePath = this.removePropertyIfExists(parent, prop.getName());
                if (removePath != null) {
                    this.changes.add(Modification.onDeleted(removePath));
                }
            }
        }
    }

    private boolean storeAsDate(Modifiable parent, String name, String[] values, boolean multiValued, ValueFactory valFac) throws RepositoryException, PersistenceException {
        Calendar c;
        if (multiValued) {
            Value[] array = this.dateParser.parse(values, valFac);
            if (array != null) {
                if (parent.node != null) {
                    parent.node.setProperty(name, array);
                } else {
                    Calendar[] dates = new Calendar[array.length];
                    int index = 0;
                    for (Value v : array) {
                        dates[index] = v.getDate();
                        ++index;
                    }
                    parent.valueMap.put((Object)name, (Object)dates);
                }
                this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
                return true;
            }
        } else if (values.length >= 1 && (c = this.dateParser.parse(values[0])) != null) {
            parent.valueMap.put((Object)name, (Object)c);
            this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
            return true;
        }
        return false;
    }

    private boolean storeAsReference(Modifiable parent, String name, String[] values, int type, boolean multiValued, ValueFactory valFac) throws RepositoryException, PersistenceException {
        Value v;
        if (parent.node == null) {
            throw new PersistenceException("Resource " + parent.resource.getPath() + " does not support reference properties.");
        }
        if (multiValued) {
            Value[] array = this.referenceParser.parse(values, valFac, this.isWeakReference(type));
            if (array != null) {
                this.changes.add(Modification.onModified(parent.node.setProperty(name, array).getPath()));
                return true;
            }
        } else if (values.length >= 1 && (v = this.referenceParser.parse(values[0], valFac, this.isWeakReference(type))) != null) {
            this.changes.add(Modification.onModified(parent.node.setProperty(name, v).getPath()));
            return true;
        }
        return false;
    }

    private void store(Modifiable parent, String name, String[] values, int type, boolean multiValued) throws RepositoryException, PersistenceException {
        if (parent.node != null) {
            Property p = null;
            if (multiValued) {
                p = type == 0 ? parent.node.setProperty(name, values) : parent.node.setProperty(name, values, type);
            } else if (values.length >= 1) {
                p = type == 0 ? parent.node.setProperty(name, values[0]) : parent.node.setProperty(name, values[0], type);
            }
            if (p != null) {
                this.changes.add(Modification.onModified(p.getPath()));
            }
        } else if (multiValued) {
            parent.valueMap.put((Object)name, SlingPropertyValueHandler.toJavaObject(values, type));
            this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
        } else if (values.length >= 1) {
            parent.valueMap.put((Object)name, SlingPropertyValueHandler.toJavaObject(values[0], type));
            this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
        }
    }

    private static Object toJavaObject(String value, int type) {
        boolean isEmpty = value == null || value.trim().length() == 0;
        switch (type) {
            case 12: {
                return isEmpty ? BigDecimal.ZERO : new BigDecimal(value);
            }
            case 6: {
                return isEmpty ? Boolean.FALSE : Boolean.valueOf(value);
            }
            case 4: {
                return isEmpty ? 0.0 : Double.valueOf(value);
            }
            case 3: {
                return isEmpty ? 0L : Long.valueOf(value);
            }
        }
        return value;
    }

    private static Object toJavaObject(String[] values, int type) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            result[i] = SlingPropertyValueHandler.toJavaObject(values[i], type);
        }
        return result;
    }

    static {
        AUTO_PROPS.put("created", AutoType.CREATED);
        AUTO_PROPS.put("createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("jcr:created", AutoType.CREATED);
        AUTO_PROPS.put("jcr:createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("lastModifiedBy", AutoType.MODIFIED_BY);
        AUTO_PROPS.put("jcr:lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("jcr:lastModifiedBy", AutoType.MODIFIED_BY);
    }

    public static final class Modifiable {
        public Resource resource;
        public ModifiableValueMap valueMap;
        public Node node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AutoType {
        CREATED,
        CREATED_BY,
        MODIFIED,
        MODIFIED_BY;

    }
}

