/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.servlet.ServletContext;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.apache.sling.servlets.post.impl.helper.SlingPropertyValueHandler;
import org.apache.sling.servlets.post.impl.operations.AbstractCreateOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOperation
extends AbstractCreateOperation {
    private DateParser dateParser = new DateParser();
    private final SlingFileUploadHandler uploadHandler = new SlingFileUploadHandler();

    public void setServletContext(ServletContext servletContext) {
        this.uploadHandler.setServletContext(servletContext);
    }

    public void setDateParser(DateParser dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        try {
            Map<String, RequestProperty> reqProperties = this.collectContent(request, response);
            VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
            this.processCreate(request.getResourceResolver(), reqProperties, response, changes, versioningConfiguration);
            this.processMoves(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
            this.processCopies(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
            this.processDeletes(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
            this.writeContent(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
            Resource newResource = request.getResourceResolver().getResource(response.getPath());
            Node newNode = (Node)newResource.adaptTo(Node.class);
            if (newNode != null) {
                this.orderNode(request, (Item)newNode, changes);
            }
        }
        catch (PersistenceException pe) {
            if (pe.getCause() instanceof RepositoryException) {
                throw (RepositoryException)pe.getCause();
            }
            throw new RepositoryException((Throwable)pe);
        }
    }

    @Override
    protected String getItemPath(SlingHttpServletRequest request) {
        String suffix;
        StringBuilder rootPathBuf = new StringBuilder();
        Resource currentResource = request.getResource();
        if (ResourceUtil.isSyntheticResource((Resource)currentResource)) {
            suffix = currentResource.getPath();
        } else {
            int dotPos;
            suffix = request.getRequestPathInfo().getSuffix();
            if (suffix != null && (dotPos = suffix.indexOf(46)) > 0) {
                suffix = suffix.substring(0, dotPos);
            }
            rootPathBuf.append(currentResource.getPath());
        }
        boolean doGenerateName = false;
        if (suffix != null) {
            if (suffix.endsWith("/")) {
                suffix = suffix.substring(0, suffix.length() - "/".length());
                doGenerateName = true;
            } else if (suffix.endsWith("/*")) {
                suffix = suffix.substring(0, suffix.length() - "/*".length());
                doGenerateName = true;
            }
            rootPathBuf.append(suffix);
        }
        String path = rootPathBuf.toString();
        if (doGenerateName) {
            try {
                path = this.generateName(request, path);
            }
            catch (RepositoryException re) {
                throw new SlingException("Failed to generate name", (Throwable)re);
            }
        }
        return path;
    }

    private void processMoves(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException, PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryMoveSource()) continue;
            this.processMovesCopiesInternal(property, true, resolver, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processCopies(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException, PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryCopySource()) continue;
            this.processMovesCopiesInternal(property, false, resolver, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processMovesCopiesInternal(RequestProperty property, boolean isMove, ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException, PersistenceException {
        Session session = (Session)resolver.adaptTo(Session.class);
        String propPath = property.getPath();
        String source = property.getRepositorySource();
        if (session.itemExists(source)) {
            Node parent;
            if (session.itemExists(propPath)) {
                parent = session.getItem(propPath).getParent();
                this.checkoutIfNecessary(parent, changes, versioningConfiguration);
                session.getItem(propPath).remove();
                changes.add(Modification.onDeleted(propPath));
            } else {
                parent = this.deepGetOrCreateNode(resolver, property.getParentPath(), reqProperties, changes, versioningConfiguration);
                Node node = (Node)parent.adaptTo(Node.class);
                if (node != null) {
                    this.checkoutIfNecessary(node, changes, versioningConfiguration);
                }
            }
            Item sourceItem = session.getItem(source);
            if (sourceItem.isNode()) {
                if (isMove) {
                    this.checkoutIfNecessary(sourceItem.getParent(), changes, versioningConfiguration);
                    session.move(source, propPath);
                } else {
                    Node sourceNode = (Node)sourceItem;
                    Node destParent = (Node)session.getItem(property.getParentPath());
                    this.checkoutIfNecessary(destParent, changes, versioningConfiguration);
                    CopyOperation.copy(sourceNode, destParent, property.getName());
                }
            } else {
                Property sourceProperty = (Property)sourceItem;
                Node destParent = (Node)session.getItem(property.getParentPath());
                this.checkoutIfNecessary(destParent, changes, versioningConfiguration);
                CopyOperation.copy(sourceProperty, destParent, null);
                if (isMove) {
                    this.checkoutIfNecessary(sourceProperty.getParent(), changes, versioningConfiguration);
                    sourceProperty.remove();
                }
            }
            property.setDelete(false);
            if (isMove) {
                changes.add(Modification.onMoved(source, propPath));
            } else {
                changes.add(Modification.onCopied(source, propPath));
            }
        }
    }

    private void processDeletes(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException, PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            Resource parent;
            if (!property.isDelete() || (parent = resolver.getResource(property.getParentPath())) == null) continue;
            Node parentNode = (Node)parent.adaptTo(Node.class);
            if (parentNode != null) {
                this.checkoutIfNecessary(parentNode, changes, versioningConfiguration);
                if (property.getName().equals("jcr:mixinTypes")) {
                    for (NodeType mixin : parentNode.getMixinNodeTypes()) {
                        parentNode.removeMixin(mixin.getName());
                    }
                } else if (parentNode.hasProperty(property.getName())) {
                    parentNode.getProperty(property.getName()).remove();
                } else if (parentNode.hasNode(property.getName())) {
                    parentNode.getNode(property.getName()).remove();
                }
            } else {
                ValueMap vm = (ValueMap)parent.adaptTo(ModifiableValueMap.class);
                if (vm == null) {
                    throw new PersistenceException("Resource '" + parent.getPath() + "' is not modifiable.");
                }
                vm.remove((Object)property.getName());
            }
            changes.add(Modification.onDeleted(property.getPath()));
        }
    }

    private void writeContent(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException, PersistenceException {
        SlingPropertyValueHandler propHandler = new SlingPropertyValueHandler(this.dateParser, new ReferenceParser((Session)resolver.adaptTo(Session.class)), changes);
        for (RequestProperty prop : reqProperties.values()) {
            if (!prop.hasValues()) continue;
            Resource parent = this.deepGetOrCreateNode(resolver, prop.getParentPath(), reqProperties, changes, versioningConfiguration);
            Node parentNode = (Node)parent.adaptTo(Node.class);
            if (parentNode != null) {
                this.checkoutIfNecessary(parentNode, changes, versioningConfiguration);
            }
            if (prop.getName().equals("jcr:primaryType") || prop.getName().equals("jcr:mixinTypes")) continue;
            if (prop.isFileUpload()) {
                this.uploadHandler.setFile(parent, prop, changes);
                continue;
            }
            propHandler.setProperty(parent, prop);
        }
    }
}

