/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.settings.impl.RunModeCommand;
import org.apache.sling.settings.impl.SlingPropertiesPrinter;
import org.apache.sling.settings.impl.SlingSettingsPrinter;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ServiceRegistration serviceRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        SlingSettingsServiceImpl settingsService = new SlingSettingsServiceImpl(bundleContext);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", settingsService.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling Settings Service");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.serviceRegistration = bundleContext.registerService(new String[]{SlingSettingsService.class.getName()}, (Object)settingsService, props);
        SlingPropertiesPrinter.initPlugin(bundleContext);
        SlingSettingsPrinter.initPlugin(bundleContext, settingsService);
        try {
            RunModeCommand.initPlugin(bundleContext, settingsService.getRunModes());
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            RunModeCommand.destroyPlugin();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SlingSettingsPrinter.destroyPlugin();
        SlingPropertiesPrinter.destroyPlugin();
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

