/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.tooling.support.source.impl.FelixJettySourceReferenceFinder;
import org.apache.sling.tooling.support.source.impl.SourceReference;
import org.apache.sling.tooling.support.source.impl.SourceReferenceException;
import org.apache.sling.tooling.support.source.impl.SourceReferenceFinder;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Property(name="alias", value={"/system/sling/tooling/sourceReferences.json"})
public class SourceReferencesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String KEY_TYPE = "__type__";
    private static final String KEY_GROUP_ID = "groupId";
    private static final String KEY_ARTIFACT_ID = "artifactId";
    private static final String KEY_VERSION = "version";
    static final String VALUE_TYPE_MAVEN = "maven";
    private static final String FELIX_FW_GROUP_ID = "org.apache.felix";
    private static final String FELIX_FW_ARTIFACT_ID = "org.apache.felix.framework";
    private ComponentContext ctx;
    private List<SourceReferenceFinder> finders;

    protected void activate(ComponentContext ctx) {
        this.ctx = ctx;
        this.finders = new ArrayList<SourceReferenceFinder>();
        this.finders.add(new FelixJettySourceReferenceFinder());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("application/json");
            JSONWriter w = new JSONWriter((Writer)response.getWriter());
            w.array();
            for (Bundle bundle : this.ctx.getBundleContext().getBundles()) {
                Object bundleVersion = bundle.getHeaders().get("Bundle-Version");
                w.object();
                w.key("Bundle-SymbolicName");
                w.value((Object)bundle.getSymbolicName());
                w.key("Bundle-Version");
                w.value(bundleVersion);
                w.key("sourceReferences");
                w.array();
                if (bundle.getBundleId() == 0L && bundle.getSymbolicName().equals(FELIX_FW_ARTIFACT_ID)) {
                    this.writeMavenGav(w, FELIX_FW_GROUP_ID, FELIX_FW_ARTIFACT_ID, (String)bundleVersion);
                }
                this.collectMavenSourceReferences(w, bundle);
                for (String jar : this.getEmbeddedJars(bundle)) {
                    URL entry = bundle.getEntry(jar);
                    if (entry == null) continue;
                    this.collectMavenSourceRerefences(w, entry);
                }
                for (SourceReferenceFinder finder : this.finders) {
                    try {
                        for (SourceReference reference : finder.findSourceReferences(bundle)) {
                            this.log.debug("{} found reference {}:{}:{} in {}", new Object[]{finder, reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), bundle});
                            this.writeMavenGav(w, reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
                        }
                    }
                    catch (SourceReferenceException e) {
                        this.log.warn(finder + " execution did not complete normally for " + bundle, (Throwable)e);
                    }
                }
                w.endArray();
                w.endObject();
            }
            w.endArray();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectMavenSourceReferences(JSONWriter w, Bundle bundle) throws IOException, JSONException {
        Enumeration entries = bundle.findEntries("/META-INF/maven", "pom.properties", true);
        while (entries != null && entries.hasMoreElements()) {
            URL entry = (URL)entries.nextElement();
            InputStream in = entry.openStream();
            try {
                this.writeMavenGav(w, in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private void writeMavenGav(JSONWriter w, String groupId, String artifactId, String version) throws JSONException {
        w.object();
        w.key(KEY_TYPE).value((Object)VALUE_TYPE_MAVEN);
        w.key(KEY_GROUP_ID).value((Object)groupId);
        w.key(KEY_ARTIFACT_ID).value((Object)artifactId);
        w.key(KEY_VERSION).value((Object)version);
        w.endObject();
    }

    private void writeMavenGav(JSONWriter w, InputStream in) throws IOException, JSONException {
        Properties p = new Properties();
        p.load(in);
        w.object();
        w.key(KEY_TYPE).value((Object)VALUE_TYPE_MAVEN);
        for (String prop : new String[]{KEY_GROUP_ID, KEY_ARTIFACT_ID, KEY_VERSION}) {
            w.key(prop).value((Object)p.getProperty(prop));
        }
        w.endObject();
    }

    private List<String> getEmbeddedJars(Bundle bundle) {
        String[] classPathEntryNames;
        String classPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (classPath == null) {
            return Collections.emptyList();
        }
        ArrayList<String> embeddedJars = new ArrayList<String>();
        for (String classPathEntry : classPathEntryNames = classPath.split("\\,")) {
            if (!classPathEntry.endsWith(".jar")) continue;
            embeddedJars.add(classPathEntry);
        }
        return embeddedJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectMavenSourceRerefences(JSONWriter w, URL entry) throws IOException, JSONException {
        InputStream wrappedIn = entry.openStream();
        try {
            JarEntry jarEntry;
            JarInputStream jarIs = new JarInputStream(wrappedIn);
            while ((jarEntry = jarIs.getNextJarEntry()) != null) {
                String entryName = jarEntry.getName();
                if (!entryName.startsWith("META-INF/maven/") || !entryName.endsWith("/pom.properties")) continue;
                this.writeMavenGav(w, jarIs);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)wrappedIn);
        }
    }
}

