/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSFilter;

public final class JSONUtil {
    public static final String KEY_SUFFIX_XSS = "_xss";

    private JSONUtil() {
    }

    public static void putProtected(JSONObject object, String key, String value, XSSFilter xss) throws JSONException {
        String xssValue = xss.filter(ProtectionContext.PLAIN_HTML_CONTENT, value);
        object.put(key, (Object)xssValue);
    }

    public static void putWithProtected(JSONObject object, String key, String value, XSSFilter xss) throws JSONException {
        JSONUtil.putProtected(object, key + KEY_SUFFIX_XSS, value, xss);
        object.put(key, (Object)value);
    }

    public static void writeProtected(JSONWriter writer, String key, String value, XSSFilter xss) throws JSONException {
        String xssValue = xss.filter(ProtectionContext.PLAIN_HTML_CONTENT, value);
        writer.key(key).value((Object)xssValue);
    }

    public static void writeProtected(JSONWriter writer, String key, String[] values, XSSFilter xss) throws JSONException {
        writer.key(key);
        writer.array();
        for (String value : values) {
            String xssValue = xss.filter(ProtectionContext.PLAIN_HTML_CONTENT, value);
            writer.value((Object)xssValue);
        }
        writer.endArray();
    }

    public static void writeWithProtected(JSONWriter writer, String key, String value, XSSFilter xss) throws JSONException {
        JSONUtil.writeProtected(writer, key + KEY_SUFFIX_XSS, value, xss);
        writer.key(key).value((Object)value);
    }

    public static void writeWithProtected(JSONWriter writer, String key, String[] values, XSSFilter xss) throws JSONException {
        JSONUtil.writeProtected(writer, key + KEY_SUFFIX_XSS, values, xss);
        writer.key(key);
        writer.array();
        for (String value : values) {
            writer.value((Object)value);
        }
        writer.endArray();
    }
}

