/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.xss.XSSFilter;
import org.apache.sling.xss.impl.XSSFilterImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"felix.webconsole.label=xssprotection", "felix.webconsole.title=XSS Protection", "felix.webconsole.category=Sling"})
public class XSSProtectionAPIWebConsolePlugin
extends HttpServlet {
    static final String REG_PROP_LABEL = "felix.webconsole.label";
    static final String REG_PROP_TITLE = "felix.webconsole.title";
    static final String REG_PROP_CATEGORY = "felix.webconsole.category";
    static final String LABEL = "xssprotection";
    static final String TITLE = "XSS Protection";
    private static final String RES_LOC = "xssprotection/res/ui";
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSProtectionAPIWebConsolePlugin.class);
    @Reference(target="(component.name=org.apache.sling.xss.impl.XSSFilterImpl)")
    private XSSFilter xssFilter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        XSSFilterImpl xssFilterImpl;
        XSSFilterImpl.AntiSamyPolicy antiSamyPolicy;
        if (request.getRequestURI().endsWith("xssprotection/res/ui/prettify.css")) {
            try (InputStream cssStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.css");){
                if (cssStream == null) return;
                response.setContentType("text/css");
                IOUtils.copy((InputStream)cssStream, (OutputStream)response.getOutputStream());
                return;
            }
        }
        if (request.getRequestURI().endsWith("xssprotection/res/ui/prettify.js")) {
            try (InputStream jsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.js");){
                if (jsStream == null) return;
                response.setContentType("application/javascript");
                IOUtils.copy((InputStream)jsStream, (OutputStream)response.getOutputStream());
                return;
            }
        }
        if (this.xssFilter == null || (antiSamyPolicy = (xssFilterImpl = (XSSFilterImpl)this.xssFilter).getActivePolicy()) == null) return;
        PrintWriter w = response.getWriter();
        ((Writer)w).write("<link rel=\"stylesheet\" type=\"text/css\" href=\"xssprotection/res/ui/prettify.css\"></link>");
        ((Writer)w).write("<script type=\"text/javascript\" src=\"xssprotection/res/ui/prettify.js\"></script>");
        ((Writer)w).write("<script type=\"text/javascript\" src=\"xssprotection/res/ui/fsclassloader.js\"></script>");
        ((Writer)w).write("<script>$(document).ready(prettyPrint);</script>");
        ((Writer)w).write("<style>.prettyprint ol.linenums > li { list-style-type: decimal; } pre.prettyprint { white-space: pre-wrap; }</style>");
        ((Writer)w).write("<p class=\"statline ui-state-highlight\">The current AntiSamy configuration ");
        if (antiSamyPolicy.isEmbedded()) {
            ((Writer)w).write("is the default one embedded in the org.apache.sling.xss bundle.");
        } else {
            ((Writer)w).write("is loaded from ");
            ((Writer)w).write(antiSamyPolicy.getPath());
            ((Writer)w).write(".");
        }
        ((Writer)w).write("</p>");
        String contents = "";
        try (InputStream configurationStream = antiSamyPolicy.read();){
            contents = IOUtils.toString((InputStream)configurationStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to read policy file.", t);
        }
        ((Writer)w).write("<pre class=\"prettyprint linenums\">");
        ((Writer)w).write(StringEscapeUtils.escapeHtml4((String)contents));
        ((Writer)w).write("</pre>");
    }
}

