/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContentContext
implements XSSFilterRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(PolicyHandler policyHandler, String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                boolean bl = policyHandler.getAntiSamy().scan(str).getNumberOfErrors() == 0;
                return bl;
            }
            catch (ScanException se) {
                this.log.warn("Unable to scan input.", (Throwable)se);
                this.log.debug("Provided input: {}", (Object)str);
            }
            catch (PolicyException pe) {
                this.log.warn("Unable to check input.", (Throwable)pe);
                this.log.debug("Provided input: {}", (Object)str);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String filter(PolicyHandler policyHandler, String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.log.debug("Protecting (HTML -> HTML) :\n{}", (Object)str);
                CleanResults results = policyHandler.getAntiSamy().scan(str);
                String cleaned = results.getCleanHTML();
                List<String> errors = results.getErrorMessages();
                for (String error : errors) {
                    this.log.info("AntiSamy warning: {}", (Object)error);
                }
                this.log.debug("Protected (HTML -> HTML):\n{}", (Object)cleaned);
                String string = cleaned;
                return string;
            }
            catch (ScanException se) {
                this.log.warn("Unable to scan input.", (Throwable)se);
                this.log.debug("Provided input: {}", (Object)str);
            }
            catch (PolicyException pe) {
                this.log.warn("Unable to check input.", (Throwable)pe);
                this.log.debug("Provided input: {}", (Object)str);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return "";
    }

    @Override
    public boolean supportsPolicy() {
        return true;
    }
}

