/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "slingstart-maven-plugin";
    private static final String PROVIDED = "provided";
    @Requirement
    private Logger log;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver resolver;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.log.info("Searching for slingstart projects...");
        try {
            HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
            for (MavenProject project : session.getProjects()) {
                projectMap.put(project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion(), project);
            }
            for (MavenProject project : session.getProjects()) {
                for (Plugin plugin : project.getBuild().getPlugins()) {
                    if (!plugin.getArtifactId().equals(PLUGIN_ID)) continue;
                    DependencyLifecycleParticipant.addDependencies(this.artifactHandlerManager, this.resolver, this.log, session, project, plugin);
                }
            }
        }
        catch (Exception e) {
            throw new MavenExecutionException("Unable to determine plugin-based dependencies", (Throwable)e);
        }
    }

    public static void addDependencies(ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, Logger log, MavenSession session, MavenProject project, Plugin plugin) throws Exception {
        String[] classifiers;
        ArrayList<File> dependencies = new ArrayList<File>();
        for (Dependency d : project.getDependencies()) {
            if (!d.getType().equals("slingstart") && !d.getType().equals("slingfeature")) continue;
            File modelFile = DependencyLifecycleParticipant.getSlingstartArtifact(artifactHandlerManager, resolver, project, session, d);
            dependencies.add(modelFile);
        }
        String directory = DependencyLifecycleParticipant.nodeValue((Xpp3Dom)plugin.getConfiguration(), "systemsDirectory", new File(project.getBasedir(), "src/main/provisioning").getAbsolutePath());
        Model model = ModelUtils.readFullModel(new File(directory), dependencies, project, session, log);
        ModelUtils.storeRawModel(project, model);
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)model, null);
        ModelUtils.storeEffectiveModel(project, effectiveModel);
        Artifact base = ModelUtils.getBaseArtifact(effectiveModel);
        for (String c : classifiers = new String[]{null, "app", "webapp"}) {
            Dependency dep = new Dependency();
            dep.setGroupId(base.getGroupId());
            dep.setArtifactId(base.getArtifactId());
            dep.setVersion(base.getVersion());
            dep.setType(base.getType());
            dep.setClassifier(c);
            if ("webapp".equals(c)) {
                dep.setType("war");
            }
            dep.setScope(PROVIDED);
            log.debug("- adding dependency " + dep);
            project.getDependencies().add(dep);
        }
        DependencyLifecycleParticipant.addDependencies(effectiveModel, log, project);
    }

    private static void addDependencies(Model model, Logger log, MavenProject project) {
        for (Feature feature : model.getFeatures()) {
            if (feature.getName().equals(":launchpad")) continue;
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    for (Artifact a : group) {
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType(a.getType());
                        dep.setClassifier(a.getClassifier());
                        dep.setScope(PROVIDED);
                        log.debug("- adding dependency " + dep);
                        project.getDependencies().add(dep);
                    }
                }
            }
        }
    }

    private static File getSlingstartArtifact(ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, MavenProject project, MavenSession session, Dependency d) throws MavenExecutionException {
        DefaultArtifact prjArtifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), PROVIDED, d.getType(), d.getClassifier(), artifactHandlerManager.getArtifactHandler(d.getType()));
        try {
            resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        return prjArtifact.getFile();
    }

    private static String nodeValue(Xpp3Dom config, String name, String defaultValue) {
        Xpp3Dom node;
        Xpp3Dom xpp3Dom = node = config == null ? null : config.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return defaultValue;
    }
}

