/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="prepare-package", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PreparePackageMojo
extends AbstractSlingStartMojo {
    private static final String BASE_DESTINATION = "resources";
    private static final String BOOT_DIRECTORY = "bundles";
    private static final String ARTIFACTS_DIRECTORY = "install";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String BOOTSTRAP_FILE = "sling_bootstrap.txt";
    private static final String PROPERTIES_FILE = "sling_install.properties";
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model = ModelUtils.getEffectiveModel(this.project);
        this.prepareGlobal(model);
        this.prepareStandaloneApp(model);
        this.prepareWebapp(model);
    }

    protected File getStandaloneOutputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    private void prepareGlobal(Model model) throws MojoExecutionException {
        HashMap<String, File> globalContentsMap = new HashMap<String, File>();
        this.buildContentsMap(model, null, globalContentsMap);
        this.project.setContextValue("slingstart:global", globalContentsMap);
    }

    private void prepareStandaloneApp(Model model) throws MojoExecutionException {
        HashMap<String, File> contentsMap = new HashMap<String, File>();
        this.project.setContextValue("slingstart:standalone", contentsMap);
        File outputDir = this.getStandaloneOutputDirectory();
        this.unpackBaseArtifact(model, outputDir, ":standalone");
        this.buildSettings(model, ":standalone", outputDir);
        this.buildBootstrapFile(model, ":standalone", outputDir);
        this.buildContentsMap(model, ":standalone", contentsMap);
    }

    private void prepareWebapp(Model model) throws MojoExecutionException {
        if (this.createWebapp) {
            Configuration webConfig;
            RunMode webappRM;
            HashMap<String, File> contentsMap = new HashMap<String, File>();
            this.project.setContextValue("slingstart:webapp", contentsMap);
            File outputDir = new File(this.project.getBuild().getDirectory(), "slingstart-webapp");
            File webappDir = new File(outputDir, "WEB-INF");
            this.unpackBaseArtifact(model, outputDir, ":webapp");
            Feature webappF = model.getFeature(":launchpad");
            if (webappF != null && (webappRM = webappF.getRunMode(null)) != null && (webConfig = webappRM.getConfiguration(":web.xml")) != null) {
                File webXML = new File(webappDir, "web.xml");
                try {
                    FileUtils.fileWrite((File)webXML, (String)webConfig.getProperties().get(":web.xml").toString());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write configuration to " + webXML, (Exception)e);
                }
            }
            this.buildSettings(model, ":webapp", webappDir);
            this.buildBootstrapFile(model, ":webapp", webappDir);
            this.buildContentsMap(model, ":webapp", contentsMap);
        }
    }

    private void buildContentsMap(Model model, String packageRunMode, Map<String, File> contentsMap) throws MojoExecutionException {
        if (packageRunMode == null) {
            org.apache.maven.artifact.Artifact artifact = this.getBaseArtifact(model, null, "jar");
            contentsMap.put("resources/" + artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension(), artifact.getFile());
        }
        for (Feature feature : model.getFeatures()) {
            if (feature.isSpecial() && !feature.getName().equals(":boot")) continue;
            for (RunMode runMode : feature.getRunModes()) {
                if (packageRunMode == null) {
                    if (runMode.isSpecial()) continue;
                    this.buildContentsMap(model, runMode, contentsMap, feature.getName().equals(":boot"));
                    continue;
                }
                if (!runMode.isRunMode(packageRunMode)) continue;
                this.buildContentsMap(model, runMode, contentsMap, feature.getName().equals(":boot"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildContentsMap(Model model, RunMode runMode, Map<String, File> contentsMap, boolean isBoot) throws MojoExecutionException {
        for (ArtifactGroup group : runMode.getArtifactGroups()) {
            for (Artifact a : group) {
                org.apache.maven.artifact.Artifact artifact = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), a.getClassifier());
                File artifactFile = artifact.getFile();
                contentsMap.put(this.getPathForArtifact(group.getStartLevel(), artifactFile.getName(), runMode, isBoot), artifactFile);
            }
        }
        File rootConfDir = new File(this.getTmpDir(), "global-config");
        boolean hasConfig = false;
        for (Configuration config : runMode.getConfigurations()) {
            if (config.isSpecial()) continue;
            String configPath = this.getPathForConfiguration(config, runMode);
            File configFile = new File(rootConfDir, configPath);
            this.getLog().debug((CharSequence)String.format("Creating configuration at %s", configFile.getPath()));
            configFile.getParentFile().mkdirs();
            try {
                FileOutputStream os = new FileOutputStream(configFile);
                try {
                    ConfigurationHandler.write((OutputStream)os, (Dictionary)config.getProperties());
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write configuration to " + configFile, (Exception)e);
            }
            hasConfig = true;
        }
        if (hasConfig) {
            contentsMap.put(BASE_DESTINATION, rootConfDir);
        }
    }

    private void buildSettings(Model model, String packageRunMode, File outputDir) throws MojoExecutionException {
        RunMode bootRunMode;
        Feature bootFeature;
        RunMode launchpadRunMode;
        Properties settings = new Properties();
        Feature launchpadFeature = model.getFeature(":launchpad");
        if (launchpadFeature != null && (launchpadRunMode = launchpadFeature.getRunMode(null)) != null) {
            for (Map.Entry entry : launchpadRunMode.getSettings()) {
                settings.put(entry.getKey(), entry.getValue());
            }
        }
        if ((bootFeature = model.getFeature(":boot")) != null && (bootRunMode = bootFeature.getRunMode(null)) != null) {
            for (Map.Entry entry : bootRunMode.getSettings()) {
                settings.put(entry.getKey(), entry.getValue());
            }
        }
        for (Feature f : model.getFeatures()) {
            RunMode packageRM = f.getRunMode(new String[]{packageRunMode});
            if (packageRM == null) continue;
            for (Map.Entry entry : packageRM.getSettings()) {
                settings.put(entry.getKey(), entry.getValue());
            }
        }
        if (settings.size() > 0) {
            File settingsFile = new File(outputDir, PROPERTIES_FILE);
            this.getLog().debug((CharSequence)String.format("Creating settings at %s", settingsFile.getPath()));
            FileWriter writer = null;
            try {
                writer = new FileWriter(settingsFile);
                settings.store(writer, null);
            }
            catch (IOException ioe) {
                try {
                    throw new MojoExecutionException("Unable to write properties file.", (Exception)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private void buildBootstrapFile(Model model, String packageRunMode, File outputDir) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        Feature launchpadFeature = model.getFeature(":launchpad");
        if (launchpadFeature != null) {
            Configuration c;
            RunMode packageRM;
            Configuration c2;
            RunMode launchpadRunMode = launchpadFeature.getRunMode(null);
            if (launchpadRunMode != null && (c2 = launchpadRunMode.getConfiguration(":bootstrap")) != null) {
                sb.append(c2.getProperties().get(c2.getPid()));
                sb.append('\n');
            }
            if ((packageRM = launchpadFeature.getRunMode(new String[]{packageRunMode})) != null && (c = packageRM.getConfiguration(":bootstrap")) != null) {
                sb.append(c.getProperties().get(c.getPid()));
                sb.append('\n');
            }
        }
        if (sb.length() > 0) {
            File file = new File(outputDir, BOOTSTRAP_FILE);
            this.getLog().debug((CharSequence)String.format("Creating bootstrap file at %s", file.getPath()));
            try {
                FileUtils.fileWrite((File)file, (String)sb.toString());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to write bootstrap file.", (Exception)ioe);
            }
        }
    }

    private org.apache.maven.artifact.Artifact getBaseArtifact(Model model, String classifier, String type) throws MojoExecutionException {
        Artifact baseArtifact = ModelUtils.getBaseArtifact(model);
        org.apache.maven.artifact.Artifact a = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, baseArtifact.getGroupId(), baseArtifact.getArtifactId(), baseArtifact.getVersion(), type, classifier);
        if (a == null) {
            throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", baseArtifact.getGroupId(), baseArtifact.getArtifactId()));
        }
        return a;
    }

    private void unpackBaseArtifact(Model model, File outputDirectory, String packageRunMode) throws MojoExecutionException {
        String type;
        String classifier;
        if (":standalone".equals(packageRunMode)) {
            classifier = "app";
            type = "jar";
        } else {
            classifier = "webapp";
            type = "war";
        }
        org.apache.maven.artifact.Artifact artifact = this.getBaseArtifact(model, classifier, type);
        this.unpack(artifact.getFile(), outputDirectory);
    }

    private void unpack(File source, File destination) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Unpacking " + source.getPath() + " to\n  " + destination.getPath()));
        try {
            destination.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(source);
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(destination);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to find archiver for " + source.getPath(), (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to unpack " + source.getPath(), (Exception)((Object)e));
        }
    }

    private String getPathForArtifact(int startLevel, String artifactName, RunMode rm, boolean isBoot) {
        String runModeExt;
        TreeSet<String> runModesList = new TreeSet<String>();
        if (rm.getNames() != null) {
            for (String mode : rm.getNames()) {
                runModesList.add(mode);
            }
        }
        if (runModesList.size() == 0 || rm.isSpecial()) {
            runModeExt = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String n : runModesList) {
                sb.append('.');
                sb.append(n);
            }
            runModeExt = sb.toString();
        }
        if (isBoot) {
            return String.format("%s/%s/1/%s", BASE_DESTINATION, BOOT_DIRECTORY, artifactName);
        }
        return String.format("%s/%s%s/%s/%s", BASE_DESTINATION, ARTIFACTS_DIRECTORY, runModeExt, startLevel == -1 ? 1 : startLevel, artifactName);
    }

    private String getPathForConfiguration(Configuration config, RunMode rm) {
        String runModeExt;
        TreeSet<String> runModesList = new TreeSet<String>();
        if (rm.getNames() != null) {
            for (String mode : rm.getNames()) {
                runModesList.add(mode);
            }
        }
        if (runModesList.size() == 0 || rm.isSpecial()) {
            runModeExt = "";
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String n : runModesList) {
                if (first) {
                    sb.append('/');
                    first = false;
                } else {
                    sb.append('.');
                }
                sb.append(n);
            }
            runModeExt = sb.toString();
        }
        String mainName = config.getFactoryPid() != null ? config.getFactoryPid() : config.getPid();
        String alias = config.getFactoryPid() != null ? "-" + config.getPid() : "";
        return String.format("%s/%s%s/%s%s.config", BASE_DESTINATION, CONFIG_DIRECTORY, runModeExt, mainName, alias);
    }
}

