/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.io.ModelWriter;

@Mojo(name="attach-slingfeature", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachSlingStartModel
extends AbstractSlingStartMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model = ProjectHelper.getRawModel(this.project);
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separatorChar + "slingstart.txt");
        outputFile.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(outputFile);
            ModelWriter.write((Writer)writer, (Model)model);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to write model to " + outputFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        if (this.project.getPackaging().equals("slingfeature")) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "slingfeature", "slingfeature", outputFile);
        }
    }
}

