/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "slingstart-maven-plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver resolver;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Environment env = new Environment();
        env.artifactHandlerManager = this.artifactHandlerManager;
        env.resolver = this.resolver;
        env.logger = this.logger;
        env.session = session;
        this.logger.debug("Searching for slingstart/slingfeature projects...");
        for (MavenProject project : session.getProjects()) {
            if (!project.getPackaging().equals("slingstart") && !project.getPackaging().equals("slingfeature")) continue;
            this.logger.debug("Found " + project.getPackaging() + " project: " + project);
            ProjectInfo info = new ProjectInfo();
            for (Plugin plugin : project.getBuild().getPlugins()) {
                if (!plugin.getArtifactId().equals(PLUGIN_ID)) continue;
                info.plugin = plugin;
                break;
            }
            info.project = project;
            env.modelProjects.put(project.getGroupId() + ":" + project.getArtifactId(), info);
        }
        DependencyLifecycleParticipant.addDependencies(env);
    }

    public static void addDependencies(Environment env) throws MavenExecutionException {
        for (ProjectInfo info : env.modelProjects.values()) {
            DependencyLifecycleParticipant.addDependencies(env, info);
        }
    }

    private static Model addDependencies(Environment env, ProjectInfo info) throws MavenExecutionException {
        if (info.done) {
            env.logger.debug("Return prepared model for " + info.project);
            return info.model;
        }
        info.done = true;
        env.logger.debug("Processing project " + info.project);
        String directory = DependencyLifecycleParticipant.nodeValue(info.plugin, "modelDirectory", new File(info.project.getBasedir(), "src/main/provisioning").getAbsolutePath());
        try {
            info.localModel = DependencyLifecycleParticipant.readLocalModel(info.project, new File(directory), env.logger);
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)info.localModel, null);
        List<Model> dependencies = DependencyLifecycleParticipant.searchSlingstartDependencies(env, info, effectiveModel);
        info.model = new Model();
        for (Model d : dependencies) {
            ModelUtility.merge((Model)info.model, (Model)d);
        }
        ModelUtility.merge((Model)info.model, (Model)effectiveModel);
        info.model = ModelUtility.getEffectiveModel((Model)info.model, null);
        Map errors = ModelUtility.validate((Model)info.model);
        if (errors != null) {
            throw new MavenExecutionException("Unable to create model file for " + info.project + " : " + errors, (File)null);
        }
        DependencyLifecycleParticipant.addDependenciesFromModel(env, info);
        try {
            ProjectHelper.storeProjectInfo(info);
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        return info.model;
    }

    private static void addDependenciesFromModel(Environment env, ProjectInfo info) throws MavenExecutionException {
        if (info.project.getPackaging().equals("slingstart")) {
            String[] classifiers;
            Artifact baseArtifact = ModelUtils.findBaseArtifact(info.model);
            for (String c : classifiers = new String[]{null, "app", "webapp"}) {
                Dependency dep = new Dependency();
                dep.setGroupId(baseArtifact.getGroupId());
                dep.setArtifactId(baseArtifact.getArtifactId());
                dep.setVersion(baseArtifact.getVersion());
                dep.setType(baseArtifact.getType());
                dep.setClassifier(c);
                if ("webapp".equals(c)) {
                    dep.setType("war");
                }
                dep.setScope("provided");
                info.project.getDependencies().add(dep);
                env.logger.debug("- adding base dependency " + ModelUtils.toString(dep));
            }
        }
        for (Feature feature : info.model.getFeatures()) {
            if (feature.getName().equals(":launchpad")) continue;
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    for (Artifact a : group) {
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType(a.getType());
                        dep.setClassifier(a.getClassifier());
                        dep.setScope("provided");
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                    }
                }
            }
        }
    }

    private static List<Model> searchSlingstartDependencies(Environment env, ProjectInfo info, Model effectiveModel) throws MavenExecutionException {
        ArrayList<Model> dependencies = new ArrayList<Model>();
        for (Feature feature : effectiveModel.getFeatures()) {
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    ArrayList<Artifact> removeList = new ArrayList<Artifact>();
                    for (Artifact a : group) {
                        if (!a.getType().equals("slingstart") && !a.getType().equals("slingfeature")) continue;
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType("slingfeature");
                        if (a.getType().equals("slingstart")) {
                            dep.setClassifier("slingfeature");
                        } else {
                            dep.setClassifier(a.getClassifier());
                        }
                        dep.setScope("provided");
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                        String key = a.getGroupId() + ":" + a.getArtifactId();
                        if (env.modelProjects.containsKey(key)) {
                            env.logger.debug("Found reactor " + a.getType() + " dependency : " + a);
                            Model model = DependencyLifecycleParticipant.addDependencies(env, env.modelProjects.get(key));
                            if (model == null) {
                                throw new MavenExecutionException("Recursive model dependency list including project " + info.project, (File)null);
                            }
                            dependencies.add(model);
                        } else {
                            env.logger.debug("Found external " + a.getType() + " dependency: " + a);
                            File modelFile = DependencyLifecycleParticipant.resolveSlingstartArtifact(env, info.project, dep);
                            FileReader r = null;
                            try {
                                r = new FileReader(modelFile);
                                Model m = ModelReader.read((Reader)r, (String)modelFile.getAbsolutePath());
                                Map errors = ModelUtility.validate((Model)m);
                                if (errors != null) {
                                    throw new MavenExecutionException("Unable to read model file from " + modelFile + " : " + errors, modelFile);
                                }
                                dependencies.add(m);
                            }
                            catch (IOException ioe) {
                                throw new MavenExecutionException("Unable to read model file from " + modelFile, (Throwable)ioe);
                            }
                            finally {
                                try {
                                    if (r != null) {
                                        r.close();
                                    }
                                }
                                catch (IOException io) {}
                            }
                        }
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                        removeList.add(a);
                    }
                    for (Artifact r : removeList) {
                        group.remove((Object)r);
                    }
                }
            }
        }
        return dependencies;
    }

    private static String nodeValue(Plugin plugin, String name, String defaultValue) {
        Xpp3Dom node;
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom xpp3Dom = node = config == null ? null : config.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return defaultValue;
    }

    private static File resolveSlingstartArtifact(Environment env, MavenProject project, Dependency d) throws MavenExecutionException {
        DefaultArtifact prjArtifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), "provided", d.getType(), d.getClassifier(), env.artifactHandlerManager.getArtifactHandler(d.getType()));
        try {
            env.resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), env.session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        return prjArtifact.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model readLocalModel(MavenProject project, File modelDirectory, Logger logger) throws MavenExecutionException, IOException {
        ArrayList<String> candidates = new ArrayList<String>();
        if (modelDirectory != null && modelDirectory.exists()) {
            for (File f : modelDirectory.listFiles()) {
                if (!f.isFile() || f.getName().startsWith(".") || !f.getName().endsWith(".txt") && !f.getName().endsWith(".model")) continue;
                candidates.add(f.getName());
            }
            Collections.sort(candidates);
        }
        if (candidates.size() == 0) {
            throw new MavenExecutionException("No model files found in " + modelDirectory, (File)null);
        }
        Model result = new Model();
        for (String name : candidates) {
            logger.debug("Reading model " + name + " in project " + project.getId());
            try {
                File f;
                f = new File(modelDirectory, name);
                FileReader reader = new FileReader(f);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)f.getAbsolutePath());
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MavenExecutionException("Invalid model at " + name + " : " + errors, (File)null);
                    }
                    ModelUtility.merge((Model)result, (Model)current, (boolean)false);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MavenExecutionException("Unable to read model at " + name, (Throwable)io);
            }
        }
        Map errors = ModelUtility.validate((Model)result);
        if (errors != null) {
            throw new MavenExecutionException("Invalid assembled model : " + errors, (File)null);
        }
        return result;
    }

    public static final class Environment {
        public ArtifactHandlerManager artifactHandlerManager;
        public ArtifactResolver resolver;
        public MavenSession session;
        public Logger logger;
        public final Map<String, ProjectInfo> modelProjects = new HashMap<String, ProjectInfo>();
    }

    public static final class ProjectInfo {
        public MavenProject project;
        public Plugin plugin;
        public Model localModel;
        public boolean done = false;
        public Model model;
    }
}

