/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.DependencyLifecycleParticipant;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.apache.sling.provisioning.model.io.ModelWriter;

public abstract class ProjectHelper {
    private static final String RAW_MODEL_TXT = Model.class.getName() + "/raw.txt";
    private static final String RAW_MODEL_CACHE = Model.class.getName() + "/raw.cache";
    private static final String EFFECTIVE_MODEL_TXT = Model.class.getName() + "/effective.txt";
    private static final String EFFECTIVE_MODEL_CACHE = Model.class.getName() + "/effective.cache";

    public static void storeProjectInfo(DependencyLifecycleParticipant.ProjectInfo info) throws IOException {
        StringWriter w1 = new StringWriter();
        ModelWriter.write((Writer)w1, (Model)info.localModel);
        info.project.setContextValue(RAW_MODEL_TXT, (Object)w1.toString());
        StringWriter w2 = new StringWriter();
        ModelWriter.write((Writer)w2, (Model)info.model);
        info.project.setContextValue(EFFECTIVE_MODEL_TXT, (Object)w2.toString());
    }

    public static Model getEffectiveModel(MavenProject project) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(EFFECTIVE_MODEL_CACHE);
        if (result == null) {
            try {
                StringReader r = new StringReader((String)project.getContextValue(EFFECTIVE_MODEL_TXT));
                result = ModelReader.read((Reader)r, (String)project.getId());
                result = ModelUtility.getEffectiveModel((Model)result, null);
                project.setContextValue(EFFECTIVE_MODEL_CACHE, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        return result;
    }

    public static Model getRawModel(MavenProject project) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(RAW_MODEL_CACHE);
        if (result == null) {
            try {
                StringReader r = new StringReader((String)project.getContextValue(RAW_MODEL_TXT));
                result = ModelReader.read((Reader)r, (String)project.getId());
                project.setContextValue(RAW_MODEL_CACHE, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        return result;
    }
}

