/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.File;
import java.io.Serializable;

public class ServerConfiguration
implements Serializable {
    private static final long serialVersionUID = 1922175510880318125L;
    private static final String DEFAULT_VM_OPTS = "-Xmx1024m -XX:MaxPermSize=256m -Djava.awt.headless=true";
    private static final String DEFAULT_VM_DEBUG_OPTS = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=8000";
    private String id;
    private String runmode;
    private String port;
    private String controlPort;
    private String contextPath;
    private String vmOpts = "-Xmx1024m -XX:MaxPermSize=256m -Djava.awt.headless=true";
    private String debug;
    private String opts;
    private int instances = 1;
    private File folder;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRunmode() {
        return this.runmode;
    }

    public void setRunmode(String runmode) {
        this.runmode = runmode;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getVmOpts() {
        return this.vmOpts;
    }

    public void setVmOpts(String vmOpts) {
        this.vmOpts = vmOpts;
    }

    public String getVmDebugOpts(String globalDebug) {
        if (globalDebug != null) {
            if (Boolean.valueOf(globalDebug).equals(Boolean.TRUE)) {
                return DEFAULT_VM_DEBUG_OPTS;
            }
            return globalDebug;
        }
        if (Boolean.valueOf(this.debug).equals(Boolean.TRUE)) {
            return DEFAULT_VM_DEBUG_OPTS;
        }
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String getOpts() {
        return this.opts;
    }

    public void setOpts(String opts) {
        this.opts = opts;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int value) {
        this.instances = value;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder.getAbsoluteFile();
    }

    public String getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(String controlPort) {
        this.controlPort = controlPort;
    }

    public String getServer() {
        return "localhost";
    }

    public ServerConfiguration copy() {
        ServerConfiguration copy = new ServerConfiguration();
        copy.setRunmode(this.getRunmode());
        copy.setPort(this.getPort());
        copy.setContextPath(this.getContextPath());
        copy.setVmOpts(this.getVmOpts());
        copy.setDebug(this.debug);
        copy.setOpts(this.getOpts());
        copy.setInstances(1);
        copy.setFolder(this.getFolder());
        copy.setControlPort(this.getControlPort());
        return copy;
    }

    public String toString() {
        return "LaunchpadConfiguration [id=" + this.id + ", runmode=" + this.runmode + ", port=" + this.port + ", controlPort=" + this.controlPort + ", contextPath=" + this.contextPath + ", vmOpts=" + this.vmOpts + ", vmDebugOpts=" + this.getVmDebugOpts(null) + ", opts=" + this.opts + ", instances=" + this.instances + ", folder=" + this.folder + "]";
    }
}

