/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeArrayWriter {
    private BufferHolder holder;
    private int startingOffset;

    public void initialize(BufferHolder holder, int numElements, int fixedElementSize) {
        int fixedSize = 4 + 4 * numElements;
        this.holder = holder;
        this.startingOffset = holder.cursor;
        holder.grow(fixedSize);
        Platform.putInt((Object)holder.buffer, (long)holder.cursor, (int)numElements);
        holder.cursor += fixedSize;
        holder.grow(fixedElementSize * numElements);
    }

    private long getElementOffset(int ordinal) {
        return this.startingOffset + 4 + 4 * ordinal;
    }

    public void setNullAt(int ordinal) {
        int relativeOffset = this.holder.cursor - this.startingOffset;
        Platform.putInt((Object)this.holder.buffer, (long)this.getElementOffset(ordinal), (int)(-relativeOffset));
    }

    public void setOffset(int ordinal) {
        int relativeOffset = this.holder.cursor - this.startingOffset;
        Platform.putInt((Object)this.holder.buffer, (long)this.getElementOffset(ordinal), (int)relativeOffset);
    }

    public void write(int ordinal, boolean value) {
        Platform.putBoolean((Object)this.holder.buffer, (long)this.holder.cursor, (boolean)value);
        this.setOffset(ordinal);
        ++this.holder.cursor;
    }

    public void write(int ordinal, byte value) {
        Platform.putByte((Object)this.holder.buffer, (long)this.holder.cursor, (byte)value);
        this.setOffset(ordinal);
        ++this.holder.cursor;
    }

    public void write(int ordinal, short value) {
        Platform.putShort((Object)this.holder.buffer, (long)this.holder.cursor, (short)value);
        this.setOffset(ordinal);
        this.holder.cursor += 2;
    }

    public void write(int ordinal, int value) {
        Platform.putInt((Object)this.holder.buffer, (long)this.holder.cursor, (int)value);
        this.setOffset(ordinal);
        this.holder.cursor += 4;
    }

    public void write(int ordinal, long value) {
        Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)value);
        this.setOffset(ordinal);
        this.holder.cursor += 8;
    }

    public void write(int ordinal, float value) {
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        Platform.putFloat((Object)this.holder.buffer, (long)this.holder.cursor, (float)value);
        this.setOffset(ordinal);
        this.holder.cursor += 4;
    }

    public void write(int ordinal, double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        Platform.putDouble((Object)this.holder.buffer, (long)this.holder.cursor, (double)value);
        this.setOffset(ordinal);
        this.holder.cursor += 8;
    }

    public void write(int ordinal, Decimal input, int precision, int scale) {
        if (input.changePrecision(precision, scale)) {
            if (precision <= Decimal.MAX_LONG_DIGITS()) {
                Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)input.toUnscaledLong());
                this.setOffset(ordinal);
                this.holder.cursor += 8;
            } else {
                byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
                assert (bytes.length <= 16);
                this.holder.grow(bytes.length);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.holder.buffer, (long)this.holder.cursor, (long)bytes.length);
                this.setOffset(ordinal);
                this.holder.cursor += bytes.length;
            }
        } else {
            this.setNullAt(ordinal);
        }
    }

    public void write(int ordinal, UTF8String input) {
        int numBytes = input.numBytes();
        this.holder.grow(numBytes);
        input.writeToMemory((Object)this.holder.buffer, (long)this.holder.cursor);
        this.setOffset(ordinal);
        this.holder.cursor += numBytes;
    }

    public void write(int ordinal, byte[] input) {
        this.holder.grow(input.length);
        Platform.copyMemory((Object)input, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.holder.buffer, (long)this.holder.cursor, (long)input.length);
        this.setOffset(ordinal);
        this.holder.cursor += input.length;
    }

    public void write(int ordinal, CalendarInterval input) {
        this.holder.grow(16);
        Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)input.months);
        Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + 8), (long)input.microseconds);
        this.setOffset(ordinal);
        this.holder.cursor += 16;
    }
}

