/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.physical.AllTuples$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.OrderedDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.catalyst.plans.physical.UnspecifiedDistribution$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001\u001b\t\tB)[:ue&\u0014W\u000f^5p]N+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t\"G\u0001\u000fG\",7m[*bi&\u001ch-[3e)\u0011Q\u0002EK\u0018\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006C]\u0001\rAI\u0001\u0012S:\u0004X\u000f\u001e)beRLG/[8oS:<\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003!\u0001\b._:jG\u0006d'BA\u0014\u0003\u0003\u0015\u0001H.\u00198t\u0013\tICE\u0001\u0007QCJ$\u0018\u000e^5p]&tw\rC\u0003,/\u0001\u0007A&\u0001\u000bsKF,\u0018N]3e\t&\u001cHO]5ckRLwN\u001c\t\u0003G5J!A\f\u0013\u0003\u0019\u0011K7\u000f\u001e:jEV$\u0018n\u001c8\t\u000bA:\u0002\u0019A\u0019\u0002\u0013M\fG/[:gS\u0016$\u0007CA\u000e3\u0013\t\u0019DDA\u0004C_>dW-\u00198")
public class DistributionSuite
extends SparkFunSuite {
    public void checkSatisfied(Partitioning inputPartitioning, Distribution requiredDistribution, boolean satisfied) {
        if (inputPartitioning.satisfies(requiredDistribution) != satisfied) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |== Input Partitioning ==\n        |", "\n        |== Required Distribution ==\n        |", "\n        |== Does input partitioning satisfy required distribution? ==\n        |Expected ", " got ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPartitioning, requiredDistribution, BoxesRunTime.boxToBoolean((boolean)satisfied), BoxesRunTime.boxToBoolean((boolean)inputPartitioning.satisfies(requiredDistribution))})))).stripMargin());
        }
    }

    public DistributionSuite() {
        this.test("HashPartitioning (with nullSafe = true) is the output partitioning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DistributionSuite $outer;
            private static Symbol symbol$1;
            private static Symbol symbol$2;
            private static Symbol symbol$3;
            private static Symbol symbol$4;
            private static Symbol symbol$5;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
                symbol$2 = Symbol$.MODULE$.apply("b");
                symbol$3 = Symbol$.MODULE$.apply("c");
                symbol$4 = Symbol$.MODULE$.apply("d");
                symbol$5 = Symbol$.MODULE$.apply("e");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)UnspecifiedDistribution$.MODULE$, true);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)}))), true);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)}))), true);
                this.$outer.checkSatisfied((Partitioning)SinglePartition$.MODULE$, (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)}))), true);
                this.$outer.checkSatisfied((Partitioning)SinglePartition$.MODULE$, (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$1).asc(), package.expressions$.MODULE$.DslSymbol(symbol$2).asc(), package.expressions$.MODULE$.DslSymbol(symbol$3).asc()}))), true);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)}))), false);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$4), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$5)}))), false);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)AllTuples$.MODULE$, false);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$1), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$1).asc(), package.expressions$.MODULE$.DslSymbol(symbol$2).asc(), package.expressions$.MODULE$.DslSymbol(symbol$3).asc()}))), false);
                this.$outer.checkSatisfied((Partitioning)new HashPartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$2), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$3)})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$1).asc(), package.expressions$.MODULE$.DslSymbol(symbol$2).asc(), package.expressions$.MODULE$.DslSymbol(symbol$3).asc()}))), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("RangePartitioning is the output partitioning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DistributionSuite $outer;
            private static Symbol symbol$6;
            private static Symbol symbol$7;
            private static Symbol symbol$8;
            private static Symbol symbol$9;

            static {
                symbol$6 = Symbol$.MODULE$.apply("a");
                symbol$7 = Symbol$.MODULE$.apply("b");
                symbol$8 = Symbol$.MODULE$.apply("c");
                symbol$9 = Symbol$.MODULE$.apply("d");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)UnspecifiedDistribution$.MODULE$, true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc()}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc(), package.expressions$.MODULE$.DslSymbol(symbol$9).desc()}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8)}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6)}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)}))), true);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).desc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()}))), false);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new OrderedDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$6).asc()}))), false);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7)}))), false);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)new ClusteredDistribution((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)}))), false);
                this.$outer.checkSatisfied((Partitioning)new RangePartitioning((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).asc()})), 10), (Distribution)AllTuples$.MODULE$, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

