/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTestCases$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2Q!\u0001\u0002\u0002\u0002=\u0011\u0001cQ1uC2|w\rV3ti\u000e\u000b7/Z:\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003D\u0001\ng\u000e\fG.\u0019;fgRL!!\u0007\f\u0003%\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0016\u000b7\r\u001b\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u001bE\u0011%A\u0003vi&d7/F\u0001#!\tq2%\u0003\u0002%\u0005\t\u00012)\u0019;bY><G+Z:u+RLGn\u001d\u0005\u0006M\u0001!\tbJ\u0001\u000be\u0016\u001cX\r^*uCR,G#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006_\u0001!\teJ\u0001\nC\u001a$XM]#bG\"\u0004")
public abstract class CatalogTestCases
extends SparkFunSuite
implements BeforeAndAfterEach {
    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public abstract CatalogTestUtils utils();

    public void resetState() {
    }

    public void afterEach() {
        try {
            this.resetState();
            return;
        }
        finally {
            BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
        }
    }

    public CatalogTestCases() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.test("basic create and list databases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("default"), true);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog.createDatabase(this.$outer.utils().newDb("testing"), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                catalog.createDatabase(this.$outer.utils().newDb("testing2"), false);
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get database when a database exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CatalogDatabase db1 = this.$outer.utils().newBasicCatalog().getDatabase("db1");
                String $org_scalatest_assert_macro_left = db1.name();
                String $org_scalatest_assert_macro_right = "db1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = db1.description();
                String $org_scalatest_assert_macro_right2 = "db1";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final CatalogDatabase apply() {
                        return this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newBasicCatalog().getDatabase("db_that_does_not_exist");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("list databases with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.dropDatabase("db1", false, false);
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database is not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog1 = this.$outer.utils().newBasicCatalog();
                catalog1.dropTable("db2", "tbl1", false);
                catalog1.dropTable("db2", "tbl2", false);
                this.$outer.intercept((Function0)new Serializable(this, catalog1){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog1$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog1$1 = catalog1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                catalog2.dropFunction("db2", "func1");
                this.$outer.intercept((Function0)new Serializable(this, catalog2){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog2$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog2$1 = catalog2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.resetState();
                ExternalCatalog catalog3 = this.$outer.utils().newBasicCatalog();
                catalog3.dropDatabase("db2", false, true);
                Set $org_scalatest_assert_macro_left = catalog3.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop database when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$1.dropDatabase("db_that_does_not_exist", false, false);
                    }
                    {
                        this.catalog$1 = catalog$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropDatabase("db_that_does_not_exist", true, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db1 = catalog.getDatabase("db1");
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"good"), (Object)"true")}));
                String x$4 = db1.copy$default$1();
                String x$5 = db1.copy$default$2();
                String x$6 = db1.copy$default$3();
                catalog.alterDatabase(db1.copy(x$4, x$5, x$6, x$3));
                CatalogDatabase newDb1 = catalog.getDatabase("db1");
                Map $org_scalatest_assert_macro_left = db1.properties();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newDb1.properties();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
                Option option2 = $org_scalatest_assert_macro_left4;
                Some some2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newBasicCatalog().alterDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newDb("does_not_exist"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropTable("db2", "tbl1", false);
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("unknown_db", "unknown_table", false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("unknown_db", "unknown_table", true);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.dropTable("db2", "unknown_table", false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropTable("db2", "unknown_table", true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.renameTable("db2", "tbl1", "tblone");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.renameTable("unknown_db", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.renameTable("db2", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable tbl1 = catalog.getTable("db2", "tbl1");
                Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toh"), (Object)"frem")}));
                TableIdentifier x$8 = tbl1.copy$default$1();
                CatalogTableType x$9 = tbl1.copy$default$2();
                CatalogStorageFormat x$10 = tbl1.copy$default$3();
                Seq x$11 = tbl1.copy$default$4();
                Seq x$12 = tbl1.copy$default$5();
                Seq x$13 = tbl1.copy$default$6();
                int x$14 = tbl1.copy$default$7();
                long x$15 = tbl1.copy$default$8();
                long x$16 = tbl1.copy$default$9();
                Option x$17 = tbl1.copy$default$11();
                Option x$18 = tbl1.copy$default$12();
                catalog.alterTable("db2", tbl1.copy(x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$7, x$17, x$18));
                CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
                Map $org_scalatest_assert_macro_left = tbl1.properties();
                String $org_scalatest_assert_macro_right = "toh";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
                int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final ExternalCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.alterTable("unknown_db", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newTable("tbl1", "unknown_db"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$4 = catalog$4;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final ExternalCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.alterTable("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newTable("unknown_table", "db2"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$4 = catalog$4;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String $org_scalatest_assert_macro_left = this.$outer.utils().newBasicCatalog().getTable("db2", "tbl1").identifier().table();
                String $org_scalatest_assert_macro_right = "tbl1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$5;

                    public final CatalogTable apply() {
                        return this.catalog$5.getTable("unknown_db", "unknown_table");
                    }
                    {
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$5;

                    public final CatalogTable apply() {
                        return this.catalog$5.getTable("db2", "unknown_table");
                    }
                    {
                        this.catalog$5 = catalog$5;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$6;

                    public final Seq<String> apply() {
                        return this.catalog$6.listTables("unknown_db");
                    }
                    {
                        this.catalog$6 = catalog$6;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("list tables with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$7;

                    public final Seq<String> apply() {
                        return this.catalog$7.listTables("unknown_db", "*");
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createTable("mydb", this.$outer.utils().newTable("tbl", "mydb"), false);
                catalog.createPartitions("mydb", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "CatalogTestCases.this.utils.catalogPartitionsEqual(catalog, \"mydb\", \"tbl\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](CatalogTestCases.this.utils.part1, CatalogTestCases.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$8;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$8.createPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$8;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$8.createPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create partitions that already exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$23 $outer;
                    private final ExternalCatalog catalog$9;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$9.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$9 = catalog$9;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), true);
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "CatalogTestCases.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](CatalogTestCases.this.utils.part1, CatalogTestCases.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part2()})))), "CatalogTestCases.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](CatalogTestCases.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog2, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "CatalogTestCases.this.utils.catalogPartitionsEqual(catalog2, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](CatalogTestCases.this.utils.part1, CatalogTestCases.this.utils.part2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                catalog2.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), false);
                Seq $org_scalatest_assert_macro_left = catalog2.listPartitions("db2", "tbl2");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$10;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$10.dropPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$10;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$10.dropPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop partitions that do not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$26 $outer;
                    private final ExternalCatalog catalog$11;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$11.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part3().spec()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$11 = catalog$11;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part3().spec()})), true);
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Map $org_scalatest_assert_macro_left = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec()).spec();
                Map $org_scalatest_assert_macro_right = this.$outer.utils().part1().spec();
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Map $org_scalatest_assert_macro_left2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec()).spec();
                Map $org_scalatest_assert_macro_right2 = this.$outer.utils().part2().spec();
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$27 $outer;
                    private final ExternalCatalog catalog$12;

                    public final CatalogTablePartition apply() {
                        return this.catalog$12.getPartition("db2", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part3().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$12 = catalog$12;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get partition when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$28 $outer;
                    private final ExternalCatalog catalog$13;

                    public final CatalogTablePartition apply() {
                        return this.catalog$13.getPartition("does_not_exist", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$13 = catalog$13;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$28 $outer;
                    private final ExternalCatalog catalog$13;

                    public final CatalogTablePartition apply() {
                        return this.catalog$13.getPartition("db2", "does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$13 = catalog$13;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTablePartition newPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"101")})), this.$outer.utils().part1().copy$default$2());
                CatalogTablePartition newPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"201")})), this.$outer.utils().part2().copy$default$2());
                Seq newSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newPart1.spec(), newPart2.spec()}));
                catalog.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), newSpecs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart1.spec()).spec());
                Map $org_scalatest_assert_macro_right = newPart1.spec();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart2.spec()).spec());
                Map $org_scalatest_assert_macro_right2 = newPart2.spec();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$29 $outer;
                    private final ExternalCatalog catalog$14;

                    public final CatalogTablePartition apply() {
                        return this.catalog$14.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$14 = catalog$14;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$29 $outer;
                    private final ExternalCatalog catalog$14;

                    public final CatalogTablePartition apply() {
                        return this.catalog$14.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part2().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$14 = catalog$14;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;
                    private final ExternalCatalog catalog$15;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$15.renamePartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;
                    private final ExternalCatalog catalog$15;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$15.renamePartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$15 = catalog$15;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                try {
                    catalog.setCurrentDatabase("db2");
                    String newLocation = this.$outer.utils().newUriForDatabase();
                    CatalogTablePartition oldPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition oldPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    CatalogTablePartition[] catalogTablePartitionArray = new CatalogTablePartition[2];
                    CatalogStorageFormat x$19 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5());
                    Map x$20 = oldPart1.copy$default$1();
                    catalogTablePartitionArray[0] = oldPart1.copy(x$20, x$19);
                    CatalogStorageFormat x$21 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5());
                    Map x$22 = oldPart2.copy$default$1();
                    catalogTablePartitionArray[1] = oldPart2.copy(x$22, x$21);
                    catalog.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray)));
                    CatalogTablePartition newPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition newPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                    Option option = $org_scalatest_assert_macro_left;
                    Some some = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                    Option option2 = $org_scalatest_assert_macro_left2;
                    Some some2 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                    Option option3 = $org_scalatest_assert_macro_left3;
                    Some some3 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 != null ? !option3.equals(some3) : some3 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                    Option option4 = $org_scalatest_assert_macro_left4;
                    Some some4 = $org_scalatest_assert_macro_right4;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 != null ? !option4.equals(some4) : some4 != null);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    CatalogTablePartition badPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v2")})), this.$outer.utils().part1().copy$default$2());
                    CatalogTablePartition badPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v4")})), this.$outer.utils().part2().copy$default$2());
                    this.$outer.intercept((Function0)new Serializable(this, catalog, badPart1, badPart2){
                        public static final long serialVersionUID = 0L;
                        private final ExternalCatalog catalog$16;
                        private final CatalogTablePartition badPart1$1;
                        private final CatalogTablePartition badPart2$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.catalog$16.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.badPart1$1, this.badPart2$1})));
                        }
                        {
                            this.catalog$16 = catalog$16;
                            this.badPart1$1 = badPart1$1;
                            this.badPart2$1 = badPart2$1;
                        }
                    }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.setCurrentDatabase("default");
                    throw throwable;
                }
                catalog.setCurrentDatabase("default");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;
                    private final ExternalCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.alterPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;
                    private final ExternalCatalog catalog$17;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$17.alterPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("basic create and list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createFunction("mydb", this.$outer.utils().newFunc("myfunc", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("mydb", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$34 $outer;
                    private final ExternalCatalog catalog$18;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$18.createFunction("does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$18 = catalog$18;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create function that already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$35 $outer;
                    private final ExternalCatalog catalog$19;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$19.createFunction("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc("func1", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc$default$2()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$19 = catalog$19;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.dropFunction("db2", "func1");
                Seq $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "*");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$20;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$20.dropFunction("does_not_exist", "something");
                    }
                    {
                        this.catalog$20 = catalog$20;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop function that does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$21;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$21.dropFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$21 = catalog$21;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1");
                CatalogFunction $org_scalatest_assert_macro_right = new CatalogFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), this.$outer.utils().funcClass());
                CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
                CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$22;

                    public final CatalogFunction apply() {
                        return this.catalog$22.getFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$22 = catalog$22;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("get function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$23;

                    public final CatalogFunction apply() {
                        return this.catalog$23.getFunction("does_not_exist", "func1");
                    }
                    {
                        this.catalog$23 = catalog$23;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String newName = "funcky";
                String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right = this.$outer.utils().funcClass();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                catalog.renameFunction("db2", "func1", newName);
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$24;

                    public final CatalogFunction apply() {
                        return this.catalog$24.getFunction("db2", "func1");
                    }
                    {
                        this.catalog$24 = catalog$24;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", newName).identifier().funcName();
                String $org_scalatest_assert_macro_right2 = newName;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = catalog.getFunction("db2", newName).className();
                String $org_scalatest_assert_macro_right3 = this.$outer.utils().funcClass();
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$24;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$24.renameFunction("db2", "does_not_exist", "me");
                    }
                    {
                        this.catalog$24 = catalog$24;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rename function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$25;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$25.renameFunction("does_not_exist", "func1", "func5");
                    }
                    {
                        this.catalog$25 = catalog$25;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right = this.$outer.utils().funcClass();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                CatalogFunction qual$1 = this.$outer.utils().newFunc("func1", this.$outer.utils().newFunc$default$2());
                String x$23 = "muhaha";
                FunctionIdentifier x$24 = qual$1.copy$default$1();
                catalog.alterFunction("db2", qual$1.copy(x$24, x$23));
                String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right2 = "muhaha";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;
                    private final ExternalCatalog catalog$26;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$26.alterFunction("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc("funcky", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc$default$2()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$26 = catalog$26;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("alter function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final ExternalCatalog catalog$27;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$27.alterFunction("does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer().utils().newFunc());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$27 = catalog$27;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CatalogTestCases org$apache$spark$sql$catalyst$catalog$CatalogTestCases$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogTestCases $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createFunction("db2", this.$outer.utils().newFunc("func2", this.$outer.utils().newFunc$default$2()));
                catalog.createFunction("db2", this.$outer.utils().newFunc("not_me", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2", "not_me"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "func*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

