/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.SpecificMutableRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001#\tA\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vgN+\u0018\u000e^3\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\tqb\u0019:fCR,Wi\u001d;j[\u0006$xN\u001d\u000b\u0004=-\u0002\u0004#B\u0010#I\u001d:S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\rQ+\b\u000f\\34!\tQR%\u0003\u0002'\u0005\t\u0019\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vgB\u0011\u0001&K\u0007\u0002\t%\u0011!\u0006\u0002\u0002\u000b\u001bV$\u0018M\u00197f%><\b\"\u0002\u0017\u001c\u0001\u0004i\u0013a\u0001:tIB\u0011qDL\u0005\u0003_\u0001\u0012a\u0001R8vE2,\u0007bB\u0019\u001c!\u0003\u0005\rAM\u0001\u0003IR\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0005\u0002\u000bQL\b/Z:\n\u0005]\"$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000be\u0002A\u0011\u0001\u001e\u0002\u0019\r\u0014X-\u0019;f\u0005V4g-\u001a:\u0015\u0005\u001dZ\u0004\"\u0002\u001f9\u0001\u0004!\u0013a\u00015mY\")a\b\u0001C\u0001\u007f\u0005\u0001RM^1mk\u0006$X-R:uS6\fG/\u001a\u000b\u0005\u0001\u000e#e\t\u0005\u0002 \u0003&\u0011!\t\t\u0002\u0005+:LG\u000fC\u0003={\u0001\u0007A\u0005C\u0003F{\u0001\u0007q%\u0001\u0004ck\u001a4WM\u001d\u0005\u0006\u000fv\u0002\r\u0001S\u0001\fG\u0006\u0014H-\u001b8bY&$\u0018\u0010\u0005\u0002 \u0013&\u0011!\n\t\u0002\u0004\u0013:$\b\"\u0002'\u0001\t\u0003i\u0015\u0001\u0007;fgR\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=FgRLW.\u0019;fgR)\u0001I\u0014/`I\")qj\u0013a\u0001!\u0006!!o\u001d3t!\r\t\u0016,\f\b\u0003%^s!a\u0015,\u000e\u0003QS!!\u0016\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u0001-!\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002YA!)Ql\u0013a\u0001=\u0006\u0011an\u001d\t\u0004#fC\u0005\"\u00021L\u0001\u0004\t\u0017!\u00014\u0011\t}\u0011\u0007\nS\u0005\u0003G\u0002\u0012\u0011BR;oGRLwN\\\u0019\t\u000b\u0015\\\u0005\u0019A1\u0002\u0003\rDqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001.A\rde\u0016\fG/Z#ti&l\u0017\r^8sI\u0011,g-Y;mi\u0012\u0012T#A5+\u0005IR7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001\b%\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class HyperLogLogPlusPlusSuite
extends SparkFunSuite {
    public Tuple3<HyperLogLogPlusPlus, MutableRow, MutableRow> createEstimator(double rsd, DataType dt) {
        SpecificMutableRow input = new SpecificMutableRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dt})));
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus((Expression)new BoundReference(0, dt, true), rsd, HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3(), HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4());
        MutableRow buffer = this.createBuffer(hll);
        return new Tuple3((Object)hll, (Object)input, (Object)buffer);
    }

    public DataType createEstimator$default$2() {
        return IntegerType$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public MutableRow createBuffer(HyperLogLogPlusPlus hll) {
        void var2_2;
        SpecificMutableRow buffer = new SpecificMutableRow((Seq)hll.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(AttributeReference x$1) {
                return x$1.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        hll.initialize((MutableRow)buffer);
        return var2_2;
    }

    public void evaluateEstimate(HyperLogLogPlusPlus hll, MutableRow buffer, int cardinality) {
        double error;
        double estimate = BoxesRunTime.unboxToLong((Object)hll.eval((InternalRow)buffer));
        double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
        double $org_scalatest_assert_macro_right = hll.trueRsd() * 3.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.");
    }

    public void testCardinalityEstimates(Seq<Object> rsds, Seq<Object> ns, Function1<Object, Object> f2, Function1<Object, Object> c) {
        ((IterableLike)rsds.flatMap((Function1)new Serializable(this, ns){
            public static final long serialVersionUID = 0L;
            private final Seq ns$1;

            public final Seq<Tuple2<Object, Object>> apply(double rsd) {
                return (Seq)this.ns$1.map((Function1)new Serializable(this, rsd){
                    public static final long serialVersionUID = 0L;
                    private final double rsd$1;

                    public final Tuple2<Object, Object> apply(int n) {
                        return new Tuple2.mcDI.sp(this.rsd$1, n);
                    }
                    {
                        this.rsd$1 = rsd$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.ns$1 = ns$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, f2, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;
            private final Function1 f$1;
            private final Function1 c$1;

            public final void apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double rsd = tuple2._1$mcD$sp();
                    int n = tuple2._2$mcI$sp();
                    Tuple3<HyperLogLogPlusPlus, MutableRow, MutableRow> tuple3 = this.$outer.createEstimator(rsd, this.$outer.createEstimator$default$2());
                    if (tuple3 != null) {
                        double error;
                        Tuple3 tuple32;
                        HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                        MutableRow input = (MutableRow)tuple3._2();
                        MutableRow buffer = (MutableRow)tuple3._3();
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
                        HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                        MutableRow input2 = (MutableRow)tuple33._2();
                        MutableRow buffer2 = (MutableRow)tuple33._3();
                        for (int i = 0; i < n; ++i) {
                            input2.setInt(0, this.f$1.apply$mcII$sp(i));
                            hll2.update(buffer2, (InternalRow)input2);
                        }
                        double estimate = BoxesRunTime.unboxToLong((Object)hll2.eval((InternalRow)buffer2));
                        int cardinality = this.c$1.apply$mcII$sp(n);
                        double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
                        double $org_scalatest_assert_macro_right = hll2.trueRsd() * 3.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
                this.c$1 = c$1;
            }
        });
    }

    public HyperLogLogPlusPlusSuite() {
        this.test("add nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<HyperLogLogPlusPlus, MutableRow, MutableRow> tuple3 = this.$outer.createEstimator(0.05, this.$outer.createEstimator$default$2());
                if (tuple3 != null) {
                    long estimate;
                    Tuple3 tuple32;
                    HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                    MutableRow input = (MutableRow)tuple3._2();
                    MutableRow buffer = (MutableRow)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
                    HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                    MutableRow input2 = (MutableRow)tuple33._2();
                    MutableRow buffer2 = (MutableRow)tuple33._3();
                    input2.setNullAt(0);
                    hll2.update(buffer2, (InternalRow)input2);
                    hll2.update(buffer2, (InternalRow)input2);
                    long $org_scalatest_assert_macro_left = estimate = BoxesRunTime.unboxToLong((Object)hll2.eval((InternalRow)buffer2));
                    long $org_scalatest_assert_macro_right = 0L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Nothing meaningful added; estimate should be 0.");
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("deterministic cardinality estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int repeats = 10;
                this.$outer.testCardinalityEstimates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.05, 0.025, 0.01}))), (Seq<Object>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000}))).map((Function1)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int x$4) {
                        return this.apply$mcII$sp(x$4);
                    }

                    public int apply$mcII$sp(int x$4) {
                        return x$4 * this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Function1<Object, Object>)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return i / this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                }, (Function1<Object, Object>)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return i / this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("random cardinality estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random srng = new Random(323981238L);
                HashSet seen = HashSet$.MODULE$.empty();
                Serializable update = new Serializable(this, srng, seen){
                    public static final long serialVersionUID = 0L;
                    private final Random srng$1;
                    private final HashSet seen$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply$mcII$sp(int i) {
                        void var2_2;
                        int value = this.srng$1.nextInt();
                        this.seen$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
                        return (int)var2_2;
                    }
                    {
                        this.srng$1 = srng$1;
                        this.seen$1 = seen$1;
                    }
                };
                Serializable eval = new Serializable(this, seen){
                    public static final long serialVersionUID = 0L;
                    private final HashSet seen$1;

                    public final int apply(int n) {
                        return this.apply$mcII$sp(n);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply$mcII$sp(int n) {
                        void var2_2;
                        int cardinality = this.seen$1.size();
                        this.seen$1.clear();
                        return (int)var2_2;
                    }
                    {
                        this.seen$1 = seen$1;
                    }
                };
                this.$outer.testCardinalityEstimates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.05, 0.01}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 10000, 500000}))), (Function1<Object, Object>)update, (Function1<Object, Object>)eval);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("merging HLL instances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<HyperLogLogPlusPlus, MutableRow, MutableRow> tuple3 = this.$outer.createEstimator(0.05, this.$outer.createEstimator$default$2());
                if (tuple3 != null) {
                    int i;
                    Tuple3 tuple32;
                    HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                    MutableRow input = (MutableRow)tuple3._2();
                    MutableRow buffer1a = (MutableRow)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer1a);
                    HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                    MutableRow input2 = (MutableRow)tuple33._2();
                    MutableRow buffer1a2 = (MutableRow)tuple33._3();
                    MutableRow buffer1b = this.$outer.createBuffer(hll2);
                    MutableRow buffer2 = this.$outer.createBuffer(hll2);
                    for (i = 0; i < 500000; ++i) {
                        input2.setInt(0, i);
                        hll2.update(buffer1a2, (InternalRow)input2);
                    }
                    for (i = 500000; i < 1000000; ++i) {
                        input2.setInt(0, i);
                        hll2.update(buffer1b, (InternalRow)input2);
                    }
                    hll2.merge(buffer1a2, (InternalRow)buffer1b);
                    for (i = 999999; i >= 0; --i) {
                        input2.setInt(0, i);
                        hll2.update(buffer2, (InternalRow)input2);
                    }
                    MutableRow $org_scalatest_assert_macro_left = buffer2;
                    MutableRow $org_scalatest_assert_macro_right = buffer1a2;
                    MutableRow mutableRow = $org_scalatest_assert_macro_left;
                    MutableRow mutableRow2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(mutableRow != null ? !mutableRow.equals(mutableRow2) : mutableRow2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Buffers should be equal");
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

