/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2Q!\u0001\u0002\u0002\u0002=\u00111$\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3QCJ\u001cXM]*vSR,'BA\u0002\u0005\u0003\u0019\u0001\u0018M]:fe*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002A\"\u0001\u001c\u0003\u0015\u0001\u0018M]:f)\ta\"\u0005\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u0005)A/\u001f9fg&\u0011\u0011E\b\u0002\t\t\u0006$\u0018\rV=qK\")q!\u0007a\u0001GA\u0011AE\u000b\b\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011FJ\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*M!)a\u0006\u0001C\u0001_\u0005i1\r[3dW\u0012\u000bG/\u0019+za\u0016$2\u0001M\u001a6!\t)\u0013'\u0003\u00023M\t!QK\\5u\u0011\u0015!T\u00061\u0001$\u00039!\u0017\r^1UsB,7\u000b\u001e:j]\u001eDQAN\u0017A\u0002q\t\u0001#\u001a=qK\u000e$X\r\u001a#bi\u0006$\u0016\u0010]3\t\u000ba\u0002a\u0011A\u001d\u0002\u0013%tG/\u001a:dKB$HC\u0001\u0019;\u0011\u00159q\u00071\u0001$\u0011\u0015a\u0004\u0001\"\u0001>\u0003-)hn];qa>\u0014H/\u001a3\u0015\u0005Ar\u0004\"\u0002\u001b<\u0001\u0004\u0019\u0003")
public abstract class AbstractDataTypeParserSuite
extends SparkFunSuite {
    public abstract DataType parse(String var1);

    public void checkDataType(String dataTypeString, DataType expectedDataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString.replace("\n", "")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString, expectedDataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractDataTypeParserSuite $outer;
            private final String dataTypeString$1;
            private final DataType expectedDataType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.parse(this.dataTypeString$1));
                DataType $org_scalatest_assert_macro_right = this.expectedDataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataTypeString$1 = dataTypeString$1;
                this.expectedDataType$1 = expectedDataType$1;
            }
        });
    }

    public abstract void intercept(String var1);

    public void unsupported(String dataTypeString) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractDataTypeParserSuite $outer;
            private final String dataTypeString$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept(this.dataTypeString$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataTypeString$2 = dataTypeString$2;
            }
        });
    }

    public AbstractDataTypeParserSuite() {
        this.checkDataType("int", (DataType)IntegerType$.MODULE$);
        this.checkDataType("integer", (DataType)IntegerType$.MODULE$);
        this.checkDataType("BooLean", (DataType)BooleanType$.MODULE$);
        this.checkDataType("tinYint", (DataType)ByteType$.MODULE$);
        this.checkDataType("smallINT", (DataType)ShortType$.MODULE$);
        this.checkDataType("INT", (DataType)IntegerType$.MODULE$);
        this.checkDataType("INTEGER", (DataType)IntegerType$.MODULE$);
        this.checkDataType("bigint", (DataType)LongType$.MODULE$);
        this.checkDataType("float", (DataType)FloatType$.MODULE$);
        this.checkDataType("dOUBle", (DataType)DoubleType$.MODULE$);
        this.checkDataType("decimal(10, 5)", (DataType)new DecimalType(10, 5));
        this.checkDataType("decimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT());
        this.checkDataType("DATE", (DataType)DateType$.MODULE$);
        this.checkDataType("timestamp", (DataType)TimestampType$.MODULE$);
        this.checkDataType("string", (DataType)StringType$.MODULE$);
        this.checkDataType("ChaR(5)", (DataType)StringType$.MODULE$);
        this.checkDataType("varchAr(20)", (DataType)StringType$.MODULE$);
        this.checkDataType("cHaR(27)", (DataType)StringType$.MODULE$);
        this.checkDataType("BINARY", (DataType)BinaryType$.MODULE$);
        this.checkDataType("array<doublE>", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataType("Array<map<int, tinYint>>", (DataType)new ArrayType((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ByteType$.MODULE$, true), true));
        StructField structField = new StructField("tinYint", (DataType)ByteType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("array<struct<tinYint:tinyint>>", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), true));
        this.checkDataType("MAP<int, STRING>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataType("MAp<int, ARRAY<double>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), true));
        StructField structField2 = new StructField("varchar", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("MAP<int, struct<varchar:string>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true));
        StructField structField3 = new StructField("intType", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("ts", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3)));
        StructField structField5 = new StructField("int", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<int: int, timestamp:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5)));
        StructField structField7 = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8).$colon$colon((Object)structField7)), true, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)StringType$.MODULE$), true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("arrAy", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("anotherArray", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        this.checkDataType(new StringOps(Predef$.MODULE$.augmentString("\n      |struct<\n      |  struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n      |  MAP:Map<timestamp, varchar(10)>,\n      |  arrAy:Array<double>,\n      |  anotherArray:Array<char(9)>>\n    ")).stripMargin(), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9)));
        StructField structField13 = new StructField("x+y", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("!@#$%^&*()", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField15 = new StructField("1_2.345<>:\"", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<`x+y`:int, `!@#$%^&*()`:string, `1_2.345<>:\"`:varchar(20)>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField15).$colon$colon((Object)structField14).$colon$colon((Object)structField13)));
        this.checkDataType("strUCt<>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        this.unsupported("it is not a data type");
        this.unsupported("struct<x+y: int, 1.1:timestamp>");
        this.unsupported("struct<x: int");
    }
}

