/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.HiveTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UpCast;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class ResolveUpCast$
extends Rule<LogicalPlan> {
    public static final ResolveUpCast$ MODULE$;

    static {
        new ResolveUpCast$();
    }

    public Nothing$ org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(Expression from, DataType to, Seq<String> walkedTypePath) {
        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot up cast ", " from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from.sql()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", " as it may truncate\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from.dataType().simpleString(), to.simpleString()}))).append((Object)"The type path of the target object is:\n").append((Object)walkedTypePath.mkString("", "\n", "\n")).append((Object)"You can either add an explicit cast to the input data or choose a higher precision ").append((Object)"type of the field in the target object").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$illegalNumericPrecedence(DataType from, DataType to) {
        int fromPrecedence = HiveTypeCoercion$.MODULE$.numericPrecedence().indexOf((Object)from);
        int toPrecedence = HiveTypeCoercion$.MODULE$.numericPrecedence().indexOf((Object)to);
        return toPrecedence > 0 && fromPrecedence > toPrecedence;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transformAllExpressions((PartialFunction<Expression, Expression>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x58, Function1<A1, B1> function1) {
                DataType to;
                DataType from;
                Object object;
                boolean bl = false;
                UpCast upCast = null;
                A1 A1 = x58;
                if (A1 instanceof UpCast) {
                    bl = true;
                    upCast = (UpCast)A1;
                    Expression child = upCast.child();
                    if (!child.resolved()) {
                        object = upCast;
                        return (B1)object;
                    }
                }
                if (!bl) {
                    object = function1.apply(x58);
                    return (B1)object;
                }
                Expression child = upCast.child();
                DataType dataType2 = upCast.dataType();
                Seq<String> walkedTypePath = upCast.walkedTypePath();
                Tuple2 tuple2 = new Tuple2((Object)child.dataType(), (Object)dataType2);
                if (tuple2 != null) {
                    DataType from2 = (DataType)tuple2._1();
                    DataType to2 = (DataType)tuple2._2();
                    if (from2 instanceof NumericType) {
                        DecimalType decimalType;
                        NumericType numericType = (NumericType)from2;
                        if (to2 instanceof DecimalType && !(decimalType = (DecimalType)to2).isWiderThan(numericType)) {
                            throw ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(child, decimalType, walkedTypePath);
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType from3 = (DataType)tuple2._1();
                    DataType to3 = (DataType)tuple2._2();
                    if (from3 instanceof DecimalType) {
                        NumericType numericType;
                        DecimalType decimalType = (DecimalType)from3;
                        if (to3 instanceof NumericType && !decimalType.isTighterThan(numericType = (NumericType)to3)) {
                            throw ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(child, numericType, walkedTypePath);
                        }
                    }
                }
                if (tuple2 != null && ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$illegalNumericPrecedence(from = (DataType)tuple2._1(), to = (DataType)tuple2._2())) {
                    throw ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(child, to, walkedTypePath);
                }
                if (tuple2 != null) {
                    DataType dataType3 = (DataType)tuple2._1();
                    DataType dataType4 = (DataType)tuple2._2();
                    if (TimestampType$.MODULE$.equals(dataType3) && DateType$.MODULE$.equals(dataType4)) {
                        throw ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(child, DateType$.MODULE$, walkedTypePath);
                    }
                }
                if (tuple2 != null) {
                    DataType dataType5 = (DataType)tuple2._1();
                    DataType to4 = (DataType)tuple2._2();
                    if (StringType$.MODULE$.equals(dataType5) && to4 instanceof NumericType) {
                        NumericType numericType = (NumericType)to4;
                        throw ResolveUpCast$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveUpCast$$fail(child, numericType, walkedTypePath);
                    }
                }
                Cast cast2 = new Cast(child, dataType2.asNullable());
                object = cast2;
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x58) {
                boolean bl = false;
                UpCast upCast = null;
                Expression expression = x58;
                if (expression instanceof UpCast) {
                    bl = true;
                    upCast = (UpCast)expression;
                    Expression child = upCast.child();
                    if (!child.resolved()) {
                        return true;
                    }
                }
                if (!bl) return false;
                return true;
            }
        });
    }

    private ResolveUpCast$() {
        MODULE$ = this;
    }
}

