/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.File;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.SimpleFunctionRegistry;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001B\u0001\u0003\u0001=\u0011abU3tg&|gnQ1uC2|wM\u0003\u0002\u0004\t\u000591-\u0019;bY><'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\bfqR,'O\\1m\u0007\u0006$\u0018\r\\8h!\tI\"$D\u0001\u0003\u0013\tY\"AA\bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h\u0011!i\u0002A!A!\u0002\u0013q\u0012\u0001\u00054v]\u000e$\u0018n\u001c8SK\u001eL7\u000f\u001e:z!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\u0019\u0003E\u0001\tGk:\u001cG/[8o%\u0016<\u0017n\u001d;ss\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u0003d_:4\u0007CA\u0014)\u001b\u0005!\u0011BA\u0015\u0005\u00051\u0019\u0015\r^1msN$8i\u001c8g\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q!QFL\u00181!\tI\u0002\u0001C\u0003\u0018U\u0001\u0007\u0001\u0004C\u0003\u001eU\u0001\u0007a\u0004C\u0003&U\u0001\u0007a\u0005C\u0003,\u0001\u0011\u0005!\u0007F\u0002.gQBQaF\u0019A\u0002aAQ!H\u0019A\u0002yAQa\u000b\u0001\u0005\u0002Y\"\"!L\u001c\t\u000b])\u0004\u0019\u0001\r\t\u000fe\u0002!\u0019)C\tu\u0005QA/Z7q)\u0006\u0014G.Z:\u0016\u0003m\u0002B\u0001P!D\u00156\tQH\u0003\u0002?\u007f\u00059Q.\u001e;bE2,'B\u0001!\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0005v\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002E\u000f:\u0011\u0011#R\u0005\u0003\rJ\ta\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aI\u0005\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002P\t\u0005)\u0001\u000f\\1og&\u0011\u0011\u000b\u0014\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0003\u0004T\u0001\u0001\u0006IaO\u0001\fi\u0016l\u0007\u000fV1cY\u0016\u001c\b\u0005C\u0004V\u0001\u0001\u0007K\u0011\u0003,\u0002\u0013\r,(O]3oi\u0012\u0013W#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u00027b]\u001eT\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002I3\"9q\f\u0001a!\n#\u0001\u0017!D2veJ,g\u000e\u001e#c?\u0012*\u0017\u000f\u0006\u0002bIB\u0011\u0011CY\u0005\u0003GJ\u0011A!\u00168ji\"9QMXA\u0001\u0002\u00049\u0016a\u0001=%c!1q\r\u0001Q!\n]\u000b!bY;se\u0016tG\u000f\u00122!\u0011\u0019I\u0007\u0001)C\tU\u0006yam\u001c:nCR$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0002DW\")A\u000e\u001ba\u0001\u0007\u0006!a.Y7f\u0011\u0015q\u0007\u0001\"\u0001p\u00039\u0019'/Z1uK\u0012\u000bG/\u00192bg\u0016$2!\u00199v\u0011\u0015\tX\u000e1\u0001s\u00031!'\rR3gS:LG/[8o!\tI2/\u0003\u0002u\u0005\ty1)\u0019;bY><G)\u0019;bE\u0006\u001cX\rC\u0003w[\u0002\u0007q/\u0001\bjO:|'/Z%g\u000bbL7\u000f^:\u0011\u0005EA\u0018BA=\u0013\u0005\u001d\u0011un\u001c7fC:DQa\u001f\u0001\u0005\u0002q\fA\u0002\u001a:pa\u0012\u000bG/\u00192bg\u0016$R!Y?\u0000\u0003\u0007AQA >A\u0002\r\u000b!\u0001\u001a2\t\r\u0005\u0005!\u00101\u0001x\u0003EIwM\\8sK&3gj\u001c;Fq&\u001cHo\u001d\u0005\u0007\u0003\u000bQ\b\u0019A<\u0002\u000f\r\f7oY1eK\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011!D1mi\u0016\u0014H)\u0019;bE\u0006\u001cX\rF\u0002b\u0003\u001bAa!]A\u0004\u0001\u0004\u0011\bbBA\t\u0001\u0011\u0005\u00111C\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\rF\u0002s\u0003+AaA`A\b\u0001\u0004\u0019\u0005bBA\r\u0001\u0011\u0005\u00111D\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\r9\u0018Q\u0004\u0005\u0007}\u0006]\u0001\u0019A\"\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005iA.[:u\t\u0006$\u0018MY1tKN$\"!!\n\u0011\u000b\u0005\u001d\u0012qG\"\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAA\u001b%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u00111aU3r\u0015\r\t)D\u0005\u0005\b\u0003C\u0001A\u0011AA )\u0011\t)#!\u0011\t\u000f\u0005\r\u0013Q\ba\u0001\u0007\u00069\u0001/\u0019;uKJt\u0007bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0013O\u0016$8)\u001e:sK:$H)\u0019;bE\u0006\u001cX-F\u0001D\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001f\n!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0019\u0011-!\u0015\t\ry\fY\u00051\u0001D\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n\u0001cZ3u\t\u00164\u0017-\u001e7u\t\n\u0003\u0016\r\u001e5\u0015\u0007\r\u000bI\u0006\u0003\u0004\u007f\u0003'\u0002\ra\u0011\u0005\b\u0003;\u0002A\u0011AA0\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u000b\u0005\f\t'a\u001b\t\u0011\u0005\r\u00141\fa\u0001\u0003K\nq\u0002^1cY\u0016$UMZ5oSRLwN\u001c\t\u00043\u0005\u001d\u0014bAA5\u0005\ta1)\u0019;bY><G+\u00192mK\"1a/a\u0017A\u0002]Dq!a\u001c\u0001\t\u0003\t\t(\u0001\u0006bYR,'\u000fV1cY\u0016$2!YA:\u0011!\t\u0019'!\u001cA\u0002\u0005\u0015\u0004bBA<\u0001\u0011\u0005\u0011\u0011P\u0001\tO\u0016$H+\u00192mKR!\u0011QMA>\u0011\u001da\u0017Q\u000fa\u0001\u0003{\u00022aJA@\u0013\r\t\t\t\u0002\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015aD2sK\u0006$X\rV3naR\u000b'\r\\3\u0015\u000f\u0005\fI)a#\u0002\u000e\"1A.a!A\u0002\rCq!a\u0019\u0002\u0004\u0002\u0007!\nC\u0004\u0002\u0010\u0006\r\u0005\u0019A<\u0002!=4XM\u001d:jI\u0016Le-\u0012=jgR\u001c\bbBAJ\u0001\u0011\u0005\u0011QS\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0003b\u0003/\u000bY\n\u0003\u0005\u0002\u001a\u0006E\u0005\u0019AA?\u0003\u001dyG\u000e\u001a(b[\u0016D\u0001\"!(\u0002\u0012\u0002\u0007\u0011QP\u0001\b]\u0016<h*Y7f\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000b\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u000b\u0005\f)+a*\t\u000f1\fy\n1\u0001\u0002~!9\u0011\u0011AAP\u0001\u00049\bbBAV\u0001\u0011\u0005\u0011QV\u0001\u000fY>|7.\u001e9SK2\fG/[8o)\u0015Q\u0015qVAY\u0011\u001da\u0017\u0011\u0016a\u0001\u0003{B!\"a-\u0002*B\u0005\t\u0019AA[\u0003\u0015\tG.[1t!\u0011\t\u0012qW\"\n\u0007\u0005e&C\u0001\u0004PaRLwN\u001c\u0005\b\u0003{\u0003A\u0011AA`\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\u0007]\f\t\rC\u0004m\u0003w\u0003\r!! \t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006QA.[:u)\u0006\u0014G.Z:\u0015\t\u0005%\u00171\u001a\t\u0007\u0003O\t9$! \t\ry\f\u0019\r1\u0001D\u0011\u001d\t)\r\u0001C\u0001\u0003\u001f$b!!3\u0002R\u0006M\u0007B\u0002@\u0002N\u0002\u00071\tC\u0004\u0002D\u00055\u0007\u0019A\"\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\u0006a!/\u001a4sKNDG+\u00192mKR\u0019\u0011-a7\t\u000f1\f)\u000e1\u0001\u0002~!9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\u0018aD2mK\u0006\u0014H+Z7q)\u0006\u0014G.Z:\u0015\u0003\u0005D\u0001\"!:\u0001\t\u0003\u0011\u0011q]\u0001\rO\u0016$H+Z7q)\u0006\u0014G.\u001a\u000b\u0005\u0003S\fY\u000f\u0005\u0003\u0012\u0003oS\u0005B\u00027\u0002d\u0002\u00071\tC\u0004\u0002p\u0002!\t!!=\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cHcB1\u0002t\u0006](1\u0001\u0005\t\u0003k\fi\u000f1\u0001\u0002~\u0005IA/\u00192mK:\u000bW.\u001a\u0005\t\u0003s\fi\u000f1\u0001\u0002|\u0006)\u0001/\u0019:ugB1\u0011qEA\u001c\u0003{\u00042!GA\u0000\u0013\r\u0011\tA\u0001\u0002\u0016\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a)beRLG/[8o\u0011\u00191\u0018Q\u001ea\u0001o\"9!q\u0001\u0001\u0005\u0002\t%\u0011A\u00043s_B\u0004\u0016M\u001d;ji&|gn\u001d\u000b\bC\n-!Q\u0002B\u0010\u0011!\t)P!\u0002A\u0002\u0005u\u0004\u0002CA}\u0005\u000b\u0001\rAa\u0004\u0011\r\u0005\u001d\u0012q\u0007B\t!\u0011\u0011\u0019B!\u0007\u000f\u0007e\u0011)\"C\u0002\u0003\u0018\t\tq\"\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ\u0005\u0005\u00057\u0011iB\u0001\nUC\ndW\rU1si&$\u0018n\u001c8Ta\u0016\u001c'b\u0001B\f\u0005!9\u0011\u0011\u0001B\u0003\u0001\u00049\bb\u0002B\u0012\u0001\u0011\u0005!QE\u0001\u0011e\u0016t\u0017-\\3QCJ$\u0018\u000e^5p]N$r!\u0019B\u0014\u0005S\u0011i\u0003\u0003\u0005\u0002v\n\u0005\u0002\u0019AA?\u0011!\u0011YC!\tA\u0002\t=\u0011!B:qK\u000e\u001c\b\u0002\u0003B\u0018\u0005C\u0001\rAa\u0004\u0002\u00119,wo\u00159fGNDqAa\r\u0001\t\u0003\u0011)$A\bbYR,'\u000fU1si&$\u0018n\u001c8t)\u0015\t'q\u0007B\u001d\u0011!\t)P!\rA\u0002\u0005u\u0004\u0002CA}\u0005c\u0001\r!a?\t\u000f\tu\u0002\u0001\"\u0001\u0003@\u0005aq-\u001a;QCJ$\u0018\u000e^5p]R1\u0011Q B!\u0005\u0007B\u0001\"!>\u0003<\u0001\u0007\u0011Q\u0010\u0005\t\u0005\u000b\u0012Y\u00041\u0001\u0003\u0012\u0005!1\u000f]3d\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017\na\u0002\\5tiB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002|\n5\u0003\u0002CA{\u0005\u000f\u0002\r!! \t\u000f\tE\u0003\u0001\"\u0001\u0003T\u0005q1M]3bi\u00164UO\\2uS>tGcA1\u0003V!A!q\u000bB(\u0001\u0004\u0011I&\u0001\bgk:\u001cG)\u001a4j]&$\u0018n\u001c8\u0011\u0007e\u0011Y&C\u0002\u0003^\t\u0011qbQ1uC2|wMR;oGRLwN\u001c\u0005\b\u0005C\u0002A\u0011\u0001B2\u00031!'o\u001c9Gk:\u001cG/[8o)\r\t'Q\r\u0005\bY\n}\u0003\u0019\u0001B4!\r9#\u0011N\u0005\u0004\u0005W\"!A\u0005$v]\u000e$\u0018n\u001c8JI\u0016tG/\u001b4jKJDqAa\u001c\u0001\t\u0003\u0011\t(A\u0007bYR,'OR;oGRLwN\u001c\u000b\u0004C\nM\u0004\u0002\u0003B,\u0005[\u0002\rA!\u0017\t\u000f\t]\u0004\u0001\"\u0001\u0003z\u0005Yq-\u001a;Gk:\u001cG/[8o)\u0011\u0011IFa\u001f\t\u000f1\u0014)\b1\u0001\u0003h!9!q\u0010\u0001\u0005\u0002\t\u0005\u0015AE2sK\u0006$X\rV3na\u001a+hn\u0019;j_:$r!\u0019BB\u0005\u000b\u0013i\u000b\u0003\u0004m\u0005{\u0002\ra\u0011\u0005\t\u0005/\u0012i\b1\u0001\u0003\bB!!\u0011\u0012BT\u001d\u0011\u0011YIa)\u000f\t\t5%\u0011\u0015\b\u0005\u0005\u001f\u0013yJ\u0004\u0003\u0003\u0012\nue\u0002\u0002BJ\u00057sAA!&\u0003\u001a:!\u00111\u0006BL\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003C\u0011I1A!*!\u0003A1UO\\2uS>t'+Z4jgR\u0014\u00180\u0003\u0003\u0003*\n-&a\u0004$v]\u000e$\u0018n\u001c8Ck&dG-\u001a:\u000b\u0007\t\u0015\u0006\u0005\u0003\u0004w\u0005{\u0002\ra\u001e\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0003A!'o\u001c9UK6\u0004h)\u001e8di&|g\u000eF\u0003b\u0005k\u00139\f\u0003\u0004m\u0005_\u0003\ra\u0011\u0005\b\u0003\u0003\u0011y\u000b1\u0001x\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{\u000baB]3oC6,g)\u001e8di&|g\u000eF\u0003b\u0005\u007f\u0013\t\r\u0003\u0005\u0002\u001a\ne\u0006\u0019\u0001B4\u0011!\tiJ!/A\u0002\t\u001d\u0004b\u0002Bc\u0001\u0011\u0005!qY\u0001\u000fY>|7.\u001e9Gk:\u001cG/[8o)\u0019\u0011IM!6\u0003XB!!1\u001aBi\u001b\t\u0011iMC\u0002\u0003P\u0012\t1\"\u001a=qe\u0016\u001c8/[8og&!!1\u001bBg\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007Y\n\r\u0007\u0019A\"\t\u0011\te'1\u0019a\u0001\u00057\f\u0001b\u00195jY\u0012\u0014XM\u001c\t\u0007\u0003O\t9D!3\t\u000f\t}\u0007\u0001\"\u0001\u0003b\u0006iA.[:u\rVt7\r^5p]N$bAa9\u0003f\n\u001d\bCBA\u0014\u0003o\u00119\u0007\u0003\u0004\u007f\u0005;\u0004\ra\u0011\u0005\b\u0003\u0007\u0012i\u000e1\u0001D\u0011!\u0011Y\u000f\u0001C\u0001\u0005\t5\u0018aD4fiR+W\u000e\u001d$v]\u000e$\u0018n\u001c8\u0015\t\t=(\u0011\u001f\t\u0006#\u0005]&q\u0011\u0005\u0007Y\n%\b\u0019A\"\t\u0013\tU\b!%A\u0005\u0002\t]\u0018\u0001\u00077p_.,\bOU3mCRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011 \u0016\u0005\u0003k\u0013Yp\u000b\u0002\u0003~B!!q`B\u0005\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011!C;oG\",7m[3e\u0015\r\u00199AE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0006\u0007\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SessionCatalog {
    private final ExternalCatalog externalCatalog;
    private final FunctionRegistry functionRegistry;
    private final CatalystConf conf;
    private final HashMap<String, LogicalPlan> tempTables;
    private String currentDb;

    public HashMap<String, LogicalPlan> tempTables() {
        return this.tempTables;
    }

    public String currentDb() {
        return this.currentDb;
    }

    public void currentDb_$eq(String x$1) {
        this.currentDb = x$1;
    }

    public String formatTableName(String name2) {
        return this.conf.caseSensitiveAnalysis() ? name2 : name2.toLowerCase();
    }

    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        this.externalCatalog.createDatabase(dbDefinition, ignoreIfExists);
    }

    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        this.externalCatalog.dropDatabase(db, ignoreIfNotExists, cascade);
    }

    public void alterDatabase(CatalogDatabase dbDefinition) {
        this.externalCatalog.alterDatabase(dbDefinition);
    }

    public CatalogDatabase getDatabase(String db) {
        return this.externalCatalog.getDatabase(db);
    }

    public boolean databaseExists(String db) {
        return this.externalCatalog.databaseExists(db);
    }

    public Seq<String> listDatabases() {
        return this.externalCatalog.listDatabases();
    }

    public Seq<String> listDatabases(String pattern) {
        return this.externalCatalog.listDatabases(pattern);
    }

    public String getCurrentDatabase() {
        return this.currentDb();
    }

    public void setCurrentDatabase(String db) {
        if (this.databaseExists(db)) {
            this.currentDb_$eq(db);
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot set current database to non-existent '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public String getDefaultDBPath(String db) {
        return new StringBuilder().append((Object)System.getProperty("java.io.tmpdir")).append((Object)File.separator).append((Object)db).append((Object)".db").toString();
    }

    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = (String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableDefinition.identifier().table());
        CatalogTable newTableDefinition = tableDefinition.copy(new TableIdentifier(table, (Option<String>)new Some((Object)db)), tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12());
        this.externalCatalog.createTable(db, newTableDefinition, ignoreIfExists);
    }

    public void alterTable(CatalogTable tableDefinition) {
        String db = (String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableDefinition.identifier().table());
        CatalogTable newTableDefinition = tableDefinition.copy(new TableIdentifier(table, (Option<String>)new Some((Object)db)), tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12());
        this.externalCatalog.alterTable(db, newTableDefinition);
    }

    public CatalogTable getTable(TableIdentifier name2) {
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(name2.table());
        return this.externalCatalog.getTable(db, table);
    }

    public void createTempTable(String name2, LogicalPlan tableDefinition, boolean overrideIfExists) {
        String table = this.formatTableName(name2);
        if (this.tempTables().contains((Object)table) && !overrideIfExists) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary table '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        this.tempTables().put((Object)table, (Object)tableDefinition);
    }

    public void renameTable(TableIdentifier oldName, TableIdentifier newName) {
        Option<String> option = oldName.database();
        Option<String> option2 = newName.database();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            String db = (String)oldName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String oldTableName = this.formatTableName(oldName.table());
            String newTableName = this.formatTableName(newName.table());
            if (!oldName.database().isDefined() && this.tempTables().contains((Object)oldTableName)) {
                LogicalPlan table = (LogicalPlan)this.tempTables().apply((Object)oldTableName);
                this.tempTables().remove((Object)oldTableName);
                this.tempTables().put((Object)newTableName, (Object)table);
            } else {
                this.externalCatalog.renameTable(db, oldTableName, newTableName);
            }
            return;
        }
        throw new AnalysisException("rename does not support moving tables across databases", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public void dropTable(TableIdentifier name2, boolean ignoreIfNotExists) {
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(name2.table());
        if (!name2.database().isDefined() && this.tempTables().contains((Object)table)) {
            this.tempTables().remove((Object)table);
        } else {
            this.externalCatalog.dropTable(db, table, ignoreIfNotExists);
        }
    }

    public LogicalPlan lookupRelation(TableIdentifier name2, Option<String> alias) {
        LogicalPlan logicalPlan;
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(name2.table());
        if (!name2.database().isDefined() && this.tempTables().contains((Object)table)) {
            logicalPlan = (LogicalPlan)this.tempTables().apply((Object)table);
        } else {
            CatalogTable metadata2 = this.externalCatalog.getTable(db, table);
            logicalPlan = new CatalogRelation(db, metadata2, alias);
        }
        LogicalPlan relation = logicalPlan;
        SubqueryAlias qualifiedTable = new SubqueryAlias(table, relation);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply(String a) {
                return new SubqueryAlias(a, this.qualifiedTable$1);
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        }).getOrElse((Function0)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply() {
                return this.qualifiedTable$1;
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        });
    }

    public Option<String> lookupRelation$default$2() {
        return None$.MODULE$;
    }

    public boolean tableExists(TableIdentifier name2) {
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(name2.table());
        return !name2.database().isDefined() && this.tempTables().contains((Object)table) ? true : this.externalCatalog.tableExists(db, table);
    }

    public Seq<TableIdentifier> listTables(String db) {
        return this.listTables(db, "*");
    }

    public Seq<TableIdentifier> listTables(String db, String pattern) {
        Seq dbTables = (Seq)this.externalCatalog.listTables(db, pattern).map((Function1)new Serializable(this, db){
            public static final long serialVersionUID = 0L;
            private final String db$1;

            public final TableIdentifier apply(String t) {
                return new TableIdentifier(t, (Option<String>)new Some((Object)this.db$1));
            }
            {
                this.db$1 = db$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Regex regex = new StringOps(Predef$.MODULE$.augmentString(pattern.replaceAll("\\*", ".*"))).r();
        Seq _tempTables = (Seq)((TraversableLike)this.tempTables().keys().toSeq().filter((Function1)new Serializable(this, regex){
            public static final long serialVersionUID = 0L;
            private final Regex regex$1;

            public final boolean apply(String t) {
                return this.regex$1.pattern().matcher(t).matches();
            }
            {
                this.regex$1 = regex$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TableIdentifier apply(String t) {
                return TableIdentifier$.MODULE$.apply(t);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)dbTables.$plus$plus((GenTraversableOnce)_tempTables, Seq$.MODULE$.canBuildFrom());
    }

    public void refreshTable(TableIdentifier name2) {
    }

    public void clearTempTables() {
        this.tempTables().clear();
    }

    public Option<LogicalPlan> getTempTable(String name2) {
        return this.tempTables().get((Object)name2);
    }

    public void createPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        this.externalCatalog.createPartitions(db, table, parts, ignoreIfExists);
    }

    public void dropPartitions(TableIdentifier tableName, Seq<Map<String, String>> parts, boolean ignoreIfNotExists) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        this.externalCatalog.dropPartitions(db, table, parts, ignoreIfNotExists);
    }

    public void renamePartitions(TableIdentifier tableName, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        this.externalCatalog.renamePartitions(db, table, specs, newSpecs);
    }

    public void alterPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        this.externalCatalog.alterPartitions(db, table, parts);
    }

    public CatalogTablePartition getPartition(TableIdentifier tableName, Map<String, String> spec) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        return this.externalCatalog.getPartition(db, table, spec);
    }

    public Seq<CatalogTablePartition> listPartitions(TableIdentifier tableName) {
        String db = (String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = this.formatTableName(tableName.table());
        return this.externalCatalog.listPartitions(db, table);
    }

    public void createFunction(CatalogFunction funcDefinition) {
        String db = (String)funcDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CatalogFunction newFuncDefinition = funcDefinition.copy(new FunctionIdentifier(funcDefinition.identifier().funcName(), (Option<String>)new Some((Object)db)), funcDefinition.copy$default$2());
        this.externalCatalog.createFunction(db, newFuncDefinition);
    }

    public void dropFunction(FunctionIdentifier name2) {
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.externalCatalog.dropFunction(db, name2.funcName());
    }

    public void alterFunction(CatalogFunction funcDefinition) {
        String db = (String)funcDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CatalogFunction newFuncDefinition = funcDefinition.copy(new FunctionIdentifier(funcDefinition.identifier().funcName(), (Option<String>)new Some((Object)db)), funcDefinition.copy$default$2());
        this.externalCatalog.alterFunction(db, newFuncDefinition);
    }

    public CatalogFunction getFunction(FunctionIdentifier name2) {
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.externalCatalog.getFunction(db, name2.funcName());
    }

    public void createTempFunction(String name2, Function1<Seq<Expression>, Expression> funcDefinition, boolean ignoreIfExists) {
        if (this.functionRegistry.lookupFunctionBuilder(name2).isDefined() && !ignoreIfExists) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary function '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        this.functionRegistry.registerFunction(name2, funcDefinition);
    }

    public void dropTempFunction(String name2, boolean ignoreIfNotExists) {
        if (this.functionRegistry.dropFunction(name2) || ignoreIfNotExists) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary function '", "' cannot be dropped because it does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public void renameFunction(FunctionIdentifier oldName, FunctionIdentifier newName) {
        Option<String> option = oldName.database();
        Option<String> option2 = newName.database();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            String db = (String)oldName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Option<Function1<Seq<Expression>, Expression>> oldBuilder = this.functionRegistry.lookupFunctionBuilder(oldName.funcName());
            if (oldName.database().isDefined() || oldBuilder.isEmpty()) {
                this.externalCatalog.renameFunction(db, oldName.funcName(), newName.funcName());
            } else {
                ExpressionInfo oldExpressionInfo = (ExpressionInfo)this.functionRegistry.lookupFunction(oldName.funcName()).get();
                ExpressionInfo newExpressionInfo = new ExpressionInfo(oldExpressionInfo.getClassName(), newName.funcName(), oldExpressionInfo.getUsage(), oldExpressionInfo.getExtended());
                this.functionRegistry.dropFunction(oldName.funcName());
                this.functionRegistry.registerFunction(newName.funcName(), newExpressionInfo, (Function1<Seq<Expression>, Expression>)((Function1)oldBuilder.get()));
            }
            return;
        }
        throw new AnalysisException("rename does not support moving functions across databases", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public Expression lookupFunction(String name2, Seq<Expression> children2) {
        return this.functionRegistry.lookupFunction(name2, children2);
    }

    public Seq<FunctionIdentifier> listFunctions(String db, String pattern) {
        Seq dbFunctions = (Seq)this.externalCatalog.listFunctions(db, pattern).map((Function1)new Serializable(this, db){
            public static final long serialVersionUID = 0L;
            private final String db$2;

            public final FunctionIdentifier apply(String f) {
                return new FunctionIdentifier(f, (Option<String>)new Some((Object)this.db$2));
            }
            {
                this.db$2 = db$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Regex regex = new StringOps(Predef$.MODULE$.augmentString(pattern.replaceAll("\\*", ".*"))).r();
        Seq _tempFunctions = (Seq)((TraversableLike)this.functionRegistry.listFunction().filter((Function1)new Serializable(this, regex){
            public static final long serialVersionUID = 0L;
            private final Regex regex$2;

            public final boolean apply(String f) {
                return this.regex$2.pattern().matcher(f).matches();
            }
            {
                this.regex$2 = regex$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FunctionIdentifier apply(String f) {
                return FunctionIdentifier$.MODULE$.apply(f);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)dbFunctions.$plus$plus((GenTraversableOnce)_tempFunctions, Seq$.MODULE$.canBuildFrom());
    }

    public Option<Function1<Seq<Expression>, Expression>> getTempFunction(String name2) {
        return this.functionRegistry.lookupFunctionBuilder(name2);
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionRegistry functionRegistry, CatalystConf conf) {
        this.externalCatalog = externalCatalog;
        this.functionRegistry = functionRegistry;
        this.conf = conf;
        this.tempTables = new HashMap();
        String defaultName = "default";
        CatalogDatabase defaultDbDefinition = new CatalogDatabase(defaultName, "default database", "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.createDatabase(defaultDbDefinition, true);
        this.currentDb = defaultName;
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionRegistry functionRegistry) {
        this(externalCatalog, functionRegistry, new SimpleCatalystConf(true, SimpleCatalystConf$.MODULE$.$lessinit$greater$default$2(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$3()));
    }

    public SessionCatalog(ExternalCatalog externalCatalog) {
        this(externalCatalog, new SimpleFunctionRegistry());
    }
}

