/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.unsafe.Platform;

public class BufferHolder {
    public byte[] buffer;
    public int cursor = Platform.BYTE_ARRAY_OFFSET;
    private final UnsafeRow row;
    private final int fixedSize;

    public BufferHolder(UnsafeRow row) {
        this(row, 64);
    }

    public BufferHolder(UnsafeRow row, int initialSize) {
        this.fixedSize = UnsafeRow.calculateBitSetWidthInBytes(row.numFields()) + 8 * row.numFields();
        this.buffer = new byte[this.fixedSize + initialSize];
        this.row = row;
        this.row.pointTo(this.buffer, this.buffer.length);
    }

    public void grow(int neededSize) {
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            byte[] tmp = new byte[length * 2];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
            this.row.pointTo(this.buffer, this.buffer.length);
        }
    }

    public void reset() {
        this.cursor = Platform.BYTE_ARRAY_OFFSET + this.fixedSize;
    }

    public int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }
}

