/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.nio.charset.StandardCharsets;

public final class ParseUtils {
    private static final int[] multiplier = new int[]{1000, 100, 10, 1};

    private ParseUtils() {
    }

    public static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < b.length() && b.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(b.charAt(j + base), 16);
                    code += digit * multiplier[j];
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr, StandardCharsets.UTF_8);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }
}

