/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.BaseGenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class BaseGenericInternalRow$class {
    private static Object getAs(BaseGenericInternalRow $this, int ordinal) {
        return $this.genericGet(ordinal);
    }

    public static boolean isNullAt(BaseGenericInternalRow $this, int ordinal) {
        return BaseGenericInternalRow$class.getAs($this, ordinal) == null;
    }

    public static Object get(BaseGenericInternalRow $this, int ordinal, DataType dataType2) {
        return BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static boolean getBoolean(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToBoolean((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static byte getByte(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToByte((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static short getShort(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToShort((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static int getInt(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToInt((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static long getLong(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToLong((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static float getFloat(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToFloat((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static double getDouble(BaseGenericInternalRow $this, int ordinal) {
        return BoxesRunTime.unboxToDouble((Object)BaseGenericInternalRow$class.getAs($this, ordinal));
    }

    public static Decimal getDecimal(BaseGenericInternalRow $this, int ordinal, int precision, int scale) {
        return (Decimal)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static UTF8String getUTF8String(BaseGenericInternalRow $this, int ordinal) {
        return (UTF8String)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static byte[] getBinary(BaseGenericInternalRow $this, int ordinal) {
        return (byte[])BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static ArrayData getArray(BaseGenericInternalRow $this, int ordinal) {
        return (ArrayData)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static CalendarInterval getInterval(BaseGenericInternalRow $this, int ordinal) {
        return (CalendarInterval)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static MapData getMap(BaseGenericInternalRow $this, int ordinal) {
        return (MapData)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static InternalRow getStruct(BaseGenericInternalRow $this, int ordinal, int numFields) {
        return (InternalRow)BaseGenericInternalRow$class.getAs($this, ordinal);
    }

    public static String toString(BaseGenericInternalRow $this) {
        String string;
        if (((InternalRow)((Object)$this)).numFields() == 0) {
            string = "[empty row]";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append($this.genericGet(0));
            int len = ((InternalRow)((Object)$this)).numFields();
            for (int i = 1; i < len; ++i) {
                sb.append(",");
                sb.append($this.genericGet(i));
            }
            sb.append("]");
            string = sb.toString();
        }
        return string;
    }

    public static GenericInternalRow copy(BaseGenericInternalRow $this) {
        int len = ((InternalRow)((Object)$this)).numFields();
        Object[] newValues = new Object[len];
        for (int i = 0; i < len; ++i) {
            newValues[i] = InternalRow$.MODULE$.copyValue($this.genericGet(i));
        }
        return new GenericInternalRow(newValues);
    }

    public static boolean equals(BaseGenericInternalRow $this, Object o) {
        if (o instanceof BaseGenericInternalRow) {
            BaseGenericInternalRow other = (BaseGenericInternalRow)o;
            if (other == null) {
                return false;
            }
            int len = ((InternalRow)((Object)$this)).numFields();
            if (len != ((InternalRow)((Object)other)).numFields()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                double d;
                float f;
                BoxedUnit boxedUnit;
                if ($this.isNullAt(i) != other.isNullAt(i)) {
                    return false;
                }
                if ($this.isNullAt(i)) continue;
                Object o1 = $this.genericGet(i);
                Object o2 = other.genericGet(i);
                Object object = o1;
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (o2 instanceof byte[] && Arrays.equals(byArray, (byte[])o2)) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (object instanceof Float && Float.isNaN(f = BoxesRunTime.unboxToFloat((Object)object))) {
                    if (o2 instanceof Float && Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (object instanceof Double && Double.isNaN(d = BoxesRunTime.unboxToDouble((Object)object))) {
                    if (o2 instanceof Double && Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (BoxesRunTime.equals((Object)o1, (Object)o2)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCode(BaseGenericInternalRow $this) {
        void var1_1;
        int result = 37;
        int len = ((InternalRow)((Object)$this)).numFields();
        for (int i = 0; i < len; ++i) {
            int n;
            if ($this.isNullAt(i)) {
                n = 0;
            } else {
                int n2;
                Object object = $this.genericGet(i);
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    n2 = bl ? 0 : 1;
                } else if (object instanceof Byte) {
                    int n3;
                    n2 = n3 = BoxesRunTime.unboxToByte((Object)object);
                } else if (object instanceof Short) {
                    int n4;
                    n2 = n4 = BoxesRunTime.unboxToShort((Object)object);
                } else if (object instanceof Integer) {
                    int n5;
                    n2 = n5 = BoxesRunTime.unboxToInt((Object)object);
                } else if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    n2 = (int)(l ^ l >>> 32);
                } else if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    n2 = Float.floatToIntBits(f);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    long b = Double.doubleToLongBits(d);
                    n2 = (int)(b ^ b >>> 32);
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    n2 = Arrays.hashCode(byArray);
                } else {
                    n2 = object.hashCode();
                }
                n = n2;
            }
            int update2 = n;
            result = 37 * result + update2;
        }
        return (int)var1_1;
    }

    public static void $init$(BaseGenericInternalRow $this) {
    }
}

