/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)\u0011\t\u0001C!\u0005\")\u0011\n\u0001C!\u0015\")!\f\u0001C)7\")\u0011\r\u0001C!E\")\u0001\u000f\u0001C!c\"9!\u0010AA\u0001\n\u0003Y\bbB?\u0001#\u0003%\tA \u0005\n\u0003'\u0001\u0011\u0011!C!\u0003+A\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001c\u0001\u0005\u0005I\u0011IA\u001d\u0011%\t9\u0005AA\u0001\n\u0003\tI\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V\u001dI\u0011QN\r\u0002\u0002#\u0005\u0011q\u000e\u0004\t1e\t\t\u0011#\u0001\u0002r!1QH\u0005C\u0001\u0003\u007fB\u0011\"!!\u0013\u0003\u0003%)%a!\t\u0013\u0005\u0015%#!A\u0005\u0002\u0006\u001d\u0005\"CAF%\u0005\u0005I\u0011QAG\u0011%\tIJEA\u0001\n\u0013\tYJA\u0005CSRdUM\\4uQ*\u0011!dG\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001d;\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001O-rC\u0007\u0005\u0002)S5\t\u0011$\u0003\u0002+3\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002)Y%\u0011Q&\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t9\u0001K]8ek\u000e$\bCA\u00186\u0013\t1\u0004G\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001:!\tA#(\u0003\u0002<3\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011q\b\u0011\t\u0003Q\u0001AQaN\u0002A\u0002e\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\u0011a)H\u0001\u0006if\u0004Xm]\u0005\u0003\u0011\u0016\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A&\u0011\u00071#vK\u0004\u0002N%:\u0011a*U\u0007\u0002\u001f*\u0011\u0001+J\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!a\u0015\u0019\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u0004'\u0016\f(BA*1!\t!\u0005,\u0003\u0002Z\u000b\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00039~\u0003\"aL/\n\u0005y\u0003$aA!os\")\u0001M\u0002a\u00019\u0006)a/\u00197vK\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004G&t\u0007C\u00013h\u001b\u0005)'B\u00014\u001a\u0003\u001d\u0019w\u000eZ3hK:L!\u0001[3\u0003\u0011\u0015C\bO]\"pI\u0016DQA[\u0004A\u0002-\f1a\u0019;y!\t!G.\u0003\u0002nK\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B8\b\u0001\u0004\u0019\u0017AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002eB\u00111o\u001e\b\u0003iV\u0004\"A\u0014\u0019\n\u0005Y\u0004\u0014A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A\u001e\u0019\u0002\t\r|\u0007/\u001f\u000b\u0003\u007fqDqaN\u0005\u0011\u0002\u0003\u0007\u0011(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003}T3!OA\u0001W\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0007a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0011q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001\u00027b]\u001eT!!!\t\u0002\t)\fg/Y\u0005\u0004q\u0006m\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0015!\ry\u00131F\u0005\u0004\u0003[\u0001$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001/\u00024!I\u0011QG\u0007\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0002#BA\u001f\u0003\u0007bVBAA \u0015\r\t\t\u0005M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA#\u0003\u007f\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111JA)!\ry\u0013QJ\u0005\u0004\u0003\u001f\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003ky\u0011\u0011!a\u00019\u00061Q-];bYN$B!a\u0013\u0002X!A\u0011Q\u0007\t\u0002\u0002\u0003\u0007A\fK\u0006\u0001\u00037\n\t'a\u0019\u0002h\u0005%\u0004c\u0001\u0015\u0002^%\u0019\u0011qL\r\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QM\u0001W?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011cSR\u0004C.\u001a8hi\"\u0004sN\u001a\u0011tiJLgn\u001a\u0011eCR\f\u0007e\u001c:!]Vl'-\u001a:!_\u001a\u0004#-\u001b;tA=4\u0007EY5oCJL\b\u0005Z1uC:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003W\nqH\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00118e)\u0001\u0003%A\u0005CSRdUM\\4uQB\u0011\u0001FE\n\u0005%\u0005MD\u0007\u0005\u0004\u0002v\u0005m\u0014hP\u0007\u0003\u0003oR1!!\u001f1\u0003\u001d\u0011XO\u001c;j[\u0016LA!! \u0002x\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005=\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0011!B1qa2LHcA \u0002\n\")q'\u0006a\u0001s\u00059QO\\1qa2LH\u0003BAH\u0003+\u0003BaLAIs%\u0019\u00111\u0013\u0019\u0003\r=\u0003H/[8o\u0011!\t9JFA\u0001\u0002\u0004y\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\n\u0005\u0003\u0002\u001a\u0005}\u0015\u0002BAQ\u00037\u0011aa\u00142kK\u000e$\b")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength bitLength) {
        return BitLength$.MODULE$.unapply(bitLength);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> function1) {
        return BitLength$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitLength> compose(Function1<A, Expression> function1) {
        return BitLength$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$}))}));
    }

    @Override
    public Object nullSafeEval(Object value) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(17).append("(").append((String)c).append(").numBytes() * 8").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").length * 8").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

