/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IsNull$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is null, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       false\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\f\u0019\u0001\u0016B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!)A\b\u0001C\u0001{!)\u0001\t\u0001C!\u0003\")Q\t\u0001C!\r\")\u0001\u000b\u0001C!#\")Q\u0004\u0001C!?\"91\u000eAA\u0001\n\u0003a\u0007b\u00028\u0001#\u0003%\ta\u001c\u0005\bu\u0002\t\t\u0011\"\u0011|\u0011%\t9\u0001AA\u0001\n\u0003\tI\u0001C\u0005\u0002\u0012\u0001\t\t\u0011\"\u0001\u0002\u0014!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00131\u0004\u0005\n\u0003S\u0001\u0011\u0011!C\u0001\u0003WA\u0011\"a\f\u0001\u0003\u0003%\t%!\r\b\u0013\u0005%\u0003$!A\t\u0002\u0005-c\u0001C\f\u0019\u0003\u0003E\t!!\u0014\t\rq\nB\u0011AA.\u0011%\ti&EA\u0001\n\u000b\ny\u0006C\u0005\u0002bE\t\t\u0011\"!\u0002d!I\u0011qM\t\u0002\u0002\u0013\u0005\u0015\u0011\u000e\u0005\n\u0003k\n\u0012\u0011!C\u0005\u0003o\u0012a!S:Ok2d'BA\r\u001b\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005ma\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u00011#&L\u001a\u0011\u0005\u001dBS\"\u0001\r\n\u0005%B\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u001dZ\u0013B\u0001\u0017\u0019\u0005%\u0001&/\u001a3jG\u0006$X\r\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0004Qe>$Wo\u0019;\u0011\u00059\"\u0014BA\u001b0\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005A\u0004CA\u0014:\u0013\tQ\u0004D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002?\u007fA\u0011q\u0005\u0001\u0005\u0006m\r\u0001\r\u0001O\u0001\t]VdG.\u00192mKV\t!\t\u0005\u0002/\u0007&\u0011Ai\f\u0002\b\u0005>|G.Z1o\u0003\u0011)g/\u00197\u0015\u0005\u001dS\u0005C\u0001\u0018I\u0013\tIuFA\u0002B]fDqaS\u0003\u0011\u0002\u0003\u0007A*A\u0003j]B,H\u000f\u0005\u0002N\u001d6\t!$\u0003\u0002P5\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\rF\u0002S1v\u0003\"a\u0015,\u000e\u0003QS!!\u0016\r\u0002\u000f\r|G-Z4f]&\u0011q\u000b\u0016\u0002\t\u000bb\u0004(oQ8eK\")\u0011L\u0002a\u00015\u0006\u00191\r\u001e=\u0011\u0005M[\u0016B\u0001/U\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA\u0018\u0004A\u0002I\u000b!!\u001a<\u0016\u0003\u0001\u0004\"!\u00195\u000f\u0005\t4\u0007CA20\u001b\u0005!'BA3%\u0003\u0019a$o\\8u}%\u0011qmL\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002h_\u0005!1m\u001c9z)\tqT\u000eC\u00047\u0011A\u0005\t\u0019\u0001\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u00029c.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003o>\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\tIg0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\fA\u0019a&!\u0004\n\u0007\u0005=qFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002H\u0003+A\u0011\"a\u0006\r\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0002E\u0003\u0002 \u0005\u0015r)\u0004\u0002\u0002\")\u0019\u00111E\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0005\u0005\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AQA\u0017\u0011!\t9BDA\u0001\u0002\u00049\u0015AB3rk\u0006d7\u000fF\u0002C\u0003gA\u0001\"a\u0006\u0010\u0003\u0003\u0005\ra\u0012\u0015\f\u0001\u0005]\u0012QHA \u0003\u0007\n)\u0005E\u0002(\u0003sI1!a\u000f\u0019\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0011\u0002\u0005~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007\u0005Y3yaJ\u0004\u0007%[:!]VdG\u000e\f\u0011pe\u00022\u0017\r\\:fA=$\b.\u001a:xSN,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9%\u0001\u001d\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011\u0002\r%\u001bh*\u001e7m!\t9\u0013c\u0005\u0003\u0012\u0003\u001f\u001a\u0004CBA)\u0003/Bd(\u0004\u0002\u0002T)\u0019\u0011QK\u0018\u0002\u000fI,h\u000e^5nK&!\u0011\u0011LA*\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003\u0017\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002y\u0006)\u0011\r\u001d9msR\u0019a(!\u001a\t\u000bY\"\u0002\u0019\u0001\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u00111NA9!\u0011q\u0013Q\u000e\u001d\n\u0007\u0005=tF\u0001\u0004PaRLwN\u001c\u0005\t\u0003g*\u0012\u0011!a\u0001}\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u00022!`A>\u0013\r\tiH \u0002\u0007\u001f\nTWm\u0019;")
public class IsNull
extends UnaryExpression
implements Predicate,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNull isNull) {
        return IsNull$.MODULE$.unapply(isNull);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNull, A> function1) {
        return IsNull$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, IsNull> compose(Function1<A, Expression> function1) {
        return IsNull$.MODULE$.compose(function1);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        return BoxesRunTime.boxToBoolean((this.child().eval(input) == null ? 1 : 0) != 0);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        return new ExprCode(eval.code(), FalseLiteral$.MODULE$, eval.isNull());
    }

    @Override
    public String sql() {
        return new StringBuilder(10).append("(").append(this.child().sql()).append(" IS NULL)").toString();
    }

    public IsNull copy(Expression child) {
        return new IsNull(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNull";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNull)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNull isNull = (IsNull)x$1;
        Expression expression = this.child();
        Expression expression2 = isNull.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNull.canEqual(this)) return false;
        return true;
    }

    public IsNull(Expression child) {
        this.child = child;
        Predicate.$init$(this);
    }
}

