/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the leading string contains the characters from the trim string\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('Sp', 'SSparkSQLS');\n       arkSQLS\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\t)\u000b\u0003\u0005=\u0003\u0005\u0005I\u0011QAU\u0011%\ty+AI\u0001\n\u0003\tY\u0004C\u0005\u00022\u0006\t\t\u0011\"!\u00024\"I\u0011\u0011Y\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\f\u0011\u0011!C\u0005\u0003\u000b4Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011\t5\t\u000bITA\u0011I:\t\u000buTA\u0011\u000b@\t\u0013\u0005e!\"!A\u0005\u0002\u0005m\u0001\"CA\u0011\u0015E\u0005I\u0011AA\u0012\u0011%\tIDCI\u0001\n\u0003\tY\u0004C\u0005\u0002@)\t\t\u0011\"\u0011\u0002B!I\u0011\u0011\u000b\u0006\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037R\u0011\u0011!C\u0001\u0003;B\u0011\"a\u0019\u000b\u0003\u0003%\t%!\u001a\t\u0013\u0005M$\"!A\u0005\u0002\u0005U\u0004\"CA@\u0015\u0005\u0005I\u0011IAA\u00039\u0019FO]5oOR\u0013\u0018.\u001c'fMRT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0005i\u0011\u0001\t\u0002\u000f'R\u0014\u0018N\\4Ue&lG*\u001a4u'\r\t\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005IB\u0014BA\u001d4\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ&A\u0003baBd\u0017\u0010F\u0003?\u0003?\u000b\u0019\u000b\u0005\u0002/\u0015M)!\u0002Q\"GoA\u0011a&Q\u0005\u0003\u0005\u0002\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tqC)\u0003\u0002FA\t)2\u000b\u001e:j]\u001e\u0014DK]5n\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001aH\u0013\tA5GA\u0004Qe>$Wo\u0019;\u0002\rM\u00148m\u0015;s+\u0005\u0001\u0015aB:sGN#(\u000fI\u0001\biJLWn\u0015;s+\u0005q\u0005c\u0001\u001aP\u0001&\u0011\u0001k\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011Q\u0014\u0018.\\*ue\u0002\"2AP*U\u0011\u0015Iu\u00021\u0001A\u0011\u001dau\u0002%AA\u00029#2A\u0010,X\u0011\u0015a\u0005\u00031\u0001A\u0011\u0015I\u0005\u00031\u0001A)\tq\u0014\fC\u0003J#\u0001\u0007\u0001)\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u0018\t\u0003;\u0012t!A\u00182\u0011\u0005}\u001bT\"\u00011\u000b\u0005\u0005d\u0013A\u0002\u001fs_>$h(\u0003\u0002dg\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u00197'\u0001\u0005dQ&dGM]3o+\u0005I\u0007c\u00016p\u0001:\u00111.\u001c\b\u0003?2L\u0011\u0001N\u0005\u0003]N\nq\u0001]1dW\u0006<W-\u0003\u0002qc\n\u00191+Z9\u000b\u00059\u001c\u0014\u0001B3wC2$\"\u0001^<\u0011\u0005I*\u0018B\u0001<4\u0005\r\te.\u001f\u0005\bqR\u0001\n\u00111\u0001z\u0003\u0015Ig\u000e];u!\tQ80D\u0001#\u0013\ta(EA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015y\u00181BA\u000b!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003A\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0005\u0003\u0007\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u001b)\u0002\u0019AA\b\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0003\t\t\"\u0003\u0003\u0002\u0014\u0005\r!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003/)\u0002\u0019A@\u0002\u0005\u00154\u0018\u0001B2paf$RAPA\u000f\u0003?Aq!\u0013\f\u0011\u0002\u0003\u0007\u0001\tC\u0004M-A\u0005\t\u0019\u0001(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0005\u0016\u0004\u0001\u0006\u001d2FAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M2'\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u0002.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\b\u0016\u0004\u001d\u0006\u001d\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0004K\u0006\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\r\u0011\u0014qK\u0005\u0004\u00033\u001a$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001;\u0002`!I\u0011\u0011M\u000e\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004#BA5\u0003_\"XBAA6\u0015\r\tigM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA9\u0003W\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qOA?!\r\u0011\u0014\u0011P\u0005\u0004\u0003w\u001a$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003Cj\u0012\u0011!a\u0001i\u00061Q-];bYN$B!a\u001e\u0002\u0004\"A\u0011\u0011\r\u0010\u0002\u0002\u0003\u0007A\u000fK\b\u000b\u0003\u000f\u000bi)a$\u0002\u0014\u0006U\u0015\u0011TAN!\rq\u0013\u0011R\u0005\u0004\u0003\u0017\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003#\u000b\u0011Q\u000b\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0014\u0018.\\*ue2\u00023\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u001aHO]5oO\u0002\u001awN\u001c;bS:\u001c\b\u0005\u001e5fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004C\u000f[3!iJLW\u000eI:ue&twM\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u0018\u0006\tiB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!(\u0002\u0003\u0017Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B<C\u0006I\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011be.\u001c\u0016\u000bT*\u000bA\u0001Ba!!)\u0004\u0001\u0004\u0001\u0015aA:ue\")Aj\u0001a\u0001\u0001R\u0019a(a*\t\r\u0005\u0005F\u00011\u0001A)\u0015q\u00141VAW\u0011\u0015IU\u00011\u0001A\u0011\u001daU\u0001%AA\u00029\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t),!0\u0011\tIz\u0015q\u0017\t\u0006e\u0005e\u0006IT\u0005\u0004\u0003w\u001b$A\u0002+va2,'\u0007\u0003\u0005\u0002@\u001e\t\t\u00111\u0001?\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u0004B!!\u0012\u0002J&!\u00111ZA$\u0005\u0019y%M[3di\u0002")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringBuilder(88).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimLeft(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

