/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeWriter;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;

public final class UnsafeArrayWriter
extends UnsafeWriter {
    private int numElements;
    private int elementSize;
    private int headerInBytes;

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numElements) : "index (" + index + ") should < " + this.numElements;
    }

    public UnsafeArrayWriter(UnsafeWriter writer, int elementSize) {
        super(writer.getBufferHolder());
        this.elementSize = elementSize;
    }

    public void initialize(int numElements) {
        int i;
        this.numElements = numElements;
        this.headerInBytes = UnsafeArrayData.calculateHeaderPortionInBytes(numElements);
        this.startingOffset = this.cursor();
        int fixedPartInBytes = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)(this.elementSize * numElements));
        this.holder.grow(this.headerInBytes + fixedPartInBytes);
        Platform.putLong((Object)this.getBuffer(), (long)this.startingOffset, (long)numElements);
        for (i = 8; i < this.headerInBytes; i += 8) {
            Platform.putLong((Object)this.getBuffer(), (long)(this.startingOffset + i), (long)0L);
        }
        for (i = this.elementSize * numElements; i < fixedPartInBytes; ++i) {
            Platform.putByte((Object)this.getBuffer(), (long)(this.startingOffset + this.headerInBytes + i), (byte)0);
        }
        this.increaseCursor(this.headerInBytes + fixedPartInBytes);
    }

    private long getElementOffset(int ordinal) {
        return this.startingOffset + this.headerInBytes + ordinal * this.elementSize;
    }

    private void setNullBit(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitSetMethods.set((Object)this.getBuffer(), (long)(this.startingOffset + 8), (int)ordinal);
    }

    @Override
    public void setNull1Bytes(int ordinal) {
        this.setNullBit(ordinal);
        this.writeByte(this.getElementOffset(ordinal), (byte)0);
    }

    @Override
    public void setNull2Bytes(int ordinal) {
        this.setNullBit(ordinal);
        this.writeShort(this.getElementOffset(ordinal), (short)0);
    }

    @Override
    public void setNull4Bytes(int ordinal) {
        this.setNullBit(ordinal);
        this.writeInt(this.getElementOffset(ordinal), 0);
    }

    @Override
    public void setNull8Bytes(int ordinal) {
        this.setNullBit(ordinal);
        this.writeLong(this.getElementOffset(ordinal), 0L);
    }

    public void setNull(int ordinal) {
        this.setNull8Bytes(ordinal);
    }

    @Override
    public void write(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.writeBoolean(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.writeByte(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.writeShort(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.writeInt(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.writeLong(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.writeFloat(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.writeDouble(this.getElementOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, Decimal input, int precision, int scale) {
        this.assertIndexIsValid(ordinal);
        if (input != null && input.changePrecision(precision, scale)) {
            if (precision <= Decimal.MAX_LONG_DIGITS()) {
                this.write(ordinal, input.toUnscaledLong());
            } else {
                byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
                int numBytes = bytes.length;
                assert (numBytes <= 16);
                int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
                this.holder.grow(roundedSize);
                this.zeroOutPaddingBytes(numBytes);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.getBuffer(), (long)this.cursor(), (long)numBytes);
                this.setOffsetAndSize(ordinal, numBytes);
                this.increaseCursor(roundedSize);
            }
        } else {
            this.setNull(ordinal);
        }
    }
}

