/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ", since="1.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!AA\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005>\u0001\tE\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u001dy\u0007!!A\u0005\u0002ADqa\u001d\u0001\u0012\u0002\u0013\u0005A\u000fC\u0004\u0000\u0001E\u0005I\u0011\u0001;\t\u0013\u0005\u0005\u0001!!A\u0005B\u0005\r\u0001\"CA\n\u0001\u0005\u0005I\u0011AA\u000b\u0011%\ti\u0002AA\u0001\n\u0003\ty\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{9\u0011\"!\u0019\u001c\u0003\u0003E\t!a\u0019\u0007\u0011iY\u0012\u0011!E\u0001\u0003KBaA\u0010\u000b\u0005\u0002\u0005M\u0004\"CA;)\u0005\u0005IQIA<\u0011%\tI\bFA\u0001\n\u0003\u000bY\bC\u0005\u0002\u0002R\t\t\u0011\"!\u0002\u0004\"I\u0011Q\u0013\u000b\u0002\u0002\u0013%\u0011q\u0013\u0002\u000e\u000bF,\u0018\r\u001c(vY2\u001c\u0016MZ3\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0015.gA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002/i%\u0011Qg\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u00019!\tQ\u0013(\u0003\u0002;7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005)\u0002\u0001\"\u0002\u001c\u0006\u0001\u0004A\u0004\"\u0002\u001f\u0006\u0001\u0004A\u0014AB:z[\n|G.F\u0001F!\t1UJ\u0004\u0002H\u0017B\u0011\u0001jL\u0007\u0002\u0013*\u0011!jJ\u0001\u0007yI|w\u000e\u001e \n\u00051{\u0013A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\u0018\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u0015\t\u0003]MK!\u0001V\u0018\u0003\u000f\t{w\u000e\\3b]\u0006!QM^1m)\t9&\f\u0005\u0002/1&\u0011\u0011l\f\u0002\u0004\u0003:L\bbB.\t!\u0003\u0005\r\u0001X\u0001\u0006S:\u0004X\u000f\u001e\t\u0003;zk\u0011!H\u0005\u0003?v\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004E\"l\u0007CA2g\u001b\u0005!'BA3\u001c\u0003\u001d\u0019w\u000eZ3hK:L!a\u001a3\u0003\u0011\u0015C\bO]\"pI\u0016DQ![\u0005A\u0002)\f1a\u0019;y!\t\u00197.\u0003\u0002mI\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u00028\n\u0001\u0004\u0011\u0017AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0001\u000b(\u000fC\u00047\u0015A\u0005\t\u0019\u0001\u001d\t\u000fqR\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005a28&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\tax&\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&\u0019a*!\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0001c\u0001\u0018\u0002\u001a%\u0019\u00111D\u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007]\u000b\t\u0003C\u0005\u0002$=\t\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000b\u0011\u000b\u0005-\u0012\u0011G,\u000e\u0005\u00055\"bAA\u0018_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002S\u0003sA\u0001\"a\t\u0012\u0003\u0003\u0005\raV\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\u000by\u0004\u0003\u0005\u0002$I\t\t\u00111\u0001XQM\u0001\u00111IA%\u0003\u0017\ny%!\u0015\u0002V\u0005]\u00131LA/!\rQ\u0013QI\u0005\u0004\u0003\u000fZ\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\n\u0011q\u000b\u0006!A\u0001\u0002S\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\be]1nK\u0002\u0012Xm];mi\u0002\n7\u000f\t;iK\u0002*\u0015+V!MQuJ\u0003e\u001c9fe\u0006$xN\u001d\u0011g_J\u0004cn\u001c8.]VdG\u000eI8qKJ\fg\u000eZ:-\u0015\u0001\u0002\u0003\u0005\t\u0011!EV$\bE]3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011c_RD\u0007%\u0019:fA9,H\u000e\u001c\u0017!M\u0006d7/\u001a\u0011jM\u0002zg.\u001a\u0011pM\u0002\"\b.\u001a\u0011uQ\u0016l\u0007%[:!]VdGN\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003'\n!Q\f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002Jg\u000eI3rk\u0006d\u0017\u000e^=!G>l\u0007/\u0019:jg>tg\u0006I'ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$\bEY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0017\u0002\u0003sR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!iJ,X\rI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006ET+M\u0019\u0002zf)\u0016(D?\u0002rU\u000b\u0014'<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qL\u0001\u0006c9\nd\u0006M\u0001\u000e\u000bF,\u0018\r\u001c(vY2\u001c\u0016MZ3\u0011\u0005)\"2\u0003\u0002\u000b\u0002hM\u0002r!!\u001b\u0002paB\u0004)\u0004\u0002\u0002l)\u0019\u0011QN\u0018\u0002\u000fI,h\u000e^5nK&!\u0011\u0011OA6\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003G\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\tQ!\u00199qYf$R\u0001QA?\u0003\u007fBQAN\fA\u0002aBQ\u0001P\fA\u0002a\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0006\u0006E\u0005#\u0002\u0018\u0002\b\u0006-\u0015bAAE_\t1q\n\u001d;j_:\u0004RALAGqaJ1!a$0\u0005\u0019!V\u000f\u001d7fe!A\u00111\u0013\r\u0002\u0002\u0003\u0007\u0001)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0014\t\u0005\u0003\u000f\tY*\u0003\u0003\u0002\u001e\u0006%!AB(cU\u0016\u001cG\u000f")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

