/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST');\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY');\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query');\n       1\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t%v!B\u001e=\u0011\u0003Ie!B&=\u0011\u0003a\u0005\"\u0002,\u0002\t\u00039\u0006b\u0002-\u0002\u0005\u0004%I!\u0017\u0005\u0007E\u0006\u0001\u000b\u0011\u0002.\t\u000f\r\f!\u0019!C\u00053\"1A-\u0001Q\u0001\niCq!Z\u0001C\u0002\u0013%\u0011\f\u0003\u0004g\u0003\u0001\u0006IA\u0017\u0005\bO\u0006\u0011\r\u0011\"\u0003Z\u0011\u0019A\u0017\u0001)A\u00055\"9\u0011.\u0001b\u0001\n\u0013I\u0006B\u00026\u0002A\u0003%!\fC\u0004l\u0003\t\u0007I\u0011B-\t\r1\f\u0001\u0015!\u0003[\u0011\u001di\u0017A1A\u0005\neCaA\\\u0001!\u0002\u0013Q\u0006bB8\u0002\u0005\u0004%I!\u0017\u0005\u0007a\u0006\u0001\u000b\u0011\u0002.\t\u000fE\f!\u0019!C\u0005e\"110\u0001Q\u0001\nMDq\u0001`\u0001C\u0002\u0013%!\u000f\u0003\u0004~\u0003\u0001\u0006Ia\u001d\u0005\b}\u0006\t\t\u0011\"!\u0000\u0011%\u00119)AI\u0001\n\u0003\u0011)\u0004C\u0005\u0003\n\u0006\t\t\u0011\"!\u0003\f\"I!QT\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005?\u000b\u0011\u0011!C\u0005\u0005C3Qa\u0013\u001fA\u0003\u0007A!\"a\t\u001d\u0005+\u0007I\u0011AA\u0013\u0011)\ty\u0004\bB\tB\u0003%\u0011q\u0005\u0005\u000b\u0003\u0003b\"Q3A\u0005\u0002\u0005\r\u0003BCA&9\tE\t\u0015!\u0003\u0002F!1a\u000b\bC\u0001\u0003\u001bBaA\u0016\u000f\u0005\u0002\u0005M\u0003bBA,9\u0011\u0005\u00131\t\u0005\b\u00033bB\u0011IA.\u0011\u001d\tI\u0007\bC!\u0003WBq!!\u001c\u001d\t\u0003\ny\u0007\u0003\u0006\u0002\u0000qA)\u0019!C\u0005\u0003\u0003C!\"a&\u001d\u0011\u000b\u0007I\u0011BAM\u0011)\ti\u000b\bEC\u0002\u0013%\u0011q\u0016\u0005\b\u0003scB\u0011IA^\u0011\u001d\tI\r\bC\u0005\u0003\u0017Dq!!5\u001d\t\u0013\t\u0019\u000eC\u0004\u0002Zr!I!a7\t\u000f\u0005\u0005H\u0004\"\u0003\u0002d\"9\u0011Q\u001e\u000f\u0005\n\u0005=\bbBA{9\u0011%\u0011q\u001f\u0005\b\u0003{dB\u0011IA\u0000\u0011%\u0011\u0019\u0002HA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001cq\t\n\u0011\"\u0001\u0003\u001e!I!1\u0007\u000f\u0012\u0002\u0013\u0005!Q\u0007\u0005\t\u0005sa\u0012\u0011!C!e\"I!1\b\u000f\u0002\u0002\u0013\u0005!Q\b\u0005\n\u0005\u000bb\u0012\u0011!C\u0001\u0005\u000fB\u0011B!\u0014\u001d\u0003\u0003%\tEa\u0014\t\u0013\tuC$!A\u0005\u0002\t}\u0003\"\u0003B29\u0005\u0005I\u0011\tB3\u0003!\u0001\u0016M]:f+Jd'BA\u001f?\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0002\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0013\u0015aA:rY*\u00111\tR\u0001\u0006gB\f'o\u001b\u0006\u0003\u000b\u001a\u000ba!\u00199bG\",'\"A$\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005)\u000bQ\"\u0001\u001f\u0003\u0011A\u000b'o]3Ve2\u001c2!A'T!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011a\nV\u0005\u0003+>\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A%\u0002\t!{5\u000bV\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0006if\u0004Xm\u001d\u0006\u0003?\n\u000ba!\u001e8tC\u001a,\u0017BA1]\u0005))FK\u0012\u001dTiJLgnZ\u0001\u0006\u0011>\u001bF\u000bI\u0001\u0005!\u0006#\u0006*A\u0003Q\u0003RC\u0005%A\u0003R+\u0016\u0013\u0016,\u0001\u0004R+\u0016\u0013\u0016\fI\u0001\u0004%\u00163\u0015\u0001\u0002*F\r\u0002\n\u0001\u0002\u0015*P)>\u001bu\nT\u0001\n!J{EkT\"P\u0019\u0002\nAAR%M\u000b\u0006)a)\u0013'FA\u0005I\u0011)\u0016+I\u001fJKE+W\u0001\u000b\u0003V#\u0006j\u0014*J)f\u0003\u0013\u0001C+T\u000bJKeJR(\u0002\u0013U\u001bVIU%O\r>\u0003\u0013a\u0003*F\u000f\u0016C\u0006KU#G\u0013b+\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019\u0019FO]5oO\u0006a!+R$F1B\u0013VIR%YA\u0005Y!+R$F1N+&IR%Y\u00031\u0011ViR#Y'V\u0013e)\u0013-!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\tAa!\u0003\u0006B\u0011!\nH\n\u000b9\u0005\u0015\u00111BA\t\u0003;\u0019\u0006c\u0001&\u0002\b%\u0019\u0011\u0011\u0002\u001f\u0003\u0015\u0015C\bO]3tg&|g\u000eE\u0002K\u0003\u001bI1!a\u0004=\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u001f\u0002\u000f\r|G-Z4f]&!\u00111DA\u000b\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007c\u0001(\u0002 %\u0019\u0011\u0011E(\u0003\u000fA\u0013x\u000eZ;di\u0006A1\r[5mIJ,g.\u0006\u0002\u0002(A1\u0011\u0011FA\u001d\u0003\u000bqA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022!\u000ba\u0001\u0010:p_Rt\u0014\"\u0001)\n\u0007\u0005]r*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\u0004'\u0016\f(bAA\u001c\u001f\u0006I1\r[5mIJ,g\u000eI\u0001\fM\u0006LGn\u00148FeJ|'/\u0006\u0002\u0002FA\u0019a*a\u0012\n\u0007\u0005%sJA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0015\r\u0005\u0005\u0011qJA)\u0011\u001d\t\u0019#\ta\u0001\u0003OA\u0011\"!\u0011\"!\u0003\u0005\r!!\u0012\u0015\t\u0005\u0005\u0011Q\u000b\u0005\b\u0003G\u0011\u0003\u0019AA\u0014\u0003!qW\u000f\u001c7bE2,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011Q\f\t\u0007\u0003S\tI$a\u0018\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR!!\u0018!\n\t\u0005\u001d\u00141\r\u0002\t\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002`\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005E\u0004\u0003BA:\u0003wrA!!\u001e\u0002xA\u0019\u0011QF(\n\u0007\u0005et*\u0001\u0004Qe\u0016$WMZ\u0005\u0004u\u0006u$bAA=\u001f\u0006I1-Y2iK\u0012,&\u000f\\\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013;\u0018a\u00018fi&!\u0011QRAD\u0005\r)&+\u0013\u0015\u0004O\u0005E\u0005c\u0001(\u0002\u0014&\u0019\u0011QS(\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!D2bG\",G\rU1ui\u0016\u0014h.\u0006\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016!\u0002:fO\u0016D(bAASo\u0006!Q\u000f^5m\u0013\u0011\tI+a(\u0003\u000fA\u000bG\u000f^3s]\"\u001a\u0001&!%\u0002+\r\f7\r[3e\u000bb$(/Y2u!\u0006\u0014HOR;oGV\u0011\u0011\u0011\u0017\t\b\u001d\u0006M\u00161QA9\u0013\r\t)l\u0014\u0002\n\rVt7\r^5p]FB3!KAI\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\ti\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019MP\u0001\tC:\fG._:jg&!\u0011qYAa\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018AC4fiB\u000bG\u000f^3s]R!\u00111TAg\u0011\u0019\tym\u000ba\u00015\u0006\u00191.Z=\u0002\r\u001d,G/\u0016:m)\u0011\t\u0019)!6\t\r\u0005]G\u00061\u0001[\u0003\r)(\u000f\\\u0001\u0013O\u0016$X\t\u001f;sC\u000e$\b+\u0019:u\rVt7\r\u0006\u0003\u00022\u0006u\u0007BBAp[\u0001\u0007!,A\u0007qCJ$Hk\\#yiJ\f7\r^\u0001\u0016Kb$(/Y2u-\u0006dW/\u001a$s_6\fV/\u001a:z)\u0015Q\u0016Q]Au\u0011\u0019\t9O\fa\u00015\u0006)\u0011/^3ss\"9\u00111\u001e\u0018A\u0002\u0005m\u0015a\u00029biR,'O\\\u0001\u000fKb$(/Y2u\rJ|W.\u0016:m)\u0015Q\u0016\u0011_Az\u0011\u001d\t9n\fa\u0001\u0003\u0007Ca!a80\u0001\u0004Q\u0016A\u00059beN,WK\u001d7XSRDw.\u001e;LKf$RAWA}\u0003wDa!a61\u0001\u0004Q\u0006BBApa\u0001\u0007!,\u0001\u0003fm\u0006dG\u0003\u0002B\u0001\u0005\u000f\u00012A\u0014B\u0002\u0013\r\u0011)a\u0014\u0002\u0004\u0003:L\b\"\u0003B\u0005cA\u0005\t\u0019\u0001B\u0006\u0003\u0015Ig\u000e];u!\u0011\u0011iAa\u0004\u000e\u0003yJ1A!\u0005?\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0003\u00119B!\u0007\t\u0013\u0005\r\"\u0007%AA\u0002\u0005\u001d\u0002\"CA!eA\u0005\t\u0019AA#\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\b+\t\u0005\u001d\"\u0011E\u0016\u0003\u0005G\u0001BA!\n\u000305\u0011!q\u0005\u0006\u0005\u0005S\u0011Y#A\u0005v]\u000eDWmY6fI*\u0019!QF(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00032\t\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u001cU\u0011\t)E!\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\u0004E\u0002O\u0005\u0003J1Aa\u0011P\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tA!\u0013\t\u0013\t-s'!AA\u0002\t}\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003RA1!1\u000bB-\u0005\u0003i!A!\u0016\u000b\u0007\t]s*\u0001\u0006d_2dWm\u0019;j_:LAAa\u0017\u0003V\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)E!\u0019\t\u0013\t-\u0013(!AA\u0002\t\u0005\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002F\t\u001d\u0004\"\u0003B&u\u0005\u0005\t\u0019\u0001B\u0001Q=a\"1\u000eB9\u0005g\u00129H!\u001f\u0003~\t}\u0004c\u0001&\u0003n%\u0019!q\u000e\u001f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QO\u0001@?\u001a+fjQ0)kJdG\u0006\t9beR$v.\u0012=ue\u0006\u001cGo\u0017\u0017!W\u0016LX,\u000b\u0011.A\u0015CHO]1diN\u0004\u0013\r\t9beR\u0004cM]8nA\u0005\u0004SK\u0015'/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B>\u0003\t\r#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iiR\u0004(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\u0002\u0018\r\u001e5@cV,'/_\u001f2O1\u0002s\u0005S(T)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I:qCJ\\g&\u00199bG\",gf\u001c:h\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u000e\u001e;qu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018qCRDw(];fefl\u0014g\n\u0017!OE+VIU-(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013/^3ssv\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iiR\u0004(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\u0002\u0018\r\u001e5@cV,'/_\u001f2O1\u0002s%U+F%f;C\u0006I\u0014rk\u0016\u0014\u0018pJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0003\u000bQA\r\u00181]ABq!a\t\u0018\u0001\u0004\t9\u0003C\u0005\u0002B]\u0001\n\u00111\u0001\u0002F\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5%\u0011\u0014\t\u0006\u001d\n=%1S\u0005\u0004\u0005#{%AB(qi&|g\u000eE\u0004O\u0005+\u000b9#!\u0012\n\u0007\t]uJ\u0001\u0004UkBdWM\r\u0005\n\u00057K\u0012\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u000bE\u0002u\u0005KK1Aa*v\u0005\u0019y%M[3di\u0002")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return ParseUrl$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(ParseUrl parseUrl) {
        return ParseUrl$.MODULE$.unapply(parseUrl);
    }

    public static boolean apply$default$2() {
        return ParseUrl$.MODULE$.apply$default$2();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().size(), (Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                URI uRI = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.cachedUrl = uRI;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cachedUrl$lzycompute() : this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                Pattern pattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.cachedPattern = pattern;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cachedPattern$lzycompute() : this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedExtractPartFunc$lzycompute() : this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() > 3 || this.children().size() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(41).append(this.prettyName()).append(" function requires two or three arguments").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder(0).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append(key.toString()).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.failOnError()) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Find an invaild url string ").append(url.toString()).toString(), uRISyntaxException);
            }
            uRI = null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        Function1 & Serializable & scala.Serializable intersect;
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$60 -> x$60.getHost();
        } else {
            UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
            UTF8String uTF8String5 = uTF8String;
            if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)x$61 -> x$61.getRawPath();
            } else {
                UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                UTF8String uTF8String7 = uTF8String;
                if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$62 -> x$62.getRawQuery();
                } else {
                    UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
                    UTF8String uTF8String9 = uTF8String;
                    if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)x$63 -> x$63.getRawFragment();
                    } else {
                        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
                        UTF8String uTF8String11 = uTF8String;
                        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)x$64 -> x$64.getScheme();
                        } else {
                            UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
                            UTF8String uTF8String13 = uTF8String;
                            if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)url -> url.getRawQuery() != null ? new StringBuilder(1).append(url.getRawPath()).append("?").append(url.getRawQuery()).toString() : url.getRawPath();
                            } else {
                                UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
                                UTF8String uTF8String15 = uTF8String;
                                if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
                                    intersect = (Function1 & Serializable & scala.Serializable)x$65 -> x$65.getRawAuthority();
                                } else {
                                    UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
                                    UTF8String uTF8String17 = uTF8String;
                                    intersect = !(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null) ? (Function1 & Serializable & scala.Serializable)x$66 -> x$66.getRawUserInfo() : (Function1 & Serializable & scala.Serializable)url -> null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return intersect;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        return m.find() ? UTF8String.fromString((String)m.group(2)) : null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        return this.cachedExtractPartFunc() != null ? UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url))) : UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        URI currentUrl;
        return this.cachedUrl() != null ? this.extractFromUrl(this.cachedUrl(), partToExtract) : ((currentUrl = this.getUrl(url)) != null ? this.extractFromUrl(currentUrl, partToExtract) : null);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)e -> (UTF8String)e.eval(input), Seq$.MODULE$.canBuildFrom());
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            uTF8String = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        } else {
            Predef$.MODULE$.assert(evaluated.size() == 3);
            Object object = evaluated.apply(1);
            UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
            if (object == null ? uTF8String2 != null : !object.equals(uTF8String2)) {
                return null;
            }
            UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
            if (query == null) {
                return null;
            }
            uTF8String = this.cachedPattern() != null ? this.extractValueFromQuery(query, this.cachedPattern()) : this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
        }
        return uTF8String;
    }

    public ParseUrl copy(Seq<Expression> children2, boolean failOnError) {
        return new ParseUrl(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != parseUrl.failOnError()) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ParseUrl(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

