/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within the nodes of xml that match the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n       [\"b1\",\"b2\",\"b3\"]\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002Di\t\t\u0011#\u0001\u0002F\u0019A\u0011DGA\u0001\u0012\u0003\t9\u0005\u0003\u0004@'\u0011\u0005\u0011Q\u000b\u0005\n\u0003/\u001a\u0012\u0011!C#\u00033B\u0011\"a\u0017\u0014\u0003\u0003%\t)!\u0018\t\u0013\u0005\r4#!A\u0005\u0002\u0006\u0015\u0004\"CA<'\u0005\u0005I\u0011BA=\u0005%A\u0006+\u0019;i\u0019&\u001cHO\u0003\u0002\u001c9\u0005\u0019\u00010\u001c7\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0016/iA\u00111\u0006L\u0007\u00025%\u0011QF\u0007\u0002\r1B\u000bG\u000f[#yiJ\f7\r\u001e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\tyS'\u0003\u00027a\ta1+\u001a:jC2L'0\u00192mKV\t\u0001\b\u0005\u0002:u5\tA$\u0003\u0002<9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\talG\u000eI\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n\u001b\u0005CA\u0016\u0001\u0011\u0015YR\u00011\u00019\u0011\u0015iT\u00011\u00019\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\rB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013\u0019\u000e\u0003)S!a\u0013\u0015\u0002\rq\u0012xn\u001c;?\u0013\ti\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'1\u0003!!\u0017\r^1UsB,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0013!\u0002;za\u0016\u001c\u0018B\u0001-V\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA._?B\u0011q\u0006X\u0005\u0003;B\u00121!\u00118z\u0011\u0015Y\u0002\u00021\u0001\\\u0011\u0015i\u0004\u00021\u0001\\\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\u00137\rC\u0004\u001c\u0013A\u0005\t\u0019\u0001\u001d\t\u000fuJ\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00014+\u0005a:7&\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!C;oG\",7m[3e\u0015\ti\u0007'\u0001\u0006b]:|G/\u0019;j_:L!a\u001c6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011a\u0017M\\4\u000b\u0003a\fAA[1wC&\u0011q*^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yB\u0011q&`\u0005\u0003}B\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aWA\u0002\u0011!\t)ADA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fA)\u0011QBA\n76\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0014AC2pY2,7\r^5p]&!\u0011QCA\b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0011\u0011\u0005\t\u0004_\u0005u\u0011bAA\u0010a\t9!i\\8mK\u0006t\u0007\u0002CA\u0003!\u0005\u0005\t\u0019A.\u0002\r\u0015\fX/\u00197t)\u0011\tY\"a\n\t\u0011\u0005\u0015\u0011#!AA\u0002mCs\u0002AA\u0016\u0003c\t\u0019$a\u000e\u0002:\u0005u\u0012q\b\t\u0004s\u00055\u0012bAA\u00189\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA\u001b\u00039|f)\u0016(D?\"BX\u000e\u001c\u0017!qB\fG\u000f[\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:ue&tw\rI1se\u0006L\be\u001c4!m\u0006dW/Z:!o&$\b.\u001b8!i\",\u0007E\\8eKN\u0004sN\u001a\u0011y[2\u0004C\u000f[1uA5\fGo\u00195!i\",\u0007\u0005\u0017)bi\"\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u001e\u0003\u0005-!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=Czb$M\u001022y=\u0012g\b\u00102?EJbtF\u0019 =Ez\u00127\u0007P\u0018c}q\u001aghY\u0019=_\rtDh\u0019 deqz3M\u0010\u001f0Cz:CfJ10E>\"X\r\u001f;)S\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#EF\u0012CF\t23E1\u0012#m\r\u0012^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA!\u0003\u0015\u0011d\u0006\r\u00181\u0003%A\u0006+\u0019;i\u0019&\u001cH\u000f\u0005\u0002,'M!1#!\u00135!\u001d\tY%!\u00159q\u0005k!!!\u0014\u000b\u0007\u0005=\u0003'A\u0004sk:$\u0018.\\3\n\t\u0005M\u0013Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA#\u0003!!xn\u0015;sS:<G#A:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u000by&!\u0019\t\u000bm1\u0002\u0019\u0001\u001d\t\u000bu2\u0002\u0019\u0001\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u0011qMA:!\u0015y\u0013\u0011NA7\u0013\r\tY\u0007\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b=\ny\u0007\u000f\u001d\n\u0007\u0005E\u0004G\u0001\u0004UkBdWM\r\u0005\t\u0003k:\u0012\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003w\u00022\u0001^A?\u0013\r\ty(\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathList xPathList) {
        return XPathList$.MODULE$.unapply(xPathList);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return new ArrayType(StringType$.MODULE$, false);
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        GenericArrayData genericArrayData;
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            UTF8String[] ret = new UTF8String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            genericArrayData = new GenericArrayData((Object)ret);
        } else {
            genericArrayData = null;
        }
        return genericArrayData;
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

