/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathShort$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a short integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002Di\t\t\u0011#\u0001\u0002F\u0019A\u0011DGA\u0001\u0012\u0003\t9\u0005\u0003\u0004@'\u0011\u0005\u0011Q\u000b\u0005\n\u0003/\u001a\u0012\u0011!C#\u00033B\u0011\"a\u0017\u0014\u0003\u0003%\t)!\u0018\t\u0013\u0005\r4#!A\u0005\u0002\u0006\u0015\u0004\"CA<'\u0005\u0005I\u0011BA=\u0005)A\u0006+\u0019;i'\"|'\u000f\u001e\u0006\u00037q\t1\u0001_7m\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+]Q\u0002\"a\u000b\u0017\u000e\u0003iI!!\f\u000e\u0003\u0019a\u0003\u0016\r\u001e5FqR\u0014\u0018m\u0019;\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011q&N\u0005\u0003mA\u0012AbU3sS\u0006d\u0017N_1cY\u0016,\u0012\u0001\u000f\t\u0003sij\u0011\u0001H\u0005\u0003wq\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0011AX\u000e\u001c\u0011\u0002\tA\fG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u00135\t\u0005\u0002,\u0001!)1$\u0002a\u0001q!)Q(\u0002a\u0001q\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0019\u0003\"a\u0012(\u000f\u0005!c\u0005CA%1\u001b\u0005Q%BA&)\u0003\u0019a$o\\8u}%\u0011Q\nM\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002Na\u0005AA-\u0019;b)f\u0004X-F\u0001T!\t!v+D\u0001V\u0015\t1\u0006%A\u0003usB,7/\u0003\u0002Y+\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002\\=~\u0003\"a\f/\n\u0005u\u0003$aA!os\")1\u0004\u0003a\u00017\")Q\b\u0003a\u00017\u0006!1m\u001c9z)\r\t%m\u0019\u0005\b7%\u0001\n\u00111\u00019\u0011\u001di\u0014\u0002%AA\u0002a\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001gU\tAtmK\u0001i!\tIg.D\u0001k\u0015\tYG.A\u0005v]\u000eDWmY6fI*\u0011Q\u000eM\u0001\u000bC:tw\u000e^1uS>t\u0017BA8k\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006!A.\u00198h\u0015\u0005A\u0018\u0001\u00026bm\u0006L!aT;\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003q\u0004\"aL?\n\u0005y\u0004$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA.\u0002\u0004!A\u0011Q\u0001\b\u0002\u0002\u0003\u0007A0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0001R!!\u0004\u0002\u0014mk!!a\u0004\u000b\u0007\u0005E\u0001'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\u0010\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY\"!\t\u0011\u0007=\ni\"C\u0002\u0002 A\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0006A\t\t\u00111\u0001\\\u0003\u0019)\u0017/^1mgR!\u00111DA\u0014\u0011!\t)!EA\u0001\u0002\u0004Y\u0006f\u0004\u0001\u0002,\u0005E\u00121GA\u001c\u0003s\ti$a\u0010\u0011\u0007e\ni#C\u0002\u00020q\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00026\u0005\tYb\u0018$V\u001d\u000e{\u0006\u0006_7mY\u0001B\b/\u0019;iS\u0001j\u0003EU3ukJt7\u000fI1!g\"|'\u000f\u001e\u0011j]R,w-\u001a:!m\u0006dW/\u001a\u0017!_J\u0004C\u000f[3!m\u0006dW/\u001a\u0011{KJ|\u0007%\u001b4!]>\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$G\u0006I8sA\u0005\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$\u0007EY;uAQDW\r\t<bYV,\u0007%[:!]>tWF\\;nKJL7ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111H\u0001Y\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C(\u0019 =Ez\nDh\f2?y\tt$\u0007P\u0018c}qz\u0013MP\u0014-A\u001d\u001aX/\u001c\u0015b_\tLs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002B\u0005)!G\f\u0019/a\u0005Q\u0001\fU1uQNCwN\u001d;\u0011\u0005-\u001a2\u0003B\n\u0002JQ\u0002r!a\u0013\u0002RaB\u0014)\u0004\u0002\u0002N)\u0019\u0011q\n\u0019\u0002\u000fI,h\u000e^5nK&!\u00111KA'\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u000b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002g\u0006)\u0011\r\u001d9msR)\u0011)a\u0018\u0002b!)1D\u0006a\u0001q!)QH\u0006a\u0001q\u00059QO\\1qa2LH\u0003BA4\u0003g\u0002RaLA5\u0003[J1!a\u001b1\u0005\u0019y\u0005\u000f^5p]B)q&a\u001c9q%\u0019\u0011\u0011\u000f\u0019\u0003\rQ+\b\u000f\\33\u0011!\t)hFA\u0001\u0002\u0004\t\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\bE\u0002u\u0003{J1!a v\u0005\u0019y%M[3di\u0002")
public class XPathShort
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathShort xPathShort) {
        return XPathShort$.MODULE$.unapply(xPathShort);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathShort> tupled() {
        return XPathShort$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathShort>> curried() {
        return XPathShort$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_short";
    }

    @Override
    public DataType dataType() {
        return ShortType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToShort((short)ret.shortValue());
    }

    public XPathShort copy(Expression xml, Expression path) {
        return new XPathShort(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathShort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathShort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathShort)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathShort xPathShort = (XPathShort)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathShort.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathShort.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathShort.canEqual(this)) return false;
        return true;
    }

    public XPathShort(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

