/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.TimeWindowing$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class TimeWindowing$
extends Rule<LogicalPlan> {
    public static TimeWindowing$ MODULE$;

    static {
        new TimeWindowing$();
    }

    private final String WINDOW_COL_NAME() {
        return "window";
    }

    private final String WINDOW_START() {
        return "start";
    }

    private final String WINDOW_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsUp((PartialFunction<LogicalPlan, LogicalPlan>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).children().size() == 1) {
                    Object object2;
                    LogicalPlan child = (LogicalPlan)A1.children().head();
                    Set windowExpressions = ((TraversableOnce)A1.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$188 -> x$188.collect(new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof TimeWindow) {
                                TimeWindow timeWindow = (TimeWindow)A1;
                                object = timeWindow;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            boolean bl = expression instanceof TimeWindow;
                            return bl;
                        }
                    }), Seq$.MODULE$.canBuildFrom())).toSet();
                    int numWindowExpr = windowExpressions.size();
                    if (numWindowExpr == 1 && ((TimeWindow)windowExpressions.head()).timeColumn().resolved() && ((TimeWindow)windowExpressions.head()).checkInputDataTypes().isSuccess()) {
                        Metadata metadata;
                        TimeWindow window = (TimeWindow)windowExpressions.head();
                        Expression expression = window.timeColumn();
                        if (expression instanceof Attribute) {
                            Attribute attribute = (Attribute)expression;
                            metadata = attribute.metadata();
                        } else {
                            metadata = Metadata$.MODULE$.empty();
                        }
                        Metadata metadata2 = metadata;
                        String x$1 = "window";
                        DataType x$2 = window.dataType();
                        Metadata x$3 = metadata2;
                        boolean x$4 = AttributeReference$.MODULE$.apply$default$3();
                        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$4, x$3);
                        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$4, x$3);
                        AttributeReference windowAttr = new AttributeReference(x$1, x$2, x$4, x$3, x$5, x$6);
                        if (window.windowDuration() == window.slideDuration()) {
                            Expression x$7 = anonfun.apply.41.getWindow$1(0, 1, window);
                            String x$8 = "window";
                            ExprId x$9 = windowAttr.exprId();
                            Some x$10 = new Some((Object)metadata2);
                            Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                            Alias windowStruct = new Alias(x$7, x$8, x$9, x$11, (Option<Metadata>)x$10, x$12);
                            LogicalPlan replacedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new scala.Serializable(null, windowAttr){
                                public static final long serialVersionUID = 0L;
                                private final AttributeReference windowAttr$1;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    A1 A1 = x2;
                                    Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x2);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x2) {
                                    Expression expression = x2;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                                {
                                    this.windowAttr$1 = windowAttr$1;
                                }
                            });
                            IsNotNull filterExpr = new IsNotNull(window.timeColumn());
                            Alias alias = windowStruct;
                            Filter filter = new Filter(filterExpr, new Project((Seq<NamedExpression>)((Seq)child.output().$plus$colon((Object)alias, Seq$.MODULE$.canBuildFrom())), child));
                            object2 = replacedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter));
                        } else {
                            int overlappingWindows = (int)package$.MODULE$.ceil((double)window.windowDuration() * 1.0 / (double)window.slideDuration());
                            Seq windows = (Seq)Seq$.MODULE$.tabulate(overlappingWindows, (Function1 & Serializable & scala.Serializable)i -> anonfun.apply.41.$anonfun$applyOrElse$213(overlappingWindows, window, BoxesRunTime.unboxToInt((Object)i)));
                            Seq projections = (Seq)windows.map((Function1 & Serializable & scala.Serializable)x$195 -> {
                                Expression expression = x$195;
                                return (Seq)child.output().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
                            }, Seq$.MODULE$.canBuildFrom());
                            Predicate filterExpr = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$greater$eq(package$expressions$.MODULE$.DslExpression(windowAttr).getField("start")))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$less(package$expressions$.MODULE$.DslExpression(windowAttr).getField("end"))));
                            AttributeReference attributeReference = windowAttr;
                            Filter substitutedPlan = new Filter((Expression)((Object)filterExpr), new Expand((Seq<Seq<Expression>>)projections, (Seq<Attribute>)((Seq)child.output().$plus$colon((Object)attributeReference, Seq$.MODULE$.canBuildFrom())), child));
                            LogicalPlan renamedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new scala.Serializable(null, windowAttr){
                                public static final long serialVersionUID = 0L;
                                private final AttributeReference windowAttr$1;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                    A1 A1 = x3;
                                    Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x3);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x3) {
                                    Expression expression = x3;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                                {
                                    this.windowAttr$1 = windowAttr$1;
                                }
                            });
                            Filter filter = substitutedPlan;
                            object2 = renamedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter));
                        }
                    } else {
                        if (numWindowExpr > 1) {
                            throw QueryCompilationErrors$.MODULE$.multiTimeWindowExpressionsNotSupportedError(A1);
                        }
                        object2 = A1;
                    }
                    object = object2;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan;
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                return bl;
            }

            private static final Expression getWindow$1(int i, int overlappingWindows, TimeWindow window$1) {
                Expression division = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(window$1.timeColumn(), TimestampType$.MODULE$, LongType$.MODULE$)).$minus(package$expressions$.MODULE$.longToLiteral(window$1.startTime()))).$div(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration()));
                Ceil ceil = new Ceil(division);
                CaseWhen windowId = new CaseWhen((Seq<Tuple2<Expression, Expression>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$expressions$.MODULE$.DslExpression(ceil).$eq$eq$eq(division), (Object)package$expressions$.MODULE$.DslExpression(ceil).$plus(package$expressions$.MODULE$.intToLiteral(1)))}))), (Option<Expression>)new Some((Object)ceil));
                Expression windowStart = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(windowId).$plus(package$expressions$.MODULE$.intToLiteral(i))).$minus(package$expressions$.MODULE$.intToLiteral(overlappingWindows))).$times(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration()))).$plus(package$expressions$.MODULE$.longToLiteral(window$1.startTime()));
                Expression windowEnd = package$expressions$.MODULE$.DslExpression(windowStart).$plus(package$expressions$.MODULE$.longToLiteral(window$1.windowDuration()));
                Literal literal = Literal$.MODULE$.apply("start");
                PreciseTimestampConversion preciseTimestampConversion = new PreciseTimestampConversion(windowStart, LongType$.MODULE$, TimestampType$.MODULE$);
                Literal literal2 = Literal$.MODULE$.apply("end");
                PreciseTimestampConversion preciseTimestampConversion2 = new PreciseTimestampConversion(windowEnd, LongType$.MODULE$, TimestampType$.MODULE$);
                return new CreateNamedStruct((Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)preciseTimestampConversion2).$colon$colon((Object)literal2).$colon$colon((Object)preciseTimestampConversion).$colon$colon((Object)literal));
            }

            public static final /* synthetic */ Expression $anonfun$applyOrElse$213(int overlappingWindows$1, TimeWindow window$1, int i) {
                return anonfun.apply.41.getWindow$1(i, overlappingWindows$1, window$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$212(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$213$adapted(int org.apache.spark.sql.catalyst.expressions.TimeWindow java.lang.Object ), $anonfun$applyOrElse$214(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    private TimeWindowing$() {
        MODULE$ = this;
    }
}

