/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.StreamingJoinHelper$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingSets;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Now;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CoGroup;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Deduplicate;
import org.apache.spark.sql.catalyst.plans.logical.DeserializeToObject;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark$;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsWithState;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MapElements;
import org.apache.spark.sql.catalyst.plans.logical.MapPartitions;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.ReturnAnswer;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.SerializeFromObject;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.TypedFilter;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$Append$;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$Complete$;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$Update$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class UnsupportedOperationChecker$
implements Logging {
    public static UnsupportedOperationChecker$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new UnsupportedOperationChecker$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void checkForBatch(LogicalPlan plan2) {
        plan2.foreachUp((Function1 & Serializable & scala.Serializable)x0$1 -> {
            UnsupportedOperationChecker$.$anonfun$checkForBatch$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void checkStreamingQueryGlobalWatermarkLimit(LogicalPlan plan2, OutputMode outputMode) {
        boolean failWhenDetected = SQLConf$.MODULE$.get().statefulOperatorCorrectnessCheckEnabled();
        try {
            plan2.foreach((Function1 & Serializable & scala.Serializable)subPlan -> {
                UnsupportedOperationChecker$.$anonfun$checkStreamingQueryGlobalWatermarkLimit$1(plan2, outputMode, subPlan);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AnalysisException) {
                AnalysisException analysisException = (AnalysisException)throwable2;
                if (!failWhenDetected) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(analysisException.message()).append(";\n").append(plan2).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            throw throwable;
        }
    }

    public void checkForStreaming(LogicalPlan plan2, OutputMode outputMode) {
        Seq aggregates;
        if (!plan2.isStreaming()) {
            throw this.throwError("Queries without streaming sources cannot be executed with writeStream.start()", plan2);
        }
        Seq mapGroupsWithStates = plan2.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                A1 A1 = x1;
                Object object = A1 instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)A1).isStreaming() && flatMapGroupsWithState.isMapGroupsWithState() ? flatMapGroupsWithState : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming() && flatMapGroupsWithState.isMapGroupsWithState();
                return bl;
            }
        });
        if (mapGroupsWithStates.size() >= 2) {
            throw this.throwError("Multiple mapGroupsWithStates are not supported on a streaming DataFrames/Datasets", plan2);
        }
        Seq flatMapGroupsWithStates = plan2.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                A1 A1 = x2;
                Object object = A1 instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)A1).isStreaming() && !flatMapGroupsWithState.isMapGroupsWithState() ? flatMapGroupsWithState : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                LogicalPlan logicalPlan = x2;
                boolean bl = logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming() && !flatMapGroupsWithState.isMapGroupsWithState();
                return bl;
            }
        });
        if (mapGroupsWithStates.nonEmpty() && flatMapGroupsWithStates.nonEmpty()) {
            throw this.throwError("Mixing mapGroupsWithStates and flatMapGroupsWithStates are not supported on a streaming DataFrames/Datasets", plan2);
        }
        if (flatMapGroupsWithStates.size() >= 2) {
            OutputMode outputMode2 = outputMode;
            InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
            if ((outputMode2 != null ? !outputMode2.equals(internalOutputModes$Append$) : internalOutputModes$Append$ != null) || flatMapGroupsWithStates.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreaming$1(x$2)))) {
                throw this.throwError("Multiple flatMapGroupsWithStates are not supported when they are not all in append mode or the output mode is not append on a streaming DataFrames/Datasets", plan2);
            }
        }
        if ((aggregates = UnsupportedOperationChecker$.collectStreamingAggregates$1(plan2)).size() > 1) {
            throw this.throwError("Multiple streaming aggregations are not supported with streaming DataFrames/Datasets", plan2);
        }
        OutputMode outputMode3 = outputMode;
        if (InternalOutputModes$Append$.MODULE$.equals(outputMode3) && aggregates.nonEmpty()) {
            Aggregate aggregate = (Aggregate)aggregates.head();
            Seq watermarkAttributes = (Seq)aggregate.groupingExpressions().collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Attribute attribute;
                    A1 A1 = x3;
                    Object object = A1 instanceof Attribute && (attribute = (Attribute)A1).metadata().contains(EventTimeWatermark$.MODULE$.delayKey()) ? attribute : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x3) {
                    Attribute attribute;
                    Expression expression = x3;
                    boolean bl = expression instanceof Attribute && (attribute = (Attribute)expression).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (watermarkAttributes.isEmpty()) {
                throw this.throwError(new StringBuilder(115).append(outputMode).append(" output mode not supported when there are streaming aggregations on ").append("streaming DataFrames/DataSets without watermark").toString(), plan2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (InternalOutputModes$Complete$.MODULE$.equals(outputMode3) && aggregates.isEmpty()) {
                throw this.throwError(new StringBuilder(100).append(outputMode).append(" output mode not supported when there are no streaming aggregations on ").append("streaming DataFrames/Datasets").toString(), plan2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        plan2.foreachUp((Function1 & Serializable & scala.Serializable)subPlan -> {
            UnsupportedOperationChecker$.$anonfun$checkForStreaming$4(this, plan2, outputMode, subPlan);
            return BoxedUnit.UNIT;
        });
        this.checkStreamingQueryGlobalWatermarkLimit(plan2, outputMode);
    }

    public void checkForContinuous(LogicalPlan plan2, OutputMode outputMode) {
        this.checkForStreaming(plan2, outputMode);
        plan2.foreachUp((Function1 & Serializable & scala.Serializable)subPlan -> {
            UnsupportedOperationChecker$.$anonfun$checkForContinuous$1(subPlan);
            return BoxedUnit.UNIT;
        });
    }

    private void throwErrorIf(boolean condition, String msg, LogicalPlan operator) {
        if (condition) {
            throw this.throwError(msg, operator);
        }
    }

    private Nothing$ throwError(String msg, LogicalPlan operator) {
        throw new AnalysisException(msg, operator.origin().line(), operator.origin().startPosition(), (Option<LogicalPlan>)new Some((Object)operator), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private void checkForStreamStreamJoinWatermark(Join join) {
        boolean bl;
        boolean watermarkInJoinKeys = StreamingJoinHelper$.MODULE$.isWatermarkInJoinKeys(join);
        JoinType joinType = join.joinType();
        boolean bl2 = LeftOuter$.MODULE$.equals(joinType) ? true : LeftSemi$.MODULE$.equals(joinType);
        if (bl2) {
            bl = StreamingJoinHelper$.MODULE$.getStateValueWatermark(join.left().outputSet(), join.right().outputSet(), join.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        } else if (RightOuter$.MODULE$.equals(joinType)) {
            bl = StreamingJoinHelper$.MODULE$.getStateValueWatermark(join.right().outputSet(), join.left().outputSet(), join.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        } else if (FullOuter$.MODULE$.equals(joinType)) {
            bl = ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)join.left().outputSet(), (Object)join.right().outputSet()), new Tuple2((Object)join.right().outputSet(), (Object)join.left().outputSet())}))).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreamStreamJoinWatermark$1(join, x0$1)));
        } else {
            throw this.throwError(new StringBuilder(60).append("Join type ").append(join.joinType()).append(" is not supported with streaming DataFrame/Dataset").toString(), join);
        }
        boolean hasValidWatermarkRange = bl;
        if (!watermarkInJoinKeys && !hasValidWatermarkRange) {
            throw this.throwError(new StringBuilder(186).append("Stream-stream ").append(join.joinType()).append(" join between two streaming DataFrame/Datasets ").append("is not supported without a watermark in the join keys, or a watermark on ").append("the nullable side and an appropriate range condition").toString(), join);
        }
    }

    public static final /* synthetic */ void $anonfun$checkForBatch$1(LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan.isStreaming()) {
            throw MODULE$.throwError("Queries with streaming sources must be executed with writeStream.start()", logicalPlan);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStatefulOperationPossiblyEmitLateRows$1(LogicalPlan p, OutputMode outputMode$1) {
        Aggregate aggregate;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
            OutputMode outputMode = outputMode$1;
            InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
            if (outputMode == null) {
                if (internalOutputModes$Append$ == null) return true;
            } else if (outputMode.equals(internalOutputModes$Append$)) {
                return true;
            }
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            if (left.isStreaming() && right.isStreaming()) {
                JoinType joinType2 = joinType;
                Inner$ inner$ = Inner$.MODULE$;
                if (joinType2 == null ? inner$ != null : !joinType2.equals(inner$)) {
                    return true;
                }
            }
        }
        if (!(logicalPlan instanceof FlatMapGroupsWithState)) return false;
        FlatMapGroupsWithState flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan;
        if (!flatMapGroupsWithState.isStreaming()) return false;
        OutputMode outputMode = flatMapGroupsWithState.outputMode();
        OutputMode outputMode2 = OutputMode.Append();
        if (outputMode != null) {
            if (!outputMode.equals(outputMode2)) return false;
            return true;
        }
        if (outputMode2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStatefulOperation$1(LogicalPlan p) {
        FlatMapGroupsWithState flatMapGroupsWithState;
        Aggregate aggregate;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            if (left.isStreaming() && right.isStreaming()) {
                return true;
            }
        }
        if (logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming()) {
            return true;
        }
        if (!(logicalPlan instanceof Deduplicate)) return false;
        Deduplicate deduplicate = (Deduplicate)logicalPlan;
        if (!deduplicate.isStreaming()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkStreamingQueryGlobalWatermarkLimit$2(LogicalPlan subPlan$1, OutputMode outputMode$1, LogicalPlan p) {
        return p != subPlan$1 && UnsupportedOperationChecker$.isStatefulOperationPossiblyEmitLateRows$1(p, outputMode$1);
    }

    public static final /* synthetic */ void $anonfun$checkStreamingQueryGlobalWatermarkLimit$1(LogicalPlan plan$1, OutputMode outputMode$1, LogicalPlan subPlan) {
        block0: {
            if (!UnsupportedOperationChecker$.isStatefulOperation$1(subPlan)) break block0;
            subPlan.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkStreamingQueryGlobalWatermarkLimit$2(subPlan, outputMode$1, p))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                String errorMsg = "Detected pattern of possible 'correctness' issue due to global watermark. The query contains stateful operation which can emit rows older than the current watermark plus allowed late record delay, which are \"late rows\" in downstream stateful operations and these rows can be discarded. Please refer the programming guide doc for more details. If you understand the possible risk of correctness issue and still need to run the query, you can disable this check by setting the config `spark.sql.streaming.statefulOperator.checkCorrectness.enabled` to false.";
                return MODULE$.throwError(errorMsg, plan$1);
            });
        }
    }

    private static final Seq collectStreamingAggregates$1(LogicalPlan subplan) {
        return subplan.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Distinct distinct;
                LogicalPlan c;
                Object object;
                Aggregate aggregate;
                A1 A1 = x1;
                if (A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming()) {
                    object = aggregate;
                    return (B1)object;
                }
                if (A1 instanceof Distinct && (c = (distinct = (Distinct)A1).child()) != null) {
                    LogicalPlan logicalPlan = c;
                    if (distinct.isStreaming()) {
                        object = new Aggregate(logicalPlan.output(), logicalPlan.output(), logicalPlan);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Distinct distinct;
                LogicalPlan c;
                Aggregate aggregate;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming() ? true : logicalPlan instanceof Distinct && (c = (distinct = (Distinct)logicalPlan).child()) != null && distinct.isStreaming();
                return bl;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreaming$1(FlatMapGroupsWithState x$2) {
        OutputMode outputMode = x$2.outputMode();
        InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
        return outputMode == null ? internalOutputModes$Append$ != null : !outputMode.equals(internalOutputModes$Append$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsCompleteData$1(LogicalPlan subplan, OutputMode outputMode$2) {
        Seq aggs = subplan.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Aggregate aggregate;
                A1 A1 = x1;
                Object object = A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming() ? aggregate : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Aggregate aggregate;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming();
                return bl;
            }
        });
        if (!subplan.isStreaming()) return true;
        if (!aggs.nonEmpty()) return false;
        OutputMode outputMode = outputMode$2;
        InternalOutputModes$Complete$ internalOutputModes$Complete$ = InternalOutputModes$Complete$.MODULE$;
        if (outputMode != null) {
            if (!outputMode.equals(internalOutputModes$Complete$)) return false;
            return true;
        }
        if (internalOutputModes$Complete$ == null) return true;
        return false;
    }

    private final void checkUnsupportedExpressions$1(LogicalPlan operator) {
        Seq unsupportedExprs = (Seq)((SeqLike)operator.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof MonotonicallyIncreasingID) {
                    MonotonicallyIncreasingID monotonicallyIncreasingID = (MonotonicallyIncreasingID)A1;
                    object = monotonicallyIncreasingID;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof MonotonicallyIncreasingID;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom())).distinct();
        if (unsupportedExprs.nonEmpty()) {
            throw this.throwError(new StringBuilder(67).append("Expression(s): ").append(((TraversableOnce)unsupportedExprs.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(" is not supported with streaming DataFrames/Datasets").toString(), operator);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreaming$6(Expression x$5) {
        return x$5 instanceof GroupingSets;
    }

    public static final /* synthetic */ void $anonfun$checkForStreaming$4(UnsupportedOperationChecker$ $this, LogicalPlan plan$2, OutputMode outputMode$2, LogicalPlan subPlan) {
        LogicalPlan logicalPlan = subPlan;
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<Expression> groupingExpressions = aggregate.groupingExpressions();
            Seq<NamedExpression> aggregateExpressions = aggregate.aggregateExpressions();
            LogicalPlan child = aggregate.child();
            Seq distinctAggExprs = (Seq)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)expr -> ((TreeNode)((Object)expr)).collect(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    AggregateExpression aggregateExpression;
                    A1 A1 = x4;
                    Object object = A1 instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)A1).isDistinct() ? aggregateExpression : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x4) {
                    AggregateExpression aggregateExpression;
                    Expression expression = x4;
                    boolean bl = expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).isDistinct();
                    return bl;
                }
            }), Seq$.MODULE$.canBuildFrom());
            boolean haveGroupingSets = groupingExpressions.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreaming$6(x$5)));
            MODULE$.throwErrorIf(child.isStreaming() && distinctAggExprs.nonEmpty(), "Distinct aggregations are not supported on streaming DataFrames/Datasets. Consider using approx_count_distinct() instead.", subPlan);
            MODULE$.throwErrorIf(child.isStreaming() && haveGroupingSets, "Grouping Sets is not supported on streaming DataFrames/Datasets", subPlan);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            FlatMapGroupsWithState flatMapGroupsWithState;
            if (logicalPlan instanceof Command) {
                throw MODULE$.throwError("Commands like CreateTable*, AlterTable*, Show* are not supported with streaming DataFrames/Datasets", subPlan);
            }
            if (logicalPlan instanceof InsertIntoDir) {
                throw MODULE$.throwError("InsertIntoDir is not supported with streaming DataFrames/Datasets", subPlan);
            }
            if (logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming()) {
                BoxedUnit boxedUnit;
                Seq aggsInQuery = UnsupportedOperationChecker$.collectStreamingAggregates$1(plan$2);
                if (flatMapGroupsWithState.isMapGroupsWithState()) {
                    if (aggsInQuery.nonEmpty()) {
                        throw MODULE$.throwError("mapGroupsWithState is not supported with aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                    OutputMode outputMode = outputMode$2;
                    InternalOutputModes$Update$ internalOutputModes$Update$ = InternalOutputModes$Update$.MODULE$;
                    if (outputMode == null ? internalOutputModes$Update$ != null : !outputMode.equals(internalOutputModes$Update$)) {
                        throw MODULE$.throwError(new StringBuilder(86).append("mapGroupsWithState is not supported with ").append(outputMode$2).append(" output mode on a streaming DataFrame/Dataset").toString(), subPlan);
                    }
                } else if (aggsInQuery.isEmpty()) {
                    OutputMode outputMode = flatMapGroupsWithState.outputMode();
                    if (InternalOutputModes$Update$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode2 = outputMode$2;
                        InternalOutputModes$Update$ internalOutputModes$Update$ = InternalOutputModes$Update$.MODULE$;
                        if (outputMode2 == null ? internalOutputModes$Update$ != null : !outputMode2.equals(internalOutputModes$Update$)) {
                            throw MODULE$.throwError(new StringBuilder(105).append("flatMapGroupsWithState in update mode is not supported with ").append(outputMode$2).append(" output mode on a streaming DataFrame/Dataset").toString(), subPlan);
                        }
                    }
                    if (InternalOutputModes$Append$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode3 = outputMode$2;
                        InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
                        if (outputMode3 == null ? internalOutputModes$Append$ != null : !outputMode3.equals(internalOutputModes$Append$)) {
                            throw MODULE$.throwError(new StringBuilder(105).append("flatMapGroupsWithState in append mode is not supported with ").append(outputMode$2).append(" output mode on a streaming DataFrame/Dataset").toString(), subPlan);
                        }
                    }
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    OutputMode outputMode = flatMapGroupsWithState.outputMode();
                    InternalOutputModes$Update$ internalOutputModes$Update$ = InternalOutputModes$Update$.MODULE$;
                    if (!(outputMode != null ? !outputMode.equals(internalOutputModes$Update$) : internalOutputModes$Update$ != null)) {
                        throw MODULE$.throwError("flatMapGroupsWithState in update mode is not supported with aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                    if (UnsupportedOperationChecker$.collectStreamingAggregates$1(flatMapGroupsWithState).nonEmpty()) {
                        throw MODULE$.throwError("flatMapGroupsWithState in append mode is not supported after aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                }
                GroupStateTimeout groupStateTimeout = flatMapGroupsWithState.timeout();
                EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
                if (!(groupStateTimeout != null ? !groupStateTimeout.equals(eventTimeTimeout$) : eventTimeTimeout$ != null)) {
                    Seq watermarkAttributes = (Seq)flatMapGroupsWithState.child().output().collect((PartialFunction)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                            A1 A1;
                            A1 A12 = x5;
                            Object object = A12 != null && (A1 = A12).metadata().contains(EventTimeWatermark$.MODULE$.delayKey()) ? A1 : function1.apply(x5);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Attribute x5) {
                            Attribute attribute;
                            Attribute attribute2 = x5;
                            boolean bl = attribute2 != null && (attribute = attribute2).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    if (watermarkAttributes.isEmpty()) {
                        throw MODULE$.throwError("Watermark must be specified in the query using '[Dataset/DataFrame].withWatermark()' for using event-time timeout in a [map|flatMap]GroupsWithState. Event-time timeout not supported without watermark.", plan$2);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                Deduplicate deduplicate;
                if (logicalPlan instanceof Deduplicate && UnsupportedOperationChecker$.collectStreamingAggregates$1(deduplicate = (Deduplicate)logicalPlan).nonEmpty()) {
                    throw MODULE$.throwError("dropDuplicates is not supported after aggregation on a streaming DataFrame/Dataset", subPlan);
                }
                if (logicalPlan instanceof Join) {
                    JoinType joinType;
                    Join join = (Join)logicalPlan;
                    LogicalPlan left = join.left();
                    LogicalPlan right = join.right();
                    JoinType joinType2 = join.joinType();
                    if (left.isStreaming() && right.isStreaming()) {
                        OutputMode outputMode = outputMode$2;
                        InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
                        if (outputMode == null ? internalOutputModes$Append$ != null : !outputMode.equals(internalOutputModes$Append$)) {
                            throw MODULE$.throwError(new StringBuilder(107).append("Join between two streaming DataFrames/Datasets is not supported").append(" in ").append(outputMode$2).append(" output mode, only in Append output mode").toString(), subPlan);
                        }
                    }
                    if ((joinType = joinType2) instanceof InnerLike) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (FullOuter$.MODULE$.equals(joinType)) {
                        BoxedUnit boxedUnit;
                        if (left.isStreaming() && !right.isStreaming()) {
                            throw MODULE$.throwError("FullOuter joins with streaming DataFrames/Datasets on the left and a static DataFrame/Dataset on the right is not supported", subPlan);
                        }
                        if (!left.isStreaming() && right.isStreaming()) {
                            throw MODULE$.throwError("FullOuter joins with streaming DataFrames/Datasets on the right and a static DataFrame/Dataset on the left is not supported", subPlan);
                        }
                        if (left.isStreaming() && right.isStreaming()) {
                            MODULE$.checkForStreamStreamJoinWatermark(join);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit;
                    } else if (LeftAnti$.MODULE$.equals(joinType)) {
                        if (right.isStreaming()) {
                            throw MODULE$.throwError(new StringBuilder(72).append(LeftAnti$.MODULE$).append(" joins with a streaming DataFrame/Dataset ").append("on the right are not supported").toString(), subPlan);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean bl = LeftOuter$.MODULE$.equals(joinType) ? true : LeftSemi$.MODULE$.equals(joinType);
                        if (bl) {
                            BoxedUnit boxedUnit;
                            if (!left.isStreaming() && right.isStreaming()) {
                                throw MODULE$.throwError(new StringBuilder(113).append(joinType2).append(" join with a streaming DataFrame/Dataset ").append("on the right and a static DataFrame/Dataset on the left is not supported").toString(), subPlan);
                            }
                            if (left.isStreaming() && right.isStreaming()) {
                                MODULE$.checkForStreamStreamJoinWatermark(join);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit5 = boxedUnit;
                        } else if (RightOuter$.MODULE$.equals(joinType)) {
                            BoxedUnit boxedUnit;
                            if (left.isStreaming() && !right.isStreaming()) {
                                throw MODULE$.throwError("RightOuter join with a streaming DataFrame/Dataset on the left and a static DataFrame/DataSet on the right not supported", subPlan);
                            }
                            if (left.isStreaming() && right.isStreaming()) {
                                MODULE$.checkForStreamStreamJoinWatermark(join);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit6 = boxedUnit;
                        } else {
                            boolean bl2 = joinType instanceof NaturalJoin ? true : joinType instanceof UsingJoin;
                            if (bl2) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw MODULE$.throwError(new StringBuilder(60).append("Join type ").append(joinType2).append(" is not supported with streaming DataFrame/Dataset").toString(), subPlan);
                            }
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ReturnAnswer returnAnswer;
                    LogicalPlan child;
                    Window window;
                    LogicalPlan child2;
                    Sample sample;
                    LogicalPlan child3;
                    boolean bl;
                    Except except;
                    LogicalPlan right;
                    Union union;
                    CoGroup coGroup;
                    if (logicalPlan instanceof CoGroup && (coGroup = (CoGroup)logicalPlan).children().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isStreaming()))) {
                        throw MODULE$.throwError("CoGrouping with a streaming DataFrame/Dataset is not supported", subPlan);
                    }
                    if (logicalPlan instanceof Union && ((SeqLike)((SeqLike)(union = (Union)logicalPlan).children().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isStreaming()), Seq$.MODULE$.canBuildFrom())).distinct()).size() == 2) {
                        throw MODULE$.throwError("Union between streaming and batch DataFrames/Datasets is not supported", subPlan);
                    }
                    if (logicalPlan instanceof Except && (right = (except = (Except)logicalPlan).right()).isStreaming()) {
                        throw MODULE$.throwError("Except on a streaming DataFrame/Dataset on the right is not supported", subPlan);
                    }
                    if (logicalPlan instanceof Intersect) {
                        Intersect intersect = (Intersect)logicalPlan;
                        LogicalPlan left = intersect.left();
                        LogicalPlan right2 = intersect.right();
                        if (left.isStreaming() && right2.isStreaming()) {
                            throw MODULE$.throwError("Intersect between two streaming DataFrames/Datasets is not supported", subPlan);
                        }
                    }
                    if ((bl = logicalPlan instanceof GlobalLimit ? true : logicalPlan instanceof LocalLimit) && subPlan.children().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isStreaming()))) {
                        OutputMode outputMode = outputMode$2;
                        InternalOutputModes$Update$ internalOutputModes$Update$ = InternalOutputModes$Update$.MODULE$;
                        if (!(outputMode != null ? !outputMode.equals(internalOutputModes$Update$) : internalOutputModes$Update$ != null)) {
                            throw MODULE$.throwError("Limits are not supported on streaming DataFrames/Datasets in Update output mode", subPlan);
                        }
                    }
                    if (logicalPlan instanceof Sort && !UnsupportedOperationChecker$.containsCompleteData$1(subPlan, outputMode$2)) {
                        throw MODULE$.throwError("Sorting is not supported on streaming DataFrames/Datasets, unless it is on aggregated DataFrame/Dataset in Complete output mode", subPlan);
                    }
                    if (logicalPlan instanceof Sample && (child3 = (sample = (Sample)logicalPlan).child()).isStreaming()) {
                        throw MODULE$.throwError("Sampling is not supported on streaming DataFrames/Datasets", subPlan);
                    }
                    if (logicalPlan instanceof Window && (child2 = (window = (Window)logicalPlan).child()).isStreaming()) {
                        throw MODULE$.throwError("Non-time-based windows are not supported on streaming DataFrames/Datasets", subPlan);
                    }
                    if (logicalPlan instanceof ReturnAnswer && (child = (returnAnswer = (ReturnAnswer)logicalPlan).child()).isStreaming()) {
                        throw MODULE$.throwError("Cannot return immediate result on streaming DataFrames/Dataset. Queries with streaming DataFrames/Datasets must be executed with writeStream.start().", subPlan);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        $this.checkUnsupportedExpressions$1(subPlan);
    }

    public static final /* synthetic */ boolean $anonfun$checkForContinuous$3(Expression x0$1) {
        Expression expression = x0$1;
        boolean bl = expression instanceof CurrentTimestamp ? true : (expression instanceof Now ? true : expression instanceof CurrentDate);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$checkForContinuous$2(LogicalPlan subPlan$2, Expression e) {
        if (e.collectLeaves().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForContinuous$3(x0$1)))) {
            throw MODULE$.throwError("Continuous processing does not support current time operations.", subPlan$2);
        }
    }

    public static final /* synthetic */ void $anonfun$checkForContinuous$1(LogicalPlan subPlan) {
        View view;
        LogicalPlan logicalPlan = subPlan;
        boolean bl = logicalPlan instanceof Project ? true : (logicalPlan instanceof Filter ? true : (logicalPlan instanceof MapElements ? true : (logicalPlan instanceof MapPartitions ? true : (logicalPlan instanceof DeserializeToObject ? true : (logicalPlan instanceof SerializeFromObject ? true : (logicalPlan instanceof SubqueryAlias ? true : logicalPlan instanceof TypedFilter))))));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (logicalPlan instanceof View && (view = (View)logicalPlan).isTempViewStoringAnalyzedPlan()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string = logicalPlan.nodeName();
            String string2 = "StreamingRelationV2";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw MODULE$.throwError(new StringBuilder(51).append("Continuous processing does not support ").append(logicalPlan.nodeName()).append(" operations.").toString(), subPlan);
            }
        }
        subPlan.expressions().foreach((Function1 & Serializable & scala.Serializable)e -> {
            UnsupportedOperationChecker$.$anonfun$checkForContinuous$2(subPlan, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreamStreamJoinWatermark$1(Join join$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AttributeSet attributesToFindStateWatermarkFor = (AttributeSet)tuple2._1();
        AttributeSet attributesWithEventWatermark = (AttributeSet)tuple2._2();
        boolean bl = StreamingJoinHelper$.MODULE$.getStateValueWatermark(attributesToFindStateWatermarkFor, attributesWithEventWatermark, join$1.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        return bl;
    }

    private UnsupportedOperationChecker$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

