/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.collection.OpenHashSet;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u000f\u001f\u0001.B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011!a\u0005\u0001#b\u0001\n\u0013i\u0005\"\u0002+\u0001\t\u0003j\u0005\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0001,\t\u000b\u0011\u0004A\u0011I3\t\u000b5\u0004A\u0011\t8\t\u000bq\u0004A\u0011I?\t\u000f\u0005M\u0001\u0001\"\u0015\u0002\u0016!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001#\u0003%\t!!\u000b\t\u0013\u0005\u0005\u0003!!A\u0005B\u0005\r\u0003\"CA*\u0001\u0005\u0005I\u0011AA+\u0011%\ti\u0006AA\u0001\n\u0003\ty\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007;\u0011\"a*\u001f\u0003\u0003E\t!!+\u0007\u0011uq\u0012\u0011!E\u0001\u0003WCaaR\f\u0005\u0002\u0005e\u0006\"CA^/\u0005\u0005IQIA_\u0011%\tylFA\u0001\n\u0003\u000b\t\rC\u0005\u0002H^\t\t\u0011\"!\u0002J\"I\u00111\\\f\u0002\u0002\u0013%\u0011Q\u001c\u0002\u000f\u0003J\u0014\u0018-_%oi\u0016\u00148/Z2u\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011C\u0002\u0001-aM2D\b\u0005\u0002.]5\ta$\u0003\u00020=\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003[EJ!A\r\u0010\u0003\u001f\u0005\u0013(/Y=CS:\f'/\u001f'jW\u0016\u0004\"!\f\u001b\n\u0005Ur\"\u0001H\"p[BdW\r\u001f+za\u0016lUM]4j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\t9T(\u0003\u0002?q\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\t\u0005CA\u0017C\u0013\t\u0019eD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002J\u0015.\u0003\"!\f\u0001\t\u000b}*\u0001\u0019A!\t\u000b\u0015+\u0001\u0019A!\u0002!%tG/\u001a:oC2$\u0015\r^1UsB,W#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0013\u0013!\u0002;za\u0016\u001c\u0018BA*Q\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u001b\u00154\u0018\r\\%oi\u0016\u00148/Z2u+\u00059\u0006#B\u001cY5jS\u0016BA-9\u0005%1UO\\2uS>t'\u0007\u0005\u0002\\=6\tAL\u0003\u0002^A\u0005!Q\u000f^5m\u0013\tyFLA\u0005BeJ\f\u0017\u0010R1uC\"\u0012\u0001\"\u0019\t\u0003o\tL!a\u0019\u001d\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGc\u00014jWB\u0011qgZ\u0005\u0003Qb\u00121!\u00118z\u0011\u0015Q\u0017\u00021\u0001g\u0003\u0019Ig\u000e];uc!)A.\u0003a\u0001M\u00061\u0011N\u001c9viJ\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007=,(\u0010\u0005\u0002qg6\t\u0011O\u0003\u0002s=\u000591m\u001c3fO\u0016t\u0017B\u0001;r\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002<\u000b\u0001\u00049\u0018aA2uqB\u0011\u0001\u000f_\u0005\u0003sF\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003|\u0015\u0001\u0007q.\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003y\u00042a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\r\u0001(\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0001O\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0001(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u0011*a\u0006\u0002\u001c!1\u0011\u0011\u0004\u0007A\u0002\u0005\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001e1\u0001\r!Q\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015I\u00151EA\u0013\u0011\u001dyT\u0002%AA\u0002\u0005Cq!R\u0007\u0011\u0002\u0003\u0007\u0011)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-\"fA!\u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:a\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\nAA[1wC&!\u0011qBA%\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0006E\u00028\u00033J1!a\u00179\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u0017\u0011\r\u0005\n\u0003G\u0012\u0012\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA5!\u0015\tY'!\u001dg\u001b\t\tiGC\u0002\u0002pa\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\ny\bE\u00028\u0003wJ1!! 9\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0019\u0015\u0003\u0003\u0005\rAZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0014Q\u0011\u0005\t\u0003G*\u0012\u0011!a\u0001M\"\u001a\u0002!!#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi*!)\u0002$B\u0019Q&a#\n\u0007\u00055eDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0015!a\u0001\u000bA\u0001zf)\u0016(D?\"\n'O]1zc1\u0002\u0013M\u001d:bsJJ\u0003%\f\u0011SKR,(O\\:!C:\u0004\u0013M\u001d:bs\u0002zg\r\t;iK\u0002*G.Z7f]R\u001c\b%\u001b8!i\",\u0007%\u001b8uKJ\u001cXm\u0019;j_:\u0004sN\u001a\u0011beJ\f\u00170\r\u0011b]\u0012T\u0001\u0005\t\u0011!CJ\u0014\u0018-\u001f\u001a-A]LG\u000f[8vi\u0002\"W\u000f\u001d7jG\u0006$Xm\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\u000bQK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)c1\u00023\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-guS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003?\u000b1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011QU\u0001\u0006e9\"d\u0006M\u0001\u000f\u0003J\u0014\u0018-_%oi\u0016\u00148/Z2u!\tisc\u0005\u0003\u0018\u0003[c\u0004cBAX\u0003k\u000b\u0015)S\u0007\u0003\u0003cS1!a-9\u0003\u001d\u0011XO\u001c;j[\u0016LA!a.\u00022\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0013!B1qa2LH#B%\u0002D\u0006\u0015\u0007\"B \u001b\u0001\u0004\t\u0005\"B#\u001b\u0001\u0004\t\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0017\f9\u000eE\u00038\u0003\u001b\f\t.C\u0002\u0002Pb\u0012aa\u00149uS>t\u0007#B\u001c\u0002T\u0006\u000b\u0015bAAkq\t1A+\u001e9mKJB\u0001\"!7\u001c\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a8\u0011\t\u0005\u001d\u0013\u0011]\u0005\u0005\u0003G\fIE\u0001\u0004PE*,7\r\u001e")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
scala.Serializable {
    private DataType internalDataType;
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final Expression left;
    private final Expression right;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect arrayIntersect) {
        return ArrayIntersect$.MODULE$.unapply(arrayIntersect);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.canUseSpecializedHashSet$lzycompute() : this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$72;
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.hsPostFix$lzycompute() : this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.hsTypeName$lzycompute() : this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.hsValueCast$lzycompute() : this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.nullValueHolder$lzycompute() : this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataTypeCheck();
                this.internalDataType = new ArrayType(this.elementType(), ((ArrayType)this.left().dataType()).containsNull() && ((ArrayType)this.right().dataType()).containsNull());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        int i;
                        OpenHashSet hs = new OpenHashSet(ClassTag$.MODULE$.Any());
                        OpenHashSet hsResult = new OpenHashSet(ClassTag$.MODULE$.Any());
                        boolean foundNullElement = false;
                        for (i = 0; i < array2.numElements(); ++i) {
                            if (array2.isNullAt(i)) {
                                foundNullElement = true;
                                continue;
                            }
                            Object elem = array2.get(i, this.elementType());
                            hs.add(elem);
                        }
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        for (i = 0; i < array1.numElements(); ++i) {
                            if (array1.isNullAt(i)) {
                                if (!foundNullElement) continue;
                                arrayBuffer.$plus$eq(null);
                                foundNullElement = false;
                                continue;
                            }
                            Object elem = array1.get(i, this.elementType());
                            if (!hs.contains(elem) || hsResult.contains(elem)) continue;
                            arrayBuffer.$plus$eq(elem);
                            hsResult.add(elem);
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer.toSeq());
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                } : (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        boolean alreadySeenNull = false;
                        for (int i = 0; i < array1.numElements(); ++i) {
                            boolean found = false;
                            Object elem1 = array1.get(i, this.elementType());
                            if (array1.isNullAt(i)) {
                                if (!alreadySeenNull) {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        found = array2.isNullAt(j);
                                    }
                                    alreadySeenNull = true;
                                }
                            } else {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    if (array2.isNullAt(j)) continue;
                                    Object elem2 = array2.get(j, this.elementType());
                                    if (!this.ordering().equiv(elem1, elem2)) continue;
                                    boolean foundArrayBuffer = false;
                                    for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                        Object va = arrayBuffer.apply(k);
                                        foundArrayBuffer = va != null && this.ordering().equiv(va, elem1);
                                    }
                                    found = !foundArrayBuffer;
                                }
                            }
                            Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer.toSeq());
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalIntersect;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.evalIntersect$lzycompute() : this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String foundNullElement = ctx.freshName("foundNullElement");
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = OpenHashSet.class.getName();
                String classTag = new StringBuilder(34).append("scala.reflect.ClassTag$.MODULE$.").append(this.hsTypeName()).append("()").toString();
                String hashSet = ctx.freshName("hashSet");
                String hashSetResult = ctx.freshName("hashSetResult");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = new StringBuilder(3).append(arrayBuilder).append("$of").append(ptName).toString();
                String writeArray2ToHashSet = this.withArray2NullCheck$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array2, i)).append(";\n             |").append(hashSet).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n           ").toString())).stripMargin(), (String)array2, i, foundNullElement);
                String processArray1 = this.withArray1NullAssignment$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(240).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array1, i)).append(";\n             |if (").append(hashSet).append(".contains(").append(this.hsValueCast()).append(value).append(") &&\n             |    !").append(hashSetResult).append(".contains(").append(this.hsValueCast()).append(value).append(")) {\n             |  if (++").append(size).append(" > ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(") {\n             |    break;\n             |  }\n             |  ").append(hashSetResult).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n             |  ").append(builder).append(".$plus$eq(").append(value).append(");\n             |}\n           ").toString())).stripMargin(), (String)array1, i, foundNullElement, nullElementIndex, size, builder);
                String declareNullTrackVariables = ((ArrayType)this.dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |boolean ").append(foundNullElement).append(" = false;\n             |int ").append(nullElementIndex).append(" = -1;\n           ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(292).append("\n           |").append(openHashSet).append(" ").append(hashSet).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(openHashSet).append(" ").append(hashSetResult).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(declareNullTrackVariables).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array2).append(".numElements(); ").append(i).append("++) {\n           |  ").append(writeArray2ToHashSet).append("\n           |}\n           |").append(arrayBuilderClass).append(" ").append(builder).append(" = new ").append(arrayBuilderClass).append("();\n           |int ").append(size).append(" = 0;\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array1).append(".numElements(); ").append(i).append("++) {\n           |  ").append(processArray1).append("\n           |}\n           |").append(this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex)).append("\n         ").toString())).stripMargin();
            });
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String expr = ctx.addReferenceObj("arrayIntersectExpr", this, ctx.addReferenceObj$default$3());
                return new StringBuilder(32).append(ev.value()).append(" = (ArrayData)").append(expr).append(".nullSafeEval(").append((String)array1).append(", ").append((String)array2).append(");").toString();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    @Override
    public ArrayIntersect withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    private final String withArray2NullCheck$1(String body, String array2$1, String i$5, String foundNullElement$4) {
        return ((ArrayType)this.right().dataType()).containsNull() ? (((ArrayType)this.left().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n                 |if (").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(foundNullElement$4).append(" = true;\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    private final String withArray1NullAssignment$1(String body, String array1$1, String i$5, String foundNullElement$4, String nullElementIndex$3, String size$3, String builder$3) {
        return ((ArrayType)this.left().dataType()).containsNull() ? (((ArrayType)this.right().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                 |if (").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  if (").append(foundNullElement$4).append(") {\n                 |    ").append(nullElementIndex$3).append(" = ").append(size$3).append(";\n                 |    ").append(foundNullElement$4).append(" = false;\n                 |    ").append(size$3).append("++;\n                 |    ").append(builder$3).append(".$plus$eq(").append(this.nullValueHolder()).append(");\n                 |  }\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

