/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0012%\u0001FB\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t'\u0002\u0011\t\u0012)A\u0005\t\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0011!I\u0007\u0001#b\u0001\n\u0003R\u0007\"\u0002<\u0001\t\u0003:\b\"B>\u0001\t\u0003b\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u0019I\u0003\u0001\"\u0011\u00022!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"!\u0019\u0001#\u0003%\t!a\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005m\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u0011%\t\t\nAA\u0001\n\u0003\t\u0019\nC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0001\u0002\u001e\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013Q\u0015\u0005\n\u0003g\u0003\u0011\u0011!C\u0001\u0003kC\u0011\"!/\u0001\u0003\u0003%\t%a/\b\u000f\u0005\u0015H\u0005#\u0001\u0002h\u001a11\u0005\nE\u0001\u0003SDaA\u0017\u000e\u0005\u0002\u0005E\bbBAz5\u0011\u0005\u0011Q\u001f\u0005\b\u0003wTB\u0011AA\u007f\u0011%\t\u0019PGA\u0001\n\u0003\u0013\t\u0001C\u0005\u0003\bi\t\n\u0011\"\u0001\u0002|!I!\u0011\u0002\u000e\u0002\u0002\u0013\u0005%1\u0002\u0005\n\u0005+Q\u0012\u0013!C\u0001\u0003wB\u0011Ba\u0006\u001b\u0003\u0003%IA!\u0007\u0003\u0011\r\u000b7/Z,iK:T!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001I2\u0014h\u0010\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\u0019t'\u0003\u00029I\ta2i\\7qY\u0016DH+\u001f9f\u001b\u0016\u0014x-\u001b8h\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u001eA\u0013\t\t5HA\u0004Qe>$Wo\u0019;\u0002\u0011\t\u0014\u0018M\\2iKN,\u0012\u0001\u0012\t\u0004\u000b6\u0003fB\u0001$L\u001d\t9%*D\u0001I\u0015\tI\u0005'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011AjO\u0001\ba\u0006\u001c7.Y4f\u0013\tquJA\u0002TKFT!\u0001T\u001e\u0011\ti\n&GM\u0005\u0003%n\u0012a\u0001V;qY\u0016\u0014\u0014!\u00032sC:\u001c\u0007.Z:!\u0003%)Gn]3WC2,X-F\u0001W!\rQtKM\u0005\u00031n\u0012aa\u00149uS>t\u0017AC3mg\u00164\u0016\r\\;fA\u00051A(\u001b8jiz\"2\u0001X/_!\t\u0019\u0004\u0001C\u0003C\u000b\u0001\u0007A\tC\u0004U\u000bA\u0005\t\u0019\u0001,\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u0019\t\u0004\u000b6\u0013\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\t\u0011D\rC\u0003f\u000f\u0001\u0007a-A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007cA#he%\u0011\u0001n\u0014\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001F5oaV$H+\u001f9fg\u001a{'/T3sO&tw-F\u0001l!\r)U\n\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_\"\nQ\u0001^=qKNL!!\u001d8\u0003\u0011\u0011\u000bG/\u0019+za\u0016D#\u0001C:\u0011\u0005i\"\u0018BA;<\u0005%!(/\u00198tS\u0016tG/\u0001\u0005ok2d\u0017M\u00197f+\u0005A\bC\u0001\u001ez\u0013\tQ8HA\u0004C_>dW-\u00198\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001M\u0005A\u0011M\\1msNL7/C\u0002\u0002\u0006}\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\f\u0005E\u0001c\u0001\u001e\u0002\u000e%\u0019\u0011qB\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0014-\u0001\n\u00111\u0001\u0002\u0016\u0005)\u0011N\u001c9viB!\u0011qCA\r\u001b\u00051\u0013bAA\u000eM\tY\u0011J\u001c;fe:\fGNU8x\u0003!!xn\u0015;sS:<GCAA\u0011!\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012q\u0005\t\u0003\u000fnJ1!!\u000b<\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011F\u001e\u0016\u0005\u0005\u0005\u0012\u0001F7vYRL'I]1oG\",7oQ8eK\u001e,g\u000e\u0006\u0004\u00028\u0005\r\u0013Q\n\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0013\u0002\u000f\r|G-Z4f]&!\u0011\u0011IA\u001e\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA#\u001d\u0001\u0007\u0011qI\u0001\u0004GRD\b\u0003BA\u001d\u0003\u0013JA!a\u0013\u0002<\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA(\u001d\u0001\u0007\u0011qG\u0001\u0003KZ\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005]\u0012QKA,\u0011\u001d\t)e\u0004a\u0001\u0003\u000fBq!a\u0014\u0010\u0001\u0004\t9$\u0001\u0003d_BLH#\u0002/\u0002^\u0005}\u0003b\u0002\"\u0011!\u0003\u0005\r\u0001\u0012\u0005\b)B\u0001\n\u00111\u0001W\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001a+\u0007\u0011\u000b9g\u000b\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C;oG\",7m[3e\u0015\r\t\u0019hO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA<\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!! +\u0007Y\u000b9'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003mC:<'BAAG\u0003\u0011Q\u0017M^1\n\t\u00055\u0012qQ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00032AOAL\u0013\r\tIj\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\ty\nC\u0005\u0002\"V\t\t\u00111\u0001\u0002\u0016\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a*\u0011\r\u0005%\u0016qVA\u0006\u001b\t\tYKC\u0002\u0002.n\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t,a+\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004q\u0006]\u0006\"CAQ/\u0005\u0005\t\u0019AA\u0006\u0003\u0019)\u0017/^1mgR\u0019\u00010!0\t\u0013\u0005\u0005\u0006$!AA\u0002\u0005-\u0001f\u0006\u0001\u0002B\u0006\u001d\u0017\u0011ZAg\u0003\u001f\f\u0019.!6\u0002Z\u0006m\u0017q\\Aq!\r\u0019\u00141Y\u0005\u0004\u0003\u000b$#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0017\f\u00111L\"B'\u0016\u0003s\u000bS#OA\u0015D\bO]\u0019!)\"+e\nI3yaJ\u0014\u0004eW,I\u000b:\u0003S\r\u001f9sg\u0001\"\u0006*\u0012(!Kb\u0004(\u000fN/+Am+EjU#!Kb\u0004(/N/!\u000b:#\u0005%\f\u0011XQ\u0016t\u0007\u0005Y3yaJ\f\u0004\rI\u001f!iJ,X\r\f\u0011sKR,(O\\:!A\u0016D\bO\u001d\u001aaw\u0001*Gn]3!o\",g\u000e\t1fqB\u00148\u0007\u0019\u0011>AQ\u0014X/\u001a\u0017!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:5An\u0002S\r\\:fAI,G/\u001e:og\u0002\u0002W\r\u001f9sk\u0001t\u0013!C1sOVlWM\u001c;tC\t\t\t.AA}\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9sg\u0001j\u0003\u0005\u001e5fA\t\u0014\u0018M\\2iA\r|g\u000eZ5uS>t\u0007%\u001a=qe\u0016\u001c8/[8og\u0002\u001a\bn\\;mI\u0002\nG\u000e\u001c\u0011cK\u0002\u0012wn\u001c7fC:\u0004C/\u001f9f])\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9se1\u0002S\r\u001f9si1\u0002S\r\u001f9sk\u0001j\u0003\u0005\u001e5fA\t\u0014\u0018M\\2iAY\fG.^3!Kb\u0004(/Z:tS>t7\u000fI1oI\u0002*Gn]3!m\u0006dW/\u001a\u0011fqB\u0014Xm]:j_:\u00043\u000f[8vY\u0012\u0004\u0013\r\u001c7!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011tC6,\u0007\u0005^=qK\u0002z'\u000fI2pKJ\u001c\u0017N\u00197fAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAl\u0003\t\u0015!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\"B'\u0016\u0003s\u000bS#OAE\u0002c\b\t\u0019!)\"+e\nI\u0019!/\"+e\n\t\u001a!}\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\u0012d\u0006\r\u0011F\u0019N+\u0005%\r\u00183A\u0015sEi\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001b\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011?AA\u0002C\u000bS#OAIr\u0003\u0007I#M'\u0016\u0003\u0013G\f\u001a!\u000b:#5H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033)Q*FA]CUI\u0014\u00112Aq\u0002\u0003\u0007\t+I\u000b:\u0003\u0013\u0007I,I\u000b:\u0003#\u0007\t\u001f!a\u0001\"\u0006*\u0012(!e9\u0002\u0004%\u0012(Ew)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa]5oG\u0016\f#!!8\u0002\u000bEr\u0003GL\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0018!E2p]\u0012LG/[8oC2|f-\u001e8dg\u0006A1)Y:f/\",g\u000e\u0005\u000245M!!$a;:!\rQ\u0014Q^\u0005\u0004\u0003_\\$AB!osJ+g\r\u0006\u0002\u0002h\u0006)\u0011\r\u001d9msR)A,a>\u0002z\")!\t\ba\u0001\t\")A\u000b\ba\u0001e\u0005\u00012M]3bi\u00164%o\\7QCJ\u001cXM\u001d\u000b\u00049\u0006}\b\"\u0002\"\u001e\u0001\u0004\tG#\u0002/\u0003\u0004\t\u0015\u0001\"\u0002\"\u001f\u0001\u0004!\u0005b\u0002+\u001f!\u0003\u0005\rAV\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003\u0002B\u0007\u0005#\u0001BAO,\u0003\u0010A!!(\u0015#W\u0011!\u0011\u0019\u0002IA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0004\t\u0005\u0003\u000b\u0013i\"\u0003\u0003\u0003 \u0005\u001d%AB(cU\u0016\u001cG\u000f")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
scala.Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1 & Serializable & scala.Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return super.legacyWithNewChildren(newChildren);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$3 -> ((Expression)x$3._2()).dataType(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType())), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return !this.bitmap$trans$0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$5))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$1(x$7)))) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$8)));
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(94).append("WHEN expressions in CaseWhen should all be boolean type, ").append("but the ").append(index + 1).append("th when expression's type is ").append(((Tuple2)this.branches().apply(index))._1()).toString());
            }
        } else {
            String branchesStr = ((TraversableOnce)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$9 -> ((Expression)x$9._2()).dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dt -> new StringBuilder(14).append("WHEN ... THEN ").append(dt.catalogString()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" ");
            String elseStr = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)expr -> new StringBuilder(6).append(" ELSE ").append(expr.dataType().catalogString()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(94).append("THEN and ELSE expressions should all be same type or coercible to a common type,").append(" got CASE ").append(branchesStr).append(elseStr).append(" END").toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(6).append(" ELSE ").append(x$10).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$11 -> new StringBuilder(6).append(" ELSE ").append(x$11.sql()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression condExpr = (Expression)tuple2._1();
            Expression valueExpr = (Expression)tuple2._2();
            ExprCode cond = condExpr.genCode(ctx);
            ExprCode res = valueExpr.genCode(ctx);
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1 & Serializable & scala.Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString())).stripMargin();
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)func -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString())).stripMargin();
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)x$12 -> ((TraversableOnce)x$12.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, x$2, x$6, x$3, (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.branches().length() == 1 ? new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev) : this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Tuple2<Expression, Expression>> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.branches();
                break;
            }
            case 1: {
                seq = this.elseValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$5) {
        return ((Expression)x$5._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(Tuple2 x$7) {
        DataType dataType = ((Expression)x$7._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$8) {
        DataType dataType = ((Expression)x$8._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
    }
}

