/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ew!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002-\u0002\t\u0003I\u0006bB/\u0002\u0003\u0003%\tI\u0018\u0005\n\u0003w\u000b\u0011\u0011!CA\u0003{C\u0011\"a4\u0002\u0003\u0003%I!!5\u0007\t=\u0002\u0003\t\u0019\u0005\t7\"\u0011)\u001a!C\u0001U\"A1\u000e\u0003B\tB\u0003%a\b\u0003\u0005P\u0011\tU\r\u0011\"\u0001k\u0011!a\u0007B!E!\u0002\u0013q\u0004\u0002C7\t\u0005+\u0007I\u0011\u00016\t\u00119D!\u0011#Q\u0001\nyBQA\u000f\u0005\u0005\u0002=DQA\u000f\u0005\u0005\u0002MDQA\u001e\u0005\u0005B]Dq!!\u0003\t\t\u0003\nY\u0001C\u0004\u0002\u0014!!\t%!\u0006\t\u000f\u0005]\u0001\u0002\"\u0015\u0002\u001a!I\u0011q\u0004\u0005\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003SA\u0011\u0013!C\u0001\u0003WA\u0011\"!\u0011\t#\u0003%\t!a\u000b\t\u0013\u0005\r\u0003\"%A\u0005\u0002\u0005-\u0002\"CA#\u0011\u0005\u0005I\u0011IA$\u0011%\t9\u0006CA\u0001\n\u0003\tI\u0006C\u0005\u0002b!\t\t\u0011\"\u0001\u0002d!I\u0011\u0011\u000e\u0005\u0002\u0002\u0013\u0005\u00131\u000e\u0005\n\u0003oB\u0011\u0011!C\u0001\u0003sB\u0011\"a!\t\u0003\u0003%\t%!\"\u0002\u0011\u0011\u000bG/\u001a)beRT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0005i\u0011\u0001\t\u0002\t\t\u0006$X\rU1siN\u0019\u0011!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\t\u0011\u0004(\u0003\u0002:g\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012!L\u0001\u0012a\u0006\u00148/Z#yiJ\f7\r\u001e$jK2$G\u0003\u0002 B\u001dB\u0003\"AL \n\u0005\u0001\u0003#AC#yaJ,7o]5p]\")!i\u0001a\u0001\u0007\u0006aQ\r\u001f;sC\u000e$h)[3mIB\u0011Ai\u0013\b\u0003\u000b&\u0003\"AR\u001a\u000e\u0003\u001dS!\u0001\u0013\u0017\u0002\rq\u0012xn\u001c;?\u0013\tQ5'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u0013aa\u0015;sS:<'B\u0001&4\u0011\u0015y5\u00011\u0001?\u0003\u0019\u0019x.\u001e:dK\"1\u0011k\u0001CA\u0002I\u000bq\"\u001a:s_JD\u0015M\u001c3mK\u001a+hn\u0019\t\u0004eM+\u0016B\u0001+4\u0005!a$-\u001f8b[\u0016t\u0004C\u0001\u001aW\u0013\t96GA\u0004O_RD\u0017N\\4\u0002!Q|W)];jm\u0006dWM\u001c;FqB\u0014Hc\u0001 [9\")1\f\u0002a\u0001}\u0005)a-[3mI\")q\n\u0002a\u0001}\u0005)\u0011\r\u001d9msR9q,!.\u00028\u0006e\u0006C\u0001\u0018\t'\u0015A\u0011\rZ48!\tq#-\u0003\u0002dA\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/K&\u0011a\r\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00023Q&\u0011\u0011n\r\u0002\b!J|G-^2u+\u0005q\u0014A\u00024jK2$\u0007%A\u0004t_V\u00148-\u001a\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0002\r\rD\u0017\u000e\u001c3!)\u0011y\u0006/\u001d:\t\u000bm{\u0001\u0019\u0001 \t\u000b={\u0001\u0019\u0001 \t\u000b5|\u0001\u0019\u0001 \u0015\u0007}#X\u000fC\u0003\\!\u0001\u0007a\bC\u0003P!\u0001\u0007a(A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0002qB!\u0011P`A\u0002\u001d\tQHP\u0004\u0002Gw&\tA'\u0003\u0002~g\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\tA\u0011\n^3sCR|'O\u0003\u0002~gA\u0019!'!\u0002\n\u0007\u0005\u001d1GA\u0002B]f\fQ\"\u001a=qeN\u0014V\r\u001d7bG\u0016$WCAA\u0007!\u0011I\u0018q\u0002 \n\t\u0005E\u0011\u0011\u0001\u0002\u0004'\u0016\f\u0018A\u00039sKR$\u0018PT1nKV\t1)\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004?\u0006m\u0001BBA\u000f)\u0001\u0007a(\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000f}\u000b\u0019#!\n\u0002(!91,\u0006I\u0001\u0002\u0004q\u0004bB(\u0016!\u0003\u0005\rA\u0010\u0005\b[V\u0001\n\u00111\u0001?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\u0007y\nyc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tYdM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003mC:<'BAA*\u0003\u0011Q\u0017M^1\n\u00071\u000bi%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\\A\u0019!'!\u0018\n\u0007\u0005}3GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0005\u0015\u0004\"CA47\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(a\u0001\u000e\u0005\u0005E$bAA:g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007}\f\t(\u0001\u0005dC:,\u0015/^1m)\u0011\tY(!!\u0011\u0007I\ni(C\u0002\u0002\u0000M\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002hu\t\t\u00111\u0001\u0002\u0004\u00051Q-];bYN$B!a\u001f\u0002\b\"I\u0011q\r\u0010\u0002\u0002\u0003\u0007\u00111\u0001\u0015\u001c\u0011\u0005-\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u000by+!-\u0011\u00079\ni)C\u0002\u0002\u0010\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0016\u0006\tvLR+O\u0007~Cc-[3mI2\u00023o\\;sG\u0016L\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!g>,(oY3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u001c\u0006\u0011\tC\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M&,G\u000e\u001a\u0011.AM,G.Z2ug\u0002:\b.[2iAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*\u0007\u0010\u001e:bGR,G\r\f\u0011b]\u0012\u00043/\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011be\u0016\u0004\u0013m\u001d\u0011tC6,\u0007%Y:!i\",\u0007EZ5fY\u0012\u001c\be\u001c4!i\",\u0007%Z9vSZ\fG.\u001a8uA\u0019,hn\u0019;j_:\u0004\u0003-\u0012-U%\u0006\u001bE\u000b\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM|WO]2fA5\u0002\u0013\r\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002Jg\u000e^3sm\u0006d\u0007eY8mk6t\u0007E\u001a:p[\u0002:\b.\u001a:fA\u00014\u0017.\u001a7eA\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3e\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0016\u0001\"\u0001\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dJV)\u0011*(Y\u0001\"\u0016*T#T)\u0006k\u0005\u000bI\u00143aEJT\u0006\r\u001d.cI\u0002\u0003'\r\u001e1ai\u0002\u0004GL\u00193gQ*dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O],Wm[\u0014-AQLW.Z:uC6\u0004xE\r\u00192s5\u0002\u0004(L\u00193AA\n$\b\r\u0019;aAr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005Z8zO1\u0002C)\u0011+FOI\u0002\u0014'O\u00171q5\n$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0012DG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('\u0016\u001buJ\u0014#TO1\u0002C/[7fgR\fW\u000e]\u00143aEJT&\r\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0014G\f\u00191aA\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003\u0007\r\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n3bsN<C\u0006I5oi\u0016\u0014h/\u00197!c\u0001JX-\u0019:!cA\u0002Sn\u001c8uQN\u0004S\u0007\t3bsNL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001aXmY8oIN<C\u0006I5oi\u0016\u0014h/\u00197!k\u0001Bw.\u001e:tAM\u0002\u0004e]3d_:$7\u000fI\u0019![&dG.[:fG>tGm\u001d\u00112A5L7M]8tK\u000e|g\u000eZ:*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0004G\f\u00191cA\u0002\u0014G\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\u001d\u0016a\u0019\u0006!A\u0001\u0002C\u000b[3!?\u001a+fjQ0!MVt7\r^5p]\u0002J7\u000fI3rk&4\u0018\r\\3oi\u0002\"x\u000e\t;iK\u0002\u001a\u0016\u000bT\u0017ti\u0006tG-\u0019:eA\u0019,hn\u0019;j_:\u0004\u0003-\u0012-U%\u0006\u001bE\u000b\u000b4jK2$\u0007E\u0012*P\u001b\u0002\u001ax.\u001e:dK&\u0002'\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u00055\u0016A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003g\u000bQa\r\u00181]ABQaW\u0003A\u0002yBQaT\u0003A\u0002yBQ!\\\u0003A\u0002y\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002@\u0006-\u0007#\u0002\u001a\u0002B\u0006\u0015\u0017bAAbg\t1q\n\u001d;j_:\u0004bAMAd}yr\u0014bAAeg\t1A+\u001e9mKNB\u0001\"!4\u0007\u0003\u0003\u0005\raX\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a5\u0011\t\u0005-\u0013Q[\u0005\u0005\u0003/\fiE\u0001\u0004PE*,7\r\u001e")
public class DatePart
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(DatePart datePart) {
        return DatePart$.MODULE$.unapply(datePart);
    }

    public static Expression toEquivalentExpr(Expression expression, Expression expression2) {
        return DatePart$.MODULE$.toEquivalentExpr(expression, expression2);
    }

    public static Expression parseExtractField(String string, Expression expression, Function0<Nothing$> function0) {
        return DatePart$.MODULE$.parseExtractField(string, expression, function0);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        DatePart datePart = this;
        synchronized (datePart) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String prettyName() {
        return "date_part";
    }

    @Override
    public DatePart withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public DatePart copy(Expression field, Expression source, Expression child) {
        return new DatePart(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "DatePart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePart)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePart datePart = (DatePart)x$1;
        Expression expression = this.field();
        Expression expression2 = datePart.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = datePart.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = datePart.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!datePart.canEqual(this)) return false;
        return true;
    }

    public DatePart(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public DatePart(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

