/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ", since="1.1.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u000e\u001d\u0001&B\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!AQ\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005?\u0001\tE\t\u0015!\u0003:\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015\u0001\b\u0001\"\u0015r\u0011\u001d1\b!!A\u0005\u0002]DqA\u001f\u0001\u0012\u0002\u0013\u00051\u0010\u0003\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001|\u0011%\ty\u0001AA\u0001\n\u0003\n\t\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003kA\u0011\"a\u0011\u0001\u0003\u0003%\t!!\u0012\t\u0013\u0005%\u0003!!A\u0005B\u0005-s!CA;9\u0005\u0005\t\u0012AA<\r!YB$!A\t\u0002\u0005e\u0004BB \u0016\t\u0003\t9\tC\u0005\u0002\nV\t\t\u0011\"\u0012\u0002\f\"I\u0011QR\u000b\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003++\u0012\u0011!CA\u0003/C\u0011\"!+\u0016\u0003\u0003%I!a+\u0003\u001b\u0015\u000bX/\u00197Ok2d7+\u00194f\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+]Q\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003!\tKg.\u0019:z\u0007>l\u0007/\u0019:jg>t\u0007CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$a\u0002)s_\u0012,8\r\u001e\t\u0003_UJ!A\u000e\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002sA\u00111FO\u0005\u0003wq\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2!\u0011\"D!\tY\u0003\u0001C\u00038\u000b\u0001\u0007\u0011\bC\u0003>\u000b\u0001\u0007\u0011(\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002\rB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013\u0019\u000e\u0003)S!a\u0013\u0015\u0002\rq\u0012xn\u001c;?\u0013\ti\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'1\u0003!qW\u000f\u001c7bE2,W#A*\u0011\u0005=\"\u0016BA+1\u0005\u001d\u0011un\u001c7fC:\fA!\u001a<bYR\u0011\u0001l\u0017\t\u0003_eK!A\u0017\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004]\u0011A\u0005\t\u0019A/\u0002\u000b%t\u0007/\u001e;\u0011\u0005y{V\"\u0001\u0010\n\u0005\u0001t\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\rLg\u000e\u0005\u0002eO6\tQM\u0003\u0002g9\u000591m\u001c3fO\u0016t\u0017B\u00015f\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00026\n\u0001\u0004Y\u0017aA2uqB\u0011A\r\\\u0005\u0003[\u0016\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003p\u0013\u0001\u00071-\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0003J$\b\"B:\u000b\u0001\u0004I\u0014a\u00028fo2+g\r\u001e\u0005\u0006k*\u0001\r!O\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\r\t\u00050\u001f\u0005\bo-\u0001\n\u00111\u0001:\u0011\u001di4\u0002%AA\u0002e\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001}U\tITpK\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f\u0001\u0014AC1o]>$\u0018\r^5p]&!\u00111BA\u0001\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006L1aTA\f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0003E\u00020\u0003OI1!!\u000b1\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rA\u0016q\u0006\u0005\n\u0003c\u0001\u0012\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001c!\u0015\tI$a\u0010Y\u001b\t\tYDC\u0002\u0002>A\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004'\u0006\u001d\u0003\u0002CA\u0019%\u0005\u0005\t\u0019\u0001-\u0002\r\u0015\fX/\u00197t)\r\u0019\u0016Q\n\u0005\t\u0003c\u0019\u0012\u0011!a\u00011\":\u0002!!\u0015\u0002X\u0005e\u0013QLA0\u0003G\n)'!\u001b\u0002l\u0005=\u0014\u0011\u000f\t\u0004W\u0005M\u0013bAA+9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA.\u0003\u0005]#\u0002\t\u0011!A\u0015D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\u001a\u0018-\\3!e\u0016\u001cX\u000f\u001c;!CN\u0004C\u000f[3!\u000bF+\u0016\t\u0014\u0015>S\u0001z\u0007/\u001a:bi>\u0014\bEZ8sA9|g.\f8vY2\u0004s\u000e]3sC:$7\u000f\f\u0006!A\u0001\u0002\u0003\u0005\t2vi\u0002\u0012X\r^;s]N\u0004CO];fA%4\u0007EY8uQ\u0002\n'/\u001a\u0011ok2dG\u0006\t4bYN,\u0007%\u001b4!_:,\u0007e\u001c4!i\",\u0007\u0005\u001e5f[\u0002J7\u000f\t8vY2t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA1\u0003\tu#\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!S:\u0004S-];bY&$\u0018\u0010I2p[B\f'/[:p]:\u0002S*\u00199!if\u0004X\rI5tA9|G\u000fI:vaB|'\u000f^3e])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti\u0002\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9'AA=\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;sk\u0016\u0004sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002rU\u000b\u0014'!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0014!B\u0019/c9\u0002\u0014!B4s_V\u0004\u0018EAA:\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018!D#rk\u0006dg*\u001e7m'\u00064W\r\u0005\u0002,+M!Q#a\u001f5!\u001d\ti(a!:s\u0005k!!a \u000b\u0007\u0005\u0005\u0005'A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0015q\u0010\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA<\u0003!!xn\u0015;sS:<GCAA\n\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\t\u0015\u0011SAJ\u0011\u00159\u0004\u00041\u0001:\u0011\u0015i\u0004\u00041\u0001:\u0003\u001d)h.\u00199qYf$B!!'\u0002&B)q&a'\u0002 &\u0019\u0011Q\u0014\u0019\u0003\r=\u0003H/[8o!\u0015y\u0013\u0011U\u001d:\u0013\r\t\u0019\u000b\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d\u0016$!AA\u0002\u0005\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0006\u0003BA\u000b\u0003_KA!!-\u0002\u0018\t1qJ\u00196fGR\u0004")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public EqualNullSafe withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

