/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.JsonPathParser$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Key$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Subscript$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Wildcard$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$FlattenStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$QuotedStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$RawStyle$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ", group="json_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011I\u0011\u0015)\u0006\u0001\"\u0011I\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\t\b\u0001\"\u0011s\u0011!Y\b\u0001#b\u0001\n\u0013a\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002\u0012\u0002!\t&a%\t\u0013\u0005u\u0005!!A\u0005\u0002\u0005}\u0005\"CAS\u0001E\u0005I\u0011AAT\u0011%\ti\fAI\u0001\n\u0003\t9\u000bC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u0011\u0011\u001b\u0001\u0002\u0002\u0013\u0005\u00111\u001b\u0005\n\u00037\u0004\u0011\u0011!C\u0001\u0003;D\u0011\"a9\u0001\u0003\u0003%\t%!:\t\u0013\u0005M\b!!A\u0005\u0002\u0005U\b\"CA}\u0001\u0005\u0005I\u0011IA~\u000f%\u0011ybIA\u0001\u0012\u0003\u0011\tC\u0002\u0005#G\u0005\u0005\t\u0012\u0001B\u0012\u0011\u0019yE\u0004\"\u0001\u00032!I!1\u0007\u000f\u0002\u0002\u0013\u0015#Q\u0007\u0005\n\u0005oa\u0012\u0011!CA\u0005sA\u0011Ba\u0010\u001d\u0003\u0003%\tI!\u0011\t\u0013\t=C$!A\u0005\n\tE#!D$fi*\u001bxN\\(cU\u0016\u001cGO\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011'\u000e\u001d?\tB\u0011!gM\u0007\u0002G%\u0011Ag\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\r\u001c\n\u0005]\u001a#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\bP\u0007\u0002u)\u00111hI\u0001\bG>$WmZ3o\u0013\ti$HA\bD_\u0012,w-\u001a8GC2d'-Y2l!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u001d\u0001&o\u001c3vGR\u0004\"aP#\n\u0005\u0019\u0003%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00026t_:,\u0012!\u0013\t\u0003e)K!aS\u0012\u0003\u0015\u0015C\bO]3tg&|g.A\u0003kg>t\u0007%\u0001\u0003qCRD\u0017!\u00029bi\"\u0004\u0013A\u0002\u001fj]&$h\bF\u0002R%N\u0003\"A\r\u0001\t\u000b\u001d+\u0001\u0019A%\t\u000b5+\u0001\u0019A%\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001-\u0011\u0007e\u000bGM\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011QlL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!\u0001\u0019!\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\u0004'\u0016\f(B\u00011A!\t)\u0007.D\u0001g\u0015\t9w%A\u0003usB,7/\u0003\u0002jM\nAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005!\u0017\u0001\u00038vY2\f'\r\\3\u0016\u00039\u0004\"aP8\n\u0005A\u0004%a\u0002\"p_2,\u0017M\\\u0001\u000baJ,G\u000f^=OC6,W#A:\u0011\u0005QDhBA;w!\tY\u0006)\u0003\u0002x\u0001\u00061\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9\b)\u0001\u0006qCJ\u001cX\r\u001a)bi\",\u0012! \t\u0005\u007fy\f\t!\u0003\u0002\u0000\u0001\n1q\n\u001d;j_:\u0004R!WA\u0002\u0003\u000fI1!!\u0002d\u0005\u0011a\u0015n\u001d;\u0011\u0007I\nI!C\u0002\u0002\f\r\u0012q\u0002U1uQ&s7\u000f\u001e:vGRLwN\u001c\u0015\u0004\u0019\u0005=\u0001cA \u0002\u0012%\u0019\u00111\u0003!\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001B3wC2$B!!\u0007\u0002 A\u0019q(a\u0007\n\u0007\u0005u\u0001IA\u0002B]fD\u0011\"!\t\u000e!\u0003\u0005\r!a\t\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\u0015\u0012qE\u0007\u0002K%\u0019\u0011\u0011F\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\na\u0006\u00148/\u001a)bi\"$2!`A\u0018\u0011\u0019ie\u00021\u0001\u00022A!\u00111GA\u001e\u001b\t\t)DC\u0002h\u0003oQ1!!\u000f*\u0003\u0019)hn]1gK&!\u0011QHA\u001b\u0005))FK\u0012\u001dTiJLgnZ\u0001\u000bCJ\u0014\u0018-_%oI\u0016DHCBA\"\u0003\u001f\nY\u0007\u0005\u0004@\u0003\u000b\nIE\\\u0005\u0004\u0003\u000f\u0002%!\u0003$v]\u000e$\u0018n\u001c82!\ry\u00141J\u0005\u0004\u0003\u001b\u0002%\u0001\u0002'p]\u001eDq!!\u0015\u0010\u0001\u0004\t\u0019&A\u0001q!\u0011\t)&a\u001a\u000e\u0005\u0005]#\u0002BA-\u00037\nAaY8sK*!\u0011QLA0\u0003\u001dQ\u0017mY6t_:TA!!\u0019\u0002d\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003K\n1aY8n\u0013\u0011\tI'a\u0016\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0004\u0002n=\u0001\r!a\u001c\u0002\u0003\u0019\u0004BaPA9]&\u0019\u00111\u000f!\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001D3wC2,\u0018\r^3QCRDG#\u00038\u0002z\u0005m\u0014QQAH\u0011\u001d\t\t\u0006\u0005a\u0001\u0003'Bq!! \u0011\u0001\u0004\ty(A\u0001h!\u0011\t)&!!\n\t\u0005\r\u0015q\u000b\u0002\u000e\u0015N|gnR3oKJ\fGo\u001c:\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002\n\u0006)1\u000f^=mKB\u0019!'a#\n\u0007\u000555E\u0001\u0006Xe&$Xm\u0015;zY\u0016Da!\u0014\tA\u0002\u0005\u0005\u0011aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\t\u0016QSAM\u0011\u0019\t9*\u0005a\u0001\u0013\u00069a.Z<MK\u001a$\bBBAN#\u0001\u0007\u0011*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bE\u000b\t+a)\t\u000f\u001d\u0013\u0002\u0013!a\u0001\u0013\"9QJ\u0005I\u0001\u0002\u0004I\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SS3!SAVW\t\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\u0013Ut7\r[3dW\u0016$'bAA\\\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0016\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0006!!.\u0019<b\u0013\rI\u0018qY\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00042aPAl\u0013\r\tI\u000e\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\ty\u000eC\u0005\u0002b^\t\t\u00111\u0001\u0002V\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a:\u0011\r\u0005%\u0018q^A\r\u001b\t\tYOC\u0002\u0002n\u0002\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t0a;\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004]\u0006]\b\"CAq3\u0005\u0005\t\u0019AA\r\u0003\u0019)\u0017/^1mgR\u0019a.!@\t\u0013\u0005\u0005($!AA\u0002\u0005e\u0001f\u0005\u0001\u0003\u0002\t\u001d!\u0011\u0002B\u0007\u0005\u001f\u0011\u0019B!\u0006\u0003\u001a\tm\u0001c\u0001\u001a\u0003\u0004%\u0019!QA\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1B\u0001=?\u001a+fjQ0)UN|gn\u0018;yi2\u0002\u0003/\u0019;iS\u0001j\u0003%\u0012=ue\u0006\u001cGo\u001d\u0011bA)\u001cxN\u001c\u0011pE*,7\r\u001e\u0011ge>l\u0007\u0005\u00199bi\"\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t\"A#\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ(%\u0019\u0012;E\t\u0014Sp\n\u0017!O\u0011r\u0013mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\tT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005/\t!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011i\"A\u00032]Ur\u0003'A\u0007HKRT5o\u001c8PE*,7\r\u001e\t\u0003eq\u0019B\u0001\bB\u0013\tB9!q\u0005B\u0017\u0013&\u000bVB\u0001B\u0015\u0015\r\u0011Y\u0003Q\u0001\beVtG/[7f\u0013\u0011\u0011yC!\u000b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003\"\u0005AAo\\*ue&tw\r\u0006\u0002\u0002D\u0006)\u0011\r\u001d9msR)\u0011Ka\u000f\u0003>!)qi\ba\u0001\u0013\")Qj\ba\u0001\u0013\u00069QO\\1qa2LH\u0003\u0002B\"\u0005\u0017\u0002Ba\u0010@\u0003FA)qHa\u0012J\u0013&\u0019!\u0011\n!\u0003\rQ+\b\u000f\\33\u0011!\u0011i\u0005IA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0006\u0005\u0003\u0002F\nU\u0013\u0002\u0002B,\u0003\u000f\u0014aa\u00142kK\u000e$\b")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient Option<List<PathInstruction>> parsedPath;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject getJsonObject) {
        return GetJsonObject$.MODULE$.unapply(getJsonObject);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private Option<List<PathInstruction>> parsedPath$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.parsedPath = this.parsePath((UTF8String)this.path().eval(this.path().eval$default$1()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.parsedPath;
    }

    private Option<List<PathInstruction>> parsedPath() {
        return !this.bitmap$trans$0 ? this.parsedPath$lzycompute() : this.parsedPath;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Option<List<PathInstruction>> parsed;
        UTF8String jsonStr = (UTF8String)this.json().eval(input);
        if (jsonStr == null) {
            return null;
        }
        Option<List<PathInstruction>> option = parsed = this.path().foldable() ? this.parsedPath() : this.parsePath((UTF8String)this.path().eval(input));
        if (parsed.isDefined()) {
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), jsonStr), (Function1 & Serializable & scala.Serializable)parser -> {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    boolean matched = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> BoxesRunTime.boxToBoolean((boolean)GetJsonObject.$anonfun$eval$4(this, parser, parsed, generator))));
                    return matched ? UTF8String.fromBytes((byte[])output.toByteArray()) : null;
                });
            }
            catch (JsonProcessingException jsonProcessingException) {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private Option<List<PathInstruction>> parsePath(UTF8String path) {
        return path != null ? JsonPathParser$.MODULE$.parse(path.toString()) : None$.MODULE$;
    }

    private Function1<Object, Object> arrayIndex(JsonParser p, Function0<Object> f) {
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x0$1 -> {
            boolean bl;
            long l = x0$1;
            JsonToken jsonToken = p.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                bl = false;
            } else if (0L == l) {
                boolean dirty = f.apply$mcZ$sp();
                while (true) {
                    JsonToken jsonToken3 = p.nextToken();
                    JsonToken jsonToken4 = JsonToken.END_ARRAY;
                    if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
                    p.skipChildren();
                }
                bl = dirty;
            } else if (l > 0L) {
                p.skipChildren();
                p.nextToken();
                bl = this.arrayIndex(p, f).apply$mcZJ$sp(l - 1L);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            return bl;
        };
    }

    private boolean evaluatePath(JsonParser p, JsonGenerator g, WriteStyle style, List<PathInstruction> path) {
        boolean bl;
        block56: {
            while (true) {
                List list;
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)p.getCurrentToken(), path)) != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list2 = (List)tuple2._2();
                    if (JsonToken.VALUE_STRING.equals(jsonToken) && Nil$.MODULE$.equals(list2)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$RawStyle$ writeStyle$RawStyle$ = WriteStyle$RawStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$RawStyle$) : writeStyle$RawStyle$ != null)) {
                            if (p.hasTextCharacters()) {
                                g.writeRaw(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                            } else {
                                g.writeRaw(p.getText());
                            }
                            bl = true;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list3 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && Nil$.MODULE$.equals(list3)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$FlattenStyle$ writeStyle$FlattenStyle$ = WriteStyle$FlattenStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$FlattenStyle$) : writeStyle$FlattenStyle$ != null)) {
                            boolean dirty = false;
                            while (true) {
                                JsonToken jsonToken2 = p.nextToken();
                                JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                if (!(jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3))) break;
                                dirty |= this.evaluatePath(p, g, style, (List<PathInstruction>)Nil$.MODULE$);
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null && Nil$.MODULE$.equals(list = (List)tuple2._2())) {
                    g.copyCurrentStructure(p);
                    bl = true;
                    break block56;
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list4 = (List)tuple2._2();
                    if (JsonToken.START_OBJECT.equals(jsonToken) && list4 instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list4;
                        PathInstruction pathInstruction = (PathInstruction)colon2.head();
                        List xs = colon2.tl$access$1();
                        if (PathInstruction$Key$.MODULE$.equals(pathInstruction)) {
                            boolean dirty = false;
                            while (true) {
                                JsonParser jsonParser;
                                JsonToken jsonToken4 = p.nextToken();
                                JsonToken jsonToken5 = JsonToken.END_OBJECT;
                                if (!(jsonToken4 == null ? jsonToken5 != null : !jsonToken4.equals(jsonToken5))) break;
                                if (dirty) {
                                    jsonParser = p.skipChildren();
                                    continue;
                                }
                                dirty = this.evaluatePath(p, g, style, (List<PathInstruction>)xs);
                                jsonParser = BoxedUnit.UNIT;
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list5 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list5 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list5;
                        PathInstruction pathInstruction = (PathInstruction)colon3.head();
                        List list6 = colon3.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list6 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list6;
                            PathInstruction pathInstruction2 = (PathInstruction)colon4.head();
                            List list7 = colon4.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction2) && list7 instanceof .colon.colon) {
                                .colon.colon colon5 = (.colon.colon)list7;
                                PathInstruction pathInstruction3 = (PathInstruction)colon5.head();
                                List list8 = colon5.tl$access$1();
                                if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction3) && list8 instanceof .colon.colon) {
                                    .colon.colon colon6 = (.colon.colon)list8;
                                    PathInstruction pathInstruction4 = (PathInstruction)colon6.head();
                                    List xs = colon6.tl$access$1();
                                    if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction4)) {
                                        boolean dirty = false;
                                        g.writeStartArray();
                                        while (true) {
                                            JsonToken jsonToken6 = p.nextToken();
                                            JsonToken jsonToken7 = JsonToken.END_ARRAY;
                                            if (!(jsonToken6 == null ? jsonToken7 != null : !jsonToken6.equals(jsonToken7))) break;
                                            dirty |= this.evaluatePath(p, g, WriteStyle$FlattenStyle$.MODULE$, (List<PathInstruction>)xs);
                                        }
                                        g.writeEndArray();
                                        bl = dirty;
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list9 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list9 instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list9;
                        PathInstruction pathInstruction = (PathInstruction)colon7.head();
                        List list10 = colon7.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list10 instanceof .colon.colon) {
                            .colon.colon colon8 = (.colon.colon)list10;
                            PathInstruction pathInstruction5 = (PathInstruction)colon8.head();
                            List xs = colon8.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction5)) {
                                WriteStyle writeStyle = style;
                                WriteStyle$QuotedStyle$ writeStyle$QuotedStyle$ = WriteStyle$QuotedStyle$.MODULE$;
                                if (writeStyle == null ? writeStyle$QuotedStyle$ != null : !writeStyle.equals(writeStyle$QuotedStyle$)) {
                                    WriteStyle writeStyle2;
                                    WriteStyle writeStyle3 = style;
                                    if (WriteStyle$RawStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$QuotedStyle$.MODULE$;
                                    } else if (WriteStyle$FlattenStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$FlattenStyle$.MODULE$;
                                    } else {
                                        if (WriteStyle$QuotedStyle$.MODULE$.equals(writeStyle3)) {
                                            throw new IllegalStateException();
                                        }
                                        throw new MatchError((Object)writeStyle3);
                                    }
                                    WriteStyle$QuotedStyle$ nextStyle = writeStyle2;
                                    StringWriter buffer = new StringWriter();
                                    IntRef dirty = IntRef.create((int)0);
                                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((Writer)buffer), (Function1 & Serializable & scala.Serializable)flattenGenerator -> {
                                        GetJsonObject.$anonfun$evaluatePath$2(this, p, dirty, nextStyle, xs, flattenGenerator);
                                        return BoxedUnit.UNIT;
                                    });
                                    StringBuffer buf = buffer.getBuffer();
                                    if (dirty.elem > 1) {
                                        g.writeRawValue(buf.toString());
                                    } else if (dirty.elem == 1) {
                                        g.writeRawValue(buf.substring(1, buf.length() - 1));
                                    }
                                    bl = dirty.elem > 0;
                                    break block56;
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list11 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list11 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list11;
                        PathInstruction pathInstruction = (PathInstruction)colon9.head();
                        List list12 = colon9.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list12 instanceof .colon.colon) {
                            .colon.colon colon10 = (.colon.colon)list12;
                            PathInstruction pathInstruction6 = (PathInstruction)colon10.head();
                            List xs = colon10.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction6)) {
                                boolean dirty = false;
                                g.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken8 = p.nextToken();
                                    JsonToken jsonToken9 = JsonToken.END_ARRAY;
                                    if (!(jsonToken8 == null ? jsonToken9 != null : !jsonToken8.equals(jsonToken9))) break;
                                    dirty |= this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)xs);
                                }
                                g.writeEndArray();
                                bl = dirty;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list13 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list13 instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list13;
                        PathInstruction pathInstruction = (PathInstruction)colon11.head();
                        List list14 = colon11.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list14 instanceof .colon.colon) {
                            .colon.colon colon12 = (.colon.colon)list14;
                            PathInstruction pathInstruction7 = (PathInstruction)colon12.head();
                            List xs = colon12.tl$access$1();
                            if (pathInstruction7 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction7;
                                long idx = index.index();
                                if (xs instanceof .colon.colon) {
                                    .colon.colon colon13;
                                    PathInstruction pathInstruction8;
                                    .colon.colon colon14 = (.colon.colon)xs;
                                    PathInstruction pathInstruction9 = (PathInstruction)colon14.head();
                                    List list15 = colon14.tl$access$1();
                                    if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction9) && list15 instanceof .colon.colon && PathInstruction$Wildcard$.MODULE$.equals(pathInstruction8 = (PathInstruction)(colon13 = (.colon.colon)list15).head())) {
                                        p.nextToken();
                                        bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)colon14)).apply$mcZJ$sp(idx);
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list16 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list16 instanceof .colon.colon) {
                        .colon.colon colon15 = (.colon.colon)list16;
                        PathInstruction pathInstruction = (PathInstruction)colon15.head();
                        List list17 = colon15.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list17 instanceof .colon.colon) {
                            .colon.colon colon16 = (.colon.colon)list17;
                            PathInstruction pathInstruction10 = (PathInstruction)colon16.head();
                            List xs = colon16.tl$access$1();
                            if (pathInstruction10 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction10;
                                long idx = index.index();
                                p.nextToken();
                                bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, style, (List<PathInstruction>)xs)).apply$mcZJ$sp(idx);
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list18 = (List)tuple2._2();
                    if (JsonToken.FIELD_NAME.equals(jsonToken) && list18 instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list18;
                        PathInstruction pathInstruction = (PathInstruction)colon17.head();
                        List xs = colon17.tl$access$1();
                        if (pathInstruction instanceof PathInstruction.Named) {
                            PathInstruction.Named named = (PathInstruction.Named)pathInstruction;
                            String name = named.name();
                            String string = p.getCurrentName();
                            String string2 = name;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JsonToken jsonToken10 = p.nextToken();
                                JsonToken jsonToken11 = JsonToken.VALUE_NULL;
                                if (jsonToken10 == null ? jsonToken11 != null : !jsonToken10.equals(jsonToken11)) {
                                    path = xs;
                                    continue;
                                }
                                bl = false;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 == null) break;
                JsonToken jsonToken = (JsonToken)tuple2._1();
                List list19 = (List)tuple2._2();
                if (!JsonToken.FIELD_NAME.equals(jsonToken) || !(list19 instanceof .colon.colon)) break;
                .colon.colon colon18 = (.colon.colon)list19;
                PathInstruction pathInstruction = (PathInstruction)colon18.head();
                List xs = colon18.tl$access$1();
                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction)) break;
                p.nextToken();
                path = xs;
            }
            p.skipChildren();
            bl = false;
        }
        return bl;
    }

    @Override
    public GetJsonObject withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.json();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(GetJsonObject $this, JsonParser parser$1, Option parsed$1, JsonGenerator generator) {
        parser$1.nextToken();
        return $this.evaluatePath(parser$1, generator, WriteStyle$RawStyle$.MODULE$, (List<PathInstruction>)((List)parsed$1.get()));
    }

    public static final /* synthetic */ void $anonfun$evaluatePath$2(GetJsonObject $this, JsonParser p$2, IntRef dirty$1, Product nextStyle$1, List xs$1, JsonGenerator flattenGenerator) {
        flattenGenerator.writeStartArray();
        while (true) {
            JsonToken jsonToken = p$2.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            dirty$1.elem = dirty$1.elem + ($this.evaluatePath(p$2, flattenGenerator, (WriteStyle)nextStyle$1, (List<PathInstruction>)xs$1) ? 1 : 0);
        }
        flattenGenerator.writeEndArray();
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

