/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0013'\u0001NB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011!a\u0005A!f\u0001\n\u0003i\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bI\u0003A\u0011A*\t\u000bI\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\t/\t\u000b\r\u0004A\u0011\t3\t\u000b!\u0004A\u0011I5\t\u000bU\u0004A\u0011I5\t\u000bY\u0004A\u0011I<\t\u000bi\u0004A\u0011I5\t\u0011m\u0004\u0001R1A\u0005\nqDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0010\u0001!\t&!\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0013\u0001E\u0005I\u0011AA\u0014\u0011%\ti\u0004AI\u0001\n\u0003\t9\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\ty\bAA\u0001\n\u0003\n\tiB\u0005\u0002&\u001a\n\t\u0011#\u0001\u0002(\u001aAQEJA\u0001\u0012\u0003\tI\u000b\u0003\u0004S;\u0011\u0005\u0011q\u0017\u0005\n\u0003sk\u0012\u0011!C#\u0003wC\u0011\"!0\u001e\u0003\u0003%\t)a0\t\u0013\u0005\u001dW$%A\u0005\u0002\u0005\u0005\u0003\"CAe;\u0005\u0005I\u0011QAf\u0011%\ti.HI\u0001\n\u0003\t\t\u0005C\u0005\u0002`v\t\t\u0011\"\u0003\u0002b\nq\u0011J\u001c;fOJ\fG\u000eR5wS\u0012,'BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001!\u0004hO!\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#\u0001\u0005\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d!\t)\u0014(\u0003\u0002;M\tQA)\u001b<N_\u0012d\u0015n[3\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011AHQ\u0005\u0003\u0007v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\ta\t\u0005\u00026\u000f&\u0011\u0001J\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%A\u0006gC&dwJ\\#se>\u0014X#\u0001(\u0011\u0005qz\u0015B\u0001)>\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtD\u0003\u0002+V-^\u0003\"!\u000e\u0001\t\u000b\u0011;\u0001\u0019\u0001$\t\u000b);\u0001\u0019\u0001$\t\u000f1;\u0001\u0013!a\u0001\u001dR\u0019A+\u0017.\t\u000b\u0011C\u0001\u0019\u0001$\t\u000b)C\u0001\u0019\u0001$\u0002\u0013%t\u0007/\u001e;UsB,W#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001T\u0013!\u0002;za\u0016\u001c\u0018B\u00012`\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005)\u0007C\u00010g\u0013\t9wL\u0001\u0005ECR\fG+\u001f9f\u0003\u0019\u0019\u00180\u001c2pYV\t!\u000e\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[vj\u0011A\u001c\u0006\u0003_J\na\u0001\u0010:p_Rt\u0014BA9>\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005El\u0014!\u00043fG&l\u0017\r\\'fi\"|G-\u0001\reK\u000eLW.\u00197U_\u0012\u000bG/\u0019+za\u0016\u001cu\u000eZ3HK:$\"A\u001b=\t\u000bel\u0001\u0019\u00016\u0002\u001b\u0011,7-[7bYJ+7/\u001e7u\u0003-\u0019\u0018\u000f\\(qKJ\fGo\u001c:\u0002\u0007\u0011Lg/F\u0001~!!ad0!\u0001\u0002\u0002\u0005\u0005\u0011BA@>\u0005%1UO\\2uS>t'\u0007E\u0002=\u0003\u0007I1!!\u0002>\u0005\r\te._\u0001\u000eKZ\fGn\u00149fe\u0006$\u0018n\u001c8\u0015\r\u0005\u0005\u00111BA\u0007\u0011\u0019!\u0005\u00031\u0001\u0002\u0002!1!\n\u0005a\u0001\u0003\u0003\tqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bQ\u000b\u0019\"a\u0006\t\r\u0005U\u0011\u00031\u0001G\u0003\u001dqWm\u001e'fMRDa!!\u0007\u0012\u0001\u00041\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\b)\u0006}\u0011\u0011EA\u0012\u0011\u001d!%\u0003%AA\u0002\u0019CqA\u0013\n\u0011\u0002\u0003\u0007a\tC\u0004M%A\u0005\t\u0019\u0001(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0006\u0016\u0004\r\u0006-2FAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]R(\u0001\u0006b]:|G/\u0019;j_:LA!a\u000f\u00022\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\"U\rq\u00151F\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0003\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0005Y\u0006twM\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\r\u0019\u0018QJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\u00022\u0001PA/\u0013\r\ty&\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\t)\u0007C\u0005\u0002ha\t\t\u00111\u0001\u0002\\\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001c\u0011\r\u0005=\u0014QOA\u0001\u001b\t\t\tHC\u0002\u0002tu\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u001d\u0006u\u0004\"CA45\u0005\u0005\t\u0019AA\u0001\u0003\u0019)\u0017/^1mgR\u0019a*a!\t\u0013\u0005\u001d4$!AA\u0002\u0005\u0005\u0001f\u0005\u0001\u0002\b\u00065\u0015qRAJ\u0003+\u000bI*a'\u0002 \u0006\u0005\u0006cA\u001b\u0002\n&\u0019\u00111\u0012\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001\u0002\n\u0015D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.A\u0011Kg/\u001b3fA\u0001,\u0007\u0010\u001d:2A\u0002\u0012\u0017\u0010\t1fqB\u0014(\u0007\u0019\u0018!\u0013R\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\rI1oA=\u0004XM]1oI\u0002J7\u000f\t(V\u00192\u0003sN\u001d\u0011aKb\u0004(O\r1!SN\u0004\u0003G\f\u0011UQ\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011dCN$X\r\u001a\u0011u_\u0002bwN\\4/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAL\u0003UR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005u\u0015!B\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAAR\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u000f\u0013:$Xm\u001a:bY\u0012Kg/\u001b3f!\t)Td\u0005\u0003\u001e\u0003W\u000b\u0005\u0003CAW\u0003g3eI\u0014+\u000e\u0005\u0005=&bAAY{\u00059!/\u001e8uS6,\u0017\u0002BA[\u0003_\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t9+\u0001\u0005u_N#(/\u001b8h)\t\tI%A\u0003baBd\u0017\u0010F\u0004U\u0003\u0003\f\u0019-!2\t\u000b\u0011\u0003\u0003\u0019\u0001$\t\u000b)\u0003\u0003\u0019\u0001$\t\u000f1\u0003\u0003\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0017\u0011\u001c\t\u0006y\u0005=\u00171[\u0005\u0004\u0003#l$AB(qi&|g\u000e\u0005\u0004=\u0003+4eIT\u0005\u0004\u0003/l$A\u0002+va2,7\u0007\u0003\u0005\u0002\\\n\n\t\u00111\u0001U\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003G\u0004B!a\u0013\u0002f&!\u0011q]A'\u0005\u0019y%M[3di\u0002")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike,
scala.Serializable {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    public static boolean apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, IntegralDivide>>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return new StringBuilder(9).append(decimalResult).append(".toLong()").toString();
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = integralType.integral();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    decimal$DecimalAsIfIntegral$ = decimalType.asIntegral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                this.div = (Function2 & Serializable & scala.Serializable)(x, y) -> {
                    Object res = integral.quot(x, y);
                    return res == null ? null : BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.div$lzycompute() : this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, boolean failOnError) {
        return new IntegralDivide(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != integralDivide.failOnError()) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

