/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IsNull$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is null, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       false\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)\u0011\t\u0001C!\u0005\")a\t\u0001C!\u000f\")\u0011\u000b\u0001C!%\")a\u0004\u0001C!A\")A\u000e\u0001C)[\"9\u0001\u000fAA\u0001\n\u0003\t\bbB:\u0001#\u0003%\t\u0001\u001e\u0005\t\u007f\u0002\t\t\u0011\"\u0011\u0002\u0002!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u00037\u0001\u0011\u0011!C\u0001\u0003;A\u0011\"a\t\u0001\u0003\u0003%\t%!\n\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u000f%\ty&GA\u0001\u0012\u0003\t\tG\u0002\u0005\u00193\u0005\u0005\t\u0012AA2\u0011\u0019i$\u0003\"\u0001\u0002r!I\u00111\u000f\n\u0002\u0002\u0013\u0015\u0013Q\u000f\u0005\n\u0003o\u0012\u0012\u0011!CA\u0003sB\u0011\"! \u0013\u0003\u0003%\t)a \t\u0013\u0005-%#!A\u0005\n\u00055%AB%t\u001dVdGN\u0003\u0002\u001b7\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taR$\u0001\u0005dCR\fG._:u\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0015\u0001qe\u000b\u00185!\tA\u0013&D\u0001\u001a\u0013\tQ\u0013DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tAC&\u0003\u0002.3\tI\u0001K]3eS\u000e\fG/\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\tyS'\u0003\u00027a\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t\u0011\b\u0005\u0002)u%\u00111(\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\u0001\u0003\"\u0001\u000b\u0001\t\u000b]\u001a\u0001\u0019A\u001d\u0002\u00119,H\u000e\\1cY\u0016,\u0012a\u0011\t\u0003_\u0011K!!\u0012\u0019\u0003\u000f\t{w\u000e\\3b]\u0006!QM^1m)\tA5\n\u0005\u00020\u0013&\u0011!\n\r\u0002\u0004\u0003:L\bb\u0002'\u0006!\u0003\u0005\r!T\u0001\u0006S:\u0004X\u000f\u001e\t\u0003\u001d>k\u0011aG\u0005\u0003!n\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004'fs\u0006C\u0001+X\u001b\u0005)&B\u0001,\u001a\u0003\u001d\u0019w\u000eZ3hK:L!\u0001W+\u0003\u0011\u0015C\bO]\"pI\u0016DQA\u0017\u0004A\u0002m\u000b1a\u0019;y!\t!F,\u0003\u0002^+\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B0\u0007\u0001\u0004\u0019\u0016AA3w+\u0005\t\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002ea5\tQM\u0003\u0002gK\u00051AH]8pizJ!\u0001\u001b\u0019\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003QB\nAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGCA o\u0011\u0015y\u0007\u00021\u0001:\u0003!qWm^\"iS2$\u0017\u0001B2paf$\"a\u0010:\t\u000f]J\u0001\u0013!a\u0001s\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005e28&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\ta\b'\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\u0007)\f9!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016A\u0019q&a\u0006\n\u0007\u0005e\u0001GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002I\u0003?A\u0011\"!\t\u000e\u0003\u0003\u0005\r!!\u0006\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0003E\u0003\u0002*\u0005=\u0002*\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0005-\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aQA\u001c\u0011!\t\tcDA\u0001\u0002\u0004A\u0015AB3rk\u0006d7\u000fF\u0002D\u0003{A\u0001\"!\t\u0011\u0003\u0003\u0005\r\u0001\u0013\u0015\u0014\u0001\u0005\u0005\u0013qIA%\u0003\u001b\ny%a\u0015\u0002V\u0005e\u00131\f\t\u0004Q\u0005\r\u0013bAA#3\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA&\u0003\t{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1fqB\u0014\b\rI5tA9,H\u000e\u001c\u0017!_J\u0004c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011K\u00019\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t9&A\u00032]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002^\u0005y\u0001O]3eS\u000e\fG/Z0gk:\u001c7/\u0001\u0004Jg:+H\u000e\u001c\t\u0003QI\u0019BAEA3iA1\u0011qMA7s}j!!!\u001b\u000b\u0007\u0005-\u0004'A\u0004sk:$\u0018.\\3\n\t\u0005=\u0014\u0011\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAA1\u0003!!xn\u0015;sS:<GCAA\u0002\u0003\u0015\t\u0007\u000f\u001d7z)\ry\u00141\u0010\u0005\u0006oU\u0001\r!O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t)a\"\u0011\t=\n\u0019)O\u0005\u0004\u0003\u000b\u0003$AB(qi&|g\u000e\u0003\u0005\u0002\nZ\t\t\u00111\u0001@\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0010B!\u0011QAAI\u0013\u0011\t\u0019*a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class IsNull
extends UnaryExpression
implements Predicate,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNull isNull) {
        return IsNull$.MODULE$.unapply(isNull);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNull, A> function1) {
        return IsNull$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, IsNull> compose(Function1<A, Expression> function1) {
        return IsNull$.MODULE$.compose(function1);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        return BoxesRunTime.boxToBoolean((this.child().eval(input) == null ? 1 : 0) != 0);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        return new ExprCode(eval.code(), FalseLiteral$.MODULE$, eval.isNull());
    }

    @Override
    public String sql() {
        return new StringBuilder(10).append("(").append(this.child().sql()).append(" IS NULL)").toString();
    }

    @Override
    public IsNull withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public IsNull copy(Expression child) {
        return new IsNull(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNull";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNull)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNull isNull = (IsNull)x$1;
        Expression expression = this.child();
        Expression expression2 = isNull.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNull.canEqual(this)) return false;
        return true;
    }

    public IsNull(Expression child) {
        this.child = child;
        Predicate.$init$(this);
    }
}

