/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.Lag$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset[, default]]) - Returns the value of `input` at the `offset`th row\n      before the current row in the window. The default value of `offset` is 1 and the default\n      value of `default` is null. If the value of `input` at the `offset`th row is null,\n      null is returned. If there is no such offset row (e.g., when the offset is 1, the first\n      row of the window does not have any previous row), `default` is returned.\n  ", arguments="\n    Arguments:\n      * input - a string expression to evaluate `offset` rows before the current row.\n      * offset - an int expression which is rows to jump back in the partition.\n      * default - a string expression which is to use when the offset row does not exist.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\tNULL\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0014(\u0001RB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u007f!Aa\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005P\u0001\tE\t\u0015!\u0003@\u0011!\u0001\u0006A!f\u0001\n\u0003a\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011B \t\u0011I\u0003!Q3A\u0005\u0002MC\u0001b\u0016\u0001\u0003\u0012\u0003\u0006I\u0001\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u00061\u0002!\ta\u0018\u0005\u00061\u0002!\ta\u0019\u0005\u00061\u0002!\tA\u001a\u0005\u00061\u0002!\t\u0001\u001b\u0005\bS\u0002\u0011\r\u0011\"\u0011M\u0011\u0019Q\u0007\u0001)A\u0005\u007f!)1\u000e\u0001C!\u0019\")A\u000e\u0001C!\u0019\")Q\u000e\u0001C!\u0019\")a\u000e\u0001C)_\"9a\u000fAA\u0001\n\u00039\bb\u0002?\u0001#\u0003%\t! \u0005\t\u0003#\u0001\u0011\u0013!C\u0001{\"A\u00111\u0003\u0001\u0012\u0002\u0013\u0005Q\u0010C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u00111\u0004\u0001\u0002\u0002\u0013\u0005\u0013Q\u0004\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003cA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\u001d\u0003!!A\u0005B\u0005%\u0003\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\ti\u0006AA\u0001\n\u0003\nyfB\u0005\u0002\n\u001e\n\t\u0011#\u0001\u0002\f\u001aAaeJA\u0001\u0012\u0003\ti\t\u0003\u0004YA\u0011\u0005\u00111\u0014\u0005\n\u0003;\u0003\u0013\u0011!C#\u0003?C\u0011\"!)!\u0003\u0003%\t)a)\t\u0013\u00055\u0006%!A\u0005\u0002\u0006=\u0006\"CAaA\u0005\u0005I\u0011BAb\u0005\ra\u0015m\u001a\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M)\u0001!N\u001dC\u0011B\u0011agN\u0007\u0002O%\u0011\u0001h\n\u0002\u001e\rJ\fW.\u001a'fgN|eMZ:fi^Kg\u000eZ8x\rVt7\r^5p]B\u0019!(P \u000e\u0003mR!\u0001P\u0015\u0002\u000bQ\u0014X-Z:\n\u0005yZ$a\u0003+fe:\f'/\u001f'jW\u0016\u0004\"A\u000e!\n\u0005\u0005;#AC#yaJ,7o]5p]B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n9\u0001K]8ek\u000e$\bCA\"J\u0013\tQEI\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003j]B,H/F\u0001@\u0003\u0019Ig\u000e];uA\u0005Y\u0011N\u001c9vi>3gm]3u\u00031Ig\u000e];u\u001f\u001a47/\u001a;!\u0003\u001d!WMZ1vYR\f\u0001\u0002Z3gCVdG\u000fI\u0001\fS\u001etwN]3Ok2d7/F\u0001U!\t\u0019U+\u0003\u0002W\t\n9!i\\8mK\u0006t\u0017\u0001D5h]>\u0014XMT;mYN\u0004\u0013A\u0002\u001fj]&$h\bF\u0003[7rkf\f\u0005\u00027\u0001!)1*\u0003a\u0001\u007f!)a*\u0003a\u0001\u007f!)\u0001+\u0003a\u0001\u007f!)!+\u0003a\u0001)R!!\fY1c\u0011\u0015Y%\u00021\u0001@\u0011\u0015q%\u00021\u0001@\u0011\u0015\u0001&\u00021\u0001@)\rQF-\u001a\u0005\u0006\u0017.\u0001\ra\u0010\u0005\u0006\u001d.\u0001\ra\u0010\u000b\u00035\u001eDQa\u0013\u0007A\u0002}\"\u0012AW\u0001\u0007_\u001a47/\u001a;\u0002\u000f=4gm]3uA\u0005)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\ti\u0003(\u000f\u001e\u0005\u0006cN\u0001\raP\u0001\t]\u0016<h)\u001b:ti\")1o\u0005a\u0001\u007f\u0005Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0006kN\u0001\raP\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u0015Q\u00060\u001f>|\u0011\u001dYE\u0003%AA\u0002}BqA\u0014\u000b\u0011\u0002\u0003\u0007q\bC\u0004Q)A\u0005\t\u0019A \t\u000fI#\u0002\u0013!a\u0001)\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001@+\u0005}z8FAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-A)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0004\u0002\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00033Q#\u0001V@\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0007\t\u0004\u0007\u0006U\u0012bAA\u001c\t\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QHA\"!\r\u0019\u0015qH\u0005\u0004\u0003\u0003\"%aA!os\"I\u0011QI\u000e\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0003CBA'\u0003'\ni$\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002V\u0005=#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001VA.\u0011%\t)%HA\u0001\u0002\u0004\ti$\u0001\u0004fcV\fGn\u001d\u000b\u0004)\u0006\u0005\u0004\"CA#=\u0005\u0005\t\u0019AA\u001fQ]\u0001\u0011QMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0014QPA@\u0003\u0007\u000b)\tE\u00027\u0003OJ1!!\u001b(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001c\u0002\u0007\u0017S\u0001\u0005\t\u0011!?\u001a+fjQ0)S:\u0004X\u000f^.-A=4gm]3u72\u0002C-\u001a4bk2$X,X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0017N\u001c9vi\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><(\u0002\t\u0011!A\u0001\u0002#-\u001a4pe\u0016\u0004C\u000f[3!GV\u0014(/\u001a8uAI|w\u000fI5oAQDW\rI<j]\u0012|wO\f\u0011UQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004sN\u001a\u0011a_\u001a47/\u001a;aA%\u001c\b%\r\u0011b]\u0012\u0004C\u000f[3!I\u00164\u0017-\u001e7u\u0015\u0001\u0002\u0003\u0005\t\u0011!m\u0006dW/\u001a\u0011pM\u0002\u0002G-\u001a4bk2$\b\rI5tA9,H\u000e\u001c\u0018!\u0013\u001a\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0017N\u001c9vi\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><\b%[:!]VdG\u000e\f\u0006!A\u0001\u0002\u0003\u0005\t8vY2\u0004\u0013n\u001d\u0011sKR,(O\\3e]\u0001Je\r\t;iKJ,\u0007%[:!]>\u00043/^2iA=4gm]3uAI|w\u000f\t\u0015f]\u001dtC\u0006I<iK:\u0004C\u000f[3!_\u001a47/\u001a;!SN\u0004\u0013\u0007\f\u0011uQ\u0016\u0004c-\u001b:ti*\u0001\u0003\u0005\t\u0011!AI|w\u000fI8gAQDW\rI<j]\u0012|w\u000f\t3pKN\u0004cn\u001c;!Q\u00064X\rI1os\u0002\u0002(/\u001a<j_V\u001c\bE]8xS1\u0002\u0003\rZ3gCVdG\u000f\u0019\u0011jg\u0002\u0012X\r^;s]\u0016$gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002v\u0005\u0011)C\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!S:\u0004X\u000f\u001e\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!i>\u0004SM^1mk\u0006$X\r\t1pM\u001a\u001cX\r\u001e1!e><8\u000f\t2fM>\u0014X\r\t;iK\u0002\u001aWO\u001d:f]R\u0004#o\\</\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001zgMZ:fi\u0002j\u0003%\u00198!S:$\b%\u001a=qe\u0016\u001c8/[8oA]D\u0017n\u00195!SN\u0004#o\\<tAQ|\u0007E[;na\u0002\u0012\u0017mY6!S:\u0004C\u000f[3!a\u0006\u0014H/\u001b;j_:t#\u0002\t\u0011!A\u0001\u0002#\u0006\t3fM\u0006,H\u000e\u001e\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o\"L7\r\u001b\u0011jg\u0002\"x\u000eI;tK\u0002:\b.\u001a8!i\",\u0007e\u001c4gg\u0016$\bE]8xA\u0011|Wm\u001d\u0011o_R\u0004S\r_5ti:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111P\u0001\u0002$*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\r\f\u0011cY\u0001zf)\u0016(D?\"\u0012\u0017\u0006I(W\u000bJ\u0003\u0003\u0006U!S)&#\u0016j\u0014(!\u0005f\u0003\u0013\rI(S\t\u0016\u0013\u0006EQ-!E&\u0002cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-AIJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*Y\u0001Bs%\u0011\u001a(Y\u0001\u001a\u0014\u0006\f\u0011)O\u0005\u000bt\u0005\f\u00112S\u0001\"\u0018M\u0019\u0015bY\u0001\u0012\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014BT+M\u0019*\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\n\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t)A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\b\u0006aq/\u001b8e_^|f-\u001e8dg\u0006\u0019A*Y4\u0011\u0005Y\u00023\u0003\u0002\u0011\u0002\u0010\"\u0003\u0012\"!%\u0002\u0018~zt\b\u0016.\u000e\u0005\u0005M%bAAK\t\u00069!/\u001e8uS6,\u0017\u0002BAM\u0003'\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\tY)\u0001\u0005u_N#(/\u001b8h)\t\ty\"A\u0003baBd\u0017\u0010F\u0005[\u0003K\u000b9+!+\u0002,\")1j\ta\u0001\u007f!)aj\ta\u0001\u007f!)\u0001k\ta\u0001\u007f!)!k\ta\u0001)\u00069QO\\1qa2LH\u0003BAY\u0003{\u0003RaQAZ\u0003oK1!!.E\u0005\u0019y\u0005\u000f^5p]B91)!/@\u007f}\"\u0016bAA^\t\n1A+\u001e9mKRB\u0001\"a0%\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!2\u0011\t\u0005\u0005\u0012qY\u0005\u0005\u0003\u0013\f\u0019C\u0001\u0004PE*,7\r\u001e")
public class Lag
extends FrameLessOffsetWindowFunction
implements TernaryLike<Expression>,
Serializable {
    private final Expression input;
    private final Expression inputOffset;
    private final Expression default;
    private final boolean ignoreNulls;
    private final Expression offset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Lag lag) {
        return Lag$.MODULE$.unapply(lag);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, Lag> tupled() {
        return Lag$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Lag>>>> curried() {
        return Lag$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Lag lag = this;
        synchronized (lag) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    public Expression inputOffset() {
        return this.inputOffset;
    }

    @Override
    public Expression default() {
        return this.default;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public Expression first() {
        return this.input();
    }

    @Override
    public Expression second() {
        return this.inputOffset();
    }

    @Override
    public Expression third() {
        return this.default();
    }

    @Override
    public Lag withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public Lag copy(Expression input, Expression inputOffset, Expression expression, boolean ignoreNulls) {
        return new Lag(input, inputOffset, expression, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.inputOffset();
    }

    public Expression copy$default$3() {
        return this.default();
    }

    public boolean copy$default$4() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "Lag";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.inputOffset();
                break;
            }
            case 2: {
                object = this.default();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Lag)) return false;
        boolean bl = true;
        if (!bl) return false;
        Lag lag = (Lag)x$1;
        Expression expression = this.input();
        Expression expression2 = lag.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.inputOffset();
        Expression expression4 = lag.inputOffset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.default();
        Expression expression6 = lag.default();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.ignoreNulls() != lag.ignoreNulls()) return false;
        if (!lag.canEqual(this)) return false;
        return true;
    }

    public Lag(Expression input, Expression inputOffset, Expression expression, boolean ignoreNulls) {
        UnaryMinus unaryMinus;
        this.input = input;
        this.inputOffset = inputOffset;
        this.default = expression;
        this.ignoreNulls = ignoreNulls;
        TernaryLike.$init$(this);
        UnaryMinus unaryMinus2 = new UnaryMinus(inputOffset, UnaryMinus$.MODULE$.apply$default$2());
        Expression expression2 = unaryMinus2 != null && (unaryMinus = unaryMinus2).foldable() ? Literal$.MODULE$.create(unaryMinus.eval(package$.MODULE$.EmptyRow()), unaryMinus.dataType()) : unaryMinus2;
        this.offset = expression2;
    }

    public Lag(Expression input, Expression inputOffset, Expression expression) {
        this(input, inputOffset, expression, false);
    }

    public Lag(Expression input, Expression inputOffset) {
        this(input, inputOffset, Literal$.MODULE$.apply(null));
    }

    public Lag(Expression input) {
        this(input, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }

    public Lag() {
        this(Literal$.MODULE$.apply(null));
    }
}

