/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ '\\%SystemDrive\\%\\\\\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011!!\u0005A!f\u0001\n\u0003)\u0005\u0002C%\u0001\u0005#\u0005\u000b\u0011\u0002$\t\u000b)\u0003A\u0011A&\t\u000b)\u0003A\u0011\u0001)\t\u000bM\u0003A\u0011\t+\t\u000b\t\u0004A\u0011I2\t\u000bQ\u0004A\u0011I;\t\u000b\u0019\u0002A\u0011\t<\t\u000b]\u0004A\u0011\u000b=\t\u000f\u00055\u0001\u0001\"\u0015\u0002\u0010!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005}\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00131\u000e\u0005\n\u0003s\u0002\u0011\u0011!C\u0001\u0003wB\u0011\"a \u0001\u0003\u0003%\t%!!\b\u0013\u0005E\u0016%!A\t\u0002\u0005Mf\u0001\u0003\u0011\"\u0003\u0003E\t!!.\t\r)SB\u0011AAb\u0011!!($!A\u0005F\u0005\u0015\u0007\"CAd5\u0005\u0005I\u0011QAe\u0011%\t\tNGA\u0001\n\u0003\u000b\u0019\u000eC\u0005\u0002fj\t\t\u0011\"\u0003\u0002h\n!A*[6f\u0015\t\u00113%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011\u0003\u0002\u00010ge\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003+M#(/\u001b8h%\u0016<W\r_#yaJ,7o]5p]B\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t9\u0001K]8ek\u000e$\bC\u0001\u001b;\u0013\tYTG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001 \u0011\u0005Az\u0014B\u0001!\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0015\u0015\u001c8-\u00199f\u0007\"\f'/F\u0001G!\t!t)\u0003\u0002Ik\t!1\t[1s\u0003-)7oY1qK\u000eC\u0017M\u001d\u0011\u0002\rqJg.\u001b;?)\u0011aUJT(\u0011\u0005A\u0002\u0001\"\u0002\u001f\b\u0001\u0004q\u0004\"\u0002\"\b\u0001\u0004q\u0004\"\u0002#\b\u0001\u00041Ec\u0001'R%\")A\b\u0003a\u0001}!)!\t\u0003a\u0001}\u00051Qm]2ba\u0016$\"!\u00161\u0011\u0005YkfBA,\\!\tAV'D\u0001Z\u0015\tQV&\u0001\u0004=e>|GOP\u0005\u00039V\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,\u000e\u0005\u0006C&\u0001\r!V\u0001\u0002m\u00069Q.\u0019;dQ\u0016\u001cHc\u00013heB\u0011A'Z\u0005\u0003MV\u0012qAQ8pY\u0016\fg\u000eC\u0003i\u0015\u0001\u0007\u0011.A\u0003sK\u001e,\u0007\u0010\u0005\u0002ka6\t1N\u0003\u0002iY*\u0011QN\\\u0001\u0005kRLGNC\u0001p\u0003\u0011Q\u0017M^1\n\u0005E\\'a\u0002)biR,'O\u001c\u0005\u0006g*\u0001\r!V\u0001\u0004gR\u0014\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003U+\u0012!V\u0001\nI><UM\\\"pI\u0016$B!_@\u0002\nA\u0011!0`\u0007\u0002w*\u0011A0I\u0001\bG>$WmZ3o\u0013\tq8P\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\t!\u0004a\u0001\u0003\u0007\t1a\u0019;y!\rQ\u0018QA\u0005\u0004\u0003\u000fY(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0017i\u0001\u0019A=\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015a\u0015\u0011CA\u000b\u0011\u0019\t\u0019B\u0004a\u0001}\u00059a.Z<MK\u001a$\bBBA\f\u001d\u0001\u0007a(\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f1\u000bi\"a\b\u0002\"!9Ah\u0004I\u0001\u0002\u0004q\u0004b\u0002\"\u0010!\u0003\u0005\rA\u0010\u0005\b\t>\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\n+\u0007y\nIc\u000b\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C;oG\",7m[3e\u0015\r\t)$N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001d\u0003_\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002B)\u001aa)!\u000b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0005\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiE\\\u0001\u0005Y\u0006tw-C\u0002_\u0003\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0016\u0011\u0007Q\n9&C\u0002\u0002ZU\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0018\u0002fA\u0019A'!\u0019\n\u0007\u0005\rTGA\u0002B]fD\u0011\"a\u001a\u0016\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0007\u0005\u0004\u0002p\u0005U\u0014qL\u0007\u0003\u0003cR1!a\u001d6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\n\tH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00013\u0002~!I\u0011qM\f\u0002\u0002\u0003\u0007\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\u0019\tC\u0005\u0002ha\t\t\u00111\u0001\u0002`!Z\u0002!a\"\u0002\u000e\u0006=\u00151SAK\u00033\u000bY*a(\u0002\"\u0006\u0015\u0016qUAV\u0003[\u00032\u0001MAE\u0013\r\tY)\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t*AA\u000bgR\u0014\be\u0018$V\u001d\u000e{\u0006\u0005]1ui\u0016\u0014hn\u0017\u0011F'\u000e\u000b\u0005+\u0012\u0011fg\u000e\f\u0007/Z/![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007e\u001d;sA5\fGo\u00195fg\u0002\u0002\u0007/\u0019;uKJt\u0007\rI<ji\"\u0004\u0003-Z:dCB,\u0007\r\f\u0011ok2d\u0007%\u001b4!C:L\b%\u0019:hk6,g\u000e^:!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!a&\u0002\u0011KS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=dKB$\u0018n\u001c8!i>\u0004C\u000f[3!M>dGn\\<j]\u001e\u00043\u000f]3dS\u0006d\u0007e]=nE>d7O\u000f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\fI7bi\u000eDWm\u001d\u0011b]f\u0004sN\\3!G\"\f'/Y2uKJ\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!]\u0001Jg\u000e\t9pg&D\bE]3hk2\f'\u000fI3yaJ,7o]5p]NL#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015\u0002S.\u0019;dQ\u0016\u001c\bE_3s_\u0002z'\u000fI7pe\u0016\u00043\r[1sC\u000e$XM]:!S:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011)g&l\u0017\u000e\\1sAQ|\u0007E\f\u0016!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001c\u0018F\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b8!_J$WM\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGn\u001d\u0011cC\u000e\\'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nr#\u0002\t\u0011!A\u0001\u0002#\u0006I3tG\u0006\u0004X\rI\u0017!C:\u00043\r[1sC\u000e$XM\u001d\u0011bI\u0012,G\rI:j]\u000e,\u0007e\u00159be.\u00043G\f\u0019/AQCW\r\t3fM\u0006,H\u000e\u001e\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002J7\u000f\t;iK\u0002:Cl\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011b]\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000f\t9sK\u000e,G-Z:!C\u0002\u001a\b/Z2jC2\u00043/_7c_2\u0004sN\u001d\u0011b]>$\b.\u001a:!KN\u001c\u0017\r]3!G\"\f'/Y2uKJd\u0003\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8mY><\u0018N\\4!G\"\f'/Y2uKJ\u0004\u0013n\u001d\u0011nCR\u001c\u0007.\u001a3!Y&$XM]1mYft\u0003%\u0013;!SN\u0004\u0013N\u001c<bY&$\u0007\u0005^8!KN\u001c\u0017\r]3!C:L\be\u001c;iKJ\u00043\r[1sC\u000e$XM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003;\u000bA1\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001:s\f]1sW\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012+!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cX\b\u001e:vKnR\u0001\u0005\t\u0011!A\u0001\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0005ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/Vg\u0016\u00148\u000f\u0018&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006e\n/&'f\u001cH/Z7Ee&4X\rX\u0013]9V\u001bXM]:&OmR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E\u000bI:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mgv2\u0017\r\\:fw)\u0001\u0003\u0005\t\u0011!AM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7/\u00034bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/]+N,'o\u001d/]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcF\fX+tKJ\u001cXeJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-J\u0018Vg\u0016\u00148o\f&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006eJ\u0018&'f\u001cH/Z7Ee&4XmL\u00130_U\u001bXM]:&O\u0001*5kQ!Q\u000b\u0002:sfJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003G\u000bQH\u0003\u0011!A\u0001*6/\u001a\u0011S\u0019&[U\t\t;pA5\fGo\u00195!o&$\b\u000eI:uC:$\u0017M\u001d3!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0016a\u00049sK\u0012L7-\u0019;f?\u001a,hnY:\u0002\t1K7.\u001a\t\u0003ai\u0019BAGA\\sAA\u0011\u0011XA`}y2E*\u0004\u0002\u0002<*\u0019\u0011QX\u001b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011YA^\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003g#\"!a\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f1\u000bY-!4\u0002P\")A(\ba\u0001}!)!)\ba\u0001}!)A)\ba\u0001\r\u00069QO\\1qa2LH\u0003BAk\u0003C\u0004R\u0001NAl\u00037L1!!76\u0005\u0019y\u0005\u000f^5p]B1A'!8?}\u0019K1!a86\u0005\u0019!V\u000f\u001d7fg!A\u00111\u001d\u0010\u0002\u0002\u0003\u0007A*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001e\t\u0005\u0003\u0013\nY/\u0003\u0003\u0002n\u0006-#AB(cU\u0016\u001cG\u000f")
public class Like
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        String string;
        char c = this.escapeChar();
        switch (c) {
            case '\\': {
                string = new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
                break;
            }
            default: {
                string = new StringBuilder(16).append(this.left()).append(" LIKE ").append(this.right()).append(" ESCAPE '").append(c).append("'").toString();
                break;
            }
        }
        return string;
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.left().sql()).append(" ").append(this.prettyName().toUpperCase(Locale.ROOT)).append(" ").append(this.right().sql()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            String escapedEscapeChar = StringEscapeUtils.escapeJava((String)((Object)BoxesRunTime.boxToCharacter((char)this.escapeChar())).toString());
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(133).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(\n            ").append(escapeFunc).append("(").append(rightStr).append(", '").append(escapedEscapeChar).append("'));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    @Override
    public Like withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToCharacter((char)this.escapeChar());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.escapeChar() != like.escapeChar()) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

