/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 13, 1);\n       NULL\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n      > SELECT _FUNC_(2019, 2, 30);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0015+\u0001^B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011!9\u0006A!f\u0001\n\u0003\u0001\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B)\t\u0011e\u0003!Q3A\u0005\u0002iC\u0001B\u0018\u0001\u0003\u0012\u0003\u0006Ia\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006?\u0002!\tA\u001a\u0005\u0006U\u0002!\t\u0005\u0015\u0005\u0006W\u0002!\t\u0005\u0015\u0005\u0006Y\u0002!\t\u0005\u0015\u0005\u0006[\u0002!\tE\u001c\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u0019\tY\u0001\u0001C!5\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\ty\u0005\u0001C)\u0003#B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u0005-\u0004!%A\u0005\u0002\u00055\u0004\"CAB\u0001E\u0005I\u0011AA7\u0011%\t)\tAI\u0001\n\u0003\ti\u0007C\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003?\u0003\u0011\u0011!C\u0001\u0003CC\u0011\"!+\u0001\u0003\u0003%\t!a+\t\u0013\u0005E\u0006!!A\u0005B\u0005M\u0006\"CAa\u0001\u0005\u0005I\u0011AAb\u0011%\t9\rAA\u0001\n\u0003\nImB\u0005\u0002t*\n\t\u0011#\u0001\u0002v\u001aA\u0011FKA\u0001\u0012\u0003\t9\u0010\u0003\u0004`C\u0011\u0005!Q\u0001\u0005\n\u0005\u000f\t\u0013\u0011!C#\u0005\u0013A\u0011Ba\u0003\"\u0003\u0003%\tI!\u0004\t\u0013\t]\u0011%%A\u0005\u0002\u0005%\u0005\"\u0003B\rC\u0005\u0005I\u0011\u0011B\u000e\u0011%\u0011i#II\u0001\n\u0003\tI\tC\u0005\u00030\u0005\n\t\u0011\"\u0003\u00032\tAQ*Y6f\t\u0006$XM\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\bP G\u0019B\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001d>\u0013\tq$F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\u00015I\u0004\u0002:\u0003&\u0011!IK\u0001\ba\u0006\u001c7.Y4f\u0013\t!UI\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\tS\u0003CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000f6K!A\u0014%\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\te,\u0017M]\u000b\u0002#B\u0011\u0011HU\u0005\u0003'*\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015IX-\u0019:!\u0003\u0015iwN\u001c;i\u0003\u0019iwN\u001c;iA\u0005\u0019A-Y=\u0002\t\u0011\f\u0017\u0010I\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001\\!\t9E,\u0003\u0002^\u0011\n9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013A\u0002\u001fj]&$h\bF\u0003bE\u000e$W\r\u0005\u0002:\u0001!)q*\u0003a\u0001#\")Q+\u0003a\u0001#\")q+\u0003a\u0001#\"9\u0011,\u0003I\u0001\u0002\u0004YF\u0003B1hQ&DQa\u0014\u0006A\u0002ECQ!\u0016\u0006A\u0002ECQa\u0016\u0006A\u0002E\u000bQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017AC5oaV$H+\u001f9fgV\tq\u000eE\u0002qojt!!\u001d<\u000f\u0005I,X\"A:\u000b\u0005Q4\u0014A\u0002\u001fs_>$h(C\u0001J\u0013\t\u0011\u0005*\u0003\u0002ys\n\u00191+Z9\u000b\u0005\tC\u0005CA>\u007f\u001b\u0005a(BA?/\u0003\u0015!\u0018\u0010]3t\u0013\tyHP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0006A\u001910a\u0002\n\u0007\u0005%AP\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\t\u0003/\tI\"a\u0007\u0011\u0007\u001d\u000b\u0019\"C\u0002\u0002\u0016!\u00131!\u00118z\u0011\u0019y\u0015\u00031\u0001\u0002\u0012!1Q+\u0005a\u0001\u0003#AaaV\tA\u0002\u0005E\u0011!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\t#!\f\u00028A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002()\nqaY8eK\u001e,g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005=\"\u00031\u0001\u00022\u0005\u00191\r\u001e=\u0011\t\u0005\r\u00121G\u0005\u0005\u0003k\t)C\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005e\"\u00031\u0001\u0002\"\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA !\u0011\t\t%!\u0013\u000f\t\u0005\r\u0013Q\t\t\u0003e\"K1!a\u0012I\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\u0019\u0019FO]5oO*\u0019\u0011q\t%\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB1\u0002T\u0005]\u00131\f\u0005\u0007\u0003+\"\u0002\u0019A)\u0002\u00119,wOR5sgRDa!!\u0017\u0015\u0001\u0004\t\u0016!\u00038foN+7m\u001c8e\u0011\u0019\ti\u0006\u0006a\u0001#\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH#C1\u0002d\u0005\u0015\u0014qMA5\u0011\u001dyU\u0003%AA\u0002ECq!V\u000b\u0011\u0002\u0003\u0007\u0011\u000bC\u0004X+A\u0005\t\u0019A)\t\u000fe+\u0002\u0013!a\u00017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA8U\r\t\u0016\u0011O\u0016\u0003\u0003g\u0002B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0010%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0002\u0006]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tYIK\u0002\\\u0003c\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA\u0001\\1oO*\u0011\u00111T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005U\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAR!\r9\u0015QU\u0005\u0004\u0003OC%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\t\u0003[C\u0011\"a,\u001d\u0003\u0003\u0005\r!a)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\f\u0005\u0004\u00028\u0006u\u0016\u0011C\u0007\u0003\u0003sS1!a/I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\u000bIL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA.\u0002F\"I\u0011q\u0016\u0010\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\u000bY\rC\u0005\u00020~\t\t\u00111\u0001\u0002\u0012!:\u0002!a4\u0002V\u0006]\u00171\\Ao\u0003C\f\u0019/a:\u0002j\u00065\u0018q\u001e\t\u0004s\u0005E\u0017bAAjU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAm\u0003\u001d{f)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u00170\u000b\u0011.A\r\u0013X-\u0019;fA\u0011\fG/\u001a\u0011ge>l\u0007%_3be2\u0002Sn\u001c8uQ\u0002\ng\u000e\u001a\u0011eCf\u0004c-[3mINt\u0013!C1sOVlWM\u001c;tC\t\ty.AAT\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002f\u0006\t\u0019L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\u001aD\u0006I\u001c-AE*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u001aT\u0006M\u001c.cUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002\u0013g\r\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u0019:Y\u0001:D\u0006\t(V\u00192K3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002#\u0007\f\u00114a%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002l\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAy\u0003\u0015\u0019d\u0006\r\u00181\u0003!i\u0015m[3ECR,\u0007CA\u001d\"'\u0011\t\u0013\u0011 '\u0011\u0013\u0005m(\u0011A)R#n\u000bWBAA\u007f\u0015\r\ty\u0010S\u0001\beVtG/[7f\u0013\u0011\u0011\u0019!!@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0002v\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0012\u0006)\u0011\r\u001d9msRI\u0011Ma\u0004\u0003\u0012\tM!Q\u0003\u0005\u0006\u001f\u0012\u0002\r!\u0015\u0005\u0006+\u0012\u0002\r!\u0015\u0005\u0006/\u0012\u0002\r!\u0015\u0005\b3\u0012\u0002\n\u00111\u0001\\\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005;\u0011I\u0003E\u0003H\u0005?\u0011\u0019#C\u0002\u0003\"!\u0013aa\u00149uS>t\u0007cB$\u0003&E\u000b\u0016kW\u0005\u0004\u0005OA%A\u0002+va2,G\u0007\u0003\u0005\u0003,\u0019\n\t\u00111\u0001b\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005g\u0001B!a%\u00036%!!qGAK\u0005\u0019y%M[3di\u0002")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return MakeDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(MakeDate makeDate) {
        return MakeDate$.MODULE$.unapply(makeDate);
    }

    public static boolean apply$default$4() {
        return MakeDate$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeDate>>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression first() {
        return this.year();
    }

    @Override
    public Expression second() {
        return this.month();
    }

    @Override
    public Expression third() {
        return this.day();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException) || this.failOnError()) {
                throw throwable;
            }
            Object var4_7 = null;
            n = var4_7;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(year, month, day) -> new StringBuilder(136).append("\n      try {\n        ").append(ev.value()).append(" = ").append(dtu).append(".localDateToDays(java.time.LocalDate.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append("));\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString());
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    @Override
    public MakeDate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MakeDate copy(Expression year, Expression month, Expression day, boolean failOnError) {
        return new MakeDate(year, month, day, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.failOnError() != makeDate.failOnError()) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this(year, month, day, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

