/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple9;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B\u001f?\u0001.C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tW\u0002\u0011\t\u0012)A\u0005Q\"AA\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005n\u0001\tE\t\u0015!\u0003i\u0011!q\u0007A!f\u0001\n\u00039\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00025\t\u0011A\u0004!Q3A\u0005\u0002\u001dD\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\te\u0002\u0011)\u001a!C\u0001O\"A1\u000f\u0001B\tB\u0003%\u0001\u000e\u0003\u0005u\u0001\tU\r\u0011\"\u0001h\u0011!)\bA!E!\u0002\u0013A\u0007\u0002\u0003<\u0001\u0005+\u0007I\u0011A<\t\u0011m\u0004!\u0011#Q\u0001\naD\u0001\u0002 \u0001\u0003\u0016\u0004%\t! \u0005\n\u0003+\u0001!\u0011#Q\u0001\nyD!\"a\u0006\u0001\u0005+\u0007I\u0011AA\r\u0011)\t\t\u0003\u0001B\tB\u0003%\u00111\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003wAq!a\t\u0001\t\u0003\tI\u0005C\u0004\u0002Z\u0001!\t%a\u0017\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!!3\u0001\t\u0003\nY\rC\u0004\u0002^\u0002!\t%a8\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9\u0011q \u0001\u0005R\t\u0005\u0001\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0003AI\u0001\n\u0003\u0011)\u0003C\u0005\u0003<\u0001\t\n\u0011\"\u0001\u0003&!I!Q\b\u0001\u0012\u0002\u0013\u0005!Q\u0005\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005KA\u0011B!\u0011\u0001#\u0003%\tA!\n\t\u0013\t\r\u0003!%A\u0005\u0002\t\u0015\u0002\"\u0003B#\u0001E\u0005I\u0011\u0001B$\u0011%\u0011Y\u0005AI\u0001\n\u0003\u0011i\u0005C\u0005\u0003R\u0001\t\n\u0011\"\u0001\u0003T!I!q\u000b\u0001\u0002\u0002\u0013\u0005#\u0011\f\u0005\n\u0005K\u0002\u0011\u0011!C\u0001\u0005OB\u0011B!\u001b\u0001\u0003\u0003%\tAa\u001b\t\u0013\tE\u0004!!A\u0005B\tM\u0004\"\u0003BA\u0001\u0005\u0005I\u0011\u0001BB\u0011%\u00119\tAA\u0001\n\u0003\u0012IiB\u0005\u00034z\n\t\u0011#\u0001\u00036\u001aAQHPA\u0001\u0012\u0003\u00119\fC\u0004\u0002$E\"\tA!2\t\u0013\t\u001d\u0017'!A\u0005F\t%\u0007\"\u0003Bfc\u0005\u0005I\u0011\u0011Bg\u0011%\u0011\t/MI\u0001\n\u0003\u00119\u0005C\u0005\u0003dF\n\n\u0011\"\u0001\u0003N!I!Q]\u0019\u0012\u0002\u0013\u0005!1\u000b\u0005\n\u0005O\f\u0014\u0011!CA\u0005SD\u0011Ba>2#\u0003%\tAa\u0012\t\u0013\te\u0018'%A\u0005\u0002\t5\u0003\"\u0003B~cE\u0005I\u0011\u0001B*\u0011%\u0011i0MA\u0001\n\u0013\u0011yPA\u0007NC.,G+[7fgR\fW\u000e\u001d\u0006\u0003\u007f\u0001\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011IQ\u0001\tG\u0006$\u0018\r\\=ti*\u00111\tR\u0001\u0004gFd'BA#G\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0005*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0006\u0019qN]4\u0004\u0001M9\u0001\u0001\u0014)T-v\u001b\u0007CA'O\u001b\u0005q\u0014BA(?\u0005M\u0019V\r\u001d;f]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0015+\u0003\u0002S}\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u001bRK!!\u0016 \u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0016.\u000f\u00055C\u0016BA-?\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0011L\u0010\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\b!J|G-^2u!\tqF-\u0003\u0002f?\na1+\u001a:jC2L'0\u00192mK\u0006!\u00110Z1s+\u0005A\u0007CA'j\u0013\tQgH\u0001\u0006FqB\u0014Xm]:j_:\fQ!_3be\u0002\nQ!\\8oi\"\fa!\\8oi\"\u0004\u0013a\u00013bs\u0006!A-Y=!\u0003\u0011Aw.\u001e:\u0002\u000b!|WO\u001d\u0011\u0002\u00075Lg.\u0001\u0003nS:\u0004\u0013aA:fG\u0006!1/Z2!\u0003!!\u0018.\\3{_:,W#\u0001=\u0011\u0007yK\b.\u0003\u0002{?\n1q\n\u001d;j_:\f\u0011\u0002^5nKj|g.\u001a\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001\u007f!\rq\u0016p \t\u0005\u0003\u0003\tyA\u0004\u0003\u0002\u0004\u0005-\u0001cAA\u0003?6\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Q\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u000e}\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007?\u0006YA/[7f5>tW-\u00133!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0005\u0005m\u0001c\u00010\u0002\u001e%\u0019\u0011qD0\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"B#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u0002CA'\u0001\u0011\u001517\u00031\u0001i\u0011\u0015a7\u00031\u0001i\u0011\u0015q7\u00031\u0001i\u0011\u0015\u00018\u00031\u0001i\u0011\u0015\u00118\u00031\u0001i\u0011\u0015!8\u00031\u0001i\u0011\u001d18\u0003%AA\u0002aDq\u0001`\n\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002\u0018M\u0001\n\u00111\u0001\u0002\u001cQq\u0011qEA\u001f\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0003\"\u00024\u0015\u0001\u0004A\u0007\"\u00027\u0015\u0001\u0004A\u0007\"\u00028\u0015\u0001\u0004A\u0007\"\u00029\u0015\u0001\u0004A\u0007\"\u0002:\u0015\u0001\u0004A\u0007\"\u0002;\u0015\u0001\u0004AG\u0003EA\u0014\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013QKA,\u0011\u00151W\u00031\u0001i\u0011\u0015aW\u00031\u0001i\u0011\u0015qW\u00031\u0001i\u0011\u0015\u0001X\u00031\u0001i\u0011\u0015\u0011X\u00031\u0001i\u0011\u0015!X\u00031\u0001i\u0011\u00151X\u00031\u0001i\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA/!\u0015\ty&a\u001ai\u001d\u0011\t\t'!\u001a\u000f\t\u0005\u0015\u00111M\u0005\u0002A&\u0011\u0011lX\u0005\u0005\u0003S\nYGA\u0002TKFT!!W0\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002rA1\u0011qLA4\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\u0012\u0015!\u0002;za\u0016\u001c\u0018\u0002BA?\u0003o\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a!\u0011\t\u0005U\u0014QQ\u0005\u0005\u0003\u000f\u000b9H\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,\u0017\u0001D<ji\"$\u0016.\\3[_:,Gc\u0001)\u0002\u0010\")AP\u0007a\u0001\u007f\u0006AAo\\'jGJ|7\u000f\u0006\t\u0002\u0016\u0006m\u00151UAS\u0003O\u000bI+a+\u00026B\u0019a,a&\n\u0007\u0005euLA\u0002B]fDaAZ\u000eA\u0002\u0005u\u0005c\u00010\u0002 &\u0019\u0011\u0011U0\u0003\u0007%sG\u000f\u0003\u0004m7\u0001\u0007\u0011Q\u0014\u0005\u0007]n\u0001\r!!(\t\rA\\\u0002\u0019AAO\u0011\u0019\u00118\u00041\u0001\u0002\u001e\"9\u0011QV\u000eA\u0002\u0005=\u0016\u0001D:fG\u0006sG-T5de>\u001c\b\u0003BA;\u0003cKA!a-\u0002x\t9A)Z2j[\u0006d\u0007bBA\\7\u0001\u0007\u0011\u0011X\u0001\u0007u>tW-\u00133\u0011\t\u0005m\u0016QY\u0007\u0003\u0003{SA!a0\u0002B\u0006!A/[7f\u0015\t\t\u0019-\u0001\u0003kCZ\f\u0017\u0002BAd\u0003{\u0013aAW8oK&#\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003EAK\u0003\u001b\fy-!5\u0002T\u0006U\u0017q[Am\u0011\u00191G\u00041\u0001\u0002\u0016\"1A\u000e\ba\u0001\u0003+CaA\u001c\u000fA\u0002\u0005U\u0005B\u00029\u001d\u0001\u0004\t)\n\u0003\u0004s9\u0001\u0007\u0011Q\u0013\u0005\u0007ir\u0001\r!!&\t\rYd\u0002\u0019AAn!\u0011q\u00160!&\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBAq\u0003[\f9\u0010\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9OP\u0001\bG>$WmZ3o\u0013\u0011\tY/!:\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a<\u001e\u0001\u0004\t\t0A\u0002dib\u0004B!a9\u0002t&!\u0011Q_As\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!?\u001e\u0001\u0004\t\t/\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003}\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\t\u0005\u001d\"1\u0001\u0005\b\u0005\u000by\u0002\u0019\u0001B\u0004\u0003-qWm^\"iS2$'/\u001a8\u0011\u000b\u0005}#\u0011\u00025\n\t\t-\u00111\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$B#a\n\u0003\u0012\tM!Q\u0003B\f\u00053\u0011YB!\b\u0003 \t\u0005\u0002b\u00024!!\u0003\u0005\r\u0001\u001b\u0005\bY\u0002\u0002\n\u00111\u0001i\u0011\u001dq\u0007\u0005%AA\u0002!Dq\u0001\u001d\u0011\u0011\u0002\u0003\u0007\u0001\u000eC\u0004sAA\u0005\t\u0019\u00015\t\u000fQ\u0004\u0003\u0013!a\u0001Q\"9a\u000f\tI\u0001\u0002\u0004A\bb\u0002?!!\u0003\u0005\rA \u0005\n\u0003/\u0001\u0003\u0013!a\u0001\u00037\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003()\u001a\u0001N!\u000b,\u0005\t-\u0002\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000e`\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0011yCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IEK\u0002y\u0005S\tabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003P)\u001aaP!\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u000b\u0016\u0005\u00037\u0011I#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00057\u0002BA!\u0018\u0003d5\u0011!q\f\u0006\u0005\u0005C\n\t-\u0001\u0003mC:<\u0017\u0002BA\t\u0005?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!(\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0013B7\u0011%\u0011y\u0007LA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005k\u0002bAa\u001e\u0003~\u0005UUB\u0001B=\u0015\r\u0011YhX\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B@\u0005s\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0004BC\u0011%\u0011yGLA\u0001\u0002\u0004\t)*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u0011Y\tC\u0005\u0003p=\n\t\u00111\u0001\u0002\u0016\":\u0002Aa$\u0003\u0016\n]%1\u0014BO\u0005C\u0013\u0019Ka*\u0003*\n5&q\u0016\t\u0004\u001b\nE\u0015b\u0001BJ}\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001BM\u0003\u0005\u0015qLR+O\u0007~C\u00130Z1sY\u0001jwN\u001c;iY\u0001\"\u0017-\u001f\u0017!Q>,(\u000f\f\u0011nS:d\u0003e]3d72\u0002C/[7fu>tW-X\u0015![\u0001\u001a%/Z1uK\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4s_6\u0004\u00130Z1sY\u0001jwN\u001c;iY\u0001\"\u0017-\u001f\u0017!Q>,(\u000f\f\u0011nS:d\u0003e]3dA\u0005tG\r\t;j[\u0016TxN\\3!M&,G\u000eZ:/\u0003%\t'oZ;nK:$8/\t\u0002\u0003 \u0006!YO\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!s\u0016\f'\u000fI\u0017!i\",\u0007%_3be\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001\"x\u000eI\u001d:seR\u0001\u0005\t\u0011!A\u0001R\u0003%\\8oi\"\u0004S\u0006\t;iK\u0002jwN\u001c;i[=4W&_3be\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001B#*\u00198vCJL\u0018\u0006\t;pAE\u0012\u0004\u0005\u000b#fG\u0016l'-\u001a:*\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017-\u001f\u0011.AQDW\r\t3bs6zg-L7p]RD\u0007\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\n\u0004\u0005^8!gER\u0001\u0005\t\u0011!A\u0001R\u0003\u0005[8ve\u0002j\u0003\u0005\u001e5fA!|WO]\u0017pM6\"\u0017-\u001f\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002\u00124G\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011nS:\u0004S\u0006\t;iK\u0002j\u0017N\\;uK6zg-\f5pkJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAA\u0002Co\u001c\u00116s)\u0001\u0003\u0005\t\u0011!A)\u00023/Z2![\u0001\"\b.\u001a\u0011tK\u000e|g\u000eZ\u0017pM6j\u0017N\\;uK\u0002\ng\u000e\u001a\u0011jiN\u0004S.[2s_62'/Y2uS>t\u0007\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0004\u0005^8!mAr\u0003%\u00134!i\",\u0007e]3dA\u0005\u0014x-^7f]R\u0004S-];bYN\u0004Co\u001c\u00117a1\u0002C\u000f[3!g\u0016\u001cwN\u001c3tA\u0019LW\r\u001c3!SN\u00043/\u001a;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u0004\u0003\u0007I1oI\u0002\n\u0004%\\5okR,\u0007%[:!C\u0012$W\r\u001a\u0011u_\u0002\"\b.\u001a\u0011gS:\fG\u000e\t;j[\u0016\u001cH/Y7q])\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fu>tW\rI\u0017!i\",\u0007\u0005^5nK\u0002RxN\\3!S\u0012,g\u000e^5gS\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003eQ#UY\u0001*Fk\u0011\u0011b]\u0012\u0004S\r^2/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\u0015\u0016aa\u0004\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014\u0007\u000e\u0017!cIb\u0003E\r\u001d-AYb\u0003e\r\u0019-AQ*d\u0006\u000f\u001d8SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TF\r\u001d!aYR4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\nD\u0007\f\u00112e1\u0002#\u0007\u000f\u0017!m1\u00023\u0007\r\u0017!iUr\u0003\bO\u001c-A\u001d\u001aU\tV\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001b.cIj#g\u000e\u00113ci\u001a\u0004G\u000f\u001b6]aBtG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aEJD\u0006\t\u001c-AM\u0002D\u0006\t\u001a4Y\u0001*\u0014\b\f\u00117a%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002t'\f\u00192AA\u0002$\b\r\u0019;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002\u0013g\r\u0017!c1\u0002\u0013\u0007\r\u0017!cEb\u0003%\r\u001a-A\u001d\u00026\u000bV\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9,H\u000e\u001c\u0017!o1\u0002#G\r\u0017!cUb\u0003e\r\u0019-AAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005W\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00032\u0006)1G\f\u0019/a\u0005iQ*Y6f)&lWm\u001d;b[B\u0004\"!T\u0019\u0014\tE\u0012Il\u0019\t\u0011\u0005w\u0013\t\r\u001b5iQ\"D\u0007P`A\u000e\u0003Oi!A!0\u000b\u0007\t}v,A\u0004sk:$\u0018.\\3\n\t\t\r'Q\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:LDC\u0001B[\u0003!!xn\u0015;sS:<GC\u0001B.\u0003\u0015\t\u0007\u000f\u001d7z)Q\t9Ca4\u0003R\nM'Q\u001bBl\u00053\u0014YN!8\u0003`\")a\r\u000ea\u0001Q\")A\u000e\u000ea\u0001Q\")a\u000e\u000ea\u0001Q\")\u0001\u000f\u000ea\u0001Q\")!\u000f\u000ea\u0001Q\")A\u000f\u000ea\u0001Q\"9a\u000f\u000eI\u0001\u0002\u0004A\bb\u0002?5!\u0003\u0005\rA \u0005\n\u0003/!\u0004\u0013!a\u0001\u00037\tq\"\u00199qYf$C-\u001a4bk2$HeN\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-(1\u001f\t\u0005=f\u0014i\u000fE\u0007_\u0005_D\u0007\u000e\u001b5iQbt\u00181D\u0005\u0004\u0005c|&A\u0002+va2,\u0017\bC\u0005\u0003vb\n\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\n1B]3bIJ+7o\u001c7wKR\u00111\u0011\u0001\t\u0005\u0005;\u001a\u0019!\u0003\u0003\u0004\u0006\t}#AB(cU\u0016\u001cG\u000f")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, MakeTimestamp>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day(), this.hour(), this.min(), this.sec()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(8, 6)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone().map((Function1 & Serializable & scala.Serializable)x$10 -> StringType$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nullable())) : true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Seconds fraction must have 6 digits for microseconds but got ").append(secAndMicros.scale()).toString());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            Predef$.MODULE$.assert(secAndMicros.precision() <= 8, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Seconds and fraction cannot have more than 8 digits but got ").append(secAndMicros.precision()).toString());
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, (int)1000000L);
            int nanos = Math.floorMod(totalMicros, (int)1000000L) * (int)1000L;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError();
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            Long l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
            return l;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException)) throw throwable;
            if (this.failOnError()) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable & scala.Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = new StringOps(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable & scala.Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zid);
            return new StringBuilder(831).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError();\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n        ").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 9;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

