/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015Q\b\u0001\"\u0015|\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003G\u0001\u0011\u0011!C!\u0003KA\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h\u001dI\u00111\u0012\u000f\u0002\u0002#\u0005\u0011Q\u0012\u0004\t7q\t\t\u0011#\u0001\u0002\u0010\"1!)\u0006C\u0001\u0003;C\u0011\"a(\u0016\u0003\u0003%)%!)\t\u0013\u0005\rV#!A\u0005\u0002\u0006\u0015\u0006\"CAV+\u0005\u0005I\u0011QAW\u0011%\ty,FA\u0001\n\u0013\t\tMA\u0003OC:3HN\u0003\u0002\u001e=\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0002%\u0001\u0005dCR\fG._:u\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\u0015\u0001!FL\u00198!\tYC&D\u0001\u001d\u0013\tiCD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u00111fL\u0005\u0003aq\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b!J|G-^2u!\t\u0011\u0004(\u0003\u0002:g\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005a\u0004CA\u0016>\u0013\tqDD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002E\u000b\u001a\u0003\"a\u000b\u0001\t\u000bi*\u0001\u0019\u0001\u001f\t\u000b\u0001+\u0001\u0019\u0001\u001f\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u0002\nQ\u0001^=qKNL!AT&\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\t\u0006c\u0001*[;:\u00111\u000b\u0017\b\u0003)^k\u0011!\u0016\u0006\u0003-\"\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005e\u001b\u0014a\u00029bG.\fw-Z\u0005\u00037r\u00131aU3r\u0015\tI6\u0007\u0005\u0002K=&\u0011ql\u0013\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fA!\u001a<bYR\u0011!-\u001a\t\u0003e\rL!\u0001Z\u001a\u0003\u0007\u0005s\u0017\u0010C\u0004g\u0011A\u0005\t\u0019A4\u0002\u000b%t\u0007/\u001e;\u0011\u0005!LW\"\u0001\u0010\n\u0005)t\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u00075\u001c\b\u0010\u0005\u0002oc6\tqN\u0003\u0002q9\u000591m\u001c3fO\u0016t\u0017B\u0001:p\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002;\n\u0001\u0004)\u0018aA2uqB\u0011aN^\u0005\u0003o>\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003z\u0013\u0001\u0007Q.\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\trt\b\"B?\u000b\u0001\u0004a\u0014a\u00028fo2+g\r\u001e\u0005\u0006\u007f*\u0001\r\u0001P\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015!\u0015QAA\u0004\u0011\u001dQ4\u0002%AA\u0002qBq\u0001Q\u0006\u0011\u0002\u0003\u0007A(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055!f\u0001\u001f\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001cM\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\t1\fgn\u001a\u0006\u0003\u0003c\tAA[1wC&!\u0011QGA\u0016\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\b\t\u0004e\u0005u\u0012bAA g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!-!\u0012\t\u0013\u0005\u001d\u0003#!AA\u0002\u0005m\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002NA)\u0011qJA+E6\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u001a\u0014AC2pY2,7\r^5p]&!\u0011qKA)\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00131\r\t\u0004e\u0005}\u0013bAA1g\t9!i\\8mK\u0006t\u0007\u0002CA$%\u0005\u0005\t\u0019\u00012\u0002\r\u0015\fX/\u00197t)\u0011\ti&!\u001b\t\u0011\u0005\u001d3#!AA\u0002\tD3\u0003AA7\u0003g\n)(!\u001f\u0002|\u0005}\u0014\u0011QAC\u0003\u000f\u00032aKA8\u0013\r\t\t\b\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9(A'`\rVs5i\u0018\u0015fqB\u0014\u0018\u0007\f\u0011fqB\u0014('\u000b\u0011.AI+G/\u001e:og\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013N\u001a\u0011ji\u001e\u001a\bE\\8uA9\u000bg\n\f\u0011pe\u0002\u0002W\r\u001f9se\u0001\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!! \u0002#*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3-Y:uQ\u001dr\u0015MT\u0014!CN\u0004Cm\\;cY\u0016LC\u0006I\u00193g%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001a4]AR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0007\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!#\u0002#\r|g\u000eZ5uS>t\u0017\r\\0gk:\u001c7/A\u0003OC:3H\u000e\u0005\u0002,+M!Q#!%8!\u001d\t\u0019*!'=y\u0011k!!!&\u000b\u0007\u0005]5'A\u0004sk:$\u0018.\\3\n\t\u0005m\u0015Q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAG\u0003!!xn\u0015;sS:<GCAA\u0014\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!\u0015qUAU\u0011\u0015Q\u0004\u00041\u0001=\u0011\u0015\u0001\u0005\u00041\u0001=\u0003\u001d)h.\u00199qYf$B!a,\u0002<B)!'!-\u00026&\u0019\u00111W\u001a\u0003\r=\u0003H/[8o!\u0015\u0011\u0014q\u0017\u001f=\u0013\r\tIl\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005u\u0016$!AA\u0002\u0011\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0007\u0003BA\u0015\u0003\u000bLA!a2\u0002,\t1qJ\u00196fGR\u0004")
public class NaNvl
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl naNvl) {
        return NaNvl$.MODULE$.unapply(naNvl);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object value = this.left().eval(input);
        if (value == null) {
            object = null;
        } else {
            Object object2;
            DataType dataType = this.left().dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = !Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)value)).isNaN() ? value : this.right().eval(input);
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = !Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)value)).isNaN() ? value : this.right().eval(input);
            } else {
                throw new MatchError((Object)dataType);
            }
            object = object2;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new MatchError((Object)dataType);
        }
        ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        return exprCode;
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

