/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.1164209726833079\n      > SELECT _FUNC_(null);\n       1.1164209726833079\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0011#\u0001>B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015I\u0005\u0001\"\u0001O\u0011\u0015I\u0005\u0001\"\u0001P\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015A\u0006\u0001\"\u0015Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015\u0011\b\u0001\"\u0011O\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u00199\u0003\u0001\"\u0011\u0002\n!9\u00111\u0004\u0001\u0005R\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\tY\u0003AI\u0001\n\u0003\ti\u0003C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131\n\u0005\n\u00037\u0002\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019iB\u0004\u0002.\nB\t!a,\u0007\r\u0005\u0012\u0003\u0012AAY\u0011\u0019I\u0015\u0004\"\u0001\u0002:\"9\u00111X\r\u0005\u0002\u0005u\u0006\"CA^3\u0005\u0005I\u0011QAa\u0011%\t9-GI\u0001\n\u0003\t)\u0005C\u0005\u0002Jf\t\t\u0011\"!\u0002L\"I\u0011Q\\\r\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003?L\u0012\u0011!C\u0005\u0003C\u0014QAU1oI:T!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0005\u0001A\"$\b\u0005\u00022e5\t!%\u0003\u00024E\t\u0019!\u000bR$\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011QgO\u0005\u0003yY\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012a\u0010\t\u0003c\u0001K!!\u0011\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\tQ&$WmU3fIV\tQ\t\u0005\u00026\r&\u0011qI\u000e\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00172k\u0005CA\u0019\u0001\u0011\u0015iT\u00011\u0001@\u0011\u001d\u0019U\u0001%AA\u0002\u0015#\u0012a\u0013\u000b\u0003\u0017BCQ!P\u0004A\u0002}\n1b^5uQ:+woU3fIR\u00111j\u0015\u0005\u0006)\"\u0001\r!V\u0001\u0005g\u0016,G\r\u0005\u00026-&\u0011qK\u000e\u0002\u0005\u0019>tw-\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0002[;B\u0011QgW\u0005\u00039Z\u0012a\u0001R8vE2,\u0007\"\u00020\n\u0001\u0004y\u0016!B5oaV$\bC\u00011b\u001b\u0005!\u0013B\u00012%\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA3laB\u0011a-[\u0007\u0002O*\u0011\u0001NI\u0001\bG>$WmZ3o\u0013\tQwM\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015a'\u00021\u0001n\u0003\r\u0019G\u000f\u001f\t\u0003M:L!a\\4\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")\u0011O\u0003a\u0001K\u0006\u0011QM^\u0001\nMJ,7\u000f[\"paf\fQB\u001a7bi\u0006\u0013x-^7f]R\u001cX#A;\u0011\tYt\u00181\u0001\b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f\u0018\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014BA?7\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005!IE/\u001a:bi>\u0014(BA?7!\r)\u0014QA\u0005\u0004\u0003\u000f1$aA!osV\u0011\u00111\u0002\t\u0005\u0003\u001b\t)B\u0004\u0003\u0002\u0010\u0005E\u0001C\u0001=7\u0013\r\t\u0019BN\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0011\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ma'\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004\u0017\u0006}\u0001BBA\u0011\u001d\u0001\u0007q(\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000b-\u000b9#!\u000b\t\u000fuz\u0001\u0013!a\u0001\u007f!91i\u0004I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003_Q3aPA\u0019W\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001fm\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0013q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fR3!RA\u0019\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0006\u0002R\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\f\t\u0004k\u0005\u0005\u0014bAA2m\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111AA5\u0011%\tY\u0007FA\u0001\u0002\u0004\ty&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0002b!a\u001d\u0002z\u0005\rQBAA;\u0015\r\t9HN\u0001\u000bG>dG.Z2uS>t\u0017bA@\u0002v\u0005A1-\u00198FcV\fG\u000eF\u0002F\u0003\u007fB\u0011\"a\u001b\u0017\u0003\u0003\u0005\r!a\u0001\u0002\r\u0015\fX/\u00197t)\r)\u0015Q\u0011\u0005\n\u0003W:\u0012\u0011!a\u0001\u0003\u0007As\u0003AAE\u0003\u001f\u000b\t*!&\u0002\u0018\u0006m\u0015QTAQ\u0003G\u000b9+!+\u0011\u0007E\nY)C\u0002\u0002\u000e\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0014\u0006\t\u0019c\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!m\u0006dW/Z:!IJ\fwO\u001c\u0011ge>l\u0007\u0005\u001e5fAM$\u0018M\u001c3be\u0012\u0004cn\u001c:nC2\u0004C-[:ue&\u0014W\u000f^5p]:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\u000b\u0011\u0011\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)SmR\u0001\u0005\t\u0011!A\u0001\u0002S\u0006\r\u00184eU\"\u0014\u0007N\u001c:qM\u0002\u0004\b\r\u001a9q)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\n\u0014G\u000e\u001b3ae:$G\u000e\u001d4gA:\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]E\nd\u0007\u000e\u001a1s]\u0012d\u0007O\u001a4a]J$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003?\u000b!H\u0003\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oA%\u001c\bE\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA%t\u0007eZ3oKJ\fG\u000eI2bg\u0016t#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAV\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0006%\u0006tGM\u001c\t\u0003ce\u0019B!GAZuA\u0019Q'!.\n\u0007\u0005]fG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003_\u000bQ!\u00199qYf$2aSA`\u0011\u0015!6\u00041\u0001V)\u0015Y\u00151YAc\u0011\u0015iD\u00041\u0001@\u0011\u001d\u0019E\u0004%AA\u0002\u0015\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti-!7\u0011\u000bU\ny-a5\n\u0007\u0005EgG\u0001\u0004PaRLwN\u001c\t\u0006k\u0005Uw(R\u0005\u0004\u0003/4$A\u0002+va2,'\u0007\u0003\u0005\u0002\\z\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003G\u0004B!a\u0014\u0002f&!\u0011q]A)\u0005\u0019y%M[3di\u0002")
public class Randn
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn randn) {
        return Randn$.MODULE$.unapply(randn);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Randn freshCopy() {
        return new Randn(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(7).append("randn(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Randn withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != randn.hideSeed()) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

