/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start, stop, step) - Generates an array of elements from start to stop (inclusive),\n      incrementing by step. The type of the returned elements is the same as the type of argument\n      expressions.\n\n      Supported types are: byte, short, integer, long, date, timestamp.\n\n      The start and stop expressions must resolve to the same type.\n      If start and stop expressions resolve to the 'date' or 'timestamp' type\n      then the step expression must resolve to the 'interval' type, otherwise to the same type\n      as the start and stop expressions.\n  ", arguments="\n    Arguments:\n      * start - an expression. The start of the range.\n      * stop - an expression. The end the range (inclusive).\n      * step - an optional expression. The step of the range.\n          By default step is 1 if start is less than or equal to stop, otherwise -1.\n          For the temporal sequences it's 1 day and -1 day respectively.\n          If start is greater than stop then the step must be negative, and vice versa.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(5, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(to_date('2018-01-01'), to_date('2018-03-01'), interval 1 month);\n       [2018-01-01,2018-02-01,2018-03-01]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001\u0002,X\u0001\u0012D\u0001\"\u001e\u0001\u0003\u0016\u0004%\tA\u001e\u0005\to\u0002\u0011\t\u0012)A\u0005K\"A\u0001\u0010\u0001BK\u0002\u0013\u0005a\u000f\u0003\u0005z\u0001\tE\t\u0015!\u0003f\u0011!Q\bA!f\u0001\n\u0003Y\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u0015\u0005\u0005\u0001A!f\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\u001e\u0001\u0011\t\u0012)A\u0005\u0003\u000bAq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002 \u0001!\t!!\f\t\u000f\u0005}\u0001\u0001\"\u0001\u00024!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t9\u0007\u0001C!\u0003SBq!!\u001d\u0001\t\u0003\nI\u0007C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0013\u0001\u0005\u0002\u0005\u0015\u0003bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\u000b\u0003G\u0003\u0001R1A\u0005\n\u0005\u0015\u0006b\u0002B\n\u0001\u0011\u00053\u0011\u0011\u0005\b\u0007\u001f\u0003A\u0011KBI\u0011%\u0019I\nAA\u0001\n\u0003\u0019Y\nC\u0005\u0004&\u0002\t\n\u0011\"\u0001\u0004(\"I11\u0016\u0001\u0012\u0002\u0013\u00051q\u0015\u0005\n\u0007[\u0003\u0011\u0013!C\u0001\u0007_C\u0011ba-\u0001#\u0003%\ta!\u0011\t\u0013\rU\u0006!!A\u0005B\r]\u0006\"CB_\u0001\u0005\u0005I\u0011AB`\u0011%\u0019\t\rAA\u0001\n\u0003\u0019\u0019\rC\u0005\u0004J\u0002\t\t\u0011\"\u0011\u0004L\"I1\u0011\u001c\u0001\u0002\u0002\u0013\u000511\u001c\u0005\n\u0007?\u0004\u0011\u0011!C!\u0007C<q!a+X\u0011\u0003\tiK\u0002\u0004W/\"\u0005\u0011q\u0016\u0005\b\u0003?!C\u0011AA\\\u000b\u0019\tI\f\n\u0003\u0002<\u001a1\u0011q\u0019\u0013\u0005\u0003\u0013D!\"a3(\u0005\u0003\u0005\u000b\u0011BAg\u0011)\t\tn\nB\u0001B\u0003%\u0011Q\u0014\u0005\u000b\u0003'<#\u0011!Q\u0001\n\u0005\u0005\u0007bBA\u0010O\u0011\u0005\u0011Q\u001b\u0005\n\u0003?<#\u0019!C\u0005\u0003CD\u0001\"a9(A\u0003%\u0011\u0011\u0019\u0005\b\u0003K<C\u0011AAt\u0011\u001d\tio\nC\u0001\u0003_4\u0011Ba\u0004%!\u0003\rJA!\u0005\t\u000f\tM\u0001G\"\u0001\u0003\u0016!9\u0011Q\u001e\u0019\u0007\u0002\tu\u0001\"\u0003B\u0018a\t\u0007i\u0011\u0001B\u0019\r\u0019\u0011\u0019\u0004\n\u0003\u00036!Q!Q\u0006\u001b\u0003\u0002\u0003\u0006IAa\u000f\t\u0015\t\u0005CGaA!\u0002\u0017\u0011\u0019\u0005\u0003\u0006\u0003`Q\u0012\t\u0011)A\u0006\u0005CBq!a\b5\t\u0003\u00119\u0007C\u0005\u00030Q\u0012\r\u0011\"\u0011\u00032!A!1\u000f\u001b!\u0002\u0013\t9\u000eC\u0004\u0003\u0014Q\"\tE!\u001e\t\u000f\u00055H\u0007\"\u0011\u0003\n\u001a1!q\u0013\u0013\u0005\u00053C!B!(>\u0005\u0003\u0005\u000b\u0011\u0002B\u001e\u0011)\u0011y*\u0010B\u0001B\u0003%!\u0011\u0015\u0005\u000b\u0005Ok$\u0011!Q\u0001\n\t%\u0006B\u0003BZ{\t\u0005\t\u0015!\u0003\u00036\"Q!QY\u001f\u0003\u0004\u0003\u0006YAa2\t\u0015\t}SH!A!\u0002\u0017\u0011I\rC\u0004\u0002 u\"\tAa3\t\u0013\t=RH1A\u0005B\tE\u0002\u0002\u0003B:{\u0001\u0006I!a6\t\u0013\tuWH1A\u0005\n\t}\u0007\u0002\u0003Br{\u0001\u0006IA!9\t\u0013\t\u0015XH1A\u0005\n\t\u001d\b\u0002\u0003Bu{\u0001\u0006IA!)\t\u0013\t-XH1A\u0005\n\t\u001d\b\u0002\u0003Bw{\u0001\u0006IA!)\t\u000f\tMQ\b\"\u0011\u0003p\"9\u0011Q^\u001f\u0005B\te\bbBB\u0004I\u0011%1\u0011\u0002\u0005\b\u0007K!C\u0011BB\u0014\u0011%\t)\u000fJA\u0001\n\u0003\u001b)\u0004C\u0005\u0004@\u0011\n\n\u0011\"\u0001\u0004B!I1q\u000b\u0013\u0002\u0002\u0013\u00055\u0011\f\u0005\n\u0007O\"\u0013\u0013!C\u0001\u0007\u0003B\u0011b!\u001b%\u0003\u0003%Iaa\u001b\u0003\u0011M+\u0017/^3oG\u0016T!\u0001W-\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00035n\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u00039v\u000b1a]9m\u0015\tqv,A\u0003ta\u0006\u00148N\u0003\u0002aC\u00061\u0011\r]1dQ\u0016T\u0011AY\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0015LGN\u001d\t\u0003M\u001el\u0011aV\u0005\u0003Q^\u0013!\"\u0012=qe\u0016\u001c8/[8o!\t1'.\u0003\u0002l/\n9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\b!J|G-^2u!\ti7/\u0003\u0002u]\na1+\u001a:jC2L'0\u00192mK\u0006)1\u000f^1siV\tQ-\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u0005gR|\u0007/A\u0003ti>\u0004\b%A\u0004ti\u0016\u0004x\n\u001d;\u0016\u0003q\u00042!\\?f\u0013\tqhN\u0001\u0004PaRLwN\\\u0001\tgR,\u0007o\u00149uA\u0005QA/[7f5>tW-\u00133\u0016\u0005\u0005\u0015\u0001\u0003B7~\u0003\u000f\u0001B!!\u0003\u0002\u00189!\u00111BA\n!\r\tiA\\\u0007\u0003\u0003\u001fQ1!!\u0005d\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00038\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)B\\\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003G\t)#a\n\u0002*\u0005-\u0002C\u00014\u0001\u0011\u0015)\u0018\u00021\u0001f\u0011\u0015A\u0018\u00021\u0001f\u0011\u0015Q\u0018\u00021\u0001}\u0011%\t\t!\u0003I\u0001\u0002\u0004\t)\u0001\u0006\u0004\u0002$\u0005=\u0012\u0011\u0007\u0005\u0006k*\u0001\r!\u001a\u0005\u0006q*\u0001\r!\u001a\u000b\t\u0003G\t)$a\u000e\u0002:!)Qo\u0003a\u0001K\")\u0001p\u0003a\u0001K\"1\u00111H\u0006A\u0002\u0015\fAa\u001d;fa\u0006aq/\u001b;i)&lWMW8oKR\u0019\u0011.!\u0011\t\u000f\u0005\u0005A\u00021\u0001\u0002\b\u0005A1\r[5mIJ,g.\u0006\u0002\u0002HA)\u0011\u0011JA*K:!\u00111JA(\u001d\u0011\ti!!\u0014\n\u0003=L1!!\u0015o\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0016\u0002X\t\u00191+Z9\u000b\u0007\u0005Ec.A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019\u0011.!\u0018\t\u000f\u0005}c\u00021\u0001\u0002b\u0005Ya.Z<DQ&dGM]3o!\u0015\tI%a\u0019f\u0013\u0011\t)'a\u0016\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0005g_2$\u0017M\u00197f+\t\tY\u0007E\u0002n\u0003[J1!a\u001co\u0005\u001d\u0011un\u001c7fC:\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP.\u0002\u000bQL\b/Z:\n\t\u0005\u0005\u00151\u0010\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$Z\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAI\u0003\u0017\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0012G>,'oY5cY\u0016\u001c\u0005.\u001b7ee\u0016t\u0017AD2bgR\u001c\u0005.\u001b7ee\u0016tGk\u001c\u000b\u0004K\u0006e\u0005bBAN)\u0001\u0007\u0011QT\u0001\no&$WM\u001d+za\u0016\u0004B!!\u001f\u0002 &!\u0011\u0011UA>\u0005!!\u0015\r^1UsB,\u0017\u0001B5na2,\"!a*\u0011\u0007\u0005%\u0006G\u0004\u0002gG\u0005A1+Z9vK:\u001cW\r\u0005\u0002gIM!A%!-s!\ri\u00171W\u0005\u0004\u0003ks'AB!osJ+g\r\u0006\u0002\u0002.\n\tB*Z:t)\"\fgn\u0014:FcV\fGN\u00128\u0011\u00135\fi,!1\u0002B\u0006-\u0014bAA`]\nIa)\u001e8di&|gN\r\t\u0004[\u0006\r\u0017bAAc]\n\u0019\u0011I\\=\u0003\u0017\u0011+g-Y;miN#X\r]\n\u0004O\u0005E\u0016\u0001\u00027uKF\u00042!a4'\u001b\u0005!\u0013\u0001C:uKB$\u0016\u0010]3\u0002\u0007=tW\r\u0006\u0005\u0002X\u0006e\u00171\\Ao!\r\tym\n\u0005\b\u0003\u0017\\\u0003\u0019AAg\u0011\u001d\t\tn\u000ba\u0001\u0003;Cq!a5,\u0001\u0004\t\t-A\u0006oK\u001e\fG/\u001b<f\u001f:,WCAAa\u00031qWmZ1uSZ,wJ\\3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\t-!;\u0002l\"1QO\fa\u0001\u0003\u0003Da\u0001\u001f\u0018A\u0002\u0005\u0005\u0017aB4f]\u000e{G-\u001a\u000b\t\u0003c\fiPa\u0002\u0003\fA!\u00111_A}\u001b\t\t)PC\u0002\u0002x^\u000bqaY8eK\u001e,g.\u0003\u0003\u0002|\u0006U(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005}x\u00061\u0001\u0003\u0002\u0005\u00191\r\u001e=\u0011\t\u0005M(1A\u0005\u0005\u0005\u000b\t)P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t%q\u00061\u0001\u0002r\u0006A1\u000f^1si\u001e+g\u000eC\u0004\u0003\u000e=\u0002\r!!=\u0002\u000fM$x\u000e]$f]\na1+Z9vK:\u001cW-S7qYN\u0019\u0001'!-\u0002\t\u00154\u0018\r\u001c\u000b\t\u0003\u0003\u00149B!\u0007\u0003\u001c!1Q/\ra\u0001\u0003\u0003Da\u0001_\u0019A\u0002\u0005\u0005\u0007bBA\u001ec\u0001\u0007\u0011\u0011\u0019\u000b\u000f\u0003\u000f\u0011yB!\t\u0003$\t\u0015\"q\u0005B\u0016\u0011\u001d\tyP\ra\u0001\u0005\u0003Aa!\u001e\u001aA\u0002\u0005\u001d\u0001B\u0002=3\u0001\u0004\t9\u0001C\u0004\u0002<I\u0002\r!a\u0002\t\u000f\t%\"\u00071\u0001\u0002\b\u0005\u0019\u0011M\u001d:\t\u000f\t5\"\u00071\u0001\u0002\b\u0005AQ\r\\3n)f\u0004X-A\u0006eK\u001a\fW\u000f\u001c;Ti\u0016\u0004XCAAl\u0005QIe\u000e^3he\u0006d7+Z9vK:\u001cW-S7qYV!!q\u0007B*'\u0015!\u0014\u0011\u0017B\u001d!\r\ty\r\r\t\u0005\u0003s\u0012i$\u0003\u0003\u0003@\u0005m$\u0001D%oi\u0016<'/\u00197UsB,\u0017AC3wS\u0012,gnY3%cA1!Q\tB&\u0005\u001fj!Aa\u0012\u000b\u0007\t%c.A\u0004sK\u001adWm\u0019;\n\t\t5#q\t\u0002\t\u00072\f7o\u001d+bOB!!\u0011\u000bB*\u0019\u0001!qA!\u00165\u0005\u0004\u00119FA\u0001U#\u0011\u0011I&!1\u0011\u00075\u0014Y&C\u0002\u0003^9\u0014qAT8uQ&tw-A\u0002ok6\u0004b!!\u0013\u0003d\t=\u0013\u0002\u0002B3\u0003/\u0012\u0001\"\u00138uK\u001e\u0014\u0018\r\u001c\u000b\u0005\u0005S\u0012\t\b\u0006\u0004\u0003l\t5$q\u000e\t\u0006\u0003\u001f$$q\n\u0005\b\u0005\u0003B\u00049\u0001B\"\u0011\u001d\u0011y\u0006\u000fa\u0002\u0005CBqA!\f9\u0001\u0004\u0011Y$\u0001\u0007eK\u001a\fW\u000f\u001c;Ti\u0016\u0004\b\u0005\u0006\u0005\u0003x\tu$\u0011\u0011BC!\u0015i'\u0011\u0010B(\u0013\r\u0011YH\u001c\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005\u007fZ\u0004\u0019AAa\u0003\u0019Ig\u000e];uc!9!1Q\u001eA\u0002\u0005\u0005\u0017AB5oaV$(\u0007C\u0004\u0003\bn\u0002\r!!1\u0002\r%t\u0007/\u001e;4)9\t9Aa#\u0003\u000e\n=%\u0011\u0013BJ\u0005+Cq!a@=\u0001\u0004\u0011\t\u0001\u0003\u0004vy\u0001\u0007\u0011q\u0001\u0005\u0007qr\u0002\r!a\u0002\t\u000f\u0005mB\b1\u0001\u0002\b!9!\u0011\u0006\u001fA\u0002\u0005\u001d\u0001b\u0002B\u0017y\u0001\u0007\u0011q\u0001\u0002\u0015)\u0016l\u0007o\u001c:bYN+\u0017/^3oG\u0016LU\u000e\u001d7\u0016\t\tm%\u0011W\n\u0006{\u0005E&\u0011H\u0001\u0003IR\fQa]2bY\u0016\u00042!\u001cBR\u0013\r\u0011)K\u001c\u0002\u0005\u0019>tw-\u0001\u0005ge>lGj\u001c8h!\u001di'1\u0016BQ\u0005_K1A!,o\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003R\tEFa\u0002B+{\t\u0007!qK\u0001\u0007u>tW-\u00133\u0011\t\t]&\u0011Y\u0007\u0003\u0005sSAAa/\u0003>\u0006!A/[7f\u0015\t\u0011y,\u0001\u0003kCZ\f\u0017\u0002\u0002Bb\u0005s\u0013aAW8oK&#\u0017AC3wS\u0012,gnY3%eA1!Q\tB&\u0005_\u0003b!!\u0013\u0003d\t=FC\u0003Bg\u0005+\u00149N!7\u0003\\R1!q\u001aBi\u0005'\u0004R!a4>\u0005_CqA!2E\u0001\b\u00119\rC\u0004\u0003`\u0011\u0003\u001dA!3\t\u000f\tuE\t1\u0001\u0003<!9!q\u0014#A\u0002\t\u0005\u0006b\u0002BT\t\u0002\u0007!\u0011\u0016\u0005\b\u0005g#\u0005\u0019\u0001B[\u0003I\u0011\u0017mY6fIN+\u0017/^3oG\u0016LU\u000e\u001d7\u0016\u0005\t\u0005\b#BAhi\t=\u0016a\u00052bG.,GmU3rk\u0016t7-Z%na2\u0004\u0013\u0001D7jGJ|7\u000fU3s\t\u0006LXC\u0001BQ\u00035i\u0017n\u0019:pgB+'\u000fR1zA\u0005qQ.[2s_N\u0004VM]'p]RD\u0017aD7jGJ|7\u000fU3s\u001b>tG\u000f\u001b\u0011\u0015\u0011\tE(1\u001fB{\u0005o\u0004R!\u001cB=\u0005_CqAa N\u0001\u0004\t\t\rC\u0004\u0003\u00046\u0003\r!!1\t\u000f\t\u001dU\n1\u0001\u0002BRq\u0011q\u0001B~\u0005{\u0014yp!\u0001\u0004\u0004\r\u0015\u0001bBA\u0000\u001d\u0002\u0007!\u0011\u0001\u0005\u0007k:\u0003\r!a\u0002\t\rat\u0005\u0019AA\u0004\u0011\u001d\tYD\u0014a\u0001\u0003\u000fAqA!\u000bO\u0001\u0004\t9\u0001C\u0004\u0003.9\u0003\r!a\u0002\u0002#\u001d,GoU3rk\u0016t7-\u001a'f]\u001e$\b.\u0006\u0003\u0004\f\rmA\u0003CB\u0007\u0007?\u0019\tca\t\u0015\t\r=1Q\u0003\t\u0004[\u000eE\u0011bAB\n]\n\u0019\u0011J\u001c;\t\u000f\t}s\nq\u0001\u0004\u0018A1\u0011\u0011\nB2\u00073\u0001BA!\u0015\u0004\u001c\u001191QD(C\u0002\t]#!A+\t\rU|\u0005\u0019AB\r\u0011\u0019Ax\n1\u0001\u0004\u001a!9\u00111H(A\u0002\re\u0011!F4f]N+\u0017/^3oG\u0016dUM\\4uQ\u000e{G-\u001a\u000b\r\u0003\u000f\u0019Ica\u000b\u0004.\r=2\u0011\u0007\u0005\b\u0003\u007f\u0004\u0006\u0019\u0001B\u0001\u0011\u0019)\b\u000b1\u0001\u0002\b!1\u0001\u0010\u0015a\u0001\u0003\u000fAq!a\u000fQ\u0001\u0004\t9\u0001C\u0004\u00044A\u0003\r!a\u0002\u0002\u00071,g\u000e\u0006\u0006\u0002$\r]2\u0011HB\u001e\u0007{AQ!^)A\u0002\u0015DQ\u0001_)A\u0002\u0015DQA_)A\u0002qD\u0011\"!\u0001R!\u0003\u0005\r!!\u0002\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*\"aa\u0011+\t\u0005\u00151QI\u0016\u0003\u0007\u000f\u0002Ba!\u0013\u0004T5\u001111\n\u0006\u0005\u0007\u001b\u001ay%A\u0005v]\u000eDWmY6fI*\u00191\u0011\u000b8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004V\r-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069QO\\1qa2LH\u0003BB.\u0007G\u0002B!\\?\u0004^AAQna\u0018fKr\f)!C\u0002\u0004b9\u0014a\u0001V;qY\u0016$\u0004\"CB3'\u0006\u0005\t\u0019AA\u0012\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007[\u0002Baa\u001c\u0004v5\u00111\u0011\u000f\u0006\u0005\u0007g\u0012i,\u0001\u0003mC:<\u0017\u0002BB<\u0007c\u0012aa\u00142kK\u000e$\bfA\u000b\u0004|A\u0019Qn! \n\u0007\r}dNA\u0005ue\u0006t7/[3oiR!\u0011\u0011YBB\u0011%\u0019)I\u0006I\u0001\u0002\u0004\u00199)A\u0003j]B,H\u000f\u0005\u0003\u0004\n\u000e-U\"A-\n\u0007\r5\u0015LA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\tpa%\u0004\u0016\"9\u0011q`\fA\u0002\t\u0005\u0001bBBL/\u0001\u0007\u0011\u0011_\u0001\u0003KZ\fAaY8qsRQ\u00111EBO\u0007?\u001b\tka)\t\u000fUD\u0002\u0013!a\u0001K\"9\u0001\u0010\u0007I\u0001\u0002\u0004)\u0007b\u0002>\u0019!\u0003\u0005\r\u0001 \u0005\n\u0003\u0003A\u0002\u0013!a\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004**\u001aQm!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCABYU\ra8QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0018\t\u0005\u0007_\u001aY,\u0003\u0003\u0002\u001a\rE\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAB\b\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!1\u0004F\"I1qY\u0010\u0002\u0002\u0003\u00071qB\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r5\u0007CBBh\u0007+\f\t-\u0004\u0002\u0004R*\u001911\u001b8\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004X\u000eE'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001b\u0004^\"I1qY\u0011\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-41\u001d\u0005\n\u0007\u000f\u0014\u0013\u0011!a\u0001\u0003\u0003Ds\u0003ABt\u0007[\u001cyoa=\u0004v\u000ee81`B\u0000\t\u0003!)\u0001b\u0002\u0011\u0007\u0019\u001cI/C\u0002\u0004l^\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0004r\u0006!9H\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aH/\u0019:uY\u0001\u001aHo\u001c9-AM$X\r]\u0015![\u0001:UM\\3sCR,7\u000fI1oA\u0005\u0014(/Y=!_\u001a\u0004S\r\\3nK:$8\u000f\t4s_6\u00043\u000f^1si\u0002\"x\u000eI:u_B\u0004\u0003&\u001b8dYV\u001c\u0018N^3*Y)\u0001\u0003\u0005\t\u0011!A%t7M]3nK:$\u0018N\\4!Ef\u00043\u000f^3q]\u0001\"\u0006.\u001a\u0011usB,\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0011fY\u0016lWM\u001c;tA%\u001c\b\u0005\u001e5fAM\fW.\u001a\u0011bg\u0002\"\b.\u001a\u0011usB,\u0007e\u001c4!CJ<W/\\3oi*\u0001\u0003\u0005\t\u0011!A\u0015D\bO]3tg&|gn\u001d\u0018\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!'V\u0004\bo\u001c:uK\u0012\u0004C/\u001f9fg\u0002\n'/\u001a\u001e!Ef$X\r\f\u0011tQ>\u0014H\u000f\f\u0011j]R,w-\u001a:-A1|gn\u001a\u0017!I\u0006$X\r\f\u0011uS6,7\u000f^1na:R!\u0002\t\u0011!A\u0001\u0002C\u000b[3!gR\f'\u000f\u001e\u0011b]\u0012\u00043\u000f^8qA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bE]3t_24X\r\t;pAQDW\rI:b[\u0016\u0004C/\u001f9f])\u0001\u0003\u0005\t\u0011!A%3\u0007e\u001d;beR\u0004\u0013M\u001c3!gR|\u0007\u000fI3yaJ,7o]5p]N\u0004#/Z:pYZ,\u0007\u0005^8!i\",\u0007e\n3bi\u0016<\u0003e\u001c:!OQLW.Z:uC6\u0004x\u0005\t;za\u0016T\u0001\u0005\t\u0011!A\u0001\"\b.\u001a8!i\",\u0007e\u001d;fa\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011nkN$\bE]3t_24X\r\t;pAQDW\rI\u0014j]R,'O^1mO\u0001\"\u0018\u0010]3-A=$\b.\u001a:xSN,\u0007\u0005^8!i\",\u0007e]1nK\u0002\"\u0018\u0010]3\u000bA\u0001\u0002\u0003\u0005\t\u0011bg\u0002\"\b.\u001a\u0011ti\u0006\u0014H\u000fI1oI\u0002\u001aHo\u001c9!Kb\u0004(/Z:tS>t7O\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0007o\f1Q\u000f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$\u0018M\u001d;![\u0001\ng\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!gR\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011sC:<WM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR|\u0007\u000fI\u0017!C:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\rI3oI\u0002\"\b.\u001a\u0011sC:<W\r\t\u0015j]\u000edWo]5wK&r#\u0002\t\u0011!A\u0001\u0002#\u0006I:uKB\u0004S\u0006I1oA=\u0004H/[8oC2\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\rI:uKB\u0004sN\u001a\u0011uQ\u0016\u0004#/\u00198hK:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Cs\u0002\"WMZ1vYR\u00043\u000f^3qA%\u001c\b%\r\u0011jM\u0002\u001aH/\u0019:uA%\u001c\b\u0005\\3tg\u0002\"\b.\u00198!_J\u0004S-];bY\u0002\"x\u000eI:u_Bd\u0003e\u001c;iKJ<\u0018n]3![Er#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\b\u0005\u001e5fAQ,W\u000e]8sC2\u00043/Z9vK:\u001cWm\u001d\u0011ji\u001e\u001a\b%\r\u0011eCf\u0004\u0013M\u001c3![E\u0002C-Y=!e\u0016\u001c\b/Z2uSZ,G.\u001f\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ti\u0006\u0014H\u000fI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!gR|\u0007\u000f\t;iK:\u0004C\u000f[3!gR,\u0007\u000fI7vgR\u0004#-\u001a\u0011oK\u001e\fG/\u001b<fY\u0001\ng\u000e\u001a\u0011wS\u000e,\u0007E^3sg\u0006t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#a!@\u0002\u0003KT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0017!k%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1\u001aD\u0006\u000e\u00176;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS\u0007\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023,\u000e\u00175YMb#\u0007L\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"xn\u00183bi\u0016DsE\r\u00192q5\u0002\u0014'\f\u00192O%b\u0003\u0005^8`I\u0006$X\rK\u00143aEBT\u0006M\u001a.aE:\u0013\u0006\f\u0011j]R,'O^1mAE\u0002Sn\u001c8uQ&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u001a1caj\u0003'M\u00171c1\u0012\u0004'\r\u001d.aIj\u0003'\r\u00173aEBT\u0006M\u001a.aEj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0011\r\u0011aC1se\u0006LxLZ;oGN\fQa]5oG\u0016\f#\u0001\"\u0003\u0002\u000bIrCG\f\u0019")
public class Sequence
extends Expression
implements TimeZoneAwareExpression,
scala.Serializable {
    private transient SequenceImpl impl;
    private final Expression start;
    private final Expression stop;
    private final Option<Expression> stepOpt;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return Sequence$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence sequence) {
        return Sequence$.MODULE$.unapply(sequence);
    }

    public static Option<String> apply$default$4() {
        return Sequence$.MODULE$.apply$default$4();
    }

    private boolean resolved$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression start() {
        return this.start;
    }

    public Expression stop() {
        return this.stop;
    }

    public Option<Expression> stepOpt() {
        return this.stepOpt;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Option<Expression> x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.start(), this.stop()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.stepOpt()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public TimeZoneAwareExpression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.stepOpt().isDefined() ? this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)), this.copy$default$4()) : this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)x$62.foldable()));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)x$63.nullable()));
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.start().dataType(), false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        boolean bl;
        boolean bl2;
        DataType startType = this.start().dataType();
        boolean typesCorrect = startType.sameType(this.stop().dataType()) && (bl2 = (bl = TimestampType$.MODULE$.equals(dataType = startType) ? true : DateType$.MODULE$.equals(dataType)) ? this.stepOpt().isEmpty() || CalendarIntervalType$.MODULE$.acceptsType(this.stepType$1()) : (dataType instanceof IntegralType ? this.stepOpt().isEmpty() || this.stepType$1().sameType(startType) : false));
        return typesCorrect ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append(this.prettyName()).append(" only supports integral, timestamp or date types").toString());
    }

    public Seq<Expression> coercibleChildren() {
        return (Seq)this.children().filter((Function1 & Serializable & scala.Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)Sequence.$anonfun$coercibleChildren$1(x$64)));
    }

    public Expression castChildrenTo(DataType widerType) {
        return new Sequence(new Cast(this.start(), widerType, Cast$.MODULE$.apply$default$3()), new Cast(this.stop(), widerType, Cast$.MODULE$.apply$default$3()), (Option<Expression>)this.stepOpt().map((Function1 & Serializable & scala.Serializable)step -> {
            DataType dataType = step.dataType();
            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
            return (dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$)) ? new Cast((Expression)step, widerType, Cast$.MODULE$.apply$default$3()) : step;
        }), this.timeZoneId());
    }

    private SequenceImpl impl$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                SequenceImpl sequenceImpl;
                DataType dataType = this.dataType().elementType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    ClassTag ct = ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)integralType.tag().mirror()).runtimeClass(integralType.tag().tpe()));
                    sequenceImpl = new IntegralSequenceImpl<Object>(integralType, ct, integralType.integral());
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(LongType$.MODULE$, 1L, (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))), this.zoneId(), ClassTag$.MODULE$.Long(), Numeric.LongIsIntegral$.MODULE$);
                } else if (DateType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(IntegerType$.MODULE$, 86400000000L, (JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$65 -> (int)x$65, this.zoneId(), ClassTag$.MODULE$.Int(), Numeric.IntIsIntegral$.MODULE$);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.impl = sequenceImpl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.impl;
    }

    private SequenceImpl impl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.impl$lzycompute() : this.impl;
    }

    @Override
    public Object eval(InternalRow input) {
        Object startVal = this.start().eval(input);
        if (startVal == null) {
            return null;
        }
        Object stopVal = this.stop().eval(input);
        if (stopVal == null) {
            return null;
        }
        Object stepVal = this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$66 -> x$66.eval(input)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().apply(startVal, stopVal));
        if (stepVal == null) {
            return null;
        }
        return ArrayData$.MODULE$.toArrayData(this.impl().eval(startVal, stopVal, stepVal));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        ExprCode startGen = this.start().genCode(ctx);
        ExprCode stopGen = this.stop().genCode(ctx);
        ExprCode stepGen = (ExprCode)this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$67 -> x$67.genCode(ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().genCode(ctx, startGen, stopGen));
        String resultType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String arr = ctx.freshName("arr");
        String arrElemType = CodeGenerator$.MODULE$.javaType(this.dataType().elementType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         |final ").append(arrElemType).append("[] ").append(arr).append(" = null;\n         |").append(this.impl().genCode(ctx, ExprValue$.MODULE$.exprValueToString(startGen.value()), ExprValue$.MODULE$.exprValueToString(stopGen.value()), ExprValue$.MODULE$.exprValueToString(stepGen.value()), arr, arrElemType)).append("\n         |").append(ev.value()).append(" = UnsafeArrayData.fromPrimitiveArray(").append(arr).append(");\n       ").toString())).stripMargin();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)startGen.code()), ctx.nullSafeExec(this.start().nullable(), ExprValue$.MODULE$.exprValueToString(startGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stopGen.code()), ctx.nullSafeExec(this.stop().nullable(), ExprValue$.MODULE$.exprValueToString(stopGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stepGen.code()), ctx.nullSafeExec(this.stepOpt().exists((Function1 & Serializable & scala.Serializable)x$68 -> BoxesRunTime.boxToBoolean((boolean)x$68.nullable())), ExprValue$.MODULE$.exprValueToString(stepGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n                 |").append(ev.isNull()).append(" = false;\n                 |").append(resultCode).append("\n               ").toString())).stripMargin()))))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultType, ev.value(), nullSafeEval})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n           |", "\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.code(), stopGen.code(), stepGen.code(), resultType, ev.value(), resultCode})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    public Sequence copy(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.stop();
    }

    public Option<Expression> copy$default$3() {
        return this.stepOpt();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Sequence";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.stop();
                break;
            }
            case 2: {
                object = this.stepOpt();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sequence sequence = (Sequence)x$1;
        Expression expression = this.start();
        Expression expression2 = sequence.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.stop();
        Expression expression4 = sequence.stop();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.stepOpt();
        Option<Expression> option2 = sequence.stepOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = sequence.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!sequence.canEqual(this)) return false;
        return true;
    }

    private final DataType stepType$1() {
        return ((Expression)this.stepOpt().get()).dataType();
    }

    public static final /* synthetic */ boolean $anonfun$coercibleChildren$1(Expression x$64) {
        DataType dataType = x$64.dataType();
        CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
        return dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$);
    }

    public Sequence(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        this.start = start;
        this.stop = stop;
        this.stepOpt = stepOpt;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
    }

    public Sequence(Expression start, Expression stop) {
        this(start, stop, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Sequence(Expression start, Expression stop, Expression step) {
        this(start, stop, (Option<Expression>)new Some((Object)step), (Option<String>)None$.MODULE$);
    }

    public static class DefaultStep {
        private final Function2<Object, Object, Object> lteq;
        private final DataType stepType;
        private final Object one;
        private final Object negativeOne;

        private Object negativeOne() {
            return this.negativeOne;
        }

        public Object apply(Object start, Object stop) {
            return BoxesRunTime.unboxToBoolean((Object)this.lteq.apply(start, stop)) ? this.one : this.negativeOne();
        }

        public ExprCode genCode(CodegenContext ctx, ExprCode startGen, ExprCode stopGen) {
            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.one, this.negativeOne()}))).map((Function1 & Serializable & scala.Serializable)x$69 -> Literal$.MODULE$.apply(x$69).genCode(ctx).value(), Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            ExprValue oneVal = (ExprValue)((SeqLike)some.get()).apply(0);
            ExprValue negativeOneVal = (ExprValue)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)oneVal, (Object)negativeOneVal);
            Tuple2 tuple22 = tuple2;
            ExprValue oneVal2 = (ExprValue)tuple22._1();
            ExprValue negativeOneVal2 = (ExprValue)tuple22._2();
            return ExprCode$.MODULE$.forNonNullValue(JavaCode$.MODULE$.expression(new StringBuilder(10).append(startGen.value()).append(" <= ").append(stopGen.value()).append(" ? ").append(oneVal2).append(" : ").append(negativeOneVal2).toString(), this.stepType));
        }

        public DefaultStep(Function2<Object, Object, Object> lteq, DataType stepType, Object one) {
            this.lteq = lteq;
            this.stepType = stepType;
            this.one = one;
            UnaryMinus qual$1 = new UnaryMinus(Literal$.MODULE$.apply(one), UnaryMinus$.MODULE$.apply$default$2());
            InternalRow x$1 = qual$1.eval$default$1();
            this.negativeOne = qual$1.eval(x$1);
        }
    }

    public static class IntegralSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType elemType;
        private final ClassTag<T> evidence$1;
        private final Integral<T> num;
        private final DefaultStep defaultStep;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object start = input1;
            Object stop = input2;
            Object step = input3;
            int i = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(start, stop, step, this.num);
            Object arr = this.evidence$1.newArray(i);
            while (i > 0) {
                ScalaRunTime$.MODULE$.array_update(arr, --i, this.num.mkNumericOps(start).$plus(this.num.mkNumericOps(step).$times(this.num.fromInt(i))));
            }
            return arr;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String i = ctx.freshName("i");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n         |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, start, stop, step, i)).append("\n         |").append(arr).append(" = new ").append(elemType).append("[").append(i).append("];\n         |while (").append(i).append(" > 0) {\n         |  ").append(i).append("--;\n         |  ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(start).append(" + ").append(step).append(" * ").append(i).append(");\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$1(IntegralSequenceImpl $this, Object x, Object y) {
            return $this.elemType.ordering().lteq(x, y);
        }

        public IntegralSequenceImpl(IntegralType elemType, ClassTag<T> evidence$1, Integral<T> num) {
            this.elemType = elemType;
            this.evidence$1 = evidence$1;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)IntegralSequenceImpl.$anonfun$defaultStep$1(this, x, y)), elemType, num.one());
        }
    }

    public static interface SequenceImpl {
        public Object eval(Object var1, Object var2, Object var3);

        public String genCode(CodegenContext var1, String var2, String var3, String var4, String var5, String var6);

        public DefaultStep defaultStep();
    }

    public static class TemporalSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType dt;
        private final long scale;
        private final Function1<Object, T> fromLong;
        private final ZoneId zoneId;
        private final ClassTag<T> evidence$2;
        private final Integral<T> num;
        private final DefaultStep defaultStep;
        private final IntegralSequenceImpl<T> backedSequenceImpl;
        private final long microsPerDay;
        private final long microsPerMonth;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        private IntegralSequenceImpl<T> backedSequenceImpl() {
            return this.backedSequenceImpl;
        }

        private long microsPerDay() {
            return this.microsPerDay;
        }

        private long microsPerMonth() {
            return this.microsPerMonth;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object object;
            Object start = input1;
            Object stop = input2;
            CalendarInterval step = (CalendarInterval)input3;
            int stepMonths = step.months;
            int stepDays = step.days;
            long stepMicros = step.microseconds;
            if (this.scale == 86400000000L && stepMonths == 0 && stepDays == 0) {
                throw new IllegalArgumentException("sequence step must be a day interval if start and end values are dates");
            }
            if (stepMonths == 0 && stepMicros == 0L && this.scale == 86400000000L) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)stepDays)));
            } else if (stepMonths == 0 && stepDays == 0 && this.scale == 1L) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)stepMicros)));
            } else {
                long intervalStepInMicros = stepMicros + (long)stepMonths * this.microsPerMonth() + (long)stepDays * this.microsPerDay();
                long startMicros = this.num.toLong(start) * this.scale;
                long stopMicros = this.num.toLong(stop) * this.scale;
                int maxEstimatedArrayLength = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(BoxesRunTime.boxToLong((long)startMicros), BoxesRunTime.boxToLong((long)stopMicros), BoxesRunTime.boxToLong((long)intervalStepInMicros), Numeric.LongIsIntegral$.MODULE$);
                int stepSign = stopMicros >= startMicros ? 1 : -1;
                long exclusiveItem = stopMicros + (long)stepSign;
                Object arr = this.evidence$2.newArray(maxEstimatedArrayLength);
                long t = startMicros;
                int i = 0;
                while (t < exclusiveItem ^ stepSign < 0) {
                    ScalaRunTime$.MODULE$.array_update(arr, i, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(t / this.scale))));
                    t = DateTimeUtils$.MODULE$.timestampAddInterval(startMicros, ++i * stepMonths, i * stepDays, (long)i * stepMicros, this.zoneId);
                }
                object = ScalaRunTime$.MODULE$.array_length(arr) == i ? arr : Predef$.MODULE$.genericArrayOps(arr).slice(0, i);
            }
            return object;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String stepMonths = ctx.freshName("stepMonths");
            String stepDays = ctx.freshName("stepDays");
            String stepMicros = ctx.freshName("stepMicros");
            String stepScaled = ctx.freshName("stepScaled");
            String intervalInMicros = ctx.freshName("intervalInMicros");
            String startMicros = ctx.freshName("startMicros");
            String stopMicros = ctx.freshName("stopMicros");
            String arrLength = ctx.freshName("arrLength");
            String stepSign = ctx.freshName("stepSign");
            String exclusiveItem = ctx.freshName("exclusiveItem");
            String t = ctx.freshName("t");
            String i = ctx.freshName("i");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId, ZoneId.class.getName());
            String sequenceLengthCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n           |final long ").append(intervalInMicros).append(" =\n           |  ").append(stepMicros).append(" + ").append(stepMonths).append(" * ").append(this.microsPerMonth()).append("L + ").append(stepDays).append(" * ").append(this.microsPerDay()).append("L;\n           |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, startMicros, stopMicros, intervalInMicros, arrLength)).append("\n          ").toString())).stripMargin();
            String check = this.scale == 86400000000L ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n           |if (").append(stepMonths).append(" == 0 && ").append(stepDays).append(" == 0) {\n           |  throw new IllegalArgumentException(\n           |    \"sequence step must be a day interval if start and end values are dates\");\n           |}\n          ").toString())).stripMargin() : "";
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(889).append("\n         |final int ").append(stepMonths).append(" = ").append(step).append(".months;\n         |final int ").append(stepDays).append(" = ").append(step).append(".days;\n         |final long ").append(stepMicros).append(" = ").append(step).append(".microseconds;\n         |\n         |").append(check).append("\n         |\n         |if (").append(stepMonths).append(" == 0 && ").append(stepMicros).append(" == 0 && ").append(this.scale).append("L == ").append(86400000000L).append("L) {\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepDays, arr, elemType)).append(";\n         |\n         |} else if (").append(stepMonths).append(" == 0 && ").append(stepDays).append(" == 0 && ").append(this.scale).append("L == 1) {\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepMicros, arr, elemType)).append(";\n         |} else {\n         |  final long ").append(startMicros).append(" = ").append(start).append(" * ").append(this.scale).append("L;\n         |  final long ").append(stopMicros).append(" = ").append(stop).append(" * ").append(this.scale).append("L;\n         |\n         |  ").append(sequenceLengthCode).append("\n         |\n         |  final int ").append(stepSign).append(" = ").append(stopMicros).append(" >= ").append(startMicros).append(" ? +1 : -1;\n         |  final long ").append(exclusiveItem).append(" = ").append(stopMicros).append(" + ").append(stepSign).append(";\n         |\n         |  ").append(arr).append(" = new ").append(elemType).append("[").append(arrLength).append("];\n         |  long ").append(t).append(" = ").append(startMicros).append(";\n         |  int ").append(i).append(" = 0;\n         |\n         |  while (").append(t).append(" < ").append(exclusiveItem).append(" ^ ").append(stepSign).append(" < 0) {\n         |    ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(t).append(" / ").append(this.scale).append("L);\n         |    ").append(i).append(" += 1;\n         |    ").append(t).append(" = org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampAddInterval(\n         |       ").append(startMicros).append(", ").append(i).append(" * ").append(stepMonths).append(", ").append(i).append(" * ").append(stepDays).append(", ").append(i).append(" * ").append(stepMicros).append(", ").append(zid).append(");\n         |  }\n         |\n         |  if (").append(arr).append(".length > ").append(i).append(") {\n         |    ").append(arr).append(" = java.util.Arrays.copyOf(").append(arr).append(", ").append(i).append(");\n         |  }\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$2(TemporalSequenceImpl $this, Object x, Object y) {
            return $this.dt.ordering().lteq(x, y);
        }

        public TemporalSequenceImpl(IntegralType dt, long scale, Function1<Object, T> fromLong, ZoneId zoneId, ClassTag<T> evidence$2, Integral<T> num) {
            this.dt = dt;
            this.scale = scale;
            this.fromLong = fromLong;
            this.zoneId = zoneId;
            this.evidence$2 = evidence$2;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)TemporalSequenceImpl.$anonfun$defaultStep$2(this, x, y)), CalendarIntervalType$.MODULE$, new CalendarInterval(0, 1, 0L));
            this.backedSequenceImpl = new IntegralSequenceImpl<T>(dt, evidence$2, num);
            this.microsPerDay = 86400000000L;
            this.microsPerMonth = 28L * this.microsPerDay();
        }
    }
}

