/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\")A\t\u0001C\u0001\u000b\")\u0001\n\u0001C!\u0013\")\u0001\u000b\u0001C!#\")Q\f\u0001C)=\")A\r\u0001C!K\")1\u000f\u0001C)i\"9q\u000fAA\u0001\n\u0003A\bb\u0002>\u0001#\u0003%\ta\u001f\u0005\n\u0003\u001b\u0001\u0011\u0011!C!\u0003\u001fA\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0002\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u0011%\t\u0019\u0005AA\u0001\n\u0003\t)\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R\u001dI\u0011QO\r\u0002\u0002#\u0005\u0011q\u000f\u0004\t1e\t\t\u0011#\u0001\u0002z!1AI\u0005C\u0001\u0003\u000fC\u0011\"!#\u0013\u0003\u0003%)%a#\t\u0013\u00055%#!A\u0005\u0002\u0006=\u0005\"CAJ%\u0005\u0005I\u0011QAK\u0011%\t\tKEA\u0001\n\u0013\t\u0019K\u0001\u0003TQ\u0006\f$B\u0001\u000e\u001c\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005qi\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u000193FL\u001b<!\tA\u0013&D\u0001\u001a\u0013\tQ\u0013DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tAC&\u0003\u0002.3\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00020e9\u0011\u0001\u0006M\u0005\u0003ce\tq\u0001]1dW\u0006<W-\u0003\u00024i\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u0019\u001a!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e\u001f\n\u0005u:$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001!\u0011\u0005!\n\u0015B\u0001\"\u001a\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t1u\t\u0005\u0002)\u0001!)ah\u0001a\u0001\u0001\u0006AA-\u0019;b)f\u0004X-F\u0001K!\tYe*D\u0001M\u0015\tiU$A\u0003usB,7/\u0003\u0002P\u0019\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0015\t\u0004'jSeB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9V%\u0001\u0004=e>|GOP\u0005\u0002q%\u0011\u0011gN\u0005\u00037r\u00131aU3r\u0015\t\tt'\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002`EB\u0011a\u0007Y\u0005\u0003C^\u00121!\u00118z\u0011\u0015\u0019g\u00011\u0001`\u0003\u0015Ig\u000e];u\u0003%!wnR3o\u0007>$W\rF\u0002gYF\u0004\"a\u001a6\u000e\u0003!T!![\r\u0002\u000f\r|G-Z4f]&\u00111\u000e\u001b\u0002\t\u000bb\u0004(oQ8eK\")Qn\u0002a\u0001]\u0006\u00191\r\u001e=\u0011\u0005\u001d|\u0017B\u00019i\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA]\u0004A\u0002\u0019\f!!\u001a<\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t1U\u000fC\u0003w\u0011\u0001\u0007\u0001)\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0005\u0019K\bb\u0002 \n!\u0003\u0005\r\u0001Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005a(F\u0001!~W\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005v]\u000eDWmY6fI*\u0019\u0011qA\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0005\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!A.\u00198h\u0015\t\tY\"\u0001\u0003kCZ\f\u0017\u0002BA\u0010\u0003+\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0013!\r1\u0014qE\u0005\u0004\u0003S9$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA0\u00020!I\u0011\u0011G\u0007\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0002#BA\u001d\u0003\u007fyVBAA\u001e\u0015\r\tidN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA!\u0003w\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qIA'!\r1\u0014\u0011J\u0005\u0004\u0003\u0017:$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003cy\u0011\u0011!a\u0001?\u00061Q-];bYN$B!a\u0012\u0002T!A\u0011\u0011\u0007\t\u0002\u0002\u0003\u0007q\fK\n\u0001\u0003/\ni&a\u0018\u0002d\u0005\u0015\u0014\u0011NA6\u0003_\n\t\bE\u0002)\u00033J1!a\u0017\u001a\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0019\u0002\u000f~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:iCF\u0002\u0003.Y:iAY\fG.^3!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t;iK\u0002\u0002W\r\u001f9sA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\n\u0011M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o[\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BTGZ\u001b:kU2GG\u0019\u001a8Cf\nGg\u0019\u001abC\n4dMZ36I^\n\u0004(\u000f4deeB$-\u000f\u001ad\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA7\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t\u0019(\u0001\u0006iCNDwLZ;oGN\fAa\u00155bcA\u0011\u0001FE\n\u0005%\u0005m4\b\u0005\u0004\u0002~\u0005\r\u0005IR\u0007\u0003\u0003\u007fR1!!!8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\"\u0002\u0000\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0011!B1qa2LHc\u0001$\u0002\u0012\")a(\u0006a\u0001\u0001\u00069QO\\1qa2LH\u0003BAL\u0003;\u0003BANAM\u0001&\u0019\u00111T\u001c\u0003\r=\u0003H/[8o\u0011!\tyJFA\u0001\u0002\u00041\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u000b\u0005\u0003\u0002\u0014\u0005\u001d\u0016\u0002BAU\u0003+\u0011aa\u00142kK\u000e$\b")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 sha1) {
        return Sha1$.MODULE$.unapply(sha1);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> function1) {
        return Sha1$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Sha1> compose(Function1<A, Expression> function1) {
        return Sha1$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryType$[]{BinaryType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(33).append("UTF8String.fromString(").append(DigestUtils.class.getName()).append(".sha1Hex(").append((String)c).append("))").toString());
    }

    @Override
    public Sha1 withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

