/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011!!\u0006A!f\u0001\n\u0003i\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000bY\u0003A\u0011\u00011\t\u000b\t\u0004A\u0011I'\t\u000b\r\u0004A\u0011I'\t\u000b\u0011\u0004A\u0011I'\t\u000b\u0015\u0004A\u0011\t4\t\u000ba\u0004A\u0011I=\t\u000bu\u0004A\u0011\t@\t\u0015\u0005-\u0001\u0001#b\u0001\n\u0013\ti\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005E\u0002\u0001\"\u0015\u00024!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA2\u0001\u0011E\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"! \u0001#\u0003%\t!a \t\u0013\u0005U\u0005!%A\u0005\u0002\u0005}\u0004\"CAL\u0001E\u0005I\u0011AA@\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002,\u0002\t\t\u0011\"\u0001\u0002.\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003{\u0003\u0011\u0011!C!\u0003\u007fC\u0011\"!4\u0001\u0003\u0003%\t!a4\t\u0013\u0005e\u0007!!A\u0005B\u0005mw!CA\u0000O\u0005\u0005\t\u0012\u0001B\u0001\r!1s%!A\t\u0002\t\r\u0001B\u0002,!\t\u0003\u0011\t\u0002C\u0005\u0003\u0014\u0001\n\t\u0011\"\u0012\u0003\u0016!I!q\u0003\u0011\u0002\u0002\u0013\u0005%\u0011\u0004\u0005\n\u0005C\u0001\u0013\u0011!CA\u0005GA\u0011B!\u000e!\u0003\u0003%IAa\u000e\u0003\u0017M#(/\u001b8h)>l\u0015\r\u001d\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M1\u0001!N\u001d=\u0007&\u0003\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00027u%\u00111h\n\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001fA\u001d\t1d(\u0003\u0002@O\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aP\u0014\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000fA\u0013x\u000eZ;diB\u0011AIS\u0005\u0003\u0017\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001^3yiV\ta\n\u0005\u00027\u001f&\u0011\u0001k\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u0002;fqR\u0004\u0013!\u00039bSJ$U\r\\5n\u0003)\u0001\u0018-\u001b:EK2LW\u000eI\u0001\u000eW\u0016Lh+\u00197vK\u0012+G.[7\u0002\u001d-,\u0017PV1mk\u0016$U\r\\5nA\u00051A(\u001b8jiz\"B\u0001W-[7B\u0011a\u0007\u0001\u0005\u0006\u0019\u001e\u0001\rA\u0014\u0005\u0006%\u001e\u0001\rA\u0014\u0005\u0006)\u001e\u0001\rA\u0014\u000b\u00041v{\u0006\"\u00020\t\u0001\u0004q\u0015!B2iS2$\u0007\"\u0002*\t\u0001\u0004qEC\u0001-b\u0011\u0015q\u0016\u00021\u0001O\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u001d\u00042\u0001[8s\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002mg\u00051AH]8pizJ\u0011AR\u0005\u0003\u007f\u0015K!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002@\u000bB\u00111O^\u0007\u0002i*\u0011QoK\u0001\u0006if\u0004Xm]\u0005\u0003oR\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001f\t\u0003gnL!\u0001 ;\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0015\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0003\u0002\u0004\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0006nCB\u0014U/\u001b7eKJ,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006*\u0003\u0011)H/\u001b7\n\t\u0005e\u00111\u0003\u0002\u0015\u0003J\u0014\u0018-\u001f\"bg\u0016$W*\u00199Ck&dG-\u001a:\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005}\u0011QEA\u0015\u0003[\u00012\u0001RA\u0011\u0013\r\t\u0019#\u0012\u0002\u0004\u0003:L\bbBA\u0014#\u0001\u0007\u0011qD\u0001\fS:\u0004X\u000f^*ue&tw\rC\u0004\u0002,E\u0001\r!a\b\u0002\u001fM$(/\u001b8h\t\u0016d\u0017.\\5uKJDq!a\f\u0012\u0001\u0004\ty\"A\tlKf4\u0016\r\\;f\t\u0016d\u0017.\\5uKJ\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005U\u0012\u0011IA&!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001eO\u000591m\u001c3fO\u0016t\u0017\u0002BA \u0003s\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u0007\u0012\u0002\u0019AA#\u0003\r\u0019G\u000f\u001f\t\u0005\u0003o\t9%\u0003\u0003\u0002J\u0005e\"AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u001b\u0012\u0002\u0019AA\u001b\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0015\u0011\t\u0005U\u0013Q\f\b\u0005\u0003/\nI\u0006\u0005\u0002k\u000b&\u0019\u00111L#\u0002\rA\u0013X\rZ3g\u0013\u0011\ty&!\u0019\u0003\rM#(/\u001b8h\u0015\r\tY&R\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$rATA4\u0003W\ny\u0007\u0003\u0004\u0002jQ\u0001\rAT\u0001\t]\u0016<h)\u001b:ti\"1\u0011Q\u000e\u000bA\u00029\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005ED\u00031\u0001O\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r\u0001WA<\u0003s\nY\bC\u0004M+A\u0005\t\u0019\u0001(\t\u000fI+\u0002\u0013!a\u0001\u001d\"9A+\u0006I\u0001\u0002\u0004q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003S3ATABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAH\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a\u0018\u0002\"\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0016\t\u0004\t\u0006E\u0016bAAZ\u000b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qDA]\u0011%\tYlGA\u0001\u0002\u0004\ty+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0004b!a1\u0002J\u0006}QBAAc\u0015\r\t9-R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAf\u0003\u000b\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011[Al!\r!\u00151[\u0005\u0004\u0003+,%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003wk\u0012\u0011!a\u0001\u0003?\ta!Z9vC2\u001cH\u0003BAi\u0003;D\u0011\"a/\u001f\u0003\u0003\u0005\r!a\b)'\u0001\t\t/a:\u0002j\u00065\u0018q^Az\u0003k\fI0a?\u0011\u0007Y\n\u0019/C\u0002\u0002f\u001e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002l\u0006\u00119b\u0018$V\u001d\u000e{\u0006\u0006^3yinc\u0003\u0005]1je\u0012+G.[7\\Y\u0001ZW-\u001f,bYV,G)\u001a7j[vk\u0016\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!C\u001a$XM\u001d\u0011ta2LG\u000f^5oO\u0002\"\b.\u001a\u0011uKb$\b%\u001b8u_\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001c\b%^:j]\u001e\u0004C-\u001a7j[&$XM]:/A\u0011+g-Y;mi\u0002\"W\r\\5nSR,'o\u001d\u0011be\u0016\u0004s\u0005L\u0014!M>\u0014\b\u0005\u00199bSJ$U\r\\5nA\u0002\ng\u000e\u001a\u0011(u\u001d\u0002cm\u001c:!A.,\u0017PV1mk\u0016$U\r\\5nA:\u0002#i\u001c;iA\u0001\u0004\u0018-\u001b:EK2LW\u000e\u0019\u0011b]\u0012\u0004\u0003m[3z-\u0006dW/\u001a#fY&l\u0007\rI1sK\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011_\u0001\u0002\")\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u0019\u001e2Y\tT$\u0007L2;g\u001db\u0003e\n\u0017(Y\u0001:#hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e#c\tb#E\u0019\u0012;EI\u0012CFI2#u\t\u001a$% \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#H\\;mYvT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003o\fQA\r\u00181]E\nQa\u001a:pkB\f#!!@\u0002\u00135\f\u0007o\u00184v]\u000e\u001c\u0018aC*ue&tw\rV8NCB\u0004\"A\u000e\u0011\u0014\t\u0001\u0012)!\u0013\t\t\u0005\u000f\u0011iA\u0014(O16\u0011!\u0011\u0002\u0006\u0004\u0005\u0017)\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u001f\u0011IAA\tBEN$(/Y2u\rVt7\r^5p]N\"\"A!\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fa\u0013YB!\b\u0003 !)Aj\ta\u0001\u001d\")!k\ta\u0001\u001d\")Ak\ta\u0001\u001d\u00069QO\\1qa2LH\u0003\u0002B\u0013\u0005c\u0001R\u0001\u0012B\u0014\u0005WI1A!\u000bF\u0005\u0019y\u0005\u000f^5p]B1AI!\fO\u001d:K1Aa\fF\u0005\u0019!V\u000f\u001d7fg!A!1\u0007\u0013\u0002\u0002\u0003\u0007\u0001,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\b\t\u0005\u0003?\u0013Y$\u0003\u0003\u0003>\u0005\u0005&AB(cU\u0016\u001cG\u000f")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$28))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(text, pd, kvd) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$28) {
        return !x$28.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

