/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH FROM str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(LEADING FROM str) - Removes the leading space characters from `str`.\n\n    _FUNC_(TRAILING FROM str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`.\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(BOTH FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(LEADING FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(TRAILING FROM '    SparkSQL   ');\n           SparkSQL\n      > SELECT _FUNC_('SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005mw!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005BB \u0002\t\u0003\t\u0019\f\u0003\u0005@\u0003\u0005\u0005I\u0011QA\\\u0011%\ti,AI\u0001\n\u0003\t9\u0004C\u0005\u0002@\u0006\t\t\u0011\"!\u0002B\"I\u0011qZ\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003#\f\u0011\u0011!C\u0005\u0003'4AAM\u0012A\u0005\"AAJ\u0003BK\u0002\u0013\u0005Q\n\u0003\u0005O\u0015\tE\t\u0015!\u0003D\u0011!y%B!f\u0001\n\u0003\u0001\u0006\u0002\u0003+\u000b\u0005#\u0005\u000b\u0011B)\t\u000buRA\u0011A+\t\u000buRA\u0011\u0001-\t\u000buRA\u0011A.\t\u000buSA\u0011\t0\t\u000b)TA\u0011\u000b0\t\u000b-TA\u0011\t7\t\u000b-TA\u0011I<\t\u000fmT!\u0019!C!=\"1AP\u0003Q\u0001\n}CQ! \u0006\u0005RyD\u0011\"!\u0006\u000b\u0003\u0003%\t!a\u0006\t\u0013\u0005u!\"%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0015E\u0005I\u0011AA\u001c\u0011%\tYDCA\u0001\n\u0003\ni\u0004C\u0005\u0002N)\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0006\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003KR\u0011\u0011!C!\u0003OB\u0011\"!\u001e\u000b\u0003\u0003%\t!a\u001e\t\u0013\u0005\u0005%\"!A\u0005B\u0005\r\u0015AC*ue&tw\r\u0016:j[*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00022\u00035\t1E\u0001\u0006TiJLgn\u001a+sS6\u001c2!\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fMB\u0011QgO\u0005\u0003yY\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u000bi+!-\u0011\u0005ER1#\u0002\u0006D\r&S\u0004CA\u0019E\u0013\t)5E\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!M$\n\u0005!\u001b#!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003k)K!a\u0013\u001c\u0003\u000fA\u0013x\u000eZ;di\u000611O]2TiJ,\u0012aQ\u0001\bgJ\u001c7\u000b\u001e:!\u0003\u001d!(/[7TiJ,\u0012!\u0015\t\u0004kI\u001b\u0015BA*7\u0005\u0019y\u0005\u000f^5p]\u0006AAO]5n'R\u0014\b\u0005F\u0002B-^CQ\u0001T\bA\u0002\rCqaT\b\u0011\u0002\u0003\u0007\u0011\u000bF\u0002B3jCQa\u0014\tA\u0002\rCQ\u0001\u0014\tA\u0002\r#\"!\u0011/\t\u000b1\u000b\u0002\u0019A\"\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001`!\t\u0001wM\u0004\u0002bKB\u0011!MN\u0007\u0002G*\u0011AmL\u0001\u0007yI|w\u000e\u001e \n\u0005\u00194\u0014A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!A\u001a\u001c\u0002\u0013\u0011L'/Z2uS>t\u0017A\u00023p\u000bZ\fG\u000e\u0006\u0002nkB\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0006if\u0004Xm\u001d\u0006\u0003e&\na!\u001e8tC\u001a,\u0017B\u0001;p\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u0006mR\u0001\r!\\\u0001\ngJ\u001c7\u000b\u001e:j]\u001e$2!\u001c=z\u0011\u00151X\u00031\u0001n\u0011\u0015QX\u00031\u0001n\u0003)!(/[7TiJLgnZ\u0001\u000biJLW.T3uQ>$\u0017a\u0003;sS6lU\r\u001e5pI\u0002\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005\r{\bbBA\u00011\u0001\u0007\u00111A\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0003\u0002\u0006\u0005=1I\u0004\u0003\u0002\b\u0005-ab\u00012\u0002\n%\tq'C\u0002\u0002\u000eY\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0005M!AC%oI\u0016DX\rZ*fc*\u0019\u0011Q\u0002\u001c\u0002\t\r|\u0007/\u001f\u000b\u0006\u0003\u0006e\u00111\u0004\u0005\b\u0019f\u0001\n\u00111\u0001D\u0011\u001dy\u0015\u0004%AA\u0002E\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\")\u001a1)a\t,\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\f7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\tICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:)\u001a\u0011+a\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\nAA[1wC&\u0019\u0001.a\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0003cA\u001b\u0002T%\u0019\u0011Q\u000b\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0013\u0011\r\t\u0004k\u0005u\u0013bAA0m\t\u0019\u0011I\\=\t\u0013\u0005\rd$!AA\u0002\u0005E\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jA1\u00111NA9\u00037j!!!\u001c\u000b\u0007\u0005=d'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001d\u0002n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI(a \u0011\u0007U\nY(C\u0002\u0002~Y\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002d\u0001\n\t\u00111\u0001\u0002\\\u00051Q-];bYN$B!!\u001f\u0002\u0006\"I\u00111M\u0011\u0002\u0002\u0003\u0007\u00111\f\u0015\u0018\u0015\u0005%\u0015qRAI\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161UAT\u0003S\u00032!MAF\u0013\r\tii\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019*ACT\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\u0012u\n\u0016%!\rJ{U\nI:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"bU)\u0011#J\u001d\u001e\u0003cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015U%\u0006KE*\u0013(HA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006FQ(U\u0011\u0002\"(/[7TiJ\u0004cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fAQDW\r\t7fC\u0012Lgn\u001a\u0011b]\u0012\u0004CO]1jY&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`Q1+\u0015\tR%O\u000f\u0002\"(/[7TiJ\u0004cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fAQDW\r\t7fC\u0012Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005\u0005\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u0002GO]5n'R\u0014\b\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005e\u0015aa>\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0014\u0018.\\*ue\u0002j\u0003\u0005\u001e5fAQ\u0014\u0018.\u001c\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004Co\u001c\u0011ue&lG\u0006\t;iK\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI1!g&tw\r\\3!gB\f7-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!\u0005>#\u0006\n\f\u0011G%>k\u0005%\f\u0011uQ\u0016\u001cX\rI1sK\u0002ZW-_<pe\u0012\u001c\b\u0005^8!gB,7-\u001b4zAQ\u0014\u0018.\\7j]\u001e\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t2pi\"\u0004SM\u001c3tA=4'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t'F\u0003\u0012Kej\u0012\u0017!\rJ{U\nI\u0017!i\",7/\u001a\u0011be\u0016\u00043.Z=x_J$7\u000f\t;pAM\u0004XmY5gs\u0002\"(/[7nS:<\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004C.\u001a4u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a8eA=4\u0007\u0005\u001e5fAM$(/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"&+Q%M\u0013:;E\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005\u001e5fAILw\r\u001b;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002SM\u001c3!_\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\u000bA\u0011\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012u\n\u0016%!\rJ{U\nI\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u0019\u0016\u000bE)\u0013(HA\u0019\u0013v*\u0014\u0011(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QQ\u0013\u0016)\u0013'J\u001d\u001e\u0003cIU(NA\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005]1sWN\u000b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\"P)\"\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q1+\u0015\tR%O\u000f\u0002:3\u000bT\u0014!\rJ{U\nI\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011qCJ\\7+\u0015'T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005eJ*MO\u00012%kT'!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u001b\u0006/\u0019:l'FS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003K\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a+\u0002\u0019M$(/\u001b8h?\u001a,hnY:\t\r\u0005=6\u00011\u0001D\u0003\r\u0019HO\u001d\u0005\u0006\u001f\u000e\u0001\ra\u0011\u000b\u0004\u0003\u0006U\u0006BBAX\t\u0001\u00071\tF\u0003B\u0003s\u000bY\fC\u0003M\u000b\u0001\u00071\tC\u0004P\u000bA\u0005\t\u0019A)\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002D\u0006-\u0007\u0003B\u001bS\u0003\u000b\u0004R!NAd\u0007FK1!!37\u0005\u0019!V\u000f\u001d7fe!A\u0011QZ\u0004\u0002\u0002\u0003\u0007\u0011)A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!6\u0011\t\u0005\u0005\u0013q[\u0005\u0005\u00033\f\u0019E\u0001\u0004PE*,7\r\u001e")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public String direction() {
        return "BOTH";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trim();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trim(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trim";
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

